"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Repository = void 0;

var fs = _interopRequireWildcard(require("fs/promises"));

var path = _interopRequireWildcard(require("path"));

var _integration = require("./integration");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Repository {
  constructor(directory) {
    _defineProperty(this, "directory", void 0);

    this.directory = directory;
  }

  async getIntegrationList() {
    try {
      const folders = await fs.readdir(this.directory);
      const integrations = Promise.all(folders.map(async folder => {
        const integPath = path.join(this.directory, folder);

        if (!(await fs.lstat(integPath)).isDirectory()) {
          return null;
        }

        const integ = new _integration.Integration(integPath);
        return (await integ.check()) ? integ : null;
      }));
      return (await integrations).filter(x => x !== null);
    } catch (error) {
      console.error(`Error reading integration directories in: ${this.directory}`, error);
      return [];
    }
  }

  async getIntegration(name) {
    const integ = new _integration.Integration(path.join(this.directory, name));
    return (await integ.check()) ? integ : null;
  }

}

exports.Repository = Repository;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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