"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStats = exports.getMapSavedObjects = void 0;

var _common = require("../../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const getStats = mapsSavedObjects => {
  const totalLayersCountByType = buildLayerTypesCountObject();
  let totalLayersFiltersCount = 0;
  const mapsList = [];
  mapsSavedObjects.saved_objects.forEach(mapRes => {
    var _mapRes$attributes, _mapRes$attributes2;

    const layersCountByType = buildLayerTypesCountObject();
    let layersFiltersCount = 0;
    const layerList = mapRes !== null && mapRes !== void 0 && (_mapRes$attributes = mapRes.attributes) !== null && _mapRes$attributes !== void 0 && _mapRes$attributes.layerList ? JSON.parse(mapRes === null || mapRes === void 0 ? void 0 : (_mapRes$attributes2 = mapRes.attributes) === null || _mapRes$attributes2 === void 0 ? void 0 : _mapRes$attributes2.layerList) : [];
    layerList.forEach(layer => {
      var _layer$source$filters, _layer$source, _layer$source$filters2;

      if (layer.type === _common.DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP) {
        layersCountByType[layer.source.customType]++;
        totalLayersCountByType[layer.source.customType]++;
      } else {
        layersCountByType[layer.type]++;
        totalLayersCountByType[layer.type]++;
      } // @ts-ignore


      const layerFiltersCount = (_layer$source$filters = (_layer$source = layer.source) === null || _layer$source === void 0 ? void 0 : (_layer$source$filters2 = _layer$source.filters) === null || _layer$source$filters2 === void 0 ? void 0 : _layer$source$filters2.length) !== null && _layer$source$filters !== void 0 ? _layer$source$filters : 0;
      layersFiltersCount += layerFiltersCount;
      totalLayersFiltersCount += layerFiltersCount;
    });
    mapsList.push({
      id: mapRes === null || mapRes === void 0 ? void 0 : mapRes.id,
      layers_filters_total: layersFiltersCount,
      layers_total: { ...layersCountByType
      }
    });
  });
  return {
    maps_total: mapsSavedObjects.total,
    layers_filters_total: totalLayersFiltersCount,
    layers_total: { ...totalLayersCountByType
    },
    maps_list: mapsList
  };
};

exports.getStats = getStats;

const buildLayerTypesCountObject = () => {
  const layersCountByType = {};
  Object.values(_common.DASHBOARDS_MAPS_LAYER_TYPE).forEach(layerType => {
    if (layerType === _common.DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP) {
      Object.values(_common.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE).forEach(customLayerType => {
        layersCountByType[customLayerType] = 0;
      });
    } else {
      layersCountByType[layerType] = 0;
    }
  });
  return layersCountByType;
};

const getMapSavedObjects = async (savedObjectsClient, perPage) => {
  const mapsSavedObjects = await (savedObjectsClient === null || savedObjectsClient === void 0 ? void 0 : savedObjectsClient.find({
    type: _common.MAP_SAVED_OBJECT_TYPE,
    perPage
  })); // If there are more than perPage of maps, we need to make additional requests to get all maps.

  if (mapsSavedObjects.total > perPage) {
    const iterations = Math.ceil(mapsSavedObjects.total / perPage);

    for (let i = 1; i < iterations; i++) {
      const mapsSavedObjectsPage = await (savedObjectsClient === null || savedObjectsClient === void 0 ? void 0 : savedObjectsClient.find({
        type: _common.MAP_SAVED_OBJECT_TYPE,
        perPage,
        page: i + 1
      }));
      mapsSavedObjects.saved_objects = [...mapsSavedObjects.saved_objects, ...mapsSavedObjectsPage.saved_objects];
    }
  }

  return mapsSavedObjects;
};

exports.getMapSavedObjects = getMapSavedObjects;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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