#!/bin/sh -
#	$OpenBSD: ckscripts.sh,v 1.3 1998/07/12 03:49:08 todd Exp $
#	$NetBSD: ckscripts.sh,v 1.9 1995/04/23 10:07:34 cgd Exp $
#
# This script runs the .ed scripts generated by mkscripts.sh
# and compares their output against the .r files, which contain
# the correct output

PATH="/bin:/usr/bin:/usr/local/bin/:."
ED=$1
[ ! -x $ED ] && { echo "$ED: cannot execute"; exit 1; }

# Run the *.red scripts first, since these don't generate output;
# they exit with non-zero status
for i in *.red; do
	echo $i
	if $i; then
		echo "*** The script $i exited abnormally  ***"
	fi
done >errs.o 2>&1

# Run the remaining scripts; they exit with zero status
for i in *.ed; do
#	base=`expr $i : '\([^.]*\)'`
#	base=`echo $i | sed 's/\..*//'`
	base=`$ED - \!"echo $i" <<-EOF
		s/\..*
	EOF`
	if $base.ed; then
		if cmp -s $base.o $base.r; then :; else
			echo "*** Output $base.o of script $i is incorrect ***"
		fi
	else
		echo "*** The script $i exited abnormally ***"
	fi
done >scripts.o 2>&1

grep -h '\*\*\*' errs.o scripts.o
