/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.apache.solr.client.solrj.util.Cancellable;

public class CancellableCollector
implements Collector,
Cancellable {
    private final Collector collector;
    private final AtomicBoolean isQueryCancelled;

    public CancellableCollector(Collector collector) {
        Objects.requireNonNull(collector, "Internal collector not provided but wrapper collector accessed");
        this.collector = collector;
        this.isQueryCancelled = new AtomicBoolean();
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        if (this.isQueryCancelled.get()) {
            throw new QueryCancelledException();
        }
        return new FilterLeafCollector(this.collector.getLeafCollector(context)){

            public void collect(int doc) throws IOException {
                if (CancellableCollector.this.isQueryCancelled.get()) {
                    throw new QueryCancelledException();
                }
                this.in.collect(doc);
            }
        };
    }

    public ScoreMode scoreMode() {
        return this.collector.scoreMode();
    }

    public void cancel() {
        this.isQueryCancelled.compareAndSet(false, true);
    }

    public Collector getInternalCollector() {
        return this.collector;
    }

    public static class QueryCancelledException
    extends RuntimeException {
    }
}

