/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.AttributeFetcher;
import org.apache.solr.cluster.placement.AttributeValues;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementException;
import org.apache.solr.cluster.placement.PlacementPlan;
import org.apache.solr.cluster.placement.PlacementPlanFactory;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.PlacementRequest;
import org.apache.solr.cluster.placement.ReplicaPlacement;
import org.apache.solr.cluster.placement.impl.NodeMetricImpl;
import org.apache.solr.common.util.SuppressForbidden;

public class MinimizeCoresPlacementFactory
implements PlacementPluginFactory<PlacementPluginFactory.NoConfig> {
    @Override
    public PlacementPlugin createPluginInstance() {
        return new MinimizeCoresPlacementPlugin();
    }

    private static class MinimizeCoresPlacementPlugin
    implements PlacementPlugin {
        private MinimizeCoresPlacementPlugin() {
        }

        @Override
        @SuppressForbidden(reason="Ordering.arbitrary() has no equivalent in Comparator class. Rather reuse than copy.")
        public List<PlacementPlan> computePlacements(Collection<PlacementRequest> requests, PlacementContext placementContext) throws PlacementException {
            ArrayList<PlacementPlan> placementPlans = new ArrayList<PlacementPlan>(requests.size());
            HashSet<Node> allNodes = new HashSet<Node>();
            for (PlacementRequest request : requests) {
                allNodes.addAll(request.getTargetNodes());
            }
            AttributeFetcher attributeFetcher = placementContext.getAttributeFetcher();
            attributeFetcher.requestNodeMetric(NodeMetricImpl.NUM_CORES);
            attributeFetcher.fetchFrom(allNodes);
            AttributeValues attrValues = attributeFetcher.fetchAttributes();
            HashMap<String, Integer> coresPerNodeTotal = new HashMap<String, Integer>();
            for (Node node : allNodes) {
                if (attrValues.getNodeMetric(node, NodeMetricImpl.NUM_CORES).isEmpty()) {
                    throw new PlacementException("Can't get number of cores in " + node);
                }
                coresPerNodeTotal.put(node.getName(), attrValues.getNodeMetric(node, NodeMetricImpl.NUM_CORES).get());
            }
            for (PlacementRequest request : requests) {
                int totalReplicasPerShard = 0;
                for (Replica.ReplicaType rt : Replica.ReplicaType.values()) {
                    totalReplicasPerShard += request.getCountReplicasToCreate(rt);
                }
                if (request.getTargetNodes().size() < totalReplicasPerShard) {
                    throw new PlacementException("Cluster size too small for number of replicas per shard");
                }
                TreeMultimap nodesByCores = TreeMultimap.create(Comparator.naturalOrder(), (Comparator)Ordering.arbitrary());
                Set<Node> nodes = request.getTargetNodes();
                for (Node node : nodes) {
                    nodesByCores.put((Object)((Integer)coresPerNodeTotal.get(node.getName())), (Object)node);
                }
                HashSet<ReplicaPlacement> replicaPlacements = new HashSet<ReplicaPlacement>(totalReplicasPerShard * request.getShardNames().size());
                for (String shardName : request.getShardNames()) {
                    ArrayList<Map.Entry<Integer, Node>> nodeEntriesToAssign = new ArrayList<Map.Entry<Integer, Node>>(totalReplicasPerShard);
                    Iterator treeIterator = nodesByCores.entries().iterator();
                    for (int i = 0; i < totalReplicasPerShard; ++i) {
                        nodeEntriesToAssign.add((Map.Entry)treeIterator.next());
                    }
                    for (Map.Entry entry : nodeEntriesToAssign) {
                        int coreCount = (Integer)entry.getKey();
                        Node node = (Node)entry.getValue();
                        nodesByCores.remove((Object)coreCount, (Object)node);
                        nodesByCores.put((Object)(coreCount + 1), (Object)node);
                        coresPerNodeTotal.put(node.getName(), coreCount + 1);
                    }
                    for (Replica.ReplicaType replicaType : Replica.ReplicaType.values()) {
                        this.placeReplicas(request.getCollection(), nodeEntriesToAssign, placementContext.getPlacementPlanFactory(), replicaPlacements, shardName, request, replicaType);
                    }
                }
                placementPlans.add(placementContext.getPlacementPlanFactory().createPlacementPlan(request, replicaPlacements));
            }
            return placementPlans;
        }

        private void placeReplicas(SolrCollection solrCollection, ArrayList<Map.Entry<Integer, Node>> nodeEntriesToAssign, PlacementPlanFactory placementPlanFactory, Set<ReplicaPlacement> replicaPlacements, String shardName, PlacementRequest request, Replica.ReplicaType replicaType) {
            for (int replica = 0; replica < request.getCountReplicasToCreate(replicaType); ++replica) {
                Map.Entry<Integer, Node> entry = nodeEntriesToAssign.remove(0);
                Node node = entry.getValue();
                replicaPlacements.add(placementPlanFactory.createReplicaPlacement(solrCollection, shardName, node, replicaType));
            }
        }
    }
}

