/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableJoinOnUniqueToSemiJoinRuleConfig;
import org.apache.calcite.rel.rules.ImmutableJoinToSemiJoinRuleConfig;
import org.apache.calcite.rel.rules.ImmutableProjectToSemiJoinRuleConfig;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

public abstract class SemiJoinRule
extends RelRule<Config>
implements TransformationRule {
    private static boolean isJoinTypeSupported(Join join) {
        JoinRelType type = join.getJoinType();
        return type == JoinRelType.INNER || type == JoinRelType.LEFT;
    }

    private static boolean isEmptyAggregate(Aggregate aggregate) {
        return aggregate.getRowType().getFieldCount() == 0;
    }

    protected SemiJoinRule(Config config) {
        super(config);
    }

    protected void perform(RelOptRuleCall call, @Nullable Project project, Join join, RelNode left, Aggregate aggregate) {
        ImmutableBitSet rightBits;
        ImmutableBitSet bits;
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (project != null ? (bits = RelOptUtil.InputFinder.bits(project.getProjects(), null)).intersects(rightBits = ImmutableBitSet.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount())) : join.getJoinType().projectsRight() && !SemiJoinRule.isEmptyAggregate(aggregate)) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals(ImmutableBitSet.range(aggregate.getGroupCount()))) {
            return;
        }
        if (!joinInfo.isEqui()) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(left);
        switch (join.getJoinType()) {
            case INNER: {
                ArrayList<Integer> newRightKeyBuilder = new ArrayList<Integer>();
                List<Integer> aggregateKeys = aggregate.getGroupSet().asList();
                for (int key : joinInfo.rightKeys) {
                    newRightKeyBuilder.add(aggregateKeys.get(key));
                }
                ImmutableIntList newRightKeys = ImmutableIntList.copyOf(newRightKeyBuilder);
                relBuilder.push(aggregate.getInput());
                RexNode newCondition = RelOptUtil.createEquiJoinCondition(relBuilder.peek(2, 0), joinInfo.leftKeys, relBuilder.peek(2, 1), newRightKeys, rexBuilder);
                relBuilder.semiJoin(newCondition).hints((Iterable<RelHint>)join.getHints());
                break;
            }
            case LEFT: {
                break;
            }
            default: {
                throw new AssertionError((Object)join.getJoinType());
            }
        }
        if (project != null) {
            relBuilder.project(project.getProjects(), project.getRowType().getFieldNames());
        }
        RelNode relNode = relBuilder.build();
        call.transformTo(relNode);
    }

    public static interface Config
    extends RelRule.Config {
        @Override
        public SemiJoinRule toRule();
    }

    public static class JoinOnUniqueToSemiJoinRule
    extends SemiJoinRule {
        protected JoinOnUniqueToSemiJoinRule(JoinOnUniqueToSemiJoinRuleConfig config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            ImmutableBitSet rightBits;
            Project project = (Project)call.rel(0);
            Join join = (Join)call.rel(1);
            Object left = call.rel(2);
            ImmutableBitSet bits = RelOptUtil.InputFinder.bits(project.getProjects(), null);
            return !bits.intersects(rightBits = ImmutableBitSet.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount()));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Join join = (Join)call.rel(1);
            Object left = call.rel(2);
            Object right = call.rel(3);
            JoinInfo joinInfo = join.analyzeCondition();
            RelOptCluster cluster = join.getCluster();
            RelMetadataQuery mq = cluster.getMetadataQuery();
            Boolean unique = mq.areColumnsUnique((RelNode)right, joinInfo.rightSet());
            if (unique != null && unique.booleanValue()) {
                RelBuilder builder = call.builder();
                switch (join.getJoinType()) {
                    case INNER: {
                        builder.push((RelNode)left);
                        builder.push((RelNode)right);
                        builder.join(JoinRelType.SEMI, join.getCondition());
                        break;
                    }
                    case LEFT: {
                        builder.push((RelNode)left);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)join.getJoinType());
                    }
                }
                builder.project(project.getProjects());
                call.transformTo(builder.build());
            }
        }

        @Value.Immutable
        public static interface JoinOnUniqueToSemiJoinRuleConfig
        extends Config {
            public static final JoinOnUniqueToSemiJoinRuleConfig DEFAULT = ImmutableJoinOnUniqueToSemiJoinRuleConfig.of().withDescription("SemiJoinRule:unique").withOperandSupplier(b -> b.operand(Project.class).oneInput(b2 -> b2.operand(Join.class).predicate(x$0 -> SemiJoinRule.isJoinTypeSupported(x$0)).inputs(b3 -> b3.operand(RelNode.class).anyInputs(), b4 -> b4.operand(RelNode.class).predicate(n -> !(n instanceof Aggregate)).anyInputs()))).as(JoinOnUniqueToSemiJoinRuleConfig.class);

            @Override
            default public JoinOnUniqueToSemiJoinRule toRule() {
                return new JoinOnUniqueToSemiJoinRule(this);
            }
        }
    }

    public static class JoinToSemiJoinRule
    extends SemiJoinRule {
        protected JoinToSemiJoinRule(JoinToSemiJoinRuleConfig config) {
            super(config);
        }

        @Deprecated
        public JoinToSemiJoinRule(Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
            this(JoinToSemiJoinRuleConfig.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).as(JoinToSemiJoinRuleConfig.class).withOperandFor(joinClass, aggregateClass));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            Object left = call.rel(1);
            Aggregate aggregate = (Aggregate)call.rel(2);
            this.perform(call, null, join, (RelNode)left, aggregate);
        }

        @Value.Immutable
        public static interface JoinToSemiJoinRuleConfig
        extends Config {
            public static final JoinToSemiJoinRuleConfig DEFAULT = ImmutableJoinToSemiJoinRuleConfig.of().withDescription("SemiJoinRule:join").withOperandFor(Join.class, Aggregate.class);

            @Override
            default public JoinToSemiJoinRule toRule() {
                return new JoinToSemiJoinRule(this);
            }

            default public JoinToSemiJoinRuleConfig withOperandFor(Class<Join> joinClass, Class<Aggregate> aggregateClass) {
                return this.withOperandSupplier(b -> b.operand(joinClass).predicate(x$0 -> SemiJoinRule.isJoinTypeSupported(x$0)).inputs(b2 -> b2.operand(RelNode.class).anyInputs(), b3 -> b3.operand(aggregateClass).anyInputs())).as(JoinToSemiJoinRuleConfig.class);
            }
        }
    }

    public static class ProjectToSemiJoinRule
    extends SemiJoinRule {
        protected ProjectToSemiJoinRule(ProjectToSemiJoinRuleConfig config) {
            super(config);
        }

        @Deprecated
        public ProjectToSemiJoinRule(Class<Project> projectClass, Class<Join> joinClass, Class<Aggregate> aggregateClass, RelBuilderFactory relBuilderFactory, String description) {
            this(ProjectToSemiJoinRuleConfig.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).as(ProjectToSemiJoinRuleConfig.class).withOperandFor(projectClass, joinClass, aggregateClass));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Join join = (Join)call.rel(1);
            Object left = call.rel(2);
            Aggregate aggregate = (Aggregate)call.rel(3);
            this.perform(call, project, join, (RelNode)left, aggregate);
        }

        @Value.Immutable
        public static interface ProjectToSemiJoinRuleConfig
        extends Config {
            public static final ProjectToSemiJoinRuleConfig DEFAULT = ImmutableProjectToSemiJoinRuleConfig.of().withDescription("SemiJoinRule:project").withOperandFor(Project.class, Join.class, Aggregate.class);

            @Override
            default public ProjectToSemiJoinRule toRule() {
                return new ProjectToSemiJoinRule(this);
            }

            default public ProjectToSemiJoinRuleConfig withOperandFor(Class<? extends Project> projectClass, Class<? extends Join> joinClass, Class<? extends Aggregate> aggregateClass) {
                return this.withOperandSupplier(b -> b.operand(projectClass).oneInput(b2 -> b2.operand(joinClass).predicate(x$0 -> SemiJoinRule.isJoinTypeSupported(x$0)).inputs(b3 -> b3.operand(RelNode.class).anyInputs(), b4 -> b4.operand(aggregateClass).anyInputs()))).as(ProjectToSemiJoinRuleConfig.class);
            }
        }
    }
}

