/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.BezierOutlineHandle;
import org.jhotdraw.draw.BezierScaleHandle;
import org.jhotdraw.draw.ChopBezierConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class BezierFigure
extends AbstractAttributedFigure {
    protected BezierPath path = new BezierPath();
    private transient BezierPath cappedPath;

    public BezierFigure() {
        this(false);
    }

    public BezierFigure(boolean bl) {
        this.set(AttributeKeys.PATH_CLOSED, bl);
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return new ChopBezierConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return new ChopBezierConnector(this);
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        if (this.isClosed()) {
            double d = AttributeKeys.getPerpendicularDrawGrowth(this);
            if (d == 0.0) {
                graphics2D.draw(this.path);
            } else {
                GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * this.get(AttributeKeys.STROKE_MITER_LIMIT)));
                graphics2D.draw(growStroke.createStrokedShape(this.path));
            }
        } else {
            graphics2D.draw(this.getCappedPath());
        }
        this.drawCaps(graphics2D);
    }

    protected void drawCaps(Graphics2D graphics2D) {
        if (this.getNodeCount() > 1) {
            Point2D.Double double_;
            Point2D.Double double_2;
            BezierPath bezierPath;
            if (this.get(AttributeKeys.START_DECORATION) != null) {
                bezierPath = this.getCappedPath();
                double_2 = this.path.get(0, 0);
                double_ = bezierPath.get(0, 0);
                if (double_.equals(double_2)) {
                    double_ = this.path.get(1, 0);
                }
                this.get(AttributeKeys.START_DECORATION).draw(graphics2D, this, double_2, double_);
            }
            if (this.get(AttributeKeys.END_DECORATION) != null) {
                bezierPath = this.getCappedPath();
                double_2 = this.path.get(this.path.size() - 1, 0);
                double_ = bezierPath.get(this.path.size() - 1, 0);
                if (double_.equals(double_2)) {
                    double_ = this.path.get(this.path.size() - 2, 0);
                }
                this.get(AttributeKeys.END_DECORATION).draw(graphics2D, this, double_2, double_);
            }
        }
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        if (this.isClosed() || this.get(AttributeKeys.UNCLOSED_PATH_FILLED).booleanValue()) {
            double d = AttributeKeys.getPerpendicularFillGrowth(this);
            if (d == 0.0) {
                graphics2D.fill(this.path);
            } else {
                GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * this.get(AttributeKeys.STROKE_MITER_LIMIT)));
                graphics2D.fill(growStroke.createStrokedShape(this.path));
            }
        }
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        Object object;
        double d = Math.max(2.0, AttributeKeys.getStrokeTotalWidth(this) / 2.0);
        if (this.isClosed() || this.get(AttributeKeys.FILL_COLOR) != null && this.get(AttributeKeys.UNCLOSED_PATH_FILLED).booleanValue()) {
            if (this.path.contains(double_)) {
                return true;
            }
            double d2 = AttributeKeys.getPerpendicularHitGrowth(this) * 2.0;
            object = new GrowStroke((float)d2, (float)(AttributeKeys.getStrokeTotalWidth(this) * this.get(AttributeKeys.STROKE_MITER_LIMIT)));
            if (((GrowStroke)object).createStrokedShape(this.path).contains(double_)) {
                return true;
            }
            if (this.isClosed()) {
                return false;
            }
        }
        if (!this.isClosed()) {
            Point2D.Double double_2;
            if (this.getCappedPath().outlineContains(double_, d)) {
                return true;
            }
            if (this.get(AttributeKeys.START_DECORATION) != null) {
                BezierPath bezierPath = this.getCappedPath();
                double_2 = this.path.get(0, 0);
                object = bezierPath.get(0, 0);
                if (Geom.lineContainsPoint(double_2.x, double_2.y, ((Point2D.Double)object).x, ((Point2D.Double)object).y, double_.x, double_.y, d)) {
                    return true;
                }
            }
            if (this.get(AttributeKeys.END_DECORATION) != null) {
                BezierPath bezierPath = this.getCappedPath();
                double_2 = this.path.get(this.path.size() - 1, 0);
                object = bezierPath.get(this.path.size() - 1, 0);
                if (Geom.lineContainsPoint(double_2.x, double_2.y, ((Point2D.Double)object).x, ((Point2D.Double)object).y, double_.x, double_.y, d)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean canConnect() {
        return this.isClosed();
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n % 2) {
            case -1: {
                linkedList.add(new BezierOutlineHandle(this, true));
                break;
            }
            case 0: {
                linkedList.add(new BezierOutlineHandle(this));
                int n2 = this.path.size();
                for (int i = 0; i < n2; ++i) {
                    linkedList.add(new BezierNodeHandle(this, i));
                }
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, linkedList);
                linkedList.add(new BezierScaleHandle(this));
            }
        }
        return linkedList;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double double_ = this.path.getBounds2D();
        return double_;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double double_ = super.getDrawingArea();
        if (this.getNodeCount() > 1) {
            Point2D.Double double_2;
            Point2D.Double double_3;
            if (this.get(AttributeKeys.START_DECORATION) != null) {
                double_3 = this.getPoint(0, 0);
                double_2 = this.getPoint(1, 0);
                double_.add(this.get(AttributeKeys.START_DECORATION).getDrawingArea(this, double_3, double_2));
            }
            if (this.get(AttributeKeys.END_DECORATION) != null) {
                double_3 = this.getPoint(this.getNodeCount() - 1, 0);
                double_2 = this.getPoint(this.getNodeCount() - 2, 0);
                double_.add(this.get(AttributeKeys.END_DECORATION).getDrawingArea(this, double_3, double_2));
            }
        }
        return double_;
    }

    @Override
    protected void validate() {
        super.validate();
        this.path.invalidatePath();
        this.cappedPath = null;
    }

    public BezierPath getBezierPath() {
        return this.path.clone();
    }

    public void setBezierPath(BezierPath bezierPath) {
        this.path = bezierPath.clone();
        this.setClosed(bezierPath.isClosed());
    }

    public Point2D.Double getPointOnPath(float f, double d) {
        return this.path.getPointOnPath(f, d);
    }

    public boolean isClosed() {
        return this.get(AttributeKeys.PATH_CLOSED);
    }

    public void setClosed(boolean bl) {
        this.set(AttributeKeys.PATH_CLOSED, bl);
    }

    @Override
    public <T> void set(AttributeKey<T> attributeKey, T t) {
        if (attributeKey == AttributeKeys.PATH_CLOSED) {
            this.path.setClosed((Boolean)t);
        } else if (attributeKey == AttributeKeys.WINDING_RULE) {
            this.path.setWindingRule(t == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
        }
        super.set(attributeKey, t);
        this.invalidate();
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.setStartPoint(double_);
        this.setEndPoint(double_2);
        this.invalidate();
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.path.transform(affineTransform);
        this.invalidate();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.path.invalidatePath();
        this.cappedPath = null;
    }

    protected BezierPath getCappedPath() {
        if (this.cappedPath == null) {
            this.cappedPath = this.path.clone();
            if (this.isClosed()) {
                this.cappedPath.setClosed(true);
            } else if (this.cappedPath.size() > 1) {
                double d;
                double d2;
                Point2D.Double double_;
                BezierPath.Node node;
                BezierPath.Node node2;
                if (this.get(AttributeKeys.START_DECORATION) != null) {
                    node2 = (BezierPath.Node)this.cappedPath.get(0);
                    node = (BezierPath.Node)this.cappedPath.get(1);
                    double_ = (node2.getMask() & 2) != 0 ? node2.getControlPoint(2) : ((node.getMask() & 1) != 0 ? node.getControlPoint(1) : node.getControlPoint(0));
                    d2 = this.get(AttributeKeys.START_DECORATION).getDecorationRadius(this);
                    d = Geom.length(node2.getControlPoint(0), double_);
                    this.cappedPath.set(0, 0, Geom.cap(double_, node2.getControlPoint(0), -Math.min(d2, d)));
                }
                if (this.get(AttributeKeys.END_DECORATION) != null) {
                    node2 = (BezierPath.Node)this.cappedPath.get(this.cappedPath.size() - 1);
                    node = (BezierPath.Node)this.cappedPath.get(this.cappedPath.size() - 2);
                    double_ = (node2.getMask() & 1) != 0 ? node2.getControlPoint(1) : ((node.getMask() & 2) != 0 ? node.getControlPoint(2) : node.getControlPoint(0));
                    d2 = this.get(AttributeKeys.END_DECORATION).getDecorationRadius(this);
                    d = Geom.length(node2.getControlPoint(0), double_);
                    this.cappedPath.set(this.cappedPath.size() - 1, 0, Geom.cap(double_, node2.getControlPoint(0), -Math.min(d2, d)));
                }
                this.cappedPath.invalidatePath();
            }
        }
        return this.cappedPath;
    }

    public void layout() {
    }

    public void addNode(BezierPath.Node node) {
        this.addNode(this.getNodeCount(), node);
    }

    public void addNode(int n, BezierPath.Node node) {
        BezierPath.Node node2 = new BezierPath.Node(node);
        this.path.add(n, node);
        this.invalidate();
    }

    public void setNode(int n, BezierPath.Node node) {
        this.path.set(n, node);
        this.invalidate();
    }

    public BezierPath.Node getNode(int n) {
        return (BezierPath.Node)((BezierPath.Node)this.path.get(n)).clone();
    }

    public Point2D.Double getPoint(int n) {
        return ((BezierPath.Node)this.path.get(n)).getControlPoint(0);
    }

    public Point2D.Double getPoint(int n, int n2) {
        return ((BezierPath.Node)this.path.get(n)).getControlPoint(n2);
    }

    public void setPoint(int n, Point2D.Double double_) {
        BezierPath.Node node = (BezierPath.Node)this.path.get(n);
        double d = double_.x - node.x[0];
        double d2 = double_.y - node.y[0];
        int n2 = 0;
        while (n2 < node.x.length) {
            int n3 = n2;
            node.x[n3] = node.x[n3] + d;
            int n4 = n2++;
            node.y[n4] = node.y[n4] + d2;
        }
        this.invalidate();
    }

    public void setPoint(int n, int n2, Point2D.Double double_) {
        BezierPath.Node node = new BezierPath.Node((BezierPath.Node)this.path.get(n));
        node.setControlPoint(n2, double_);
        this.setNode(n, node);
    }

    public void setStartPoint(Point2D.Double double_) {
        for (int i = this.getNodeCount(); i < 2; ++i) {
            this.addNode(0, new BezierPath.Node(double_.x, double_.y));
        }
        this.setPoint(0, double_);
    }

    public void setEndPoint(Point2D.Double double_) {
        for (int i = this.getNodeCount(); i < 2; ++i) {
            this.addNode(0, new BezierPath.Node(double_.x, double_.y));
        }
        this.setPoint(this.getNodeCount() - 1, double_);
    }

    @Override
    public Point2D.Double getStartPoint() {
        return this.getPoint(0, 0);
    }

    @Override
    public Point2D.Double getEndPoint() {
        return this.getPoint(this.getNodeCount() - 1, 0);
    }

    public int findNode(Point2D.Double double_) {
        BezierPath bezierPath = this.path;
        for (int i = 0; i < bezierPath.size(); ++i) {
            BezierPath.Node node = (BezierPath.Node)bezierPath.get(i);
            if (node.x[0] != double_.x || node.y[0] != double_.y) continue;
            return i;
        }
        return -1;
    }

    public int findSegment(Point2D.Double double_, double d) {
        return this.getBezierPath().findSegment(double_, d);
    }

    public boolean joinSegments(Point2D.Double double_, double d) {
        int n = this.findSegment(double_, d);
        if (n != -1 && n > 1) {
            this.removeNode(n);
            return true;
        }
        return false;
    }

    public int splitSegment(Point2D.Double double_, double d) {
        int n = this.findSegment(double_, d);
        if (n != -1) {
            this.addNode(n + 1, new BezierPath.Node(double_));
        }
        return n + 1;
    }

    public BezierPath.Node removeNode(int n) {
        return (BezierPath.Node)this.path.remove(n);
    }

    protected void removeAllNodes() {
        this.path.clear();
    }

    public int getNodeCount() {
        return this.path.size();
    }

    @Override
    public BezierFigure clone() {
        BezierFigure bezierFigure = (BezierFigure)super.clone();
        bezierFigure.path = this.path.clone();
        bezierFigure.invalidate();
        return bezierFigure;
    }

    @Override
    public void restoreTransformTo(Object object) {
        this.path.setTo((BezierPath)object);
    }

    @Override
    public Object getTransformRestoreData() {
        return this.path.clone();
    }

    public Point2D.Double chop(Point2D.Double double_) {
        if (this.isClosed()) {
            double d = AttributeKeys.getPerpendicularHitGrowth(this);
            if (d == 0.0) {
                return this.path.chop(double_);
            }
            GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * this.get(AttributeKeys.STROKE_MITER_LIMIT)));
            return Geom.chop(growStroke.createStrokedShape(this.path), double_);
        }
        return this.path.chop(double_);
    }

    public Point2D.Double getCenter() {
        return this.path.getCenter();
    }

    public Point2D.Double getOutermostPoint() {
        return ((BezierPath.Node)this.path.get(this.path.indexOfOutermostNode())).getControlPoint(0);
    }

    public int joinSegments(Point2D.Double double_, float f) {
        return this.path.joinSegments(double_, f);
    }

    public int splitSegment(Point2D.Double double_, float f) {
        return this.path.splitSegment(double_, f);
    }

    @Override
    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        if (mouseEvent.getClickCount() == 2 && drawingView.getHandleDetailLevel() % 2 == 0) {
            this.willChange();
            final int n = this.splitSegment(double_, (float)(5.0 / drawingView.getScaleFactor()));
            if (n != -1) {
                final BezierPath.Node node = this.getNode(n);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                        return resourceBundleUtil.getString("edit.bezierPath.splitSegment.text");
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        BezierFigure.this.willChange();
                        BezierFigure.this.addNode(n, node);
                        BezierFigure.this.changed();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        BezierFigure.this.willChange();
                        BezierFigure.this.removeNode(n);
                        BezierFigure.this.changed();
                    }
                });
                this.changed();
                mouseEvent.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        this.writePoints(dOMOutput);
        this.writeAttributes(dOMOutput);
    }

    protected void writePoints(DOMOutput dOMOutput) throws IOException {
        dOMOutput.openElement("points");
        if (this.isClosed()) {
            dOMOutput.addAttribute("closed", true);
        }
        int n = this.getNodeCount();
        for (int i = 0; i < n; ++i) {
            BezierPath.Node node = this.getNode(i);
            dOMOutput.openElement("p");
            dOMOutput.addAttribute("mask", node.mask, 0);
            dOMOutput.addAttribute("colinear", true);
            dOMOutput.addAttribute("x", node.x[0]);
            dOMOutput.addAttribute("y", node.y[0]);
            dOMOutput.addAttribute("c1x", node.x[1], node.x[0]);
            dOMOutput.addAttribute("c1y", node.y[1], node.y[0]);
            dOMOutput.addAttribute("c2x", node.x[2], node.x[0]);
            dOMOutput.addAttribute("c2y", node.y[2], node.y[0]);
            dOMOutput.closeElement();
        }
        dOMOutput.closeElement();
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        this.readPoints(dOMInput);
        this.readAttributes(dOMInput);
    }

    protected void readPoints(DOMInput dOMInput) throws IOException {
        this.path.clear();
        dOMInput.openElement("points");
        this.setClosed(dOMInput.getAttribute("closed", false));
        int n = dOMInput.getElementCount("p");
        for (int i = 0; i < n; ++i) {
            dOMInput.openElement("p", i);
            BezierPath.Node node = new BezierPath.Node(dOMInput.getAttribute("mask", 0), dOMInput.getAttribute("x", 0.0), dOMInput.getAttribute("y", 0.0), dOMInput.getAttribute("c1x", dOMInput.getAttribute("x", 0.0)), dOMInput.getAttribute("c1y", dOMInput.getAttribute("y", 0.0)), dOMInput.getAttribute("c2x", dOMInput.getAttribute("x", 0.0)), dOMInput.getAttribute("c2y", dOMInput.getAttribute("y", 0.0)));
            node.keepColinear = dOMInput.getAttribute("colinear", true);
            this.path.add(node);
            this.path.invalidatePath();
            dOMInput.closeElement();
        }
        dOMInput.closeElement();
    }
}

