"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupIndexRoutes = setupIndexRoutes;

var _constants = require("../utils/constants");

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupIndexRoutes(services, router) {
  const {
    indexService
  } = services;
  router.get({
    path: _constants.API.INDICES_BASE,
    validate: {}
  }, indexService.getIndices);
  router.post({
    path: _constants.API.UPDATE_ALIASES,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.updateAliases);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkluZGV4Um91dGVzLnRzIl0sIm5hbWVzIjpbInNldHVwSW5kZXhSb3V0ZXMiLCJzZXJ2aWNlcyIsInJvdXRlciIsImluZGV4U2VydmljZSIsImdldCIsInBhdGgiLCJBUEkiLCJJTkRJQ0VTX0JBU0UiLCJ2YWxpZGF0ZSIsImdldEluZGljZXMiLCJwb3N0IiwiVVBEQVRFX0FMSUFTRVMiLCJib2R5Iiwic2NoZW1hIiwiYW55IiwidXBkYXRlQWxpYXNlcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQU1BOztBQUVBOztBQVJBO0FBQ0E7QUFDQTtBQUNBO0FBT08sU0FBU0EsZ0JBQVQsQ0FBMEJDLFFBQTFCLEVBQWtEQyxNQUFsRCxFQUFtRTtBQUN4RSxRQUFNO0FBQUVDLElBQUFBO0FBQUYsTUFBbUJGLFFBQXpCO0FBRUFDLEVBQUFBLE1BQU0sQ0FBQ0UsR0FBUCxDQUNFO0FBQ0VDLElBQUFBLElBQUksRUFBRUMsZUFBSUMsWUFEWjtBQUVFQyxJQUFBQSxRQUFRLEVBQUU7QUFGWixHQURGLEVBS0VMLFlBQVksQ0FBQ00sVUFMZjtBQVFBUCxFQUFBQSxNQUFNLENBQUNRLElBQVAsQ0FDRTtBQUNFTCxJQUFBQSxJQUFJLEVBQUVDLGVBQUlLLGNBRFo7QUFFRUgsSUFBQUEsUUFBUSxFQUFFO0FBQ1JJLE1BQUFBLElBQUksRUFBRUMscUJBQU9DLEdBQVA7QUFERTtBQUZaLEdBREYsRUFPRVgsWUFBWSxDQUFDWSxhQVBmO0FBU0QiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IElSb3V0ZXIgfSBmcm9tICdvcGVuc2VhcmNoLWRhc2hib2FyZHMvc2VydmVyJztcbmltcG9ydCB7IEFQSSB9IGZyb20gJy4uL3V0aWxzL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBOb2RlU2VydmljZXMgfSBmcm9tICcuLi9tb2RlbHMvaW50ZXJmYWNlcyc7XG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xuXG5leHBvcnQgZnVuY3Rpb24gc2V0dXBJbmRleFJvdXRlcyhzZXJ2aWNlczogTm9kZVNlcnZpY2VzLCByb3V0ZXI6IElSb3V0ZXIpIHtcbiAgY29uc3QgeyBpbmRleFNlcnZpY2UgfSA9IHNlcnZpY2VzO1xuXG4gIHJvdXRlci5nZXQoXG4gICAge1xuICAgICAgcGF0aDogQVBJLklORElDRVNfQkFTRSxcbiAgICAgIHZhbGlkYXRlOiB7fSxcbiAgICB9LFxuICAgIGluZGV4U2VydmljZS5nZXRJbmRpY2VzXG4gICk7XG5cbiAgcm91dGVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogQVBJLlVQREFURV9BTElBU0VTLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLmFueSgpLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGluZGV4U2VydmljZS51cGRhdGVBbGlhc2VzXG4gICk7XG59XG4iXX0=