"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeLegendSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var get_deselected_data_series_1 = require("../../../../state/selectors/get_deselected_data_series");
var get_color_scale_1 = require("./get_color_scale");
var heatmap_spec_1 = require("./heatmap_spec");
exports.computeLegendSelector = create_selector_1.createCustomCachedSelector([heatmap_spec_1.getSpecOrNull, get_color_scale_1.getColorScale, get_deselected_data_series_1.getDeselectedSeriesSelector], function (spec, colorScale, deselectedDataSeries) {
    var legendItems = [];
    if (colorScale === null || spec === null) {
        return legendItems;
    }
    return colorScale.ticks.map(function (tick) {
        var color = colorScale.config(tick);
        var seriesIdentifier = {
            key: String(tick),
            specId: String(tick),
        };
        return {
            color: color,
            label: "> " + (spec.valueFormatter ? spec.valueFormatter(tick) : tick),
            seriesIdentifiers: [seriesIdentifier],
            isSeriesHidden: deselectedDataSeries.some(function (dataSeries) { return dataSeries.key === seriesIdentifier.key; }),
            isToggleable: true,
            path: [{ index: 0, value: seriesIdentifier.key }],
            keys: [],
        };
    });
});
//# sourceMappingURL=compute_legend.js.map