/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.cas.group;

import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.guacamole.auth.cas.group.GroupParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPGroupParser
implements GroupParser {
    private static final Logger logger = LoggerFactory.getLogger(LDAPGroupParser.class);
    private final String nameAttribute;
    private final LdapName baseDn;

    public LDAPGroupParser(String nameAttribute, LdapName baseDn) {
        this.nameAttribute = nameAttribute;
        this.baseDn = baseDn;
    }

    @Override
    public String parse(String casGroup) {
        LdapName group;
        if (casGroup == null || casGroup.isEmpty()) {
            return null;
        }
        try {
            group = new LdapName(casGroup);
        }
        catch (InvalidNameException e) {
            logger.debug("CAS group \"{}\" has been rejected as it is not a valid LDAP DN.", (Object)casGroup, (Object)e);
            return null;
        }
        if (this.baseDn != null && !group.startsWith(this.baseDn)) {
            return null;
        }
        Rdn last = group.getRdn(group.size() - 1);
        if (this.nameAttribute != null && !this.nameAttribute.equalsIgnoreCase(last.getType())) {
            return null;
        }
        return last.getValue().toString();
    }
}

