// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourceOSConfigGuestPolicies() *schema.Resource {
	return &schema.Resource{
		Create: resourceOSConfigGuestPoliciesCreate,
		Read:   resourceOSConfigGuestPoliciesRead,
		Update: resourceOSConfigGuestPoliciesUpdate,
		Delete: resourceOSConfigGuestPoliciesDelete,

		Importer: &schema.ResourceImporter{
			State: resourceOSConfigGuestPoliciesImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"assignment": {
				Type:     schema.TypeList,
				Required: true,
				Description: `Specifies the VM instances that are assigned to this policy. This allows you to target sets
or groups of VM instances by different parameters such as labels, names, OS, or zones.
If left empty, all VM instances underneath this policy are targeted.
At the same level in the resource hierarchy (that is within a project), the service prevents
the creation of multiple policies that conflict with each other.
For more information, see how the service
[handles assignment conflicts](https://cloud.google.com/compute/docs/os-config-management/create-guest-policy#handle-conflicts).`,
				MaxItems: 1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"group_labels": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups,
for example "env=prod or env=staging".`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"labels": {
										Type:        schema.TypeMap,
										Required:    true,
										Description: `Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.`,
										Elem:        &schema.Schema{Type: schema.TypeString},
									},
								},
							},
							AtLeastOneOf: []string{"assignment.0.group_labels", "assignment.0.zones", "assignment.0.instances", "assignment.0.instance_name_prefixes", "assignment.0.os_types"},
						},
						"instance_name_prefixes": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Targets VM instances whose name starts with one of these prefixes.
Like labels, this is another way to group VM instances when targeting configs,
for example prefix="prod-".
Only supported for project-level policies.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							AtLeastOneOf: []string{"assignment.0.group_labels", "assignment.0.zones", "assignment.0.instances", "assignment.0.instance_name_prefixes", "assignment.0.os_types"},
						},
						"instances": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Targets any of the instances specified. Instances are specified by their URI in the form
zones/[ZONE]/instances/[INSTANCE_NAME].
Instance targeting is uncommon and is supported to facilitate the management of changes
by the instance or to target specific VM instances for development and testing.
Only supported for project-level policies and must reference instances within this project.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							AtLeastOneOf: []string{"assignment.0.group_labels", "assignment.0.zones", "assignment.0.instances", "assignment.0.instance_name_prefixes", "assignment.0.os_types"},
						},
						"os_types": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Targets VM instances matching at least one of the following OS types.
VM instances must match all supplied criteria for a given OsType to be included.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"os_architecture": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `Targets VM instances with OS Inventory enabled and having the following OS architecture.`,
									},
									"os_short_name": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".`,
									},
									"os_version": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `Targets VM instances with OS Inventory enabled and having the following following OS version.`,
									},
								},
							},
							AtLeastOneOf: []string{"assignment.0.group_labels", "assignment.0.zones", "assignment.0.instances", "assignment.0.instance_name_prefixes", "assignment.0.os_types"},
						},
						"zones": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Targets instances in any of these zones. Leave empty to target instances in any zone.
Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
							AtLeastOneOf: []string{"assignment.0.group_labels", "assignment.0.zones", "assignment.0.instances", "assignment.0.instance_name_prefixes", "assignment.0.os_types"},
						},
					},
				},
			},
			"guest_policy_id": {
				Type:         schema.TypeString,
				Required:     true,
				ValidateFunc: validateRegexp(`(?:(?:[-a-z0-9]{1,63}\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))`),
				Description: `The logical name of the guest policy in the project with the following restrictions:
* Must contain only lowercase letters, numbers, and hyphens.
* Must start with a letter.
* Must be between 1-63 characters.
* Must end with a number or a letter.
* Must be unique within the project.`,
			},
			"description": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `Description of the guest policy. Length of the description is limited to 1024 characters.`,
			},
			"etag": {
				Type:        schema.TypeString,
				Computed:    true,
				Optional:    true,
				Description: `The etag for this guest policy. If this is provided on update, it must match the server's etag.`,
			},
			"package_repositories": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `A list of package repositories to configure on the VM instance.
This is done before any other configs are applied so they can use these repos.
Package repositories are only configured if the corresponding package manager(s) are available.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"apt": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `An Apt Repository.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"components": {
										Type:        schema.TypeList,
										Required:    true,
										Description: `List of components for this repository. Must contain at least one item.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"distribution": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Distribution of this repository.`,
									},
									"uri": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `URI for this repository.`,
									},
									"archive_type": {
										Type:         schema.TypeString,
										Optional:     true,
										ValidateFunc: validateEnum([]string{"DEB", "DEB_SRC", ""}),
										Description:  `Type of archive files in this repository. The default behavior is DEB. Default value: "DEB" Possible values: ["DEB", "DEB_SRC"]`,
										Default:      "DEB",
									},
									"gpg_key": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `URI of the key file for this repository. The agent maintains a keyring at
/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg containing all the keys in any applied guest policy.`,
									},
								},
							},
						},
						"goo": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `A Goo Repository.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"name": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `The name of the repository.`,
									},
									"url": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `The url of the repository.`,
									},
								},
							},
						},
						"yum": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `A Yum Repository.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"base_url": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `The location of the repository directory.`,
									},
									"id": {
										Type:     schema.TypeString,
										Required: true,
										Description: `A one word, unique name for this repository. This is the repo id in the Yum config file and also the displayName
if displayName is omitted. This id is also used as the unique identifier when checking for guest policy conflicts.`,
									},
									"display_name": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `The display name of the repository.`,
									},
									"gpg_keys": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `URIs of GPG keys.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
								},
							},
						},
						"zypper": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `A Zypper Repository.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"base_url": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `The location of the repository directory.`,
									},
									"id": {
										Type:     schema.TypeString,
										Required: true,
										Description: `A one word, unique name for this repository. This is the repo id in the zypper config file and also the displayName
if displayName is omitted. This id is also used as the unique identifier when checking for guest policy conflicts.`,
									},
									"display_name": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `The display name of the repository.`,
									},
									"gpg_keys": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `URIs of GPG keys.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
								},
							},
						},
					},
				},
			},
			"packages": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `The software packages to be managed by this policy.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"name": {
							Type:     schema.TypeString,
							Required: true,
							Description: `The name of the package. A package is uniquely identified for conflict validation
by checking the package name and the manager(s) that the package targets.`,
						},
						"desired_state": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"INSTALLED", "UPDATED", "REMOVED", ""}),
							Description:  `The desiredState the agent should maintain for this package. The default is to ensure the package is installed. Possible values: ["INSTALLED", "UPDATED", "REMOVED"]`,
						},
						"manager": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"ANY", "APT", "YUM", "ZYPPER", "GOO", ""}),
							Description: `Type of package manager that can be used to install this package. If a system does not have the package manager,
the package is not installed or removed no error message is returned. By default, or if you specify ANY,
the agent attempts to install and remove this package using the default package manager.
This is useful when creating a policy that applies to different types of systems.
The default behavior is ANY. Default value: "ANY" Possible values: ["ANY", "APT", "YUM", "ZYPPER", "GOO"]`,
							Default: "ANY",
						},
					},
				},
			},
			"recipes": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `A list of Recipes to install on the VM instance.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"name": {
							Type:     schema.TypeString,
							Required: true,
							Description: `Unique identifier for the recipe. Only one recipe with a given name is installed on an instance.
Names are also used to identify resources which helps to determine whether guest policies have conflicts.
This means that requests to create multiple recipes with the same name and version are rejected since they
could potentially have conflicting assignments.`,
						},
						"artifacts": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Resources available to be used in the steps in the recipe.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"id": {
										Type:     schema.TypeString,
										Required: true,
										Description: `Id of the artifact, which the installation and update steps of this recipe can reference.
Artifacts in a recipe cannot have the same id.`,
									},
									"allow_insecure": {
										Type:     schema.TypeBool,
										Optional: true,
										Description: `Defaults to false. When false, recipes are subject to validations based on the artifact type:
Remote: A checksum must be specified, and only protocols with transport-layer security are permitted.
GCS: An object generation number must be specified.`,
										Default: false,
									},
									"gcs": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `A Google Cloud Storage artifact.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"bucket": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Bucket of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
this value would be my-bucket.`,
												},
												"generation": {
													Type:     schema.TypeInt,
													Optional: true,
													Description: `Must be provided if allowInsecure is false. Generation number of the Google Cloud Storage object.
https://storage.googleapis.com/my-bucket/foo/bar#1234567 this value would be 1234567.`,
												},
												"object": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Name of the Google Cloud Storage object. Given an example URL: https://storage.googleapis.com/my-bucket/foo/bar#1234567
this value would be foo/bar.`,
												},
											},
										},
									},
									"remote": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `A generic remote artifact.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"check_sum": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Must be provided if allowInsecure is false. SHA256 checksum in hex format, to compare to the checksum of the artifact.
If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any
of the steps.`,
												},
												"uri": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.`,
												},
											},
										},
									},
								},
							},
						},
						"desired_state": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"INSTALLED", "UPDATED", "REMOVED", ""}),
							Description: `Default is INSTALLED. The desired state the agent should maintain for this recipe.

INSTALLED: The software recipe is installed on the instance but won't be updated to new versions.
INSTALLED_KEEP_UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version,
if a higher version of the recipe is assigned to this instance.
REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected. Default value: "INSTALLED" Possible values: ["INSTALLED", "UPDATED", "REMOVED"]`,
							Default: "INSTALLED",
						},
						"install_steps": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation.
Any steps taken (including partially completed steps) are not rolled back.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"archive_extraction": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Extracts an archive into the specified directory.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
												"type": {
													Type:         schema.TypeString,
													Required:     true,
													ValidateFunc: validateEnum([]string{"TAR", "TAR_GZIP", "TAR_BZIP", "TAR_LZMA", "TAR_XZ", "ZIP"}),
													Description:  `The type of the archive to extract. Possible values: ["TAR", "TAR_GZIP", "TAR_BZIP", "TAR_LZMA", "TAR_XZ", "ZIP"]`,
												},
												"destination": {
													Type:        schema.TypeString,
													Computed:    true,
													Optional:    true,
													Description: `Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.`,
												},
											},
										},
									},
									"dpkg_installation": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Installs a deb file via dpkg.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
											},
										},
									},
									"file_copy": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Copies a file onto the instance.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
												"destination": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The absolute path on the instance to put the file.`,
												},
												"overwrite": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
is not overwritten and the step is considered a success. Defaults to false.`,
													Default: false,
												},
												"permissions": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
bit corresponds to the execute permission. Default behavior is 755.

Below are some examples of permissions and their associated values:
read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4`,
												},
											},
										},
									},
									"file_exec": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Executes an artifact or local file.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"allowed_exit_codes": {
													Type:        schema.TypeString,
													Computed:    true,
													Optional:    true,
													Description: `A list of possible return values that the program can return to indicate a success. Defaults to [0].`,
												},
												"args": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `Arguments to be passed to the provided executable.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"artifact_id": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
												"local_path": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `The absolute path of the file on the local filesystem.`,
												},
											},
										},
									},
									"msi_installation": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Installs an MSI file.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
												"allowed_exit_codes": {
													Type:        schema.TypeList,
													Computed:    true,
													Optional:    true,
													Description: `Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"flags": {
													Type:        schema.TypeList,
													Computed:    true,
													Optional:    true,
													Description: `The flags to use when installing the MSI. Defaults to the install flag.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
											},
										},
									},
									"rpm_installation": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Installs an rpm file via the rpm utility.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
											},
										},
									},
									"script_run": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Runs commands in a shell.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"script": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The shell script to be executed.`,
												},
												"allowed_exit_codes": {
													Type:        schema.TypeList,
													Computed:    true,
													Optional:    true,
													Description: `Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"interpreter": {
													Type:         schema.TypeString,
													Optional:     true,
													ValidateFunc: validateEnum([]string{"SHELL", "POWERSHELL", ""}),
													Description: `The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
which likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]`,
												},
											},
										},
									},
								},
							},
						},
						"update_steps": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe.
Any steps taken (including partially completed steps) are not rolled back.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"archive_extraction": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Extracts an archive into the specified directory.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
												"type": {
													Type:         schema.TypeString,
													Required:     true,
													ValidateFunc: validateEnum([]string{"TAR", "TAR_GZIP", "TAR_BZIP", "TAR_LZMA", "TAR_XZ", "ZIP"}),
													Description:  `The type of the archive to extract. Possible values: ["TAR", "TAR_GZIP", "TAR_BZIP", "TAR_LZMA", "TAR_XZ", "ZIP"]`,
												},
												"destination": {
													Type:        schema.TypeString,
													Computed:    true,
													Optional:    true,
													Description: `Directory to extract archive to. Defaults to / on Linux or C:\ on Windows.`,
												},
											},
										},
									},
									"dpkg_installation": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Installs a deb file via dpkg.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
											},
										},
									},
									"file_copy": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Copies a file onto the instance.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
												"destination": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The absolute path on the instance to put the file.`,
												},
												"overwrite": {
													Type:     schema.TypeBool,
													Optional: true,
													Description: `Whether to allow this step to overwrite existing files.If this is false and the file already exists the file
is not overwritten and the step is considered a success. Defaults to false.`,
													Default: false,
												},
												"permissions": {
													Type:     schema.TypeString,
													Optional: true,
													Description: `Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users
for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit
number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one
bit corresponds to the execute permission. Default behavior is 755.

Below are some examples of permissions and their associated values:
read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4`,
												},
											},
										},
									},
									"file_exec": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Executes an artifact or local file.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"allowed_exit_codes": {
													Type:        schema.TypeList,
													Computed:    true,
													Optional:    true,
													Description: `A list of possible return values that the program can return to indicate a success. Defaults to [0].`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"args": {
													Type:        schema.TypeList,
													Optional:    true,
													Description: `Arguments to be passed to the provided executable.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"artifact_id": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
												"local_path": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `The absolute path of the file on the local filesystem.`,
												},
											},
										},
									},
									"msi_installation": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Installs an MSI file.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
												"allowed_exit_codes": {
													Type:        schema.TypeList,
													Computed:    true,
													Optional:    true,
													Description: `Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"flags": {
													Type:        schema.TypeList,
													Computed:    true,
													Optional:    true,
													Description: `The flags to use when installing the MSI. Defaults to the install flag.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
											},
										},
									},
									"rpm_installation": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Installs an rpm file via the rpm utility.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"artifact_id": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The id of the relevant artifact in the recipe.`,
												},
											},
										},
									},
									"script_run": {
										Type:        schema.TypeList,
										Optional:    true,
										Description: `Runs commands in a shell.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"script": {
													Type:        schema.TypeString,
													Required:    true,
													Description: `The shell script to be executed.`,
												},
												"allowed_exit_codes": {
													Type:        schema.TypeList,
													Computed:    true,
													Optional:    true,
													Description: `Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
												"interpreter": {
													Type:         schema.TypeString,
													Optional:     true,
													ValidateFunc: validateEnum([]string{"SHELL", "POWERSHELL", ""}),
													Description: `The script interpreter to use to run the script. If no interpreter is specified the script is executed directly,
which likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]`,
												},
											},
										},
									},
								},
							},
						},
						"version": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).`,
						},
					},
				},
			},
			"create_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `Time this guest policy was created. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
Example: "2014-10-02T15:01:23.045123456Z".`,
			},
			"name": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Unique name of the resource in this project using one of the following forms: projects/{project_number}/guestPolicies/{guestPolicyId}.`,
			},
			"update_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `Last time this guest policy was updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
Example: "2014-10-02T15:01:23.045123456Z".`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceOSConfigGuestPoliciesCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	descriptionProp, err := expandOSConfigGuestPoliciesDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(descriptionProp)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	assignmentProp, err := expandOSConfigGuestPoliciesAssignment(d.Get("assignment"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("assignment"); !isEmptyValue(reflect.ValueOf(assignmentProp)) && (ok || !reflect.DeepEqual(v, assignmentProp)) {
		obj["assignment"] = assignmentProp
	}
	packagesProp, err := expandOSConfigGuestPoliciesPackages(d.Get("packages"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("packages"); !isEmptyValue(reflect.ValueOf(packagesProp)) && (ok || !reflect.DeepEqual(v, packagesProp)) {
		obj["packages"] = packagesProp
	}
	packageRepositoriesProp, err := expandOSConfigGuestPoliciesPackageRepositories(d.Get("package_repositories"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("package_repositories"); !isEmptyValue(reflect.ValueOf(packageRepositoriesProp)) && (ok || !reflect.DeepEqual(v, packageRepositoriesProp)) {
		obj["packageRepositories"] = packageRepositoriesProp
	}
	recipesProp, err := expandOSConfigGuestPoliciesRecipes(d.Get("recipes"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("recipes"); !isEmptyValue(reflect.ValueOf(recipesProp)) && (ok || !reflect.DeepEqual(v, recipesProp)) {
		obj["recipes"] = recipesProp
	}
	etagProp, err := expandOSConfigGuestPoliciesEtag(d.Get("etag"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("etag"); !isEmptyValue(reflect.ValueOf(etagProp)) && (ok || !reflect.DeepEqual(v, etagProp)) {
		obj["etag"] = etagProp
	}

	url, err := replaceVars(d, config, "{{OSConfigBasePath}}projects/{{project}}/guestPolicies?guestPolicyId={{guest_policy_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new GuestPolicies: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for GuestPolicies: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating GuestPolicies: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/guestPolicies/{{guest_policy_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// `name` is autogenerated from the api so needs to be set post-create
	name, ok := res["name"]
	if !ok {
		respBody, ok := res["response"]
		if !ok {
			return fmt.Errorf("Create response didn't contain critical fields. Create may not have succeeded.")
		}

		name, ok = respBody.(map[string]interface{})["name"]
		if !ok {
			return fmt.Errorf("Create response didn't contain critical fields. Create may not have succeeded.")
		}
	}
	if err := d.Set("name", name.(string)); err != nil {
		return fmt.Errorf("Error setting name: %s", err)
	}
	d.SetId(name.(string))

	log.Printf("[DEBUG] Finished creating GuestPolicies %q: %#v", d.Id(), res)

	return resourceOSConfigGuestPoliciesRead(d, meta)
}

func resourceOSConfigGuestPoliciesRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{OSConfigBasePath}}projects/{{project}}/guestPolicies/{{guest_policy_id}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for GuestPolicies: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("OSConfigGuestPolicies %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}

	if err := d.Set("name", flattenOSConfigGuestPoliciesName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}
	if err := d.Set("description", flattenOSConfigGuestPoliciesDescription(res["description"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}
	if err := d.Set("assignment", flattenOSConfigGuestPoliciesAssignment(res["assignment"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}
	if err := d.Set("packages", flattenOSConfigGuestPoliciesPackages(res["packages"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}
	if err := d.Set("package_repositories", flattenOSConfigGuestPoliciesPackageRepositories(res["packageRepositories"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}
	if err := d.Set("recipes", flattenOSConfigGuestPoliciesRecipes(res["recipes"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}
	if err := d.Set("create_time", flattenOSConfigGuestPoliciesCreateTime(res["createTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}
	if err := d.Set("update_time", flattenOSConfigGuestPoliciesUpdateTime(res["updateTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}
	if err := d.Set("etag", flattenOSConfigGuestPoliciesEtag(res["etag"], d, config)); err != nil {
		return fmt.Errorf("Error reading GuestPolicies: %s", err)
	}

	return nil
}

func resourceOSConfigGuestPoliciesUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for GuestPolicies: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	descriptionProp, err := expandOSConfigGuestPoliciesDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	assignmentProp, err := expandOSConfigGuestPoliciesAssignment(d.Get("assignment"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("assignment"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, assignmentProp)) {
		obj["assignment"] = assignmentProp
	}
	packagesProp, err := expandOSConfigGuestPoliciesPackages(d.Get("packages"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("packages"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, packagesProp)) {
		obj["packages"] = packagesProp
	}
	packageRepositoriesProp, err := expandOSConfigGuestPoliciesPackageRepositories(d.Get("package_repositories"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("package_repositories"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, packageRepositoriesProp)) {
		obj["packageRepositories"] = packageRepositoriesProp
	}
	recipesProp, err := expandOSConfigGuestPoliciesRecipes(d.Get("recipes"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("recipes"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, recipesProp)) {
		obj["recipes"] = recipesProp
	}
	etagProp, err := expandOSConfigGuestPoliciesEtag(d.Get("etag"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("etag"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, etagProp)) {
		obj["etag"] = etagProp
	}

	url, err := replaceVars(d, config, "{{OSConfigBasePath}}projects/{{project}}/guestPolicies/{{guest_policy_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating GuestPolicies %q: %#v", d.Id(), obj)

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating GuestPolicies %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating GuestPolicies %q: %#v", d.Id(), res)
	}

	return resourceOSConfigGuestPoliciesRead(d, meta)
}

func resourceOSConfigGuestPoliciesDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for GuestPolicies: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{OSConfigBasePath}}projects/{{project}}/guestPolicies/{{guest_policy_id}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting GuestPolicies %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "GuestPolicies")
	}

	log.Printf("[DEBUG] Finished deleting GuestPolicies %q: %#v", d.Id(), res)
	return nil
}

func resourceOSConfigGuestPoliciesImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/guestPolicies/(?P<guest_policy_id>[^/]+)",
		"(?P<project>[^/]+)/(?P<guest_policy_id>[^/]+)",
		"(?P<guest_policy_id>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/guestPolicies/{{guest_policy_id}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenOSConfigGuestPoliciesName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesAssignment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["group_labels"] =
		flattenOSConfigGuestPoliciesAssignmentGroupLabels(original["groupLabels"], d, config)
	transformed["zones"] =
		flattenOSConfigGuestPoliciesAssignmentZones(original["zones"], d, config)
	transformed["instances"] =
		flattenOSConfigGuestPoliciesAssignmentInstances(original["instances"], d, config)
	transformed["instance_name_prefixes"] =
		flattenOSConfigGuestPoliciesAssignmentInstanceNamePrefixes(original["instanceNamePrefixes"], d, config)
	transformed["os_types"] =
		flattenOSConfigGuestPoliciesAssignmentOsTypes(original["osTypes"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesAssignmentGroupLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"labels": flattenOSConfigGuestPoliciesAssignmentGroupLabelsLabels(original["labels"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigGuestPoliciesAssignmentGroupLabelsLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesAssignmentZones(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesAssignmentInstances(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesAssignmentInstanceNamePrefixes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesAssignmentOsTypes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"os_short_name":   flattenOSConfigGuestPoliciesAssignmentOsTypesOsShortName(original["osShortName"], d, config),
			"os_version":      flattenOSConfigGuestPoliciesAssignmentOsTypesOsVersion(original["osVersion"], d, config),
			"os_architecture": flattenOSConfigGuestPoliciesAssignmentOsTypesOsArchitecture(original["osArchitecture"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigGuestPoliciesAssignmentOsTypesOsShortName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesAssignmentOsTypesOsVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesAssignmentOsTypesOsArchitecture(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"name":          flattenOSConfigGuestPoliciesPackagesName(original["name"], d, config),
			"desired_state": flattenOSConfigGuestPoliciesPackagesDesiredState(original["desiredState"], d, config),
			"manager":       flattenOSConfigGuestPoliciesPackagesManager(original["manager"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigGuestPoliciesPackagesName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackagesDesiredState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackagesManager(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositories(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"apt":    flattenOSConfigGuestPoliciesPackageRepositoriesApt(original["apt"], d, config),
			"yum":    flattenOSConfigGuestPoliciesPackageRepositoriesYum(original["yum"], d, config),
			"zypper": flattenOSConfigGuestPoliciesPackageRepositoriesZypper(original["zypper"], d, config),
			"goo":    flattenOSConfigGuestPoliciesPackageRepositoriesGoo(original["goo"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigGuestPoliciesPackageRepositoriesApt(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["archive_type"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesAptArchiveType(original["archiveType"], d, config)
	transformed["uri"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesAptUri(original["uri"], d, config)
	transformed["distribution"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesAptDistribution(original["distribution"], d, config)
	transformed["components"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesAptComponents(original["components"], d, config)
	transformed["gpg_key"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesAptGpgKey(original["gpgKey"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesPackageRepositoriesAptArchiveType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesAptUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesAptDistribution(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesAptComponents(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesAptGpgKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesYum(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["id"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesYumId(original["id"], d, config)
	transformed["display_name"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesYumDisplayName(original["displayName"], d, config)
	transformed["base_url"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesYumBaseUrl(original["baseUrl"], d, config)
	transformed["gpg_keys"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesYumGpgKeys(original["gpgKeys"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesPackageRepositoriesYumId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesYumDisplayName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesYumBaseUrl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesYumGpgKeys(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesZypper(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["id"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesZypperId(original["id"], d, config)
	transformed["display_name"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesZypperDisplayName(original["displayName"], d, config)
	transformed["base_url"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesZypperBaseUrl(original["baseUrl"], d, config)
	transformed["gpg_keys"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesZypperGpgKeys(original["gpgKeys"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesPackageRepositoriesZypperId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesZypperDisplayName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesZypperBaseUrl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesZypperGpgKeys(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesGoo(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["name"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesGooName(original["name"], d, config)
	transformed["url"] =
		flattenOSConfigGuestPoliciesPackageRepositoriesGooUrl(original["url"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesPackageRepositoriesGooName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesPackageRepositoriesGooUrl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"name":          flattenOSConfigGuestPoliciesRecipesName(original["name"], d, config),
			"version":       flattenOSConfigGuestPoliciesRecipesVersion(original["version"], d, config),
			"artifacts":     flattenOSConfigGuestPoliciesRecipesArtifacts(original["artifacts"], d, config),
			"install_steps": flattenOSConfigGuestPoliciesRecipesInstallSteps(original["installSteps"], d, config),
			"update_steps":  flattenOSConfigGuestPoliciesRecipesUpdateSteps(original["updateSteps"], d, config),
			"desired_state": flattenOSConfigGuestPoliciesRecipesDesiredState(original["desiredState"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigGuestPoliciesRecipesName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesArtifacts(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"id":             flattenOSConfigGuestPoliciesRecipesArtifactsId(original["id"], d, config),
			"allow_insecure": flattenOSConfigGuestPoliciesRecipesArtifactsAllowInsecure(original["allowInsecure"], d, config),
			"remote":         flattenOSConfigGuestPoliciesRecipesArtifactsRemote(original["remote"], d, config),
			"gcs":            flattenOSConfigGuestPoliciesRecipesArtifactsGcs(original["gcs"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigGuestPoliciesRecipesArtifactsId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesArtifactsAllowInsecure(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesArtifactsRemote(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["uri"] =
		flattenOSConfigGuestPoliciesRecipesArtifactsRemoteUri(original["uri"], d, config)
	transformed["check_sum"] =
		flattenOSConfigGuestPoliciesRecipesArtifactsRemoteCheckSum(original["checkSum"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesArtifactsRemoteUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesArtifactsRemoteCheckSum(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesArtifactsGcs(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket"] =
		flattenOSConfigGuestPoliciesRecipesArtifactsGcsBucket(original["bucket"], d, config)
	transformed["object"] =
		flattenOSConfigGuestPoliciesRecipesArtifactsGcsObject(original["object"], d, config)
	transformed["generation"] =
		flattenOSConfigGuestPoliciesRecipesArtifactsGcsGeneration(original["generation"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesArtifactsGcsBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesArtifactsGcsObject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesArtifactsGcsGeneration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenOSConfigGuestPoliciesRecipesInstallSteps(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"file_copy":          flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopy(original["fileCopy"], d, config),
			"archive_extraction": flattenOSConfigGuestPoliciesRecipesInstallStepsArchiveExtraction(original["archiveExtraction"], d, config),
			"msi_installation":   flattenOSConfigGuestPoliciesRecipesInstallStepsMsiInstallation(original["msiInstallation"], d, config),
			"dpkg_installation":  flattenOSConfigGuestPoliciesRecipesInstallStepsDpkgInstallation(original["dpkgInstallation"], d, config),
			"rpm_installation":   flattenOSConfigGuestPoliciesRecipesInstallStepsRpmInstallation(original["rpmInstallation"], d, config),
			"file_exec":          flattenOSConfigGuestPoliciesRecipesInstallStepsFileExec(original["fileExec"], d, config),
			"script_run":         flattenOSConfigGuestPoliciesRecipesInstallStepsScriptRun(original["scriptRun"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopy(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopyArtifactId(original["artifactId"], d, config)
	transformed["destination"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopyDestination(original["destination"], d, config)
	transformed["overwrite"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopyOverwrite(original["overwrite"], d, config)
	transformed["permissions"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopyPermissions(original["permissions"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopyArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopyDestination(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopyOverwrite(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsFileCopyPermissions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsArchiveExtraction(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionArtifactId(original["artifactId"], d, config)
	transformed["destination"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionDestination(original["destination"], d, config)
	transformed["type"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionType(original["type"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionDestination(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsMsiInstallation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationArtifactId(original["artifactId"], d, config)
	transformed["flags"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationFlags(original["flags"], d, config)
	transformed["allowed_exit_codes"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationAllowedExitCodes(original["allowedExitCodes"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationFlags(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationAllowedExitCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsDpkgInstallation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsDpkgInstallationArtifactId(original["artifactId"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesInstallStepsDpkgInstallationArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsRpmInstallation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsRpmInstallationArtifactId(original["artifactId"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesInstallStepsRpmInstallationArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsFileExec(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["args"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsFileExecArgs(original["args"], d, config)
	transformed["allowed_exit_codes"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsFileExecAllowedExitCodes(original["allowedExitCodes"], d, config)
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsFileExecArtifactId(original["artifactId"], d, config)
	transformed["local_path"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsFileExecLocalPath(original["localPath"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesInstallStepsFileExecArgs(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsFileExecAllowedExitCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsFileExecArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsFileExecLocalPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsScriptRun(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["script"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsScriptRunScript(original["script"], d, config)
	transformed["allowed_exit_codes"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsScriptRunAllowedExitCodes(original["allowedExitCodes"], d, config)
	transformed["interpreter"] =
		flattenOSConfigGuestPoliciesRecipesInstallStepsScriptRunInterpreter(original["interpreter"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesInstallStepsScriptRunScript(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsScriptRunAllowedExitCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesInstallStepsScriptRunInterpreter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateSteps(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"file_copy":          flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopy(original["fileCopy"], d, config),
			"archive_extraction": flattenOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction(original["archiveExtraction"], d, config),
			"msi_installation":   flattenOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallation(original["msiInstallation"], d, config),
			"dpkg_installation":  flattenOSConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation(original["dpkgInstallation"], d, config),
			"rpm_installation":   flattenOSConfigGuestPoliciesRecipesUpdateStepsRpmInstallation(original["rpmInstallation"], d, config),
			"file_exec":          flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExec(original["fileExec"], d, config),
			"script_run":         flattenOSConfigGuestPoliciesRecipesUpdateStepsScriptRun(original["scriptRun"], d, config),
		})
	}
	return transformed
}
func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopy(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopyArtifactId(original["artifactId"], d, config)
	transformed["destination"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopyDestination(original["destination"], d, config)
	transformed["overwrite"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopyOverwrite(original["overwrite"], d, config)
	transformed["permissions"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopyPermissions(original["permissions"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopyArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopyDestination(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopyOverwrite(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileCopyPermissions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionArtifactId(original["artifactId"], d, config)
	transformed["destination"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionDestination(original["destination"], d, config)
	transformed["type"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionType(original["type"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionDestination(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationArtifactId(original["artifactId"], d, config)
	transformed["flags"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationFlags(original["flags"], d, config)
	transformed["allowed_exit_codes"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationAllowedExitCodes(original["allowedExitCodes"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationFlags(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationAllowedExitCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsDpkgInstallationArtifactId(original["artifactId"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesUpdateStepsDpkgInstallationArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsRpmInstallation(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsRpmInstallationArtifactId(original["artifactId"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesUpdateStepsRpmInstallationArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExec(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["args"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExecArgs(original["args"], d, config)
	transformed["allowed_exit_codes"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExecAllowedExitCodes(original["allowedExitCodes"], d, config)
	transformed["artifact_id"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExecArtifactId(original["artifactId"], d, config)
	transformed["local_path"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExecLocalPath(original["localPath"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExecArgs(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExecAllowedExitCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExecArtifactId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsFileExecLocalPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsScriptRun(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["script"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsScriptRunScript(original["script"], d, config)
	transformed["allowed_exit_codes"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsScriptRunAllowedExitCodes(original["allowedExitCodes"], d, config)
	transformed["interpreter"] =
		flattenOSConfigGuestPoliciesRecipesUpdateStepsScriptRunInterpreter(original["interpreter"], d, config)
	return []interface{}{transformed}
}
func flattenOSConfigGuestPoliciesRecipesUpdateStepsScriptRunScript(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsScriptRunAllowedExitCodes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesUpdateStepsScriptRunInterpreter(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesRecipesDesiredState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesCreateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesUpdateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenOSConfigGuestPoliciesEtag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandOSConfigGuestPoliciesDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesAssignment(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedGroupLabels, err := expandOSConfigGuestPoliciesAssignmentGroupLabels(original["group_labels"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGroupLabels); val.IsValid() && !isEmptyValue(val) {
		transformed["groupLabels"] = transformedGroupLabels
	}

	transformedZones, err := expandOSConfigGuestPoliciesAssignmentZones(original["zones"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedZones); val.IsValid() && !isEmptyValue(val) {
		transformed["zones"] = transformedZones
	}

	transformedInstances, err := expandOSConfigGuestPoliciesAssignmentInstances(original["instances"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstances); val.IsValid() && !isEmptyValue(val) {
		transformed["instances"] = transformedInstances
	}

	transformedInstanceNamePrefixes, err := expandOSConfigGuestPoliciesAssignmentInstanceNamePrefixes(original["instance_name_prefixes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstanceNamePrefixes); val.IsValid() && !isEmptyValue(val) {
		transformed["instanceNamePrefixes"] = transformedInstanceNamePrefixes
	}

	transformedOsTypes, err := expandOSConfigGuestPoliciesAssignmentOsTypes(original["os_types"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOsTypes); val.IsValid() && !isEmptyValue(val) {
		transformed["osTypes"] = transformedOsTypes
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesAssignmentGroupLabels(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedLabels, err := expandOSConfigGuestPoliciesAssignmentGroupLabelsLabels(original["labels"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedLabels); val.IsValid() && !isEmptyValue(val) {
			transformed["labels"] = transformedLabels
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigGuestPoliciesAssignmentGroupLabelsLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandOSConfigGuestPoliciesAssignmentZones(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesAssignmentInstances(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesAssignmentInstanceNamePrefixes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesAssignmentOsTypes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedOsShortName, err := expandOSConfigGuestPoliciesAssignmentOsTypesOsShortName(original["os_short_name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedOsShortName); val.IsValid() && !isEmptyValue(val) {
			transformed["osShortName"] = transformedOsShortName
		}

		transformedOsVersion, err := expandOSConfigGuestPoliciesAssignmentOsTypesOsVersion(original["os_version"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedOsVersion); val.IsValid() && !isEmptyValue(val) {
			transformed["osVersion"] = transformedOsVersion
		}

		transformedOsArchitecture, err := expandOSConfigGuestPoliciesAssignmentOsTypesOsArchitecture(original["os_architecture"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedOsArchitecture); val.IsValid() && !isEmptyValue(val) {
			transformed["osArchitecture"] = transformedOsArchitecture
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigGuestPoliciesAssignmentOsTypesOsShortName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesAssignmentOsTypesOsVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesAssignmentOsTypesOsArchitecture(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackages(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandOSConfigGuestPoliciesPackagesName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedDesiredState, err := expandOSConfigGuestPoliciesPackagesDesiredState(original["desired_state"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDesiredState); val.IsValid() && !isEmptyValue(val) {
			transformed["desiredState"] = transformedDesiredState
		}

		transformedManager, err := expandOSConfigGuestPoliciesPackagesManager(original["manager"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedManager); val.IsValid() && !isEmptyValue(val) {
			transformed["manager"] = transformedManager
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigGuestPoliciesPackagesName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackagesDesiredState(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackagesManager(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositories(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedApt, err := expandOSConfigGuestPoliciesPackageRepositoriesApt(original["apt"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedApt); val.IsValid() && !isEmptyValue(val) {
			transformed["apt"] = transformedApt
		}

		transformedYum, err := expandOSConfigGuestPoliciesPackageRepositoriesYum(original["yum"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedYum); val.IsValid() && !isEmptyValue(val) {
			transformed["yum"] = transformedYum
		}

		transformedZypper, err := expandOSConfigGuestPoliciesPackageRepositoriesZypper(original["zypper"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedZypper); val.IsValid() && !isEmptyValue(val) {
			transformed["zypper"] = transformedZypper
		}

		transformedGoo, err := expandOSConfigGuestPoliciesPackageRepositoriesGoo(original["goo"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedGoo); val.IsValid() && !isEmptyValue(val) {
			transformed["goo"] = transformedGoo
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesApt(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArchiveType, err := expandOSConfigGuestPoliciesPackageRepositoriesAptArchiveType(original["archive_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArchiveType); val.IsValid() && !isEmptyValue(val) {
		transformed["archiveType"] = transformedArchiveType
	}

	transformedUri, err := expandOSConfigGuestPoliciesPackageRepositoriesAptUri(original["uri"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUri); val.IsValid() && !isEmptyValue(val) {
		transformed["uri"] = transformedUri
	}

	transformedDistribution, err := expandOSConfigGuestPoliciesPackageRepositoriesAptDistribution(original["distribution"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDistribution); val.IsValid() && !isEmptyValue(val) {
		transformed["distribution"] = transformedDistribution
	}

	transformedComponents, err := expandOSConfigGuestPoliciesPackageRepositoriesAptComponents(original["components"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedComponents); val.IsValid() && !isEmptyValue(val) {
		transformed["components"] = transformedComponents
	}

	transformedGpgKey, err := expandOSConfigGuestPoliciesPackageRepositoriesAptGpgKey(original["gpg_key"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGpgKey); val.IsValid() && !isEmptyValue(val) {
		transformed["gpgKey"] = transformedGpgKey
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesAptArchiveType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesAptUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesAptDistribution(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesAptComponents(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesAptGpgKey(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesYum(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedId, err := expandOSConfigGuestPoliciesPackageRepositoriesYumId(original["id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedId); val.IsValid() && !isEmptyValue(val) {
		transformed["id"] = transformedId
	}

	transformedDisplayName, err := expandOSConfigGuestPoliciesPackageRepositoriesYumDisplayName(original["display_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDisplayName); val.IsValid() && !isEmptyValue(val) {
		transformed["displayName"] = transformedDisplayName
	}

	transformedBaseUrl, err := expandOSConfigGuestPoliciesPackageRepositoriesYumBaseUrl(original["base_url"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBaseUrl); val.IsValid() && !isEmptyValue(val) {
		transformed["baseUrl"] = transformedBaseUrl
	}

	transformedGpgKeys, err := expandOSConfigGuestPoliciesPackageRepositoriesYumGpgKeys(original["gpg_keys"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGpgKeys); val.IsValid() && !isEmptyValue(val) {
		transformed["gpgKeys"] = transformedGpgKeys
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesYumId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesYumDisplayName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesYumBaseUrl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesYumGpgKeys(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesZypper(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedId, err := expandOSConfigGuestPoliciesPackageRepositoriesZypperId(original["id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedId); val.IsValid() && !isEmptyValue(val) {
		transformed["id"] = transformedId
	}

	transformedDisplayName, err := expandOSConfigGuestPoliciesPackageRepositoriesZypperDisplayName(original["display_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDisplayName); val.IsValid() && !isEmptyValue(val) {
		transformed["displayName"] = transformedDisplayName
	}

	transformedBaseUrl, err := expandOSConfigGuestPoliciesPackageRepositoriesZypperBaseUrl(original["base_url"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBaseUrl); val.IsValid() && !isEmptyValue(val) {
		transformed["baseUrl"] = transformedBaseUrl
	}

	transformedGpgKeys, err := expandOSConfigGuestPoliciesPackageRepositoriesZypperGpgKeys(original["gpg_keys"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGpgKeys); val.IsValid() && !isEmptyValue(val) {
		transformed["gpgKeys"] = transformedGpgKeys
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesZypperId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesZypperDisplayName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesZypperBaseUrl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesZypperGpgKeys(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesGoo(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedName, err := expandOSConfigGuestPoliciesPackageRepositoriesGooName(original["name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
		transformed["name"] = transformedName
	}

	transformedUrl, err := expandOSConfigGuestPoliciesPackageRepositoriesGooUrl(original["url"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUrl); val.IsValid() && !isEmptyValue(val) {
		transformed["url"] = transformedUrl
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesGooName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesPackageRepositoriesGooUrl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandOSConfigGuestPoliciesRecipesName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedVersion, err := expandOSConfigGuestPoliciesRecipesVersion(original["version"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedVersion); val.IsValid() && !isEmptyValue(val) {
			transformed["version"] = transformedVersion
		}

		transformedArtifacts, err := expandOSConfigGuestPoliciesRecipesArtifacts(original["artifacts"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedArtifacts); val.IsValid() && !isEmptyValue(val) {
			transformed["artifacts"] = transformedArtifacts
		}

		transformedInstallSteps, err := expandOSConfigGuestPoliciesRecipesInstallSteps(original["install_steps"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedInstallSteps); val.IsValid() && !isEmptyValue(val) {
			transformed["installSteps"] = transformedInstallSteps
		}

		transformedUpdateSteps, err := expandOSConfigGuestPoliciesRecipesUpdateSteps(original["update_steps"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedUpdateSteps); val.IsValid() && !isEmptyValue(val) {
			transformed["updateSteps"] = transformedUpdateSteps
		}

		transformedDesiredState, err := expandOSConfigGuestPoliciesRecipesDesiredState(original["desired_state"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDesiredState); val.IsValid() && !isEmptyValue(val) {
			transformed["desiredState"] = transformedDesiredState
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigGuestPoliciesRecipesName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesArtifacts(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedId, err := expandOSConfigGuestPoliciesRecipesArtifactsId(original["id"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedId); val.IsValid() && !isEmptyValue(val) {
			transformed["id"] = transformedId
		}

		transformedAllowInsecure, err := expandOSConfigGuestPoliciesRecipesArtifactsAllowInsecure(original["allow_insecure"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedAllowInsecure); val.IsValid() && !isEmptyValue(val) {
			transformed["allowInsecure"] = transformedAllowInsecure
		}

		transformedRemote, err := expandOSConfigGuestPoliciesRecipesArtifactsRemote(original["remote"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRemote); val.IsValid() && !isEmptyValue(val) {
			transformed["remote"] = transformedRemote
		}

		transformedGcs, err := expandOSConfigGuestPoliciesRecipesArtifactsGcs(original["gcs"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedGcs); val.IsValid() && !isEmptyValue(val) {
			transformed["gcs"] = transformedGcs
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsAllowInsecure(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsRemote(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedUri, err := expandOSConfigGuestPoliciesRecipesArtifactsRemoteUri(original["uri"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUri); val.IsValid() && !isEmptyValue(val) {
		transformed["uri"] = transformedUri
	}

	transformedCheckSum, err := expandOSConfigGuestPoliciesRecipesArtifactsRemoteCheckSum(original["check_sum"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCheckSum); val.IsValid() && !isEmptyValue(val) {
		transformed["checkSum"] = transformedCheckSum
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsRemoteUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsRemoteCheckSum(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsGcs(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucket, err := expandOSConfigGuestPoliciesRecipesArtifactsGcsBucket(original["bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["bucket"] = transformedBucket
	}

	transformedObject, err := expandOSConfigGuestPoliciesRecipesArtifactsGcsObject(original["object"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObject); val.IsValid() && !isEmptyValue(val) {
		transformed["object"] = transformedObject
	}

	transformedGeneration, err := expandOSConfigGuestPoliciesRecipesArtifactsGcsGeneration(original["generation"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedGeneration); val.IsValid() && !isEmptyValue(val) {
		transformed["generation"] = transformedGeneration
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsGcsBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsGcsObject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesArtifactsGcsGeneration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallSteps(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedFileCopy, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileCopy(original["file_copy"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedFileCopy); val.IsValid() && !isEmptyValue(val) {
			transformed["fileCopy"] = transformedFileCopy
		}

		transformedArchiveExtraction, err := expandOSConfigGuestPoliciesRecipesInstallStepsArchiveExtraction(original["archive_extraction"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedArchiveExtraction); val.IsValid() && !isEmptyValue(val) {
			transformed["archiveExtraction"] = transformedArchiveExtraction
		}

		transformedMsiInstallation, err := expandOSConfigGuestPoliciesRecipesInstallStepsMsiInstallation(original["msi_installation"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedMsiInstallation); val.IsValid() && !isEmptyValue(val) {
			transformed["msiInstallation"] = transformedMsiInstallation
		}

		transformedDpkgInstallation, err := expandOSConfigGuestPoliciesRecipesInstallStepsDpkgInstallation(original["dpkg_installation"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDpkgInstallation); val.IsValid() && !isEmptyValue(val) {
			transformed["dpkgInstallation"] = transformedDpkgInstallation
		}

		transformedRpmInstallation, err := expandOSConfigGuestPoliciesRecipesInstallStepsRpmInstallation(original["rpm_installation"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRpmInstallation); val.IsValid() && !isEmptyValue(val) {
			transformed["rpmInstallation"] = transformedRpmInstallation
		}

		transformedFileExec, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileExec(original["file_exec"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedFileExec); val.IsValid() && !isEmptyValue(val) {
			transformed["fileExec"] = transformedFileExec
		}

		transformedScriptRun, err := expandOSConfigGuestPoliciesRecipesInstallStepsScriptRun(original["script_run"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedScriptRun); val.IsValid() && !isEmptyValue(val) {
			transformed["scriptRun"] = transformedScriptRun
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileCopy(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileCopyArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	transformedDestination, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileCopyDestination(original["destination"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestination); val.IsValid() && !isEmptyValue(val) {
		transformed["destination"] = transformedDestination
	}

	transformedOverwrite, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileCopyOverwrite(original["overwrite"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOverwrite); val.IsValid() && !isEmptyValue(val) {
		transformed["overwrite"] = transformedOverwrite
	}

	transformedPermissions, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileCopyPermissions(original["permissions"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPermissions); val.IsValid() && !isEmptyValue(val) {
		transformed["permissions"] = transformedPermissions
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileCopyArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileCopyDestination(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileCopyOverwrite(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileCopyPermissions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsArchiveExtraction(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	transformedDestination, err := expandOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionDestination(original["destination"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestination); val.IsValid() && !isEmptyValue(val) {
		transformed["destination"] = transformedDestination
	}

	transformedType, err := expandOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionType(original["type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedType); val.IsValid() && !isEmptyValue(val) {
		transformed["type"] = transformedType
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionDestination(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsArchiveExtractionType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsMsiInstallation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	transformedFlags, err := expandOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationFlags(original["flags"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFlags); val.IsValid() && !isEmptyValue(val) {
		transformed["flags"] = transformedFlags
	}

	transformedAllowedExitCodes, err := expandOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationAllowedExitCodes(original["allowed_exit_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedExitCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedExitCodes"] = transformedAllowedExitCodes
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationFlags(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsMsiInstallationAllowedExitCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsDpkgInstallation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesInstallStepsDpkgInstallationArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsDpkgInstallationArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsRpmInstallation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesInstallStepsRpmInstallationArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsRpmInstallationArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileExec(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArgs, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileExecArgs(original["args"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArgs); val.IsValid() && !isEmptyValue(val) {
		transformed["args"] = transformedArgs
	}

	transformedAllowedExitCodes, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileExecAllowedExitCodes(original["allowed_exit_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedExitCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedExitCodes"] = transformedAllowedExitCodes
	}

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileExecArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	transformedLocalPath, err := expandOSConfigGuestPoliciesRecipesInstallStepsFileExecLocalPath(original["local_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocalPath); val.IsValid() && !isEmptyValue(val) {
		transformed["localPath"] = transformedLocalPath
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileExecArgs(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileExecAllowedExitCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileExecArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsFileExecLocalPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsScriptRun(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedScript, err := expandOSConfigGuestPoliciesRecipesInstallStepsScriptRunScript(original["script"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedScript); val.IsValid() && !isEmptyValue(val) {
		transformed["script"] = transformedScript
	}

	transformedAllowedExitCodes, err := expandOSConfigGuestPoliciesRecipesInstallStepsScriptRunAllowedExitCodes(original["allowed_exit_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedExitCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedExitCodes"] = transformedAllowedExitCodes
	}

	transformedInterpreter, err := expandOSConfigGuestPoliciesRecipesInstallStepsScriptRunInterpreter(original["interpreter"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInterpreter); val.IsValid() && !isEmptyValue(val) {
		transformed["interpreter"] = transformedInterpreter
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsScriptRunScript(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsScriptRunAllowedExitCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesInstallStepsScriptRunInterpreter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateSteps(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedFileCopy, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopy(original["file_copy"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedFileCopy); val.IsValid() && !isEmptyValue(val) {
			transformed["fileCopy"] = transformedFileCopy
		}

		transformedArchiveExtraction, err := expandOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction(original["archive_extraction"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedArchiveExtraction); val.IsValid() && !isEmptyValue(val) {
			transformed["archiveExtraction"] = transformedArchiveExtraction
		}

		transformedMsiInstallation, err := expandOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallation(original["msi_installation"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedMsiInstallation); val.IsValid() && !isEmptyValue(val) {
			transformed["msiInstallation"] = transformedMsiInstallation
		}

		transformedDpkgInstallation, err := expandOSConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation(original["dpkg_installation"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDpkgInstallation); val.IsValid() && !isEmptyValue(val) {
			transformed["dpkgInstallation"] = transformedDpkgInstallation
		}

		transformedRpmInstallation, err := expandOSConfigGuestPoliciesRecipesUpdateStepsRpmInstallation(original["rpm_installation"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRpmInstallation); val.IsValid() && !isEmptyValue(val) {
			transformed["rpmInstallation"] = transformedRpmInstallation
		}

		transformedFileExec, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileExec(original["file_exec"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedFileExec); val.IsValid() && !isEmptyValue(val) {
			transformed["fileExec"] = transformedFileExec
		}

		transformedScriptRun, err := expandOSConfigGuestPoliciesRecipesUpdateStepsScriptRun(original["script_run"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedScriptRun); val.IsValid() && !isEmptyValue(val) {
			transformed["scriptRun"] = transformedScriptRun
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopy(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopyArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	transformedDestination, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopyDestination(original["destination"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestination); val.IsValid() && !isEmptyValue(val) {
		transformed["destination"] = transformedDestination
	}

	transformedOverwrite, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopyOverwrite(original["overwrite"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOverwrite); val.IsValid() && !isEmptyValue(val) {
		transformed["overwrite"] = transformedOverwrite
	}

	transformedPermissions, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopyPermissions(original["permissions"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPermissions); val.IsValid() && !isEmptyValue(val) {
		transformed["permissions"] = transformedPermissions
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopyArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopyDestination(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopyOverwrite(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileCopyPermissions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtraction(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	transformedDestination, err := expandOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionDestination(original["destination"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDestination); val.IsValid() && !isEmptyValue(val) {
		transformed["destination"] = transformedDestination
	}

	transformedType, err := expandOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionType(original["type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedType); val.IsValid() && !isEmptyValue(val) {
		transformed["type"] = transformedType
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionDestination(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsArchiveExtractionType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	transformedFlags, err := expandOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationFlags(original["flags"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFlags); val.IsValid() && !isEmptyValue(val) {
		transformed["flags"] = transformedFlags
	}

	transformedAllowedExitCodes, err := expandOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationAllowedExitCodes(original["allowed_exit_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedExitCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedExitCodes"] = transformedAllowedExitCodes
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationFlags(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsMsiInstallationAllowedExitCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsDpkgInstallation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesUpdateStepsDpkgInstallationArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsDpkgInstallationArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsRpmInstallation(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesUpdateStepsRpmInstallationArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsRpmInstallationArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileExec(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedArgs, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileExecArgs(original["args"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArgs); val.IsValid() && !isEmptyValue(val) {
		transformed["args"] = transformedArgs
	}

	transformedAllowedExitCodes, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileExecAllowedExitCodes(original["allowed_exit_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedExitCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedExitCodes"] = transformedAllowedExitCodes
	}

	transformedArtifactId, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileExecArtifactId(original["artifact_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedArtifactId); val.IsValid() && !isEmptyValue(val) {
		transformed["artifactId"] = transformedArtifactId
	}

	transformedLocalPath, err := expandOSConfigGuestPoliciesRecipesUpdateStepsFileExecLocalPath(original["local_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocalPath); val.IsValid() && !isEmptyValue(val) {
		transformed["localPath"] = transformedLocalPath
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileExecArgs(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileExecAllowedExitCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileExecArtifactId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsFileExecLocalPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsScriptRun(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedScript, err := expandOSConfigGuestPoliciesRecipesUpdateStepsScriptRunScript(original["script"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedScript); val.IsValid() && !isEmptyValue(val) {
		transformed["script"] = transformedScript
	}

	transformedAllowedExitCodes, err := expandOSConfigGuestPoliciesRecipesUpdateStepsScriptRunAllowedExitCodes(original["allowed_exit_codes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAllowedExitCodes); val.IsValid() && !isEmptyValue(val) {
		transformed["allowedExitCodes"] = transformedAllowedExitCodes
	}

	transformedInterpreter, err := expandOSConfigGuestPoliciesRecipesUpdateStepsScriptRunInterpreter(original["interpreter"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInterpreter); val.IsValid() && !isEmptyValue(val) {
		transformed["interpreter"] = transformedInterpreter
	}

	return transformed, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsScriptRunScript(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsScriptRunAllowedExitCodes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesUpdateStepsScriptRunInterpreter(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesRecipesDesiredState(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandOSConfigGuestPoliciesEtag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}
