/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLUtils;
import io.mola.galimatias.canonicalize.BaseURLCanonicalizer;
import io.mola.galimatias.canonicalize.CharacterPredicate;

public class RFC3986Canonicalizer
extends BaseURLCanonicalizer {
    private static final CharacterPredicate USERINFO_PREDICATE = new CharacterPredicate(){

        @Override
        public boolean test(int c) {
            return RFC3986Canonicalizer.isUserInfo(c);
        }
    };
    private static final CharacterPredicate PATH_PREDICATE = new CharacterPredicate(){

        @Override
        public boolean test(int c) {
            return RFC3986Canonicalizer.isPChar(c) || c == 47;
        }
    };
    private static final CharacterPredicate QUERY_OR_FRAGMENT_PREDICATE = new CharacterPredicate(){

        @Override
        public boolean test(int c) {
            return RFC3986Canonicalizer.isPChar(c) || c == 47 || c == 63;
        }
    };

    @Override
    public URL canonicalize(URL url) throws GalimatiasParseException {
        if (url.username() != null && !url.username().isEmpty()) {
            url = url.withUsername(RFC3986Canonicalizer.canonicalize(url.username(), USERINFO_PREDICATE));
        }
        if (url.password() != null && !url.password().isEmpty()) {
            url = url.withPassword(RFC3986Canonicalizer.canonicalize(url.password(), USERINFO_PREDICATE));
        }
        if (url.path() != null) {
            url = url.withPath(RFC3986Canonicalizer.canonicalize(url.path(), PATH_PREDICATE));
        }
        if (url.query() != null) {
            url = url.withQuery(RFC3986Canonicalizer.canonicalize(url.query(), QUERY_OR_FRAGMENT_PREDICATE));
        }
        if (url.fragment() != null) {
            url = url.withFragment(RFC3986Canonicalizer.canonicalize(url.fragment(), QUERY_OR_FRAGMENT_PREDICATE));
        }
        return url;
    }

    private static boolean isUnreserved(int c) {
        return URLUtils.isASCIIAlphanumeric(c) || c == 45 || c == 46 || c == 95 || c == 126;
    }

    private static boolean isSubdelim(int c) {
        return c == 33 || c == 36 || c == 38 || c == 39 || c == 40 || c == 41 || c == 42 || c == 43 || c == 44 || c == 59 || c == 61;
    }

    private static boolean isPChar(int c) {
        return RFC3986Canonicalizer.isUnreserved(c) || RFC3986Canonicalizer.isSubdelim(c) || c == 58 || c == 64;
    }

    private static boolean isUserInfo(int c) {
        return RFC3986Canonicalizer.isUnreserved(c) || RFC3986Canonicalizer.isSubdelim(c);
    }
}

