/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDate;
import org.apache.solr.util.DateMathParser;

@Deprecated
class TrieDateFieldSource
extends LongFieldSource {
    public TrieDateFieldSource(String field) {
        super(field);
    }

    public String description() {
        return "date(" + this.field + ")";
    }

    public Date longToObject(long val) {
        return new Date(val);
    }

    public String longToString(long val) {
        return this.longToObject(val).toInstant().toString();
    }

    public long externalToLong(String extVal) {
        return DateMathParser.parseMath(null, extVal).getTime();
    }

    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = this.getNumericDocValues(context, readerContext);
        return new LongDocValues((ValueSource)this){
            int lastDocID;

            public long longVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    return arr.longValue();
                }
                return 0L;
            }

            public boolean exists(int doc) throws IOException {
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                this.lastDocID = doc;
                int curDocID = arr.docID();
                if (doc > curDocID) {
                    curDocID = arr.advance(doc);
                }
                return doc == curDocID;
            }

            public Object objectVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    long value = this.longVal(doc);
                    return TrieDateFieldSource.this.longToObject(value);
                }
                return null;
            }

            public String strVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    long value = this.longVal(doc);
                    return TrieDateFieldSource.this.longToString(value);
                }
                return null;
            }

            protected long externalToLong(String extVal) {
                return TrieDateFieldSource.this.externalToLong(extVal);
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueDate mval = new MutableValueDate();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) throws IOException {
                        this.mval.value = this.longVal(doc);
                        this.mval.exists = this.exists(doc);
                    }
                };
            }
        };
    }
}

