/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.Metric;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class AggregateMetric
implements Metric {
    private final Map<String, Update> values = new ConcurrentHashMap<String, Update>();

    public void set(String name, Object value) {
        Update existing = this.values.get(name);
        if (existing == null) {
            Update created = new Update(value);
            Update raced = this.values.putIfAbsent(name, created);
            if (raced != null) {
                raced.update(value);
            }
        } else {
            existing.update(value);
        }
    }

    public void clear(String name) {
        this.values.remove(name);
    }

    public void clear() {
        this.values.clear();
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Map<String, Update> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public double getMax() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        Double res = null;
        for (Update u : this.values.values()) {
            if (!(u.value instanceof Number)) continue;
            Number n = (Number)u.value;
            if (res == null) {
                res = n.doubleValue();
                continue;
            }
            if (!(n.doubleValue() > res)) continue;
            res = n.doubleValue();
        }
        if (res == null) {
            return 0.0;
        }
        return res;
    }

    public double getMin() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        Double res = null;
        for (Update u : this.values.values()) {
            if (!(u.value instanceof Number)) continue;
            Number n = (Number)u.value;
            if (res == null) {
                res = n.doubleValue();
                continue;
            }
            if (!(n.doubleValue() < res)) continue;
            res = n.doubleValue();
        }
        if (res == null) {
            return 0.0;
        }
        return res;
    }

    public double getMean() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        double total = 0.0;
        for (Update u : this.values.values()) {
            if (!(u.value instanceof Number)) continue;
            Number n = (Number)u.value;
            total += n.doubleValue();
        }
        return total / (double)this.values.size();
    }

    public double getStdDev() {
        int size = this.values.size();
        if (size < 2) {
            return 0.0;
        }
        double mean = this.getMean();
        double sum = 0.0;
        int count = 0;
        for (Update u : this.values.values()) {
            if (!(u.value instanceof Number)) continue;
            ++count;
            Number n = (Number)u.value;
            double diff = n.doubleValue() - mean;
            sum += diff * diff;
        }
        if (count < 2) {
            return 0.0;
        }
        double variance = sum / (double)(count - 1);
        return Math.sqrt(variance);
    }

    public double getSum() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        double res = 0.0;
        for (Update u : this.values.values()) {
            if (!(u.value instanceof Number)) continue;
            Number n = (Number)u.value;
            res += n.doubleValue();
        }
        return res;
    }

    public String toString() {
        return "AggregateMetric{size=" + this.size() + ", max=" + this.getMax() + ", min=" + this.getMin() + ", mean=" + this.getMean() + ", stddev=" + this.getStdDev() + ", sum=" + this.getSum() + ", values=" + this.values + "}";
    }

    public static class Update {
        public Object value;
        public final AtomicInteger updateCount = new AtomicInteger();

        public Update(Object value) {
            this.update(value);
        }

        public void update(Object value) {
            this.value = value;
            this.updateCount.incrementAndGet();
        }

        public String toString() {
            return "Update{value=" + this.value + ", updateCount=" + this.updateCount + "}";
        }
    }
}

