# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2022 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.model.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ALBAlertScriptConfig(VapiStruct):
    """
    Advanced load balancer AlertScriptConfig object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'action_script': 'action_script',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 action_script=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  action_script: :class:`str` or ``None``
        :param action_script: User Defined Alert Action Script. Please refer to
            kb.avinetworks.com for more information.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.action_script = action_script
        VapiStruct.__init__(self)


ALBAlertScriptConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_alert_script_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'action_script': type.OptionalType(type.StringType()),
    },
    ALBAlertScriptConfig,
    False,
    None))



class ALBAnalyticsPolicy(VapiStruct):
    """
    Advanced load balancer AnalyticsPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    CLIENT_INSIGHTS_NO_INSIGHTS = "NO_INSIGHTS"
    """


    """
    CLIENT_INSIGHTS_PASSIVE = "PASSIVE"
    """


    """
    CLIENT_INSIGHTS_ACTIVE = "ACTIVE"
    """


    """



    _canonical_to_pep_names = {
                            'all_headers': 'all_headers',
                            'client_insights': 'client_insights',
                            'client_insights_sampling': 'client_insights_sampling',
                            'client_log_filters': 'client_log_filters',
                            'full_client_logs': 'full_client_logs',
                            'metrics_realtime_update': 'metrics_realtime_update',
                            'significant_log_throttle': 'significant_log_throttle',
                            'udf_log_throttle': 'udf_log_throttle',
                            }

    def __init__(self,
                 all_headers=None,
                 client_insights=None,
                 client_insights_sampling=None,
                 client_log_filters=None,
                 full_client_logs=None,
                 metrics_realtime_update=None,
                 significant_log_throttle=None,
                 udf_log_throttle=None,
                ):
        """
        :type  all_headers: :class:`bool` or ``None``
        :param all_headers: Log all headers. Default value when not specified in API or module
            is interpreted by ALB Controller as false.
        :type  client_insights: :class:`str` or ``None``
        :param client_insights: Possible values are: 
            
            * :attr:`ALBAnalyticsPolicy.CLIENT_INSIGHTS_NO_INSIGHTS`
            * :attr:`ALBAnalyticsPolicy.CLIENT_INSIGHTS_PASSIVE`
            * :attr:`ALBAnalyticsPolicy.CLIENT_INSIGHTS_ACTIVE`
            
            Gain insights from sampled client to server HTTP requests and
            responses. Enum options - NO_INSIGHTS, PASSIVE, ACTIVE. Default
            value when not specified in API or module is interpreted by ALB
            Controller as NO_INSIGHTS.
        :type  client_insights_sampling: :class:`ALBClientInsightsSampling` or ``None``
        :param client_insights_sampling: 
        :type  client_log_filters: :class:`list` of :class:`ALBClientLogFilter` or ``None``
        :param client_log_filters: Placeholder for description of property client_log_filters of obj
            type AnalyticsPolicy field type str type array.
        :type  full_client_logs: :class:`ALBFullClientLogs` or ``None``
        :param full_client_logs: 
        :type  metrics_realtime_update: :class:`ALBMetricsRealTimeUpdate` or ``None``
        :param metrics_realtime_update: 
        :type  significant_log_throttle: :class:`long` or ``None``
        :param significant_log_throttle: This setting limits the number of significant logs generated per
            second for this VS on each SE. Default is 10 logs per second. Set
            it to zero (0) to deactivate throttling. Unit is PER_SECOND.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 10. format: int64
        :type  udf_log_throttle: :class:`long` or ``None``
        :param udf_log_throttle: This setting limits the total number of UDF logs generated per
            second for this VS on each SE. UDF logs are generated due to the
            configured client log filters or the rules with logging enabled.
            Default is 10 logs per second. Set it to zero (0) to deactivate
            throttling. Unit is PER_SECOND. Default value when not specified in
            API or module is interpreted by ALB Controller as 10. format: int64
        """
        self.all_headers = all_headers
        self.client_insights = client_insights
        self.client_insights_sampling = client_insights_sampling
        self.client_log_filters = client_log_filters
        self.full_client_logs = full_client_logs
        self.metrics_realtime_update = metrics_realtime_update
        self.significant_log_throttle = significant_log_throttle
        self.udf_log_throttle = udf_log_throttle
        VapiStruct.__init__(self)


ALBAnalyticsPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_analytics_policy', {
        'all_headers': type.OptionalType(type.BooleanType()),
        'client_insights': type.OptionalType(type.StringType()),
        'client_insights_sampling': type.OptionalType(type.ReferenceType(__name__, 'ALBClientInsightsSampling')),
        'client_log_filters': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBClientLogFilter'))),
        'full_client_logs': type.OptionalType(type.ReferenceType(__name__, 'ALBFullClientLogs')),
        'metrics_realtime_update': type.OptionalType(type.ReferenceType(__name__, 'ALBMetricsRealTimeUpdate')),
        'significant_log_throttle': type.OptionalType(type.IntegerType()),
        'udf_log_throttle': type.OptionalType(type.IntegerType()),
    },
    ALBAnalyticsPolicy,
    False,
    None))



class ALBAnalyticsProfile(VapiStruct):
    """
    Advanced load balancer AnalyticsProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESP_CODE_BLOCK_4XX = "AP_HTTP_RSP_4XX"
    """


    """
    RESP_CODE_BLOCK_5XX = "AP_HTTP_RSP_5XX"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'apdex_response_threshold': 'apdex_response_threshold',
                            'apdex_response_tolerated_factor': 'apdex_response_tolerated_factor',
                            'apdex_rtt_threshold': 'apdex_rtt_threshold',
                            'apdex_rtt_tolerated_factor': 'apdex_rtt_tolerated_factor',
                            'apdex_rum_threshold': 'apdex_rum_threshold',
                            'apdex_rum_tolerated_factor': 'apdex_rum_tolerated_factor',
                            'apdex_server_response_threshold': 'apdex_server_response_threshold',
                            'apdex_server_response_tolerated_factor': 'apdex_server_response_tolerated_factor',
                            'apdex_server_rtt_threshold': 'apdex_server_rtt_threshold',
                            'apdex_server_rtt_tolerated_factor': 'apdex_server_rtt_tolerated_factor',
                            'client_log_config': 'client_log_config',
                            'client_log_streaming_config': 'client_log_streaming_config',
                            'conn_lossy_ooo_threshold': 'conn_lossy_ooo_threshold',
                            'conn_lossy_timeo_rexmt_threshold': 'conn_lossy_timeo_rexmt_threshold',
                            'conn_lossy_total_rexmt_threshold': 'conn_lossy_total_rexmt_threshold',
                            'conn_lossy_zero_win_size_event_threshold': 'conn_lossy_zero_win_size_event_threshold',
                            'conn_server_lossy_ooo_threshold': 'conn_server_lossy_ooo_threshold',
                            'conn_server_lossy_timeo_rexmt_threshold': 'conn_server_lossy_timeo_rexmt_threshold',
                            'conn_server_lossy_total_rexmt_threshold': 'conn_server_lossy_total_rexmt_threshold',
                            'conn_server_lossy_zero_win_size_event_threshold': 'conn_server_lossy_zero_win_size_event_threshold',
                            'enable_adaptive_config': 'enable_adaptive_config',
                            'enable_advanced_analytics': 'enable_advanced_analytics',
                            'enable_ondemand_metrics': 'enable_ondemand_metrics',
                            'enable_se_analytics': 'enable_se_analytics',
                            'enable_server_analytics': 'enable_server_analytics',
                            'enable_vs_analytics': 'enable_vs_analytics',
                            'exclude_client_close_before_request_as_error': 'exclude_client_close_before_request_as_error',
                            'exclude_dns_policy_drop_as_significant': 'exclude_dns_policy_drop_as_significant',
                            'exclude_gs_down_as_error': 'exclude_gs_down_as_error',
                            'exclude_http_error_codes': 'exclude_http_error_codes',
                            'exclude_invalid_dns_domain_as_error': 'exclude_invalid_dns_domain_as_error',
                            'exclude_invalid_dns_query_as_error': 'exclude_invalid_dns_query_as_error',
                            'exclude_issuer_revoked_ocsp_responses_as_error': 'exclude_issuer_revoked_ocsp_responses_as_error',
                            'exclude_no_dns_record_as_error': 'exclude_no_dns_record_as_error',
                            'exclude_no_valid_gs_member_as_error': 'exclude_no_valid_gs_member_as_error',
                            'exclude_persistence_change_as_error': 'exclude_persistence_change_as_error',
                            'exclude_revoked_ocsp_responses_as_error': 'exclude_revoked_ocsp_responses_as_error',
                            'exclude_server_dns_error_as_error': 'exclude_server_dns_error_as_error',
                            'exclude_server_tcp_reset_as_error': 'exclude_server_tcp_reset_as_error',
                            'exclude_sip_error_codes': 'exclude_sip_error_codes',
                            'exclude_stale_ocsp_responses_as_error': 'exclude_stale_ocsp_responses_as_error',
                            'exclude_syn_retransmit_as_error': 'exclude_syn_retransmit_as_error',
                            'exclude_tcp_reset_as_error': 'exclude_tcp_reset_as_error',
                            'exclude_unavailable_ocsp_responses_as_error': 'exclude_unavailable_ocsp_responses_as_error',
                            'exclude_unsupported_dns_query_as_error': 'exclude_unsupported_dns_query_as_error',
                            'healthscore_max_server_limit': 'healthscore_max_server_limit',
                            'hs_event_throttle_window': 'hs_event_throttle_window',
                            'hs_max_anomaly_penalty': 'hs_max_anomaly_penalty',
                            'hs_max_resources_penalty': 'hs_max_resources_penalty',
                            'hs_max_security_penalty': 'hs_max_security_penalty',
                            'hs_min_dos_rate': 'hs_min_dos_rate',
                            'hs_performance_boost': 'hs_performance_boost',
                            'hs_pscore_traffic_threshold_l4_client': 'hs_pscore_traffic_threshold_l4_client',
                            'hs_pscore_traffic_threshold_l4_server': 'hs_pscore_traffic_threshold_l4_server',
                            'hs_security_certscore_expired': 'hs_security_certscore_expired',
                            'hs_security_certscore_gt30d': 'hs_security_certscore_gt30d',
                            'hs_security_certscore_le07d': 'hs_security_certscore_le07d',
                            'hs_security_certscore_le30d': 'hs_security_certscore_le30d',
                            'hs_security_chain_invalidity_penalty': 'hs_security_chain_invalidity_penalty',
                            'hs_security_cipherscore_eq000b': 'hs_security_cipherscore_eq000b',
                            'hs_security_cipherscore_ge128b': 'hs_security_cipherscore_ge128b',
                            'hs_security_cipherscore_lt128b': 'hs_security_cipherscore_lt128b',
                            'hs_security_encalgo_score_none': 'hs_security_encalgo_score_none',
                            'hs_security_encalgo_score_rc4': 'hs_security_encalgo_score_rc4',
                            'hs_security_hsts_penalty': 'hs_security_hsts_penalty',
                            'hs_security_nonpfs_penalty': 'hs_security_nonpfs_penalty',
                            'hs_security_ocsp_revoked_score': 'hs_security_ocsp_revoked_score',
                            'hs_security_selfsignedcert_penalty': 'hs_security_selfsignedcert_penalty',
                            'hs_security_ssl30_score': 'hs_security_ssl30_score',
                            'hs_security_tls10_score': 'hs_security_tls10_score',
                            'hs_security_tls11_score': 'hs_security_tls11_score',
                            'hs_security_tls12_score': 'hs_security_tls12_score',
                            'hs_security_tls13_score': 'hs_security_tls13_score',
                            'hs_security_weak_signature_algo_penalty': 'hs_security_weak_signature_algo_penalty',
                            'markers': 'markers',
                            'ondemand_metrics_idle_timeout': 'ondemand_metrics_idle_timeout',
                            'ranges': 'ranges',
                            'resp_code_block': 'resp_code_block',
                            'sensitive_log_profile': 'sensitive_log_profile',
                            'sip_log_depth': 'sip_log_depth',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 apdex_response_threshold=None,
                 apdex_response_tolerated_factor=None,
                 apdex_rtt_threshold=None,
                 apdex_rtt_tolerated_factor=None,
                 apdex_rum_threshold=None,
                 apdex_rum_tolerated_factor=None,
                 apdex_server_response_threshold=None,
                 apdex_server_response_tolerated_factor=None,
                 apdex_server_rtt_threshold=None,
                 apdex_server_rtt_tolerated_factor=None,
                 client_log_config=None,
                 client_log_streaming_config=None,
                 conn_lossy_ooo_threshold=None,
                 conn_lossy_timeo_rexmt_threshold=None,
                 conn_lossy_total_rexmt_threshold=None,
                 conn_lossy_zero_win_size_event_threshold=None,
                 conn_server_lossy_ooo_threshold=None,
                 conn_server_lossy_timeo_rexmt_threshold=None,
                 conn_server_lossy_total_rexmt_threshold=None,
                 conn_server_lossy_zero_win_size_event_threshold=None,
                 enable_adaptive_config=None,
                 enable_advanced_analytics=None,
                 enable_ondemand_metrics=None,
                 enable_se_analytics=None,
                 enable_server_analytics=None,
                 enable_vs_analytics=None,
                 exclude_client_close_before_request_as_error=None,
                 exclude_dns_policy_drop_as_significant=None,
                 exclude_gs_down_as_error=None,
                 exclude_http_error_codes=None,
                 exclude_invalid_dns_domain_as_error=None,
                 exclude_invalid_dns_query_as_error=None,
                 exclude_issuer_revoked_ocsp_responses_as_error=None,
                 exclude_no_dns_record_as_error=None,
                 exclude_no_valid_gs_member_as_error=None,
                 exclude_persistence_change_as_error=None,
                 exclude_revoked_ocsp_responses_as_error=None,
                 exclude_server_dns_error_as_error=None,
                 exclude_server_tcp_reset_as_error=None,
                 exclude_sip_error_codes=None,
                 exclude_stale_ocsp_responses_as_error=None,
                 exclude_syn_retransmit_as_error=None,
                 exclude_tcp_reset_as_error=None,
                 exclude_unavailable_ocsp_responses_as_error=None,
                 exclude_unsupported_dns_query_as_error=None,
                 healthscore_max_server_limit=None,
                 hs_event_throttle_window=None,
                 hs_max_anomaly_penalty=None,
                 hs_max_resources_penalty=None,
                 hs_max_security_penalty=None,
                 hs_min_dos_rate=None,
                 hs_performance_boost=None,
                 hs_pscore_traffic_threshold_l4_client=None,
                 hs_pscore_traffic_threshold_l4_server=None,
                 hs_security_certscore_expired=None,
                 hs_security_certscore_gt30d=None,
                 hs_security_certscore_le07d=None,
                 hs_security_certscore_le30d=None,
                 hs_security_chain_invalidity_penalty=None,
                 hs_security_cipherscore_eq000b=None,
                 hs_security_cipherscore_ge128b=None,
                 hs_security_cipherscore_lt128b=None,
                 hs_security_encalgo_score_none=None,
                 hs_security_encalgo_score_rc4=None,
                 hs_security_hsts_penalty=None,
                 hs_security_nonpfs_penalty=None,
                 hs_security_ocsp_revoked_score=None,
                 hs_security_selfsignedcert_penalty=None,
                 hs_security_ssl30_score=None,
                 hs_security_tls10_score=None,
                 hs_security_tls11_score=None,
                 hs_security_tls12_score=None,
                 hs_security_tls13_score=None,
                 hs_security_weak_signature_algo_penalty=None,
                 markers=None,
                 ondemand_metrics_idle_timeout=None,
                 ranges=None,
                 resp_code_block=None,
                 sensitive_log_profile=None,
                 sip_log_depth=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  apdex_response_threshold: :class:`long` or ``None``
        :param apdex_response_threshold: If a client receives an HTTP response in less than the Satisfactory
            Latency Threshold, the request is considered Satisfied. It is
            considered Tolerated if it is not Satisfied and less than Tolerated
            Latency Factor multiplied by the Satisfactory Latency Threshold.
            Greater than this number and the client's request is considered
            Frustrated. Allowed values are 1-30000. Unit is MILLISECONDS.
            Allowed in Basic(Allowed values- 500) edition, Essentials(Allowed
            values- 500) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as 500.
            format: int64
        :type  apdex_response_tolerated_factor: :class:`float` or ``None``
        :param apdex_response_tolerated_factor: Client tolerated response latency factor. Client must receive a
            response within this factor times the satisfactory threshold
            (apdex_response_threshold) to be considered tolerated. Allowed
            values are 1-1000. Allowed in Basic(Allowed values- 4) edition,
            Essentials(Allowed values- 4) edition, Enterprise edition. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 4.0.
        :type  apdex_rtt_threshold: :class:`long` or ``None``
        :param apdex_rtt_threshold: Satisfactory client to Avi Round Trip Time(RTT). Allowed values are
            1-2000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 250)
            edition, Essentials(Allowed values- 250) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 250. format: int64
        :type  apdex_rtt_tolerated_factor: :class:`float` or ``None``
        :param apdex_rtt_tolerated_factor: Tolerated client to Avi Round Trip Time(RTT) factor. It is a
            multiple of apdex_rtt_tolerated_factor. Allowed values are 1-1000.
            Allowed in Basic(Allowed values- 4) edition, Essentials(Allowed
            values- 4) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as 4.0.
        :type  apdex_rum_threshold: :class:`long` or ``None``
        :param apdex_rum_threshold: If a client is able to load a page in less than the Satisfactory
            Latency Threshold, the PageLoad is considered Satisfied. It is
            considered tolerated if it is greater than Satisfied but less than
            the Tolerated Latency multiplied by Satisifed Latency. Greater than
            this number and the client's request is considered Frustrated. A
            PageLoad includes the time for DNS lookup, download of all HTTP
            objects, and page render time. Allowed values are 1-30000. Unit is
            MILLISECONDS. Allowed in Basic(Allowed values- 5000) edition,
            Essentials(Allowed values- 5000) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 5000. format: int64
        :type  apdex_rum_tolerated_factor: :class:`float` or ``None``
        :param apdex_rum_tolerated_factor: Virtual service threshold factor for tolerated Page Load Time (PLT)
            as multiple of apdex_rum_threshold. Allowed values are 1-1000.
            Allowed in Basic(Allowed values- 4) edition, Essentials(Allowed
            values- 4) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as 4.0.
        :type  apdex_server_response_threshold: :class:`long` or ``None``
        :param apdex_server_response_threshold: A server HTTP response is considered Satisfied if latency is less
            than the Satisfactory Latency Threshold. The response is considered
            tolerated when it is greater than Satisfied but less than the
            Tolerated Latency Factor (STAR) S_Latency. Greater than this number
            and the server response is considered Frustrated. Allowed values
            are 1-30000. Unit is MILLISECONDS. Allowed in Basic(Allowed values-
            400) edition, Essentials(Allowed values- 400) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 400. format: int64
        :type  apdex_server_response_tolerated_factor: :class:`float` or ``None``
        :param apdex_server_response_tolerated_factor: Server tolerated response latency factor. Servermust response
            within this factor times the satisfactory threshold
            (apdex_server_response_threshold) to be considered tolerated.
            Allowed values are 1-1000. Allowed in Basic(Allowed values- 4)
            edition, Essentials(Allowed values- 4) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 4.0.
        :type  apdex_server_rtt_threshold: :class:`long` or ``None``
        :param apdex_server_rtt_threshold: Satisfactory client to Avi Round Trip Time(RTT). Allowed values are
            1-2000. Unit is MILLISECONDS. Allowed in Basic(Allowed values- 125)
            edition, Essentials(Allowed values- 125) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 125. format: int64
        :type  apdex_server_rtt_tolerated_factor: :class:`float` or ``None``
        :param apdex_server_rtt_tolerated_factor: Tolerated client to Avi Round Trip Time(RTT) factor. It is a
            multiple of apdex_rtt_tolerated_factor. Allowed values are 1-1000.
            Allowed in Basic(Allowed values- 4) edition, Essentials(Allowed
            values- 4) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as 4.0.
        :type  client_log_config: :class:`ALBClientLogConfiguration` or ``None``
        :param client_log_config: 
        :type  client_log_streaming_config: :class:`ALBClientLogStreamingConfig` or ``None``
        :param client_log_streaming_config: 
        :type  conn_lossy_ooo_threshold: :class:`long` or ``None``
        :param conn_lossy_ooo_threshold: A connection between client and Avi is considered lossy when more
            than this percentage of out of order packets are received. Allowed
            values are 1-100. Unit is PERCENT. Allowed in Basic(Allowed values-
            50) edition, Essentials(Allowed values- 50) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 50. format: int64
        :type  conn_lossy_timeo_rexmt_threshold: :class:`long` or ``None``
        :param conn_lossy_timeo_rexmt_threshold: A connection between client and Avi is considered lossy when more
            than this percentage of packets are retransmitted due to timeout.
            Allowed values are 1-100. Unit is PERCENT. Allowed in Basic(Allowed
            values- 20) edition, Essentials(Allowed values- 20) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as 20. format: int64
        :type  conn_lossy_total_rexmt_threshold: :class:`long` or ``None``
        :param conn_lossy_total_rexmt_threshold: A connection between client and Avi is considered lossy when more
            than this percentage of packets are retransmitted. Allowed values
            are 1-100. Unit is PERCENT. Allowed in Basic(Allowed values- 50)
            edition, Essentials(Allowed values- 50) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 50. format: int64
        :type  conn_lossy_zero_win_size_event_threshold: :class:`long` or ``None``
        :param conn_lossy_zero_win_size_event_threshold: A client connection is considered lossy when percentage of times a
            packet could not be trasmitted due to TCP zero window is above this
            threshold. Allowed values are 0-100. Unit is PERCENT. Allowed in
            Basic(Allowed values- 2) edition, Essentials(Allowed values- 2)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 2. format: int64
        :type  conn_server_lossy_ooo_threshold: :class:`long` or ``None``
        :param conn_server_lossy_ooo_threshold: A connection between Avi and server is considered lossy when more
            than this percentage of out of order packets are received. Allowed
            values are 1-100. Unit is PERCENT. Allowed in Basic(Allowed values-
            50) edition, Essentials(Allowed values- 50) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 50. format: int64
        :type  conn_server_lossy_timeo_rexmt_threshold: :class:`long` or ``None``
        :param conn_server_lossy_timeo_rexmt_threshold: A connection between Avi and server is considered lossy when more
            than this percentage of packets are retransmitted due to timeout.
            Allowed values are 1-100. Unit is PERCENT. Allowed in Basic(Allowed
            values- 20) edition, Essentials(Allowed values- 20) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as 20. format: int64
        :type  conn_server_lossy_total_rexmt_threshold: :class:`long` or ``None``
        :param conn_server_lossy_total_rexmt_threshold: A connection between Avi and server is considered lossy when more
            than this percentage of packets are retransmitted. Allowed values
            are 1-100. Unit is PERCENT. Allowed in Basic(Allowed values- 50)
            edition, Essentials(Allowed values- 50) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 50. format: int64
        :type  conn_server_lossy_zero_win_size_event_threshold: :class:`long` or ``None``
        :param conn_server_lossy_zero_win_size_event_threshold: A server connection is considered lossy when percentage of times a
            packet could not be trasmitted due to TCP zero window is above this
            threshold. Allowed values are 0-100. Unit is PERCENT. Allowed in
            Basic(Allowed values- 2) edition, Essentials(Allowed values- 2)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 2. format: int64
        :type  enable_adaptive_config: :class:`bool` or ``None``
        :param enable_adaptive_config: Enable adaptive configuration for optimizing resource usage.
            Default value when not specified in API or module is interpreted by
            ALB Controller as true.
        :type  enable_advanced_analytics: :class:`bool` or ``None``
        :param enable_advanced_analytics: Enables Advanced Analytics features like Anomaly detection. If set
            to false, anomaly computation (and associated rules/events) for VS,
            Pool and Server metrics will be deactivated. However, setting it to
            false reduces cpu and memory requirements for Analytics subsystem.
            Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
            values- false) edition, Enterprise edition. Special default for
            Basic edition is false, Essentials edition is false, Enterprise is
            True. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  enable_ondemand_metrics: :class:`bool` or ``None``
        :param enable_ondemand_metrics: Virtual Service (VS) metrics are processed only when there is live
            data traffic on the VS. In case, VS is idle for a period of time as
            specified by ondemand_metrics_idle_timeout then metrics processing
            is suspended for that VS. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  enable_se_analytics: :class:`bool` or ``None``
        :param enable_se_analytics: Enable node (service engine) level analytics forvs metrics. Default
            value when not specified in API or module is interpreted by ALB
            Controller as true.
        :type  enable_server_analytics: :class:`bool` or ``None``
        :param enable_server_analytics: Enables analytics on backend servers. This may be desired in
            container environment when there are large number of ephemeral
            servers. Additionally, no healthscore of servers is computed when
            server analytics is enabled. Default value when not specified in
            API or module is interpreted by ALB Controller as true.
        :type  enable_vs_analytics: :class:`bool` or ``None``
        :param enable_vs_analytics: Enable VirtualService (frontend) Analytics. This flag enables
            metrics and healthscore for Virtualservice. Default value when not
            specified in API or module is interpreted by ALB Controller as
            true.
        :type  exclude_client_close_before_request_as_error: :class:`bool` or ``None``
        :param exclude_client_close_before_request_as_error: Exclude client closed connection before an HTTP request could be
            completed from being classified as an error. Allowed in
            Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  exclude_dns_policy_drop_as_significant: :class:`bool` or ``None``
        :param exclude_dns_policy_drop_as_significant: Exclude dns policy drops from the list of errors. Allowed in
            Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  exclude_gs_down_as_error: :class:`bool` or ``None``
        :param exclude_gs_down_as_error: Exclude queries to GSLB services that are operationally down from
            the list of errors. Allowed in Basic(Allowed values- false)
            edition, Essentials(Allowed values- false) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  exclude_http_error_codes: :class:`list` of :class:`long` or ``None``
        :param exclude_http_error_codes: List of HTTP status codes to be excluded from being classified as
            an error. Error connections or responses impacts health score, are
            included as significant logs, and may be classified as part of a
            DoS attack. format: int64
        :type  exclude_invalid_dns_domain_as_error: :class:`bool` or ``None``
        :param exclude_invalid_dns_domain_as_error: Exclude dns queries to domains outside the domains configured in
            the DNS application profile from the list of errors. Allowed in
            Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  exclude_invalid_dns_query_as_error: :class:`bool` or ``None``
        :param exclude_invalid_dns_query_as_error: Exclude invalid dns queries from the list of errors. Allowed in
            Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  exclude_issuer_revoked_ocsp_responses_as_error: :class:`bool` or ``None``
        :param exclude_issuer_revoked_ocsp_responses_as_error: Exclude the Issuer-Revoked OCSP Responses from the list of errors.
            Allowed in Basic(Allowed values- true) edition, Essentials(Allowed
            values- true) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            true.
        :type  exclude_no_dns_record_as_error: :class:`bool` or ``None``
        :param exclude_no_dns_record_as_error: Exclude queries to domains that did not have configured
            services/records from the list of errors. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  exclude_no_valid_gs_member_as_error: :class:`bool` or ``None``
        :param exclude_no_valid_gs_member_as_error: Exclude queries to GSLB services that have no available members
            from the list of errors. Allowed in Basic(Allowed values- false)
            edition, Essentials(Allowed values- false) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  exclude_persistence_change_as_error: :class:`bool` or ``None``
        :param exclude_persistence_change_as_error: Exclude persistence server changed while load balancing' from the
            list of errors. Allowed in Basic(Allowed values- false) edition,
            Essentials(Allowed values- false) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as false.
        :type  exclude_revoked_ocsp_responses_as_error: :class:`bool` or ``None``
        :param exclude_revoked_ocsp_responses_as_error: Exclude the Revoked OCSP certificate status responses from the list
            of errors. Allowed in Basic(Allowed values- true) edition,
            Essentials(Allowed values- true) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as true.
        :type  exclude_server_dns_error_as_error: :class:`bool` or ``None``
        :param exclude_server_dns_error_as_error: Exclude server dns error response from the list of errors. Allowed
            in Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  exclude_server_tcp_reset_as_error: :class:`bool` or ``None``
        :param exclude_server_tcp_reset_as_error: Exclude server TCP reset from errors. It is common for applications
            like MS Exchange. Allowed in Basic(Allowed values- false) edition,
            Essentials(Allowed values- false) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as false.
        :type  exclude_sip_error_codes: :class:`list` of :class:`long` or ``None``
        :param exclude_sip_error_codes: List of SIP status codes to be excluded from being classified as an
            error. Allowed in Basic edition, Essentials edition, Enterprise
            edition. format: int64
        :type  exclude_stale_ocsp_responses_as_error: :class:`bool` or ``None``
        :param exclude_stale_ocsp_responses_as_error: Exclude the Stale OCSP certificate status responses from the list
            of errors. Allowed in Basic(Allowed values- true) edition,
            Essentials(Allowed values- true) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as true.
        :type  exclude_syn_retransmit_as_error: :class:`bool` or ``None``
        :param exclude_syn_retransmit_as_error: Exclude 'server unanswered syns' from the list of errors. Allowed
            in Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  exclude_tcp_reset_as_error: :class:`bool` or ``None``
        :param exclude_tcp_reset_as_error: Exclude TCP resets by client from the list of potential errors.
            Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
            values- false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  exclude_unavailable_ocsp_responses_as_error: :class:`bool` or ``None``
        :param exclude_unavailable_ocsp_responses_as_error: Exclude the unavailable OCSP Responses from the list of errors.
            Allowed in Basic(Allowed values- true) edition, Essentials(Allowed
            values- true) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            true.
        :type  exclude_unsupported_dns_query_as_error: :class:`bool` or ``None``
        :param exclude_unsupported_dns_query_as_error: Exclude unsupported dns queries from the list of errors. Allowed in
            Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  healthscore_max_server_limit: :class:`long` or ``None``
        :param healthscore_max_server_limit: Skips health score computation of pool servers when number of
            servers in a pool is more than this setting. Allowed values are
            0-5000. Special values are 0- 'server health score is deactivated'.
            Allowed in Basic(Allowed values- 0) edition, Essentials(Allowed
            values- 0) edition, Enterprise edition. Special default for Basic
            edition is 0, Essentials edition is 0, Enterprise is 20. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 0. format: int64
        :type  hs_event_throttle_window: :class:`long` or ``None``
        :param hs_event_throttle_window: Time window (in secs) within which only unique health change events
            should occur. Allowed in Basic(Allowed values- 1209600) edition,
            Essentials(Allowed values- 1209600) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 1209600. format: int64
        :type  hs_max_anomaly_penalty: :class:`long` or ``None``
        :param hs_max_anomaly_penalty: Maximum penalty that may be deducted from health score for
            anomalies. Allowed values are 0-100. Allowed in Basic(Allowed
            values- 10) edition, Essentials(Allowed values- 10) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as 10. format: int64
        :type  hs_max_resources_penalty: :class:`long` or ``None``
        :param hs_max_resources_penalty: Maximum penalty that may be deducted from health score for high
            resource utilization. Allowed values are 0-100. Allowed in
            Basic(Allowed values- 25) edition, Essentials(Allowed values- 25)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 25. format: int64
        :type  hs_max_security_penalty: :class:`long` or ``None``
        :param hs_max_security_penalty: Maximum penalty that may be deducted from health score based on
            security assessment. Allowed values are 0-100. Allowed in
            Basic(Allowed values- 100) edition, Essentials(Allowed values- 100)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 100. format:
            int64
        :type  hs_min_dos_rate: :class:`long` or ``None``
        :param hs_min_dos_rate: DoS connection rate below which the DoS security assessment will
            not kick in. Allowed in Basic(Allowed values- 1000) edition,
            Essentials(Allowed values- 1000) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 1000. format: int64
        :type  hs_performance_boost: :class:`long` or ``None``
        :param hs_performance_boost: Adds free performance score credits to health score. It can be used
            for compensating health score for known slow applications. Allowed
            values are 0-100. Allowed in Basic(Allowed values- 0) edition,
            Essentials(Allowed values- 0) edition, Enterprise edition. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 0. format: int64
        :type  hs_pscore_traffic_threshold_l4_client: :class:`float` or ``None``
        :param hs_pscore_traffic_threshold_l4_client: Threshold number of connections in 5min, below which apdexr,
            apdexc, rum_apdex, and other network quality metrics are not
            computed. Allowed in Basic(Allowed values- 10) edition,
            Essentials(Allowed values- 10) edition, Enterprise edition. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 10.0.
        :type  hs_pscore_traffic_threshold_l4_server: :class:`float` or ``None``
        :param hs_pscore_traffic_threshold_l4_server: Threshold number of connections in 5min, below which apdexr,
            apdexc, rum_apdex, and other network quality metrics are not
            computed. Allowed in Basic(Allowed values- 10) edition,
            Essentials(Allowed values- 10) edition, Enterprise edition. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 10.0.
        :type  hs_security_certscore_expired: :class:`float` or ``None``
        :param hs_security_certscore_expired: Score assigned when the certificate has expired. Allowed values are
            0-5. Allowed in Basic(Allowed values- 0.0) edition,
            Essentials(Allowed values- 0.0) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 0.0.
        :type  hs_security_certscore_gt30d: :class:`float` or ``None``
        :param hs_security_certscore_gt30d: Score assigned when the certificate expires in more than 30 days.
            Allowed values are 0-5. Allowed in Basic(Allowed values- 5.0)
            edition, Essentials(Allowed values- 5.0) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 5.0.
        :type  hs_security_certscore_le07d: :class:`float` or ``None``
        :param hs_security_certscore_le07d: Score assigned when the certificate expires in less than or equal
            to 7 days. Allowed values are 0-5. Allowed in Basic(Allowed values-
            2.0) edition, Essentials(Allowed values- 2.0) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 2.0.
        :type  hs_security_certscore_le30d: :class:`float` or ``None``
        :param hs_security_certscore_le30d: Score assigned when the certificate expires in less than or equal
            to 30 days. Allowed values are 0-5. Allowed in Basic(Allowed
            values- 4.0) edition, Essentials(Allowed values- 4.0) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as 4.0.
        :type  hs_security_chain_invalidity_penalty: :class:`float` or ``None``
        :param hs_security_chain_invalidity_penalty: Penalty for allowing certificates with invalid chain. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 1.0) edition,
            Essentials(Allowed values- 1.0) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 1.0.
        :type  hs_security_cipherscore_eq000b: :class:`float` or ``None``
        :param hs_security_cipherscore_eq000b: Score assigned when the minimum cipher strength is 0 bits. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 0.0) edition,
            Essentials(Allowed values- 0.0) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 0.0.
        :type  hs_security_cipherscore_ge128b: :class:`float` or ``None``
        :param hs_security_cipherscore_ge128b: Score assigned when the minimum cipher strength is greater than
            equal to 128 bits. Allowed values are 0-5. Allowed in Basic(Allowed
            values- 5.0) edition, Essentials(Allowed values- 5.0) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as 5.0.
        :type  hs_security_cipherscore_lt128b: :class:`float` or ``None``
        :param hs_security_cipherscore_lt128b: Score assigned when the minimum cipher strength is less than 128
            bits. Allowed values are 0-5. Allowed in Basic(Allowed values- 3.5)
            edition, Essentials(Allowed values- 3.5) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 3.5.
        :type  hs_security_encalgo_score_none: :class:`float` or ``None``
        :param hs_security_encalgo_score_none: Score assigned when no algorithm is used for encryption. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 0.0) edition,
            Essentials(Allowed values- 0.0) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 0.0.
        :type  hs_security_encalgo_score_rc4: :class:`float` or ``None``
        :param hs_security_encalgo_score_rc4: Score assigned when RC4 algorithm is used for encryption. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 2.5) edition,
            Essentials(Allowed values- 2.5) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 2.5.
        :type  hs_security_hsts_penalty: :class:`float` or ``None``
        :param hs_security_hsts_penalty: Penalty for not enabling HSTS. Allowed values are 0-5. Allowed in
            Basic(Allowed values- 1.0) edition, Essentials(Allowed values- 1.0)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 1.0.
        :type  hs_security_nonpfs_penalty: :class:`float` or ``None``
        :param hs_security_nonpfs_penalty: Penalty for allowing non-PFS handshakes. Allowed values are 0-5.
            Allowed in Basic(Allowed values- 1.0) edition, Essentials(Allowed
            values- 1.0) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as 1.0.
        :type  hs_security_ocsp_revoked_score: :class:`float` or ``None``
        :param hs_security_ocsp_revoked_score: Score assigned when OCSP Certificate Status is set to Revoked or
            Issuer Revoked. Allowed values are 0.0-5.0. Allowed in
            Basic(Allowed values- 0.0) edition, Essentials(Allowed values- 0.0)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 0.0.
        :type  hs_security_selfsignedcert_penalty: :class:`float` or ``None``
        :param hs_security_selfsignedcert_penalty: Deprecated. Allowed values are 0-5. Allowed in Basic(Allowed
            values- 1.0) edition, Essentials(Allowed values- 1.0) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as 1.0.
        :type  hs_security_ssl30_score: :class:`float` or ``None``
        :param hs_security_ssl30_score: Score assigned when supporting SSL3.0 encryption protocol. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 3.5) edition,
            Essentials(Allowed values- 3.5) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 3.5.
        :type  hs_security_tls10_score: :class:`float` or ``None``
        :param hs_security_tls10_score: Score assigned when supporting TLS1.0 encryption protocol. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 5.0) edition,
            Essentials(Allowed values- 5.0) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 5.0.
        :type  hs_security_tls11_score: :class:`float` or ``None``
        :param hs_security_tls11_score: Score assigned when supporting TLS1.1 encryption protocol. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 5.0) edition,
            Essentials(Allowed values- 5.0) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 5.0.
        :type  hs_security_tls12_score: :class:`float` or ``None``
        :param hs_security_tls12_score: Score assigned when supporting TLS1.2 encryption protocol. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 5.0) edition,
            Essentials(Allowed values- 5.0) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 5.0.
        :type  hs_security_tls13_score: :class:`float` or ``None``
        :param hs_security_tls13_score: Score assigned when supporting TLS1.3 encryption protocol. Allowed
            values are 0-5. Allowed in Basic(Allowed values- 5.0) edition,
            Essentials(Allowed values- 5.0) edition, Enterprise edition.
        :type  hs_security_weak_signature_algo_penalty: :class:`float` or ``None``
        :param hs_security_weak_signature_algo_penalty: Penalty for allowing weak signature algorithm(s). Allowed values
            are 0-5. Allowed in Basic(Allowed values- 1.0) edition,
            Essentials(Allowed values- 1.0) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 1.0.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  ondemand_metrics_idle_timeout: :class:`long` or ``None``
        :param ondemand_metrics_idle_timeout: This flag sets the time duration of no live data traffic after
            which Virtual Service metrics processing is suspended. It is
            applicable only when enable_ondemand_metrics is set to false. Unit
            is SECONDS. Default value when not specified in API or module is
            interpreted by ALB Controller as 1800. format: int64
        :type  ranges: :class:`list` of :class:`ALBHTTPStatusRange` or ``None``
        :param ranges: List of HTTP status code ranges to be excluded from being
            classified as an error.
        :type  resp_code_block: :class:`list` of :class:`str` or ``None``
        :param resp_code_block: Possible values are: 
            
            * :attr:`ALBAnalyticsProfile.RESP_CODE_BLOCK__4XX`
            * :attr:`ALBAnalyticsProfile.RESP_CODE_BLOCK__5XX`
            
            Block of HTTP response codes to be excluded from being classified
            as an error. Enum options - AP_HTTP_RSP_4XX, AP_HTTP_RSP_5XX.
        :type  sensitive_log_profile: :class:`ALBSensitiveLogProfile` or ``None``
        :param sensitive_log_profile: 
        :type  sip_log_depth: :class:`long` or ``None``
        :param sip_log_depth: Maximum number of SIP messages added in logs for a SIP transaction.
            By default, this value is 20. Allowed values are 1-1000. Allowed in
            Basic(Allowed values- 20) edition, Essentials(Allowed values- 20)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 20. format: int64
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.apdex_response_threshold = apdex_response_threshold
        self.apdex_response_tolerated_factor = apdex_response_tolerated_factor
        self.apdex_rtt_threshold = apdex_rtt_threshold
        self.apdex_rtt_tolerated_factor = apdex_rtt_tolerated_factor
        self.apdex_rum_threshold = apdex_rum_threshold
        self.apdex_rum_tolerated_factor = apdex_rum_tolerated_factor
        self.apdex_server_response_threshold = apdex_server_response_threshold
        self.apdex_server_response_tolerated_factor = apdex_server_response_tolerated_factor
        self.apdex_server_rtt_threshold = apdex_server_rtt_threshold
        self.apdex_server_rtt_tolerated_factor = apdex_server_rtt_tolerated_factor
        self.client_log_config = client_log_config
        self.client_log_streaming_config = client_log_streaming_config
        self.conn_lossy_ooo_threshold = conn_lossy_ooo_threshold
        self.conn_lossy_timeo_rexmt_threshold = conn_lossy_timeo_rexmt_threshold
        self.conn_lossy_total_rexmt_threshold = conn_lossy_total_rexmt_threshold
        self.conn_lossy_zero_win_size_event_threshold = conn_lossy_zero_win_size_event_threshold
        self.conn_server_lossy_ooo_threshold = conn_server_lossy_ooo_threshold
        self.conn_server_lossy_timeo_rexmt_threshold = conn_server_lossy_timeo_rexmt_threshold
        self.conn_server_lossy_total_rexmt_threshold = conn_server_lossy_total_rexmt_threshold
        self.conn_server_lossy_zero_win_size_event_threshold = conn_server_lossy_zero_win_size_event_threshold
        self.enable_adaptive_config = enable_adaptive_config
        self.enable_advanced_analytics = enable_advanced_analytics
        self.enable_ondemand_metrics = enable_ondemand_metrics
        self.enable_se_analytics = enable_se_analytics
        self.enable_server_analytics = enable_server_analytics
        self.enable_vs_analytics = enable_vs_analytics
        self.exclude_client_close_before_request_as_error = exclude_client_close_before_request_as_error
        self.exclude_dns_policy_drop_as_significant = exclude_dns_policy_drop_as_significant
        self.exclude_gs_down_as_error = exclude_gs_down_as_error
        self.exclude_http_error_codes = exclude_http_error_codes
        self.exclude_invalid_dns_domain_as_error = exclude_invalid_dns_domain_as_error
        self.exclude_invalid_dns_query_as_error = exclude_invalid_dns_query_as_error
        self.exclude_issuer_revoked_ocsp_responses_as_error = exclude_issuer_revoked_ocsp_responses_as_error
        self.exclude_no_dns_record_as_error = exclude_no_dns_record_as_error
        self.exclude_no_valid_gs_member_as_error = exclude_no_valid_gs_member_as_error
        self.exclude_persistence_change_as_error = exclude_persistence_change_as_error
        self.exclude_revoked_ocsp_responses_as_error = exclude_revoked_ocsp_responses_as_error
        self.exclude_server_dns_error_as_error = exclude_server_dns_error_as_error
        self.exclude_server_tcp_reset_as_error = exclude_server_tcp_reset_as_error
        self.exclude_sip_error_codes = exclude_sip_error_codes
        self.exclude_stale_ocsp_responses_as_error = exclude_stale_ocsp_responses_as_error
        self.exclude_syn_retransmit_as_error = exclude_syn_retransmit_as_error
        self.exclude_tcp_reset_as_error = exclude_tcp_reset_as_error
        self.exclude_unavailable_ocsp_responses_as_error = exclude_unavailable_ocsp_responses_as_error
        self.exclude_unsupported_dns_query_as_error = exclude_unsupported_dns_query_as_error
        self.healthscore_max_server_limit = healthscore_max_server_limit
        self.hs_event_throttle_window = hs_event_throttle_window
        self.hs_max_anomaly_penalty = hs_max_anomaly_penalty
        self.hs_max_resources_penalty = hs_max_resources_penalty
        self.hs_max_security_penalty = hs_max_security_penalty
        self.hs_min_dos_rate = hs_min_dos_rate
        self.hs_performance_boost = hs_performance_boost
        self.hs_pscore_traffic_threshold_l4_client = hs_pscore_traffic_threshold_l4_client
        self.hs_pscore_traffic_threshold_l4_server = hs_pscore_traffic_threshold_l4_server
        self.hs_security_certscore_expired = hs_security_certscore_expired
        self.hs_security_certscore_gt30d = hs_security_certscore_gt30d
        self.hs_security_certscore_le07d = hs_security_certscore_le07d
        self.hs_security_certscore_le30d = hs_security_certscore_le30d
        self.hs_security_chain_invalidity_penalty = hs_security_chain_invalidity_penalty
        self.hs_security_cipherscore_eq000b = hs_security_cipherscore_eq000b
        self.hs_security_cipherscore_ge128b = hs_security_cipherscore_ge128b
        self.hs_security_cipherscore_lt128b = hs_security_cipherscore_lt128b
        self.hs_security_encalgo_score_none = hs_security_encalgo_score_none
        self.hs_security_encalgo_score_rc4 = hs_security_encalgo_score_rc4
        self.hs_security_hsts_penalty = hs_security_hsts_penalty
        self.hs_security_nonpfs_penalty = hs_security_nonpfs_penalty
        self.hs_security_ocsp_revoked_score = hs_security_ocsp_revoked_score
        self.hs_security_selfsignedcert_penalty = hs_security_selfsignedcert_penalty
        self.hs_security_ssl30_score = hs_security_ssl30_score
        self.hs_security_tls10_score = hs_security_tls10_score
        self.hs_security_tls11_score = hs_security_tls11_score
        self.hs_security_tls12_score = hs_security_tls12_score
        self.hs_security_tls13_score = hs_security_tls13_score
        self.hs_security_weak_signature_algo_penalty = hs_security_weak_signature_algo_penalty
        self.markers = markers
        self.ondemand_metrics_idle_timeout = ondemand_metrics_idle_timeout
        self.ranges = ranges
        self.resp_code_block = resp_code_block
        self.sensitive_log_profile = sensitive_log_profile
        self.sip_log_depth = sip_log_depth
        VapiStruct.__init__(self)


ALBAnalyticsProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_analytics_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'apdex_response_threshold': type.OptionalType(type.IntegerType()),
        'apdex_response_tolerated_factor': type.OptionalType(type.DoubleType()),
        'apdex_rtt_threshold': type.OptionalType(type.IntegerType()),
        'apdex_rtt_tolerated_factor': type.OptionalType(type.DoubleType()),
        'apdex_rum_threshold': type.OptionalType(type.IntegerType()),
        'apdex_rum_tolerated_factor': type.OptionalType(type.DoubleType()),
        'apdex_server_response_threshold': type.OptionalType(type.IntegerType()),
        'apdex_server_response_tolerated_factor': type.OptionalType(type.DoubleType()),
        'apdex_server_rtt_threshold': type.OptionalType(type.IntegerType()),
        'apdex_server_rtt_tolerated_factor': type.OptionalType(type.DoubleType()),
        'client_log_config': type.OptionalType(type.ReferenceType(__name__, 'ALBClientLogConfiguration')),
        'client_log_streaming_config': type.OptionalType(type.ReferenceType(__name__, 'ALBClientLogStreamingConfig')),
        'conn_lossy_ooo_threshold': type.OptionalType(type.IntegerType()),
        'conn_lossy_timeo_rexmt_threshold': type.OptionalType(type.IntegerType()),
        'conn_lossy_total_rexmt_threshold': type.OptionalType(type.IntegerType()),
        'conn_lossy_zero_win_size_event_threshold': type.OptionalType(type.IntegerType()),
        'conn_server_lossy_ooo_threshold': type.OptionalType(type.IntegerType()),
        'conn_server_lossy_timeo_rexmt_threshold': type.OptionalType(type.IntegerType()),
        'conn_server_lossy_total_rexmt_threshold': type.OptionalType(type.IntegerType()),
        'conn_server_lossy_zero_win_size_event_threshold': type.OptionalType(type.IntegerType()),
        'enable_adaptive_config': type.OptionalType(type.BooleanType()),
        'enable_advanced_analytics': type.OptionalType(type.BooleanType()),
        'enable_ondemand_metrics': type.OptionalType(type.BooleanType()),
        'enable_se_analytics': type.OptionalType(type.BooleanType()),
        'enable_server_analytics': type.OptionalType(type.BooleanType()),
        'enable_vs_analytics': type.OptionalType(type.BooleanType()),
        'exclude_client_close_before_request_as_error': type.OptionalType(type.BooleanType()),
        'exclude_dns_policy_drop_as_significant': type.OptionalType(type.BooleanType()),
        'exclude_gs_down_as_error': type.OptionalType(type.BooleanType()),
        'exclude_http_error_codes': type.OptionalType(type.ListType(type.IntegerType())),
        'exclude_invalid_dns_domain_as_error': type.OptionalType(type.BooleanType()),
        'exclude_invalid_dns_query_as_error': type.OptionalType(type.BooleanType()),
        'exclude_issuer_revoked_ocsp_responses_as_error': type.OptionalType(type.BooleanType()),
        'exclude_no_dns_record_as_error': type.OptionalType(type.BooleanType()),
        'exclude_no_valid_gs_member_as_error': type.OptionalType(type.BooleanType()),
        'exclude_persistence_change_as_error': type.OptionalType(type.BooleanType()),
        'exclude_revoked_ocsp_responses_as_error': type.OptionalType(type.BooleanType()),
        'exclude_server_dns_error_as_error': type.OptionalType(type.BooleanType()),
        'exclude_server_tcp_reset_as_error': type.OptionalType(type.BooleanType()),
        'exclude_sip_error_codes': type.OptionalType(type.ListType(type.IntegerType())),
        'exclude_stale_ocsp_responses_as_error': type.OptionalType(type.BooleanType()),
        'exclude_syn_retransmit_as_error': type.OptionalType(type.BooleanType()),
        'exclude_tcp_reset_as_error': type.OptionalType(type.BooleanType()),
        'exclude_unavailable_ocsp_responses_as_error': type.OptionalType(type.BooleanType()),
        'exclude_unsupported_dns_query_as_error': type.OptionalType(type.BooleanType()),
        'healthscore_max_server_limit': type.OptionalType(type.IntegerType()),
        'hs_event_throttle_window': type.OptionalType(type.IntegerType()),
        'hs_max_anomaly_penalty': type.OptionalType(type.IntegerType()),
        'hs_max_resources_penalty': type.OptionalType(type.IntegerType()),
        'hs_max_security_penalty': type.OptionalType(type.IntegerType()),
        'hs_min_dos_rate': type.OptionalType(type.IntegerType()),
        'hs_performance_boost': type.OptionalType(type.IntegerType()),
        'hs_pscore_traffic_threshold_l4_client': type.OptionalType(type.DoubleType()),
        'hs_pscore_traffic_threshold_l4_server': type.OptionalType(type.DoubleType()),
        'hs_security_certscore_expired': type.OptionalType(type.DoubleType()),
        'hs_security_certscore_gt30d': type.OptionalType(type.DoubleType()),
        'hs_security_certscore_le07d': type.OptionalType(type.DoubleType()),
        'hs_security_certscore_le30d': type.OptionalType(type.DoubleType()),
        'hs_security_chain_invalidity_penalty': type.OptionalType(type.DoubleType()),
        'hs_security_cipherscore_eq000b': type.OptionalType(type.DoubleType()),
        'hs_security_cipherscore_ge128b': type.OptionalType(type.DoubleType()),
        'hs_security_cipherscore_lt128b': type.OptionalType(type.DoubleType()),
        'hs_security_encalgo_score_none': type.OptionalType(type.DoubleType()),
        'hs_security_encalgo_score_rc4': type.OptionalType(type.DoubleType()),
        'hs_security_hsts_penalty': type.OptionalType(type.DoubleType()),
        'hs_security_nonpfs_penalty': type.OptionalType(type.DoubleType()),
        'hs_security_ocsp_revoked_score': type.OptionalType(type.DoubleType()),
        'hs_security_selfsignedcert_penalty': type.OptionalType(type.DoubleType()),
        'hs_security_ssl30_score': type.OptionalType(type.DoubleType()),
        'hs_security_tls10_score': type.OptionalType(type.DoubleType()),
        'hs_security_tls11_score': type.OptionalType(type.DoubleType()),
        'hs_security_tls12_score': type.OptionalType(type.DoubleType()),
        'hs_security_tls13_score': type.OptionalType(type.DoubleType()),
        'hs_security_weak_signature_algo_penalty': type.OptionalType(type.DoubleType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'ondemand_metrics_idle_timeout': type.OptionalType(type.IntegerType()),
        'ranges': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPStatusRange'))),
        'resp_code_block': type.OptionalType(type.ListType(type.StringType())),
        'sensitive_log_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBSensitiveLogProfile')),
        'sip_log_depth': type.OptionalType(type.IntegerType()),
    },
    ALBAnalyticsProfile,
    False,
    None))



class ALBAnalyticsProfileApiResponse(VapiStruct):
    """
    AnalyticsProfileApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBAnalyticsProfile` or ``None``
        :param results: Array of AnalyticsProfile
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBAnalyticsProfileApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_analytics_profile_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBAnalyticsProfile'))),
    },
    ALBAnalyticsProfileApiResponse,
    False,
    None))



class ALBAppCookiePersistenceProfile(VapiStruct):
    """
    Advanced load balancer AppCookiePersistenceProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'encryption_key': 'encryption_key',
                            'prst_hdr_name': 'prst_hdr_name',
                            'timeout': 'timeout',
                            }

    def __init__(self,
                 encryption_key=None,
                 prst_hdr_name=None,
                 timeout=None,
                ):
        """
        :type  encryption_key: :class:`str` or ``None``
        :param encryption_key: Key to use for cookie encryption.
        :type  prst_hdr_name: :class:`str` or ``None``
        :param prst_hdr_name: Header or cookie name for application cookie persistence.
        :type  timeout: :class:`long` or ``None``
        :param timeout: The length of time after a client's connections have closed before
            expiring the client's persistence to a server. Allowed values are
            1-720. Unit is MIN. Default value when not specified in API or
            module is interpreted by ALB Controller as 20. format: int64
        """
        self.encryption_key = encryption_key
        self.prst_hdr_name = prst_hdr_name
        self.timeout = timeout
        VapiStruct.__init__(self)


ALBAppCookiePersistenceProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_app_cookie_persistence_profile', {
        'encryption_key': type.OptionalType(type.StringType()),
        'prst_hdr_name': type.OptionalType(type.StringType()),
        'timeout': type.OptionalType(type.IntegerType()),
    },
    ALBAppCookiePersistenceProfile,
    False,
    None))



class ALBAppLearningConfidenceOverride(VapiStruct):
    """
    Advanced load balancer AppLearningConfidenceOverride object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'confid_high_value': 'confid_high_value',
                            'confid_low_value': 'confid_low_value',
                            'confid_probable_value': 'confid_probable_value',
                            'confid_very_high_value': 'confid_very_high_value',
                            }

    def __init__(self,
                 confid_high_value=None,
                 confid_low_value=None,
                 confid_probable_value=None,
                 confid_very_high_value=None,
                ):
        """
        :type  confid_high_value: :class:`long` or ``None``
        :param confid_high_value: Confidence threshold for label CONFIDENCE_HIGH. Default value when
            not specified in API or module is interpreted by ALB Controller as
            9500. format: int64
        :type  confid_low_value: :class:`long` or ``None``
        :param confid_low_value: Confidence threshold for label CONFIDENCE_LOW. Default value when
            not specified in API or module is interpreted by ALB Controller as
            7500. format: int64
        :type  confid_probable_value: :class:`long` or ``None``
        :param confid_probable_value: Confidence threshold for label CONFIDENCE_PROBABLE. Default value
            when not specified in API or module is interpreted by ALB
            Controller as 9000. format: int64
        :type  confid_very_high_value: :class:`long` or ``None``
        :param confid_very_high_value: Confidence threshold for label CONFIDENCE_VERY_HIGH. Default value
            when not specified in API or module is interpreted by ALB
            Controller as 9999. format: int64
        """
        self.confid_high_value = confid_high_value
        self.confid_low_value = confid_low_value
        self.confid_probable_value = confid_probable_value
        self.confid_very_high_value = confid_very_high_value
        VapiStruct.__init__(self)


ALBAppLearningConfidenceOverride._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_app_learning_confidence_override', {
        'confid_high_value': type.OptionalType(type.IntegerType()),
        'confid_low_value': type.OptionalType(type.IntegerType()),
        'confid_probable_value': type.OptionalType(type.IntegerType()),
        'confid_very_high_value': type.OptionalType(type.IntegerType()),
    },
    ALBAppLearningConfidenceOverride,
    False,
    None))



class ALBAppLearningParams(VapiStruct):
    """
    Advanced load balancer AppLearningParams object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enable_per_uri_learning': 'enable_per_uri_learning',
                            'max_params': 'max_params',
                            'max_uris': 'max_uris',
                            'min_hits_to_learn': 'min_hits_to_learn',
                            'sampling_percent': 'sampling_percent',
                            'update_interval': 'update_interval',
                            }

    def __init__(self,
                 enable_per_uri_learning=None,
                 max_params=None,
                 max_uris=None,
                 min_hits_to_learn=None,
                 sampling_percent=None,
                 update_interval=None,
                ):
        """
        :type  enable_per_uri_learning: :class:`bool` or ``None``
        :param enable_per_uri_learning: Learn the params per URI path. Default value when not specified in
            API or module is interpreted by ALB Controller as true.
        :type  max_params: :class:`long` or ``None``
        :param max_params: Maximum number of params to learn for an application. Allowed
            values are 10-1000. Default value when not specified in API or
            module is interpreted by ALB Controller as 100. format: int64
        :type  max_uris: :class:`long` or ``None``
        :param max_uris: Maximum number of URI paths to learn for an application. Allowed
            values are 10-10000. Default value when not specified in API or
            module is interpreted by ALB Controller as 500. format: int64
        :type  min_hits_to_learn: :class:`long` or ``None``
        :param min_hits_to_learn: Minimum number of occurances required for a Param to qualify for
            learning. Default value when not specified in API or module is
            interpreted by ALB Controller as 10000. format: int64
        :type  sampling_percent: :class:`long` or ``None``
        :param sampling_percent: Percent of the requests subjected to Application learning. Allowed
            values are 1-100. Unit is PERCENT. Default value when not specified
            in API or module is interpreted by ALB Controller as 1. format:
            int64
        :type  update_interval: :class:`long` or ``None``
        :param update_interval: Frequency with which SE publishes Application learning data to
            controller. Allowed values are 1-60. Unit is MIN. Default value
            when not specified in API or module is interpreted by ALB
            Controller as 30. format: int64
        """
        self.enable_per_uri_learning = enable_per_uri_learning
        self.max_params = max_params
        self.max_uris = max_uris
        self.min_hits_to_learn = min_hits_to_learn
        self.sampling_percent = sampling_percent
        self.update_interval = update_interval
        VapiStruct.__init__(self)


ALBAppLearningParams._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_app_learning_params', {
        'enable_per_uri_learning': type.OptionalType(type.BooleanType()),
        'max_params': type.OptionalType(type.IntegerType()),
        'max_uris': type.OptionalType(type.IntegerType()),
        'min_hits_to_learn': type.OptionalType(type.IntegerType()),
        'sampling_percent': type.OptionalType(type.IntegerType()),
        'update_interval': type.OptionalType(type.IntegerType()),
    },
    ALBAppLearningParams,
    False,
    None))



class ALBApplicationPersistenceProfile(VapiStruct):
    """
    Advanced load balancer ApplicationPersistenceProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    PERSISTENCE_TYPE_CLIENT_IP_ADDRESS = "PERSISTENCE_TYPE_CLIENT_IP_ADDRESS"
    """


    """
    PERSISTENCE_TYPE_HTTP_COOKIE = "PERSISTENCE_TYPE_HTTP_COOKIE"
    """


    """
    PERSISTENCE_TYPE_TLS = "PERSISTENCE_TYPE_TLS"
    """


    """
    PERSISTENCE_TYPE_CLIENT_IPV6_ADDRESS = "PERSISTENCE_TYPE_CLIENT_IPV6_ADDRESS"
    """


    """
    PERSISTENCE_TYPE_CUSTOM_HTTP_HEADER = "PERSISTENCE_TYPE_CUSTOM_HTTP_HEADER"
    """


    """
    PERSISTENCE_TYPE_APP_COOKIE = "PERSISTENCE_TYPE_APP_COOKIE"
    """


    """
    PERSISTENCE_TYPE_GSLB_SITE = "PERSISTENCE_TYPE_GSLB_SITE"
    """


    """
    SERVER_HM_DOWN_RECOVERY_PICK_NEW_SERVER = "HM_DOWN_PICK_NEW_SERVER"
    """


    """
    SERVER_HM_DOWN_RECOVERY_ABORT_CONNECTION = "HM_DOWN_ABORT_CONNECTION"
    """


    """
    SERVER_HM_DOWN_RECOVERY_CONTINUE_PERSISTENT_SERVER = "HM_DOWN_CONTINUE_PERSISTENT_SERVER"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'app_cookie_persistence_profile': 'app_cookie_persistence_profile',
                            'hdr_persistence_profile': 'hdr_persistence_profile',
                            'http_cookie_persistence_profile': 'http_cookie_persistence_profile',
                            'ip_persistence_profile': 'ip_persistence_profile',
                            'is_federated': 'is_federated',
                            'markers': 'markers',
                            'persistence_type': 'persistence_type',
                            'server_hm_down_recovery': 'server_hm_down_recovery',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 app_cookie_persistence_profile=None,
                 hdr_persistence_profile=None,
                 http_cookie_persistence_profile=None,
                 ip_persistence_profile=None,
                 is_federated=None,
                 markers=None,
                 persistence_type=None,
                 server_hm_down_recovery=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  app_cookie_persistence_profile: :class:`ALBAppCookiePersistenceProfile` or ``None``
        :param app_cookie_persistence_profile: 
        :type  hdr_persistence_profile: :class:`ALBHdrPersistenceProfile` or ``None``
        :param hdr_persistence_profile: 
        :type  http_cookie_persistence_profile: :class:`ALBHttpCookiePersistenceProfile` or ``None``
        :param http_cookie_persistence_profile: 
        :type  ip_persistence_profile: :class:`ALBIPPersistenceProfile` or ``None``
        :param ip_persistence_profile: 
        :type  is_federated: :class:`bool` or ``None``
        :param is_federated: This field describes the object's replication scope. If the field
            is set to false, then the object is visible within the
            controller-cluster and its associated service-engines. If the field
            is set to true, then the object is replicated across the
            federation. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  persistence_type: :class:`str` or ``None``
        :param persistence_type: Possible values are: 
            
            *
              :attr:`ALBApplicationPersistenceProfile.PERSISTENCE_TYPE_CLIENT_IP_ADDRESS`
            *
              :attr:`ALBApplicationPersistenceProfile.PERSISTENCE_TYPE_HTTP_COOKIE`
            * :attr:`ALBApplicationPersistenceProfile.PERSISTENCE_TYPE_TLS`
            *
              :attr:`ALBApplicationPersistenceProfile.PERSISTENCE_TYPE_CLIENT_IPV6_ADDRESS`
            *
              :attr:`ALBApplicationPersistenceProfile.PERSISTENCE_TYPE_CUSTOM_HTTP_HEADER`
            *
              :attr:`ALBApplicationPersistenceProfile.PERSISTENCE_TYPE_APP_COOKIE`
            *
              :attr:`ALBApplicationPersistenceProfile.PERSISTENCE_TYPE_GSLB_SITE`
            
            Method used to persist clients to the same server for a duration of
            time or a session. Enum options -
            PERSISTENCE_TYPE_CLIENT_IP_ADDRESS, PERSISTENCE_TYPE_HTTP_COOKIE,
            PERSISTENCE_TYPE_TLS, PERSISTENCE_TYPE_CLIENT_IPV6_ADDRESS,
            PERSISTENCE_TYPE_CUSTOM_HTTP_HEADER, PERSISTENCE_TYPE_APP_COOKIE,
            PERSISTENCE_TYPE_GSLB_SITE. Allowed in Basic(Allowed values-
            PERSISTENCE_TYPE_CLIENT_IP_ADDRESS,PERSISTENCE_TYPE_HTTP_COOKIE)
            edition, Essentials(Allowed values-
            PERSISTENCE_TYPE_CLIENT_IP_ADDRESS,PERSISTENCE_TYPE_HTTP_COOKIE)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as
            PERSISTENCE_TYPE_CLIENT_IP_ADDRESS.
        :type  server_hm_down_recovery: :class:`str` or ``None``
        :param server_hm_down_recovery: Possible values are: 
            
            *
              :attr:`ALBApplicationPersistenceProfile.SERVER_HM_DOWN_RECOVERY_PICK_NEW_SERVER`
            *
              :attr:`ALBApplicationPersistenceProfile.SERVER_HM_DOWN_RECOVERY_ABORT_CONNECTION`
            *
              :attr:`ALBApplicationPersistenceProfile.SERVER_HM_DOWN_RECOVERY_CONTINUE_PERSISTENT_SERVER`
            
            Specifies behavior when a persistent server has been marked down by
            a health monitor. Enum options - HM_DOWN_PICK_NEW_SERVER,
            HM_DOWN_ABORT_CONNECTION, HM_DOWN_CONTINUE_PERSISTENT_SERVER.
            Allowed in Basic(Allowed values- HM_DOWN_PICK_NEW_SERVER) edition,
            Essentials(Allowed values- HM_DOWN_PICK_NEW_SERVER) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as HM_DOWN_PICK_NEW_SERVER.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.app_cookie_persistence_profile = app_cookie_persistence_profile
        self.hdr_persistence_profile = hdr_persistence_profile
        self.http_cookie_persistence_profile = http_cookie_persistence_profile
        self.ip_persistence_profile = ip_persistence_profile
        self.is_federated = is_federated
        self.markers = markers
        self.persistence_type = persistence_type
        self.server_hm_down_recovery = server_hm_down_recovery
        VapiStruct.__init__(self)


ALBApplicationPersistenceProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_application_persistence_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'app_cookie_persistence_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBAppCookiePersistenceProfile')),
        'hdr_persistence_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBHdrPersistenceProfile')),
        'http_cookie_persistence_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBHttpCookiePersistenceProfile')),
        'ip_persistence_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBIPPersistenceProfile')),
        'is_federated': type.OptionalType(type.BooleanType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'persistence_type': type.OptionalType(type.StringType()),
        'server_hm_down_recovery': type.OptionalType(type.StringType()),
    },
    ALBApplicationPersistenceProfile,
    False,
    None))



class ALBApplicationPersistenceProfileApiResponse(VapiStruct):
    """
    ApplicationPersistenceProfileApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBApplicationPersistenceProfile` or ``None``
        :param results: Array of ApplicationPersistenceProfile
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBApplicationPersistenceProfileApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_application_persistence_profile_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBApplicationPersistenceProfile'))),
    },
    ALBApplicationPersistenceProfileApiResponse,
    False,
    None))



class ALBApplicationProfile(VapiStruct):
    """
    Advanced load balancer ApplicationProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_L4 = "APPLICATION_PROFILE_TYPE_L4"
    """


    """
    TYPE_HTTP = "APPLICATION_PROFILE_TYPE_HTTP"
    """


    """
    TYPE_SYSLOG = "APPLICATION_PROFILE_TYPE_SYSLOG"
    """


    """
    TYPE_DNS = "APPLICATION_PROFILE_TYPE_DNS"
    """


    """
    TYPE_SSL = "APPLICATION_PROFILE_TYPE_SSL"
    """


    """
    TYPE_SIP = "APPLICATION_PROFILE_TYPE_SIP"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'cloud_config_cksum': 'cloud_config_cksum',
                            'created_by': 'created_by',
                            'dns_service_profile': 'dns_service_profile',
                            'dos_rl_profile': 'dos_rl_profile',
                            'http_profile': 'http_profile',
                            'markers': 'markers',
                            'preserve_client_ip': 'preserve_client_ip',
                            'preserve_client_port': 'preserve_client_port',
                            'preserve_dest_ip_port': 'preserve_dest_ip_port',
                            'sip_service_profile': 'sip_service_profile',
                            'tcp_app_profile': 'tcp_app_profile',
                            'type': 'type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 cloud_config_cksum=None,
                 created_by=None,
                 dns_service_profile=None,
                 dos_rl_profile=None,
                 http_profile=None,
                 markers=None,
                 preserve_client_ip=None,
                 preserve_client_port=None,
                 preserve_dest_ip_port=None,
                 sip_service_profile=None,
                 tcp_app_profile=None,
                 type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cloud_config_cksum: :class:`str` or ``None``
        :param cloud_config_cksum: Checksum of application profiles. Internally set by cloud
            connector.
        :type  created_by: :class:`str` or ``None``
        :param created_by: Name of the application profile creator.
        :type  dns_service_profile: :class:`ALBDnsServiceApplicationProfile` or ``None``
        :param dns_service_profile: 
        :type  dos_rl_profile: :class:`ALBDosRateLimitProfile` or ``None``
        :param dos_rl_profile: 
        :type  http_profile: :class:`ALBHTTPApplicationProfile` or ``None``
        :param http_profile: 
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  preserve_client_ip: :class:`bool` or ``None``
        :param preserve_client_ip: Specifies if client IP needs to be preserved for backend
            connection. Not compatible with Connection Multiplexing. Default
            value when not specified in API or module is interpreted by ALB
            Controller as false.
        :type  preserve_client_port: :class:`bool` or ``None``
        :param preserve_client_port: Specifies if we need to preserve client port while preserving
            client IP for backend connections. Default value when not specified
            in API or module is interpreted by ALB Controller as false.
        :type  preserve_dest_ip_port: :class:`bool` or ``None``
        :param preserve_dest_ip_port: Specifies if destination IP and port needs to be preserved for
            backend connection. Allowed in Basic(Allowed values- false)
            edition, Essentials(Allowed values- false) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  sip_service_profile: :class:`ALBSipServiceApplicationProfile` or ``None``
        :param sip_service_profile: 
        :type  tcp_app_profile: :class:`ALBTCPApplicationProfile` or ``None``
        :param tcp_app_profile: 
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBApplicationProfile.TYPE_L4`
            * :attr:`ALBApplicationProfile.TYPE_HTTP`
            * :attr:`ALBApplicationProfile.TYPE_SYSLOG`
            * :attr:`ALBApplicationProfile.TYPE_DNS`
            * :attr:`ALBApplicationProfile.TYPE_SSL`
            * :attr:`ALBApplicationProfile.TYPE_SIP`
            
            Specifies which application layer proxy is enabled for the virtual
            service. Enum options - APPLICATION_PROFILE_TYPE_L4,
            APPLICATION_PROFILE_TYPE_HTTP, APPLICATION_PROFILE_TYPE_SYSLOG,
            APPLICATION_PROFILE_TYPE_DNS, APPLICATION_PROFILE_TYPE_SSL,
            APPLICATION_PROFILE_TYPE_SIP. Allowed in Basic(Allowed values-
            APPLICATION_PROFILE_TYPE_L4,APPLICATION_PROFILE_TYPE_HTTP) edition,
            Essentials(Allowed values- APPLICATION_PROFILE_TYPE_L4) edition,
            Enterprise edition.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.cloud_config_cksum = cloud_config_cksum
        self.created_by = created_by
        self.dns_service_profile = dns_service_profile
        self.dos_rl_profile = dos_rl_profile
        self.http_profile = http_profile
        self.markers = markers
        self.preserve_client_ip = preserve_client_ip
        self.preserve_client_port = preserve_client_port
        self.preserve_dest_ip_port = preserve_dest_ip_port
        self.sip_service_profile = sip_service_profile
        self.tcp_app_profile = tcp_app_profile
        self.type = type
        VapiStruct.__init__(self)


ALBApplicationProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_application_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'cloud_config_cksum': type.OptionalType(type.StringType()),
        'created_by': type.OptionalType(type.StringType()),
        'dns_service_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsServiceApplicationProfile')),
        'dos_rl_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBDosRateLimitProfile')),
        'http_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPApplicationProfile')),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'preserve_client_ip': type.OptionalType(type.BooleanType()),
        'preserve_client_port': type.OptionalType(type.BooleanType()),
        'preserve_dest_ip_port': type.OptionalType(type.BooleanType()),
        'sip_service_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBSipServiceApplicationProfile')),
        'tcp_app_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBTCPApplicationProfile')),
        'type': type.OptionalType(type.StringType()),
    },
    ALBApplicationProfile,
    False,
    None))



class ALBApplicationProfileApiResponse(VapiStruct):
    """
    ApplicationProfileApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBApplicationProfile` or ``None``
        :param results: Array of ApplicationProfile
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBApplicationProfileApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_application_profile_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBApplicationProfile'))),
    },
    ALBApplicationProfileApiResponse,
    False,
    None))



class ALBAttackMitigationAction(VapiStruct):
    """
    Advanced load balancer AttackMitigationAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'deny': 'deny',
                            }

    def __init__(self,
                 deny=None,
                ):
        """
        :type  deny: :class:`bool` or ``None``
        :param deny: Deny the attack packets further processing and drop them. Default
            value when not specified in API or module is interpreted by ALB
            Controller as true.
        """
        self.deny = deny
        VapiStruct.__init__(self)


ALBAttackMitigationAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_attack_mitigation_action', {
        'deny': type.OptionalType(type.BooleanType()),
    },
    ALBAttackMitigationAction,
    False,
    None))



class ALBAuthAttributeMatch(VapiStruct):
    """
    Advanced load balancer AuthAttributeMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'attribute_name': 'attribute_name',
                            'attribute_value_list': 'attribute_value_list',
                            }

    def __init__(self,
                 attribute_name=None,
                 attribute_value_list=None,
                ):
        """
        :type  attribute_name: :class:`str` or ``None``
        :param attribute_name: Attribute name whose values will be looked up in the access lists.
        :type  attribute_value_list: :class:`ALBStringMatch` or ``None``
        :param attribute_value_list: 
        """
        self.attribute_name = attribute_name
        self.attribute_value_list = attribute_value_list
        VapiStruct.__init__(self)


ALBAuthAttributeMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auth_attribute_match', {
        'attribute_name': type.OptionalType(type.StringType()),
        'attribute_value_list': type.OptionalType(type.ReferenceType(__name__, 'ALBStringMatch')),
    },
    ALBAuthAttributeMatch,
    False,
    None))



class ALBAuthProfile(VapiStruct):
    """
    Advanced load balancer AuthProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_LDAP = "AUTH_PROFILE_LDAP"
    """


    """
    TYPE_TACACS_PLUS = "AUTH_PROFILE_TACACS_PLUS"
    """


    """
    TYPE_SAML = "AUTH_PROFILE_SAML"
    """


    """
    TYPE_PINGACCESS = "AUTH_PROFILE_PINGACCESS"
    """


    """
    TYPE_JWT = "AUTH_PROFILE_JWT"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'http': 'http',
                            'ldap': 'ldap',
                            'markers': 'markers',
                            'saml': 'saml',
                            'tacacs_plus': 'tacacs_plus',
                            'type': 'type',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 http=None,
                 ldap=None,
                 markers=None,
                 saml=None,
                 tacacs_plus=None,
                 type=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  http: :class:`ALBAuthProfileHTTPClientParams` or ``None``
        :param http: 
        :type  ldap: :class:`ALBLdapAuthSettings` or ``None``
        :param ldap: 
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  saml: :class:`ALBSamlSettings` or ``None``
        :param saml: 
        :type  tacacs_plus: :class:`ALBTacacsPlusAuthSettings` or ``None``
        :param tacacs_plus: 
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBAuthProfile.TYPE_LDAP`
            * :attr:`ALBAuthProfile.TYPE_TACACS_PLUS`
            * :attr:`ALBAuthProfile.TYPE_SAML`
            * :attr:`ALBAuthProfile.TYPE_PINGACCESS`
            * :attr:`ALBAuthProfile.TYPE_JWT`
            
            Type of the Auth Profile. Enum options - AUTH_PROFILE_LDAP,
            AUTH_PROFILE_TACACS_PLUS, AUTH_PROFILE_SAML,
            AUTH_PROFILE_PINGACCESS, AUTH_PROFILE_JWT.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.http = http
        self.ldap = ldap
        self.markers = markers
        self.saml = saml
        self.tacacs_plus = tacacs_plus
        self.type = type
        VapiStruct.__init__(self)


ALBAuthProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auth_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'http': type.OptionalType(type.ReferenceType(__name__, 'ALBAuthProfileHTTPClientParams')),
        'ldap': type.OptionalType(type.ReferenceType(__name__, 'ALBLdapAuthSettings')),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'saml': type.OptionalType(type.ReferenceType(__name__, 'ALBSamlSettings')),
        'tacacs_plus': type.OptionalType(type.ReferenceType(__name__, 'ALBTacacsPlusAuthSettings')),
        'type': type.OptionalType(type.StringType()),
    },
    ALBAuthProfile,
    False,
    None))



class ALBAuthProfileApiResponse(VapiStruct):
    """
    AuthProfileApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBAuthProfile` or ``None``
        :param results: Array of AuthProfile
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBAuthProfileApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auth_profile_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBAuthProfile'))),
    },
    ALBAuthProfileApiResponse,
    False,
    None))



class ALBAuthProfileHTTPClientParams(VapiStruct):
    """
    Advanced load balancer AuthProfileHTTPClientParams object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cache_expiration_time': 'cache_expiration_time',
                            'request_header': 'request_header',
                            'require_user_groups': 'require_user_groups',
                            }

    def __init__(self,
                 cache_expiration_time=None,
                 request_header=None,
                 require_user_groups=None,
                ):
        """
        :type  cache_expiration_time: :class:`long` or ``None``
        :param cache_expiration_time: The max allowed length of time a clients authentication is cached.
            Allowed values are 1-30. Unit is SEC. Default value when not
            specified in API or module is interpreted by ALB Controller as 5.
            format: int64
        :type  request_header: :class:`str` or ``None``
        :param request_header: Insert an HTTP header. This field is used to define the header
            name. The value of the header is set to the client's HTTP Auth user
            ID.
        :type  require_user_groups: :class:`list` of :class:`str` or ``None``
        :param require_user_groups: A user should be a member of these groups. Each group is defined by
            the DN. For example,
            CN=testgroup,OU=groups,dc=example,dc=avinetworks,DC=com.
        """
        self.cache_expiration_time = cache_expiration_time
        self.request_header = request_header
        self.require_user_groups = require_user_groups
        VapiStruct.__init__(self)


ALBAuthProfileHTTPClientParams._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auth_profile_HTTP_client_params', {
        'cache_expiration_time': type.OptionalType(type.IntegerType()),
        'request_header': type.OptionalType(type.StringType()),
        'require_user_groups': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBAuthProfileHTTPClientParams,
    False,
    None))



class ALBAuthTacacsPlusAttributeValuePair(VapiStruct):
    """
    Advanced load balancer AuthTacacsPlusAttributeValuePair object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'mandatory': 'mandatory',
                            'name': 'name',
                            'value': 'value',
                            }

    def __init__(self,
                 mandatory=None,
                 name=None,
                 value=None,
                ):
        """
        :type  mandatory: :class:`bool` or ``None``
        :param mandatory: mandatory.
        :type  name: :class:`str` or ``None``
        :param name: attribute name.
        :type  value: :class:`str` or ``None``
        :param value: attribute value.
        """
        self.mandatory = mandatory
        self.name = name
        self.value = value
        VapiStruct.__init__(self)


ALBAuthTacacsPlusAttributeValuePair._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auth_tacacs_plus_attribute_value_pair', {
        'mandatory': type.OptionalType(type.BooleanType()),
        'name': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.StringType()),
    },
    ALBAuthTacacsPlusAttributeValuePair,
    False,
    None))



class ALBAuthToken(VapiStruct):
    """
    ALB Auth Token

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'expires_at': 'expires_at',
                            'hours': 'hours',
                            'token': 'token',
                            'username': 'username',
                            }

    def __init__(self,
                 expires_at=None,
                 hours=None,
                 token=None,
                 username=None,
                ):
        """
        :type  expires_at: :class:`str` or ``None``
        :param expires_at: Expiry time of the token will be set by LCM at the time of
            Enforcement Point Creation.
        :type  hours: :class:`str` or ``None``
        :param hours: Hours to validate the token
        :type  token: :class:`str` or ``None``
        :param token: Token for Avi Controller.
        :type  username: :class:`str` or ``None``
        :param username: controller username.
        """
        self.expires_at = expires_at
        self.hours = hours
        self.token = token
        self.username = username
        VapiStruct.__init__(self)


ALBAuthToken._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auth_token', {
        'expires_at': type.OptionalType(type.StringType()),
        'hours': type.OptionalType(type.StringType()),
        'token': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    ALBAuthToken,
    False,
    None))



class ALBAuthenticationAction(VapiStruct):
    """
    Advanced load balancer AuthenticationAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_SKIP_AUTHENTICATION = "SKIP_AUTHENTICATION"
    """


    """
    TYPE_USE_DEFAULT_AUTHENTICATION = "USE_DEFAULT_AUTHENTICATION"
    """


    """



    _canonical_to_pep_names = {
                            'type': 'type',
                            }

    def __init__(self,
                 type=None,
                ):
        """
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBAuthenticationAction.TYPE_SKIP_AUTHENTICATION`
            * :attr:`ALBAuthenticationAction.TYPE_USE_DEFAULT_AUTHENTICATION`
            
            Authentication Action to be taken for a matched Rule. Enum options
            - SKIP_AUTHENTICATION, USE_DEFAULT_AUTHENTICATION. Default value
            when not specified in API or module is interpreted by ALB
            Controller as USE_DEFAULT_AUTHENTICATION.
        """
        self.type = type
        VapiStruct.__init__(self)


ALBAuthenticationAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_authentication_action', {
        'type': type.OptionalType(type.StringType()),
    },
    ALBAuthenticationAction,
    False,
    None))



class ALBAuthenticationMatch(VapiStruct):
    """
    Advanced load balancer AuthenticationMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_ip': 'client_ip',
                            'host_hdr': 'host_hdr',
                            'path': 'path',
                            }

    def __init__(self,
                 client_ip=None,
                 host_hdr=None,
                 path=None,
                ):
        """
        :type  client_ip: :class:`ALBIpAddrMatch` or ``None``
        :param client_ip: 
        :type  host_hdr: :class:`ALBHostHdrMatch` or ``None``
        :param host_hdr: 
        :type  path: :class:`ALBPathMatch` or ``None``
        :param path: 
        """
        self.client_ip = client_ip
        self.host_hdr = host_hdr
        self.path = path
        VapiStruct.__init__(self)


ALBAuthenticationMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_authentication_match', {
        'client_ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrMatch')),
        'host_hdr': type.OptionalType(type.ReferenceType(__name__, 'ALBHostHdrMatch')),
        'path': type.OptionalType(type.ReferenceType(__name__, 'ALBPathMatch')),
    },
    ALBAuthenticationMatch,
    False,
    None))



class ALBAuthenticationPolicy(VapiStruct):
    """
    Advanced load balancer AuthenticationPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'authn_rules': 'authn_rules',
                            'default_auth_profile_path': 'default_auth_profile_path',
                            }

    def __init__(self,
                 authn_rules=None,
                 default_auth_profile_path=None,
                ):
        """
        :type  authn_rules: :class:`list` of :class:`ALBAuthenticationRule` or ``None``
        :param authn_rules: Add rules to apply auth profile to specific targets.
        :type  default_auth_profile_path: :class:`str` or ``None``
        :param default_auth_profile_path: Auth Profile to use for validating users. It is a reference to an
            object of type AuthProfile.
        """
        self.authn_rules = authn_rules
        self.default_auth_profile_path = default_auth_profile_path
        VapiStruct.__init__(self)


ALBAuthenticationPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_authentication_policy', {
        'authn_rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBAuthenticationRule'))),
        'default_auth_profile_path': type.OptionalType(type.StringType()),
    },
    ALBAuthenticationPolicy,
    False,
    None))



class ALBAuthenticationRule(VapiStruct):
    """
    Advanced load balancer AuthenticationRule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'enable': 'enable',
                            'index': 'index',
                            'match': 'match',
                            'name': 'name',
                            }

    def __init__(self,
                 action=None,
                 enable=None,
                 index=None,
                 match=None,
                 name=None,
                ):
        """
        :type  action: :class:`ALBAuthenticationAction` or ``None``
        :param action: 
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable the rule. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  index: :class:`long` or ``None``
        :param index: Index of the rule. format: int64
        :type  match: :class:`ALBAuthenticationMatch` or ``None``
        :param match: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the rule.
        """
        self.action = action
        self.enable = enable
        self.index = index
        self.match = match
        self.name = name
        VapiStruct.__init__(self)


ALBAuthenticationRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_authentication_rule', {
        'action': type.OptionalType(type.ReferenceType(__name__, 'ALBAuthenticationAction')),
        'enable': type.OptionalType(type.BooleanType()),
        'index': type.OptionalType(type.IntegerType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBAuthenticationMatch')),
        'name': type.OptionalType(type.StringType()),
    },
    ALBAuthenticationRule,
    False,
    None))



class ALBAuthorizationAction(VapiStruct):
    """
    Advanced load balancer AuthorizationAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_CODE_401 = "HTTP_RESPONSE_STATUS_CODE_401"
    """


    """
    STATUS_CODE_403 = "HTTP_RESPONSE_STATUS_CODE_403"
    """


    """
    TYPE_ALLOW_ACCESS = "ALLOW_ACCESS"
    """


    """
    TYPE_CLOSE_CONNECTION = "CLOSE_CONNECTION"
    """


    """
    TYPE_HTTP_LOCAL_RESPONSE = "HTTP_LOCAL_RESPONSE"
    """


    """



    _canonical_to_pep_names = {
                            'status_code': 'status_code',
                            'type': 'type',
                            }

    def __init__(self,
                 status_code=None,
                 type=None,
                ):
        """
        :type  status_code: :class:`str` or ``None``
        :param status_code: Possible values are: 
            
            * :attr:`ALBAuthorizationAction.STATUS_CODE__401`
            * :attr:`ALBAuthorizationAction.STATUS_CODE__403`
            
            HTTP status code to use for local response when an policy rule is
            matched. Enum options - HTTP_RESPONSE_STATUS_CODE_401,
            HTTP_RESPONSE_STATUS_CODE_403.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBAuthorizationAction.TYPE_ALLOW_ACCESS`
            * :attr:`ALBAuthorizationAction.TYPE_CLOSE_CONNECTION`
            * :attr:`ALBAuthorizationAction.TYPE_HTTP_LOCAL_RESPONSE`
            
            Defines the action taken when an authorization policy rule is
            matched. By default, access is allowed to the requested resource.
            Enum options - ALLOW_ACCESS, CLOSE_CONNECTION, HTTP_LOCAL_RESPONSE.
            Default value when not specified in API or module is interpreted by
            ALB Controller as ALLOW_ACCESS.
        """
        self.status_code = status_code
        self.type = type
        VapiStruct.__init__(self)


ALBAuthorizationAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_authorization_action', {
        'status_code': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    ALBAuthorizationAction,
    False,
    None))



class ALBAuthorizationMatch(VapiStruct):
    """
    Advanced load balancer AuthorizationMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'attr_matches': 'attr_matches',
                            'host_hdr': 'host_hdr',
                            'method': 'method',
                            'path': 'path',
                            }

    def __init__(self,
                 attr_matches=None,
                 host_hdr=None,
                 method=None,
                 path=None,
                ):
        """
        :type  attr_matches: :class:`list` of :class:`ALBAuthAttributeMatch` or ``None``
        :param attr_matches: Attributes whose values need to be matched. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  host_hdr: :class:`ALBHostHdrMatch` or ``None``
        :param host_hdr: 
        :type  method: :class:`ALBMethodMatch` or ``None``
        :param method: 
        :type  path: :class:`ALBPathMatch` or ``None``
        :param path: 
        """
        self.attr_matches = attr_matches
        self.host_hdr = host_hdr
        self.method = method
        self.path = path
        VapiStruct.__init__(self)


ALBAuthorizationMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_authorization_match', {
        'attr_matches': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBAuthAttributeMatch'))),
        'host_hdr': type.OptionalType(type.ReferenceType(__name__, 'ALBHostHdrMatch')),
        'method': type.OptionalType(type.ReferenceType(__name__, 'ALBMethodMatch')),
        'path': type.OptionalType(type.ReferenceType(__name__, 'ALBPathMatch')),
    },
    ALBAuthorizationMatch,
    False,
    None))



class ALBAuthorizationPolicy(VapiStruct):
    """
    Advanced load balancer AuthorizationPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'authz_rules': 'authz_rules',
                            }

    def __init__(self,
                 authz_rules=None,
                ):
        """
        :type  authz_rules: :class:`list` of :class:`ALBAuthorizationRule` or ``None``
        :param authz_rules: Authorization Policy Rules.
        """
        self.authz_rules = authz_rules
        VapiStruct.__init__(self)


ALBAuthorizationPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_authorization_policy', {
        'authz_rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBAuthorizationRule'))),
    },
    ALBAuthorizationPolicy,
    False,
    None))



class ALBAuthorizationRule(VapiStruct):
    """
    Advanced load balancer AuthorizationRule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'enable': 'enable',
                            'index': 'index',
                            'match': 'match',
                            'name': 'name',
                            }

    def __init__(self,
                 action=None,
                 enable=None,
                 index=None,
                 match=None,
                 name=None,
                ):
        """
        :type  action: :class:`ALBAuthorizationAction` or ``None``
        :param action: 
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable the rule. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  index: :class:`long` or ``None``
        :param index: Index of the Authorization Policy rule. format: int64
        :type  match: :class:`ALBAuthorizationMatch` or ``None``
        :param match: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the rule.
        """
        self.action = action
        self.enable = enable
        self.index = index
        self.match = match
        self.name = name
        VapiStruct.__init__(self)


ALBAuthorizationRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_authorization_rule', {
        'action': type.OptionalType(type.ReferenceType(__name__, 'ALBAuthorizationAction')),
        'enable': type.OptionalType(type.BooleanType()),
        'index': type.OptionalType(type.IntegerType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBAuthorizationMatch')),
        'name': type.OptionalType(type.StringType()),
    },
    ALBAuthorizationRule,
    False,
    None))



class ALBAutoScaleLaunchConfig(VapiStruct):
    """
    Advanced load balancer AutoScaleLaunchConfig object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'image_id': 'image_id',
                            'markers': 'markers',
                            'mesos': 'mesos',
                            'openstack': 'openstack',
                            'use_external_asg': 'use_external_asg',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 image_id=None,
                 markers=None,
                 mesos=None,
                 openstack=None,
                 use_external_asg=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  image_id: :class:`str` or ``None``
        :param image_id: Unique ID of the Amazon Machine Image (AMI) or OpenStack VM ID.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  mesos: :class:`ALBAutoScaleMesosSettings` or ``None``
        :param mesos: 
        :type  openstack: :class:`ALBAutoScaleOpenStackSettings` or ``None``
        :param openstack: 
        :type  use_external_asg: :class:`bool` or ``None``
        :param use_external_asg: If set to True, ServerAutoscalePolicy will use the autoscaling
            group (external_autoscaling_groups) from Pool to perform scale up
            and scale down. Pool should have single autoscaling group
            configured. Default value when not specified in API or module is
            interpreted by ALB Controller as true.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.image_id = image_id
        self.markers = markers
        self.mesos = mesos
        self.openstack = openstack
        self.use_external_asg = use_external_asg
        VapiStruct.__init__(self)


ALBAutoScaleLaunchConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auto_scale_launch_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'image_id': type.OptionalType(type.StringType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'mesos': type.OptionalType(type.ReferenceType(__name__, 'ALBAutoScaleMesosSettings')),
        'openstack': type.OptionalType(type.ReferenceType(__name__, 'ALBAutoScaleOpenStackSettings')),
        'use_external_asg': type.OptionalType(type.BooleanType()),
    },
    ALBAutoScaleLaunchConfig,
    False,
    None))



class ALBAutoScaleLaunchConfigApiResponse(VapiStruct):
    """
    AutoScaleLaunchConfigApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBAutoScaleLaunchConfig` or ``None``
        :param results: Array of AutoScaleLaunchConfig
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBAutoScaleLaunchConfigApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auto_scale_launch_config_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBAutoScaleLaunchConfig'))),
    },
    ALBAutoScaleLaunchConfigApiResponse,
    False,
    None))



class ALBAutoScaleMesosSettings(VapiStruct):
    """
    Advanced load balancer AutoScaleMesosSettings object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'force': 'force',
                            }

    def __init__(self,
                 force=None,
                ):
        """
        :type  force: :class:`bool` or ``None``
        :param force: Apply scaleout even when there are deployments inprogress. Default
            value when not specified in API or module is interpreted by ALB
            Controller as true.
        """
        self.force = force
        VapiStruct.__init__(self)


ALBAutoScaleMesosSettings._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auto_scale_mesos_settings', {
        'force': type.OptionalType(type.BooleanType()),
    },
    ALBAutoScaleMesosSettings,
    False,
    None))



class ALBAutoScaleOpenStackSettings(VapiStruct):
    """
    Advanced load balancer AutoScaleOpenStackSettings object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'heat_scale_down_url': 'heat_scale_down_url',
                            'heat_scale_up_url': 'heat_scale_up_url',
                            }

    def __init__(self,
                 heat_scale_down_url=None,
                 heat_scale_up_url=None,
                ):
        """
        :type  heat_scale_down_url: :class:`str` or ``None``
        :param heat_scale_down_url: Avi Controller will use this URL to scale downthe pool. Cloud
            connector will automatically update the membership. This is an
            alpha feature.
        :type  heat_scale_up_url: :class:`str` or ``None``
        :param heat_scale_up_url: Avi Controller will use this URL to scale upthe pool. Cloud
            connector will automatically update the membership. This is an
            alpha feature.
        """
        self.heat_scale_down_url = heat_scale_down_url
        self.heat_scale_up_url = heat_scale_up_url
        VapiStruct.__init__(self)


ALBAutoScaleOpenStackSettings._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_auto_scale_open_stack_settings', {
        'heat_scale_down_url': type.OptionalType(type.StringType()),
        'heat_scale_up_url': type.OptionalType(type.StringType()),
    },
    ALBAutoScaleOpenStackSettings,
    False,
    None))



class ALBCRL(VapiStruct):
    """
    Advanced load balancer CRL object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'body': 'body',
                            'common_name': 'common_name',
                            'distinguished_name': 'distinguished_name',
                            'etag': 'etag',
                            'fingerprint': 'fingerprint',
                            'last_refreshed': 'last_refreshed',
                            'last_update': 'last_update',
                            'next_update': 'next_update',
                            'server_url': 'server_url',
                            'text': 'text',
                            'update_interval': 'update_interval',
                            }

    def __init__(self,
                 body=None,
                 common_name=None,
                 distinguished_name=None,
                 etag=None,
                 fingerprint=None,
                 last_refreshed=None,
                 last_update=None,
                 next_update=None,
                 server_url=None,
                 text=None,
                 update_interval=None,
                ):
        """
        :type  body: :class:`str` or ``None``
        :param body: Certificate Revocation list from a given issuer in PEM format. This
            can either be configured directly or via the server_url.
        :type  common_name: :class:`str` or ``None``
        :param common_name: Common name of the issuer in the Certificate Revocation list.
        :type  distinguished_name: :class:`str` or ``None``
        :param distinguished_name: Distinguished name of the issuer in the Certificate Revocation
            list.
        :type  etag: :class:`str` or ``None``
        :param etag: Cached etag to optimize the download of the CRL.
        :type  fingerprint: :class:`str` or ``None``
        :param fingerprint: Fingerprint of the CRL. Used to avoid configuring duplicates.
        :type  last_refreshed: :class:`str` or ``None``
        :param last_refreshed: Last time CRL was refreshed by the system. This is an internal
            field used by the system.
        :type  last_update: :class:`str` or ``None``
        :param last_update: The date when this CRL was last issued.
        :type  next_update: :class:`str` or ``None``
        :param next_update: The date when a newer CRL will be available. Also conveys the date
            after which the CRL should be considered obsolete.
        :type  server_url: :class:`str` or ``None``
        :param server_url: URL of a server that issues the Certificate Revocation list. If
            this is configured, CRL will be periodically downloaded either
            based on the configured update interval or the next update interval
            in the CRL. CRL itself is stored in the body.
        :type  text: :class:`str` or ``None``
        :param text: Certificate Revocation list in plain text for readability.
        :type  update_interval: :class:`long` or ``None``
        :param update_interval: Interval in minutes to check for CRL update. If not specified,
            interval will be 1 day. Allowed values are 30-525600. Unit is MIN.
            format: int64
        """
        self.body = body
        self.common_name = common_name
        self.distinguished_name = distinguished_name
        self.etag = etag
        self.fingerprint = fingerprint
        self.last_refreshed = last_refreshed
        self.last_update = last_update
        self.next_update = next_update
        self.server_url = server_url
        self.text = text
        self.update_interval = update_interval
        VapiStruct.__init__(self)


ALBCRL._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBCRL', {
        'body': type.OptionalType(type.StringType()),
        'common_name': type.OptionalType(type.StringType()),
        'distinguished_name': type.OptionalType(type.StringType()),
        'etag': type.OptionalType(type.StringType()),
        'fingerprint': type.OptionalType(type.StringType()),
        'last_refreshed': type.OptionalType(type.StringType()),
        'last_update': type.OptionalType(type.StringType()),
        'next_update': type.OptionalType(type.StringType()),
        'server_url': type.OptionalType(type.StringType()),
        'text': type.OptionalType(type.StringType()),
        'update_interval': type.OptionalType(type.IntegerType()),
    },
    ALBCRL,
    False,
    None))



class ALBCertificateAuthority(VapiStruct):
    """
    Advanced load balancer CertificateAuthority object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ca_path': 'ca_path',
                            'name': 'name',
                            }

    def __init__(self,
                 ca_path=None,
                 name=None,
                ):
        """
        :type  ca_path: :class:`str` or ``None``
        :param ca_path: It is a reference to an object of type SSLKeyAndCertificate.
        :type  name: :class:`str` or ``None``
        :param name: Name of the object.
        """
        self.ca_path = ca_path
        self.name = name
        VapiStruct.__init__(self)


ALBCertificateAuthority._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_certificate_authority', {
        'ca_path': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    ALBCertificateAuthority,
    False,
    None))



class ALBCertificateManagementProfile(VapiStruct):
    """
    Advanced load balancer CertificateManagementProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'markers': 'markers',
                            'script_params': 'script_params',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 markers=None,
                 script_params=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  script_params: :class:`list` of :class:`ALBCustomParams` or ``None``
        :param script_params: Placeholder for description of property script_params of obj type
            CertificateManagementProfile field type str type array.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.markers = markers
        self.script_params = script_params
        VapiStruct.__init__(self)


ALBCertificateManagementProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_certificate_management_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'script_params': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBCustomParams'))),
    },
    ALBCertificateManagementProfile,
    False,
    None))



class ALBClientInsightsSampling(VapiStruct):
    """
    Advanced load balancer ClientInsightsSampling object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_ip': 'client_ip',
                            'sample_uris': 'sample_uris',
                            'skip_uris': 'skip_uris',
                            }

    def __init__(self,
                 client_ip=None,
                 sample_uris=None,
                 skip_uris=None,
                ):
        """
        :type  client_ip: :class:`ALBIpAddrMatch` or ``None``
        :param client_ip: 
        :type  sample_uris: :class:`ALBStringMatch` or ``None``
        :param sample_uris: 
        :type  skip_uris: :class:`ALBStringMatch` or ``None``
        :param skip_uris: 
        """
        self.client_ip = client_ip
        self.sample_uris = sample_uris
        self.skip_uris = skip_uris
        VapiStruct.__init__(self)


ALBClientInsightsSampling._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_client_insights_sampling', {
        'client_ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrMatch')),
        'sample_uris': type.OptionalType(type.ReferenceType(__name__, 'ALBStringMatch')),
        'skip_uris': type.OptionalType(type.ReferenceType(__name__, 'ALBStringMatch')),
    },
    ALBClientInsightsSampling,
    False,
    None))



class ALBClientLogConfiguration(VapiStruct):
    """
    Advanced load balancer ClientLogConfiguration object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FILTERED_LOG_PROCESSING_NONE = "LOGS_PROCESSING_NONE"
    """


    """
    FILTERED_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND = "LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND"
    """


    """
    FILTERED_LOG_PROCESSING_AUTO_SYNC_AND_INDEX = "LOGS_PROCESSING_AUTO_SYNC_AND_INDEX"
    """


    """
    FILTERED_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND = "LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND"
    """


    """
    NON_SIGNIFICANT_LOG_PROCESSING_NONE = "LOGS_PROCESSING_NONE"
    """


    """
    NON_SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND = "LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND"
    """


    """
    NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX = "LOGS_PROCESSING_AUTO_SYNC_AND_INDEX"
    """


    """
    NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND = "LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND"
    """


    """
    SIGNIFICANT_LOG_PROCESSING_NONE = "LOGS_PROCESSING_NONE"
    """


    """
    SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND = "LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND"
    """


    """
    SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX = "LOGS_PROCESSING_AUTO_SYNC_AND_INDEX"
    """


    """
    SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND = "LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND"
    """


    """



    _canonical_to_pep_names = {
                            'enable_significant_log_collection': 'enable_significant_log_collection',
                            'filtered_log_processing': 'filtered_log_processing',
                            'non_significant_log_processing': 'non_significant_log_processing',
                            'significant_log_processing': 'significant_log_processing',
                            }

    def __init__(self,
                 enable_significant_log_collection=None,
                 filtered_log_processing=None,
                 non_significant_log_processing=None,
                 significant_log_processing=None,
                ):
        """
        :type  enable_significant_log_collection: :class:`bool` or ``None``
        :param enable_significant_log_collection: Enable significant log collection. By default, this flag is
            enabled, which means that Avi SEs collect significant logs and
            forward them to Controller for further processing. For example,
            these logs correspond to error conditions such as when the response
            code for a request is 500. Users can deactivate this flag to turn
            off default significant log collection. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Special default for Basic edition is false,
            Essentials edition is false, Enterprise is True. Default value when
            not specified in API or module is interpreted by ALB Controller as
            false.
        :type  filtered_log_processing: :class:`str` or ``None``
        :param filtered_log_processing: Possible values are: 
            
            * :attr:`ALBClientLogConfiguration.FILTERED_LOG_PROCESSING_NONE`
            *
              :attr:`ALBClientLogConfiguration.FILTERED_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND`
            *
              :attr:`ALBClientLogConfiguration.FILTERED_LOG_PROCESSING_AUTO_SYNC_AND_INDEX`
            *
              :attr:`ALBClientLogConfiguration.FILTERED_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND`
            
            Filtered logs are logs that match any client log filters or rules
            with logging enabled. Such logs are processed by the Logs Analytics
            system according to this setting. Enum options -
            LOGS_PROCESSING_NONE, LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND,
            LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
            LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when
            not specified in API or module is interpreted by ALB Controller as
            LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
        :type  non_significant_log_processing: :class:`str` or ``None``
        :param non_significant_log_processing: Possible values are: 
            
            *
              :attr:`ALBClientLogConfiguration.NON_SIGNIFICANT_LOG_PROCESSING_NONE`
            *
              :attr:`ALBClientLogConfiguration.NON_SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND`
            *
              :attr:`ALBClientLogConfiguration.NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX`
            *
              :attr:`ALBClientLogConfiguration.NON_SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND`
            
            Logs that are neither significant nor filtered, are processed by
            the Logs Analytics system according to this setting. Enum options -
            LOGS_PROCESSING_NONE, LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND,
            LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
            LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when
            not specified in API or module is interpreted by ALB Controller as
            LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
        :type  significant_log_processing: :class:`str` or ``None``
        :param significant_log_processing: Possible values are: 
            
            * :attr:`ALBClientLogConfiguration.SIGNIFICANT_LOG_PROCESSING_NONE`
            *
              :attr:`ALBClientLogConfiguration.SIGNIFICANT_LOG_PROCESSING_SYNC_AND_INDEX_ON_DEMAND`
            *
              :attr:`ALBClientLogConfiguration.SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_AND_INDEX`
            *
              :attr:`ALBClientLogConfiguration.SIGNIFICANT_LOG_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND`
            
            Significant logs are processed by the Logs Analytics system
            according to this setting. Enum options - LOGS_PROCESSING_NONE,
            LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND,
            LOGS_PROCESSING_AUTO_SYNC_AND_INDEX,
            LOGS_PROCESSING_AUTO_SYNC_BUT_INDEX_ON_DEMAND. Default value when
            not specified in API or module is interpreted by ALB Controller as
            LOGS_PROCESSING_SYNC_AND_INDEX_ON_DEMAND.
        """
        self.enable_significant_log_collection = enable_significant_log_collection
        self.filtered_log_processing = filtered_log_processing
        self.non_significant_log_processing = non_significant_log_processing
        self.significant_log_processing = significant_log_processing
        VapiStruct.__init__(self)


ALBClientLogConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_client_log_configuration', {
        'enable_significant_log_collection': type.OptionalType(type.BooleanType()),
        'filtered_log_processing': type.OptionalType(type.StringType()),
        'non_significant_log_processing': type.OptionalType(type.StringType()),
        'significant_log_processing': type.OptionalType(type.StringType()),
    },
    ALBClientLogConfiguration,
    False,
    None))



class ALBClientLogFilter(VapiStruct):
    """
    Advanced load balancer ClientLogFilter object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'all_headers': 'all_headers',
                            'client_ip': 'client_ip',
                            'duration': 'duration',
                            'enabled': 'enabled',
                            'index': 'index',
                            'name': 'name',
                            'uri': 'uri',
                            }

    def __init__(self,
                 all_headers=None,
                 client_ip=None,
                 duration=None,
                 enabled=None,
                 index=None,
                 name=None,
                 uri=None,
                ):
        """
        :type  all_headers: :class:`bool` or ``None``
        :param all_headers: Placeholder for description of property all_headers of obj type
            ClientLogFilter field type str type boolean. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  client_ip: :class:`ALBIpAddrMatch` or ``None``
        :param client_ip: 
        :type  duration: :class:`long` or ``None``
        :param duration: Special values are 0 - 'infinite'. Unit is MIN. Default value when
            not specified in API or module is interpreted by ALB Controller as
            30. format: int64
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Placeholder for description of property enabled of obj type
            ClientLogFilter field type str type boolean. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  index: :class:`long` or ``None``
        :param index: Number of index. format: int64
        :type  name: :class:`str` or ``None``
        :param name: Name of the object.
        :type  uri: :class:`ALBStringMatch` or ``None``
        :param uri: 
        """
        self.all_headers = all_headers
        self.client_ip = client_ip
        self.duration = duration
        self.enabled = enabled
        self.index = index
        self.name = name
        self.uri = uri
        VapiStruct.__init__(self)


ALBClientLogFilter._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_client_log_filter', {
        'all_headers': type.OptionalType(type.BooleanType()),
        'client_ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrMatch')),
        'duration': type.OptionalType(type.IntegerType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'index': type.OptionalType(type.IntegerType()),
        'name': type.OptionalType(type.StringType()),
        'uri': type.OptionalType(type.ReferenceType(__name__, 'ALBStringMatch')),
    },
    ALBClientLogFilter,
    False,
    None))



class ALBClientLogStreamingConfig(VapiStruct):
    """
    Advanced load balancer ClientLogStreamingConfig object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    LOG_TYPES_TO_SEND_SIGNIFICANT_ONLY = "LOGS_SIGNIFICANT_ONLY"
    """


    """
    LOG_TYPES_TO_SEND_UDF_ONLY = "LOGS_UDF_ONLY"
    """


    """
    LOG_TYPES_TO_SEND_UDF_SIGNIFICANT = "LOGS_UDF_SIGNIFICANT"
    """


    """
    LOG_TYPES_TO_SEND_ALL = "LOGS_ALL"
    """


    """
    PROTOCOL_UDP = "LOG_STREAMING_PROTOCOL_UDP"
    """


    """
    PROTOCOL_SYSLOG_OVER_UDP = "LOG_STREAMING_PROTOCOL_SYSLOG_OVER_UDP"
    """


    """
    PROTOCOL_TCP = "LOG_STREAMING_PROTOCOL_TCP"
    """


    """
    PROTOCOL_SYSLOG_OVER_TCP = "LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TCP"
    """


    """
    PROTOCOL_RAW_OVER_UDP = "LOG_STREAMING_PROTOCOL_RAW_OVER_UDP"
    """


    """
    PROTOCOL_TLS = "LOG_STREAMING_PROTOCOL_TLS"
    """


    """
    PROTOCOL_SYSLOG_OVER_TLS = "LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TLS"
    """


    """



    _canonical_to_pep_names = {
                            'external_server': 'external_server',
                            'external_server_port': 'external_server_port',
                            'format_config': 'format_config',
                            'log_types_to_send': 'log_types_to_send',
                            'max_logs_per_second': 'max_logs_per_second',
                            'protocol': 'protocol',
                            'syslog_config': 'syslog_config',
                            }

    def __init__(self,
                 external_server=None,
                 external_server_port=None,
                 format_config=None,
                 log_types_to_send=None,
                 max_logs_per_second=None,
                 protocol=None,
                 syslog_config=None,
                ):
        """
        :type  external_server: :class:`str` or ``None``
        :param external_server: IP address or hostnames (FQDNs) of destination servers. If an FQDN
            is provided, this should be resolvable on Avi Service Engines.
            Multiple servers are supported by furnishing a comma-separated list
            of IP addresses or host names, for example, 11.11.11.11,23.12.12.4.
            Optionally, a separate port can be specified for each external
            server in the list, for example, 11.11.11.11 234,12.12.12.12 343.
        :type  external_server_port: :class:`long` or ``None``
        :param external_server_port: The service port to use for the external servers. If multiple
            external servers have been specified, the single port number
            specified here will apply to all those servers for which an
            explicit port number has not been specified in the external server
            list. Default value when not specified in API or module is
            interpreted by ALB Controller as 514. format: int64
        :type  format_config: :class:`ALBClientLogStreamingFormat` or ``None``
        :param format_config: 
        :type  log_types_to_send: :class:`str` or ``None``
        :param log_types_to_send: Possible values are: 
            
            *
              :attr:`ALBClientLogStreamingConfig.LOG_TYPES_TO_SEND_SIGNIFICANT_ONLY`
            * :attr:`ALBClientLogStreamingConfig.LOG_TYPES_TO_SEND_UDF_ONLY`
            *
              :attr:`ALBClientLogStreamingConfig.LOG_TYPES_TO_SEND_UDF_SIGNIFICANT`
            * :attr:`ALBClientLogStreamingConfig.LOG_TYPES_TO_SEND_ALL`
            
            Type of logs to stream to the external server. Default is LOGS_ALL,
            i.e., send all logs. Enum options - LOGS_SIGNIFICANT_ONLY,
            LOGS_UDF_ONLY, LOGS_UDF_SIGNIFICANT, LOGS_ALL. Default value when
            not specified in API or module is interpreted by ALB Controller as
            LOGS_ALL.
        :type  max_logs_per_second: :class:`long` or ``None``
        :param max_logs_per_second: Maximum number of logs per second streamed to the remote server. By
            default, 100 logs per second are streamed. Set this to zero(0) to
            not enforce any limit. Default value when not specified in API or
            module is interpreted by ALB Controller as 100. format: int64
        :type  protocol: :class:`str` or ``None``
        :param protocol: Possible values are: 
            
            * :attr:`ALBClientLogStreamingConfig.PROTOCOL_UDP`
            * :attr:`ALBClientLogStreamingConfig.PROTOCOL_SYSLOG_OVER_UDP`
            * :attr:`ALBClientLogStreamingConfig.PROTOCOL_TCP`
            * :attr:`ALBClientLogStreamingConfig.PROTOCOL_SYSLOG_OVER_TCP`
            * :attr:`ALBClientLogStreamingConfig.PROTOCOL_RAW_OVER_UDP`
            * :attr:`ALBClientLogStreamingConfig.PROTOCOL_TLS`
            * :attr:`ALBClientLogStreamingConfig.PROTOCOL_SYSLOG_OVER_TLS`
            
            Protocol to use for streaming logs. Enum options -
            LOG_STREAMING_PROTOCOL_UDP, LOG_STREAMING_PROTOCOL_SYSLOG_OVER_UDP,
            LOG_STREAMING_PROTOCOL_TCP, LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TCP,
            LOG_STREAMING_PROTOCOL_RAW_OVER_UDP, LOG_STREAMING_PROTOCOL_TLS,
            LOG_STREAMING_PROTOCOL_SYSLOG_OVER_TLS. Default value when not
            specified in API or module is interpreted by ALB Controller as
            LOG_STREAMING_PROTOCOL_UDP.
        :type  syslog_config: :class:`ALBStreamingSyslogConfig` or ``None``
        :param syslog_config: 
        """
        self.external_server = external_server
        self.external_server_port = external_server_port
        self.format_config = format_config
        self.log_types_to_send = log_types_to_send
        self.max_logs_per_second = max_logs_per_second
        self.protocol = protocol
        self.syslog_config = syslog_config
        VapiStruct.__init__(self)


ALBClientLogStreamingConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_client_log_streaming_config', {
        'external_server': type.OptionalType(type.StringType()),
        'external_server_port': type.OptionalType(type.IntegerType()),
        'format_config': type.OptionalType(type.ReferenceType(__name__, 'ALBClientLogStreamingFormat')),
        'log_types_to_send': type.OptionalType(type.StringType()),
        'max_logs_per_second': type.OptionalType(type.IntegerType()),
        'protocol': type.OptionalType(type.StringType()),
        'syslog_config': type.OptionalType(type.ReferenceType(__name__, 'ALBStreamingSyslogConfig')),
    },
    ALBClientLogStreamingConfig,
    False,
    None))



class ALBClientLogStreamingFormat(VapiStruct):
    """
    Advanced load balancer ClientLogStreamingFormat object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FORMAT_FULL = "LOG_STREAMING_FORMAT_JSON_FULL"
    """


    """
    FORMAT_SELECTED = "LOG_STREAMING_FORMAT_JSON_SELECTED"
    """


    """



    _canonical_to_pep_names = {
                            'format': 'format',
                            'included_fields': 'included_fields',
                            }

    def __init__(self,
                 format=None,
                 included_fields=None,
                ):
        """
        :type  format: :class:`str` or ``None``
        :param format: Possible values are: 
            
            * :attr:`ALBClientLogStreamingFormat.FORMAT_FULL`
            * :attr:`ALBClientLogStreamingFormat.FORMAT_SELECTED`
            
            Format for the streamed logs. Enum options -
            LOG_STREAMING_FORMAT_JSON_FULL, LOG_STREAMING_FORMAT_JSON_SELECTED.
        :type  included_fields: :class:`list` of :class:`str` or ``None``
        :param included_fields: List of log fields to be streamed, when selective fields
            (LOG_STREAMING_FORMAT_JSON_SELECTED) option is chosen. Only
            top-level fields in application or connection logs are supported.
        """
        self.format = format
        self.included_fields = included_fields
        VapiStruct.__init__(self)


ALBClientLogStreamingFormat._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_client_log_streaming_format', {
        'format': type.OptionalType(type.StringType()),
        'included_fields': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBClientLogStreamingFormat,
    False,
    None))



class ALBCloneServer(VapiStruct):
    """
    Advanced load balancer CloneServer object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ip_address': 'ip_address',
                            'mac': 'mac',
                            'network_name': 'network_name',
                            'subnet': 'subnet',
                            }

    def __init__(self,
                 ip_address=None,
                 mac=None,
                 network_name=None,
                 subnet=None,
                ):
        """
        :type  ip_address: :class:`ALBIpAddr` or ``None``
        :param ip_address: 
        :type  mac: :class:`str` or ``None``
        :param mac: MAC Address of the Clone Server.
        :type  network_name: :class:`str` or ``None``
        :param network_name: Network to clone the traffic to. It is a reference to an object of
            type Network.
        :type  subnet: :class:`ALBIpAddrPrefix` or ``None``
        :param subnet: 
        """
        self.ip_address = ip_address
        self.mac = mac
        self.network_name = network_name
        self.subnet = subnet
        VapiStruct.__init__(self)


ALBCloneServer._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_clone_server', {
        'ip_address': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
        'mac': type.OptionalType(type.StringType()),
        'network_name': type.OptionalType(type.StringType()),
        'subnet': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrPrefix')),
    },
    ALBCloneServer,
    False,
    None))



class ALBCompressionFilter(VapiStruct):
    """
    Advanced load balancer CompressionFilter object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    LEVEL_AGGRESSIVE_COMPRESSION = "AGGRESSIVE_COMPRESSION"
    """


    """
    LEVEL_NORMAL_COMPRESSION = "NORMAL_COMPRESSION"
    """


    """
    LEVEL_NO_COMPRESSION = "NO_COMPRESSION"
    """


    """
    MATCH_IN = "IS_IN"
    """


    """
    MATCH_NOT_IN = "IS_NOT_IN"
    """


    """



    _canonical_to_pep_names = {
                            'devices_path': 'devices_path',
                            'index': 'index',
                            'ip_addr_prefixes': 'ip_addr_prefixes',
                            'ip_addr_ranges': 'ip_addr_ranges',
                            'ip_addrs': 'ip_addrs',
                            'ip_addrs_path': 'ip_addrs_path',
                            'level': 'level',
                            'match': 'match',
                            'name': 'name',
                            'user_agent': 'user_agent',
                            }

    def __init__(self,
                 devices_path=None,
                 index=None,
                 ip_addr_prefixes=None,
                 ip_addr_ranges=None,
                 ip_addrs=None,
                 ip_addrs_path=None,
                 level=None,
                 match=None,
                 name=None,
                 user_agent=None,
                ):
        """
        :type  devices_path: :class:`str` or ``None``
        :param devices_path: It is a reference to an object of type StringGroup.
        :type  index: :class:`long` or ``None``
        :param index: Number of index. format: int64
        :type  ip_addr_prefixes: :class:`list` of :class:`ALBIpAddrPrefix` or ``None``
        :param ip_addr_prefixes: Placeholder for description of property ip_addr_prefixes of obj
            type CompressionFilter field type str type array.
        :type  ip_addr_ranges: :class:`list` of :class:`ALBIpAddrRange` or ``None``
        :param ip_addr_ranges: Placeholder for description of property ip_addr_ranges of obj type
            CompressionFilter field type str type array.
        :type  ip_addrs: :class:`list` of :class:`ALBIpAddr` or ``None``
        :param ip_addrs: Placeholder for description of property ip_addrs of obj type
            CompressionFilter field type str type array.
        :type  ip_addrs_path: :class:`str` or ``None``
        :param ip_addrs_path: It is a reference to an object of type IpAddrGroup.
        :type  level: :class:`str` or ``None``
        :param level: Possible values are: 
            
            * :attr:`ALBCompressionFilter.LEVEL_AGGRESSIVE_COMPRESSION`
            * :attr:`ALBCompressionFilter.LEVEL_NORMAL_COMPRESSION`
            * :attr:`ALBCompressionFilter.LEVEL_NO_COMPRESSION`
            
            Enum options - AGGRESSIVE_COMPRESSION, NORMAL_COMPRESSION,
            NO_COMPRESSION. Default value when not specified in API or module
            is interpreted by ALB Controller as NORMAL_COMPRESSION.
        :type  match: :class:`str` or ``None``
        :param match: Possible values are: 
            
            * :attr:`ALBCompressionFilter.MATCH_IN`
            * :attr:`ALBCompressionFilter.MATCH_NOT_IN`
            
            Whether to apply Filter when group criteria is matched or not. Enum
            options - IS_IN, IS_NOT_IN. Default value when not specified in API
            or module is interpreted by ALB Controller as IS_IN.
        :type  name: :class:`str` or ``None``
        :param name: Name of the object.
        :type  user_agent: :class:`list` of :class:`str` or ``None``
        :param user_agent: Placeholder for description of property user_agent of obj type
            CompressionFilter field type str type array.
        """
        self.devices_path = devices_path
        self.index = index
        self.ip_addr_prefixes = ip_addr_prefixes
        self.ip_addr_ranges = ip_addr_ranges
        self.ip_addrs = ip_addrs
        self.ip_addrs_path = ip_addrs_path
        self.level = level
        self.match = match
        self.name = name
        self.user_agent = user_agent
        VapiStruct.__init__(self)


ALBCompressionFilter._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_compression_filter', {
        'devices_path': type.OptionalType(type.StringType()),
        'index': type.OptionalType(type.IntegerType()),
        'ip_addr_prefixes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrPrefix'))),
        'ip_addr_ranges': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrRange'))),
        'ip_addrs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddr'))),
        'ip_addrs_path': type.OptionalType(type.StringType()),
        'level': type.OptionalType(type.StringType()),
        'match': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'user_agent': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBCompressionFilter,
    False,
    None))



class ALBCompressionProfile(VapiStruct):
    """
    Advanced load balancer CompressionProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_AUTO_COMPRESSION = "AUTO_COMPRESSION"
    """


    """
    TYPE_CUSTOM_COMPRESSION = "CUSTOM_COMPRESSION"
    """


    """



    _canonical_to_pep_names = {
                            'compressible_content_path': 'compressible_content_path',
                            'compression': 'compression',
                            'filter': 'filter',
                            'remove_accept_encoding_header': 'remove_accept_encoding_header',
                            'type': 'type',
                            }

    def __init__(self,
                 compressible_content_path=None,
                 compression=None,
                 filter=None,
                 remove_accept_encoding_header=None,
                 type=None,
                ):
        """
        :type  compressible_content_path: :class:`str` or ``None``
        :param compressible_content_path: Compress only content types listed in this string group. Content
            types not present in this list are not compressed. It is a
            reference to an object of type StringGroup.
        :type  compression: :class:`bool` or ``None``
        :param compression: Compress HTTP response content if it wasn't already compressed.
            Default value when not specified in API or module is interpreted by
            ALB Controller as false.
        :type  filter: :class:`list` of :class:`ALBCompressionFilter` or ``None``
        :param filter: Custom filters used when auto compression is not selected.
        :type  remove_accept_encoding_header: :class:`bool` or ``None``
        :param remove_accept_encoding_header: Offload compression from the servers to AVI. Saves compute cycles
            on the servers. Default value when not specified in API or module
            is interpreted by ALB Controller as true.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBCompressionProfile.TYPE_AUTO_COMPRESSION`
            * :attr:`ALBCompressionProfile.TYPE_CUSTOM_COMPRESSION`
            
            Compress content automatically or add custom filters to define
            compressible content and compression levels. Enum options -
            AUTO_COMPRESSION, CUSTOM_COMPRESSION. Default value when not
            specified in API or module is interpreted by ALB Controller as
            AUTO_COMPRESSION.
        """
        self.compressible_content_path = compressible_content_path
        self.compression = compression
        self.filter = filter
        self.remove_accept_encoding_header = remove_accept_encoding_header
        self.type = type
        VapiStruct.__init__(self)


ALBCompressionProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_compression_profile', {
        'compressible_content_path': type.OptionalType(type.StringType()),
        'compression': type.OptionalType(type.BooleanType()),
        'filter': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBCompressionFilter'))),
        'remove_accept_encoding_header': type.OptionalType(type.BooleanType()),
        'type': type.OptionalType(type.StringType()),
    },
    ALBCompressionProfile,
    False,
    None))



class ALBConnPoolProperties(VapiStruct):
    """
    Advanced load balancer ConnPoolProperties object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'upstream_connpool_conn_idle_tmo': 'upstream_connpool_conn_idle_tmo',
                            'upstream_connpool_conn_life_tmo': 'upstream_connpool_conn_life_tmo',
                            'upstream_connpool_conn_max_reuse': 'upstream_connpool_conn_max_reuse',
                            'upstream_connpool_server_max_cache': 'upstream_connpool_server_max_cache',
                            }

    def __init__(self,
                 upstream_connpool_conn_idle_tmo=None,
                 upstream_connpool_conn_life_tmo=None,
                 upstream_connpool_conn_max_reuse=None,
                 upstream_connpool_server_max_cache=None,
                ):
        """
        :type  upstream_connpool_conn_idle_tmo: :class:`long` or ``None``
        :param upstream_connpool_conn_idle_tmo: Connection idle timeout. Allowed in Basic(Allowed values- 60000)
            edition, Essentials(Allowed values- 60000) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 60000. format: int64
        :type  upstream_connpool_conn_life_tmo: :class:`long` or ``None``
        :param upstream_connpool_conn_life_tmo: Connection life timeout. Allowed in Basic(Allowed values- 600000)
            edition, Essentials(Allowed values- 600000) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 600000. format: int64
        :type  upstream_connpool_conn_max_reuse: :class:`long` or ``None``
        :param upstream_connpool_conn_max_reuse: Maximum number of times a connection can be reused. Special values
            are 0- 'unlimited'. Allowed in Basic(Allowed values- 0) edition,
            Essentials(Allowed values- 0) edition, Enterprise edition. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 0. format: int64
        :type  upstream_connpool_server_max_cache: :class:`long` or ``None``
        :param upstream_connpool_server_max_cache: Maximum number of connections a server can cache. Special values
            are 0- 'unlimited'. Default value when not specified in API or
            module is interpreted by ALB Controller as 0. format: int64
        """
        self.upstream_connpool_conn_idle_tmo = upstream_connpool_conn_idle_tmo
        self.upstream_connpool_conn_life_tmo = upstream_connpool_conn_life_tmo
        self.upstream_connpool_conn_max_reuse = upstream_connpool_conn_max_reuse
        self.upstream_connpool_server_max_cache = upstream_connpool_server_max_cache
        VapiStruct.__init__(self)


ALBConnPoolProperties._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_conn_pool_properties', {
        'upstream_connpool_conn_idle_tmo': type.OptionalType(type.IntegerType()),
        'upstream_connpool_conn_life_tmo': type.OptionalType(type.IntegerType()),
        'upstream_connpool_conn_max_reuse': type.OptionalType(type.IntegerType()),
        'upstream_connpool_server_max_cache': type.OptionalType(type.IntegerType()),
    },
    ALBConnPoolProperties,
    False,
    None))



class ALBContentRewriteProfile(VapiStruct):
    """
    Advanced load balancer ContentRewriteProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'response_rewrite_enabled': 'response_rewrite_enabled',
                            'rewritable_content_path': 'rewritable_content_path',
                            'rsp_match_replace_pair': 'rsp_match_replace_pair',
                            }

    def __init__(self,
                 response_rewrite_enabled=None,
                 rewritable_content_path=None,
                 rsp_match_replace_pair=None,
                ):
        """
        :type  response_rewrite_enabled: :class:`bool` or ``None``
        :param response_rewrite_enabled: Enable rewrite on response body. Default value when not specified
            in API or module is interpreted by ALB Controller as false.
        :type  rewritable_content_path: :class:`str` or ``None``
        :param rewritable_content_path: Rewrite only content types listed in this string group. Content
            types not present in this list are not rewritten. It is a reference
            to an object of type StringGroup.
        :type  rsp_match_replace_pair: :class:`list` of :class:`ALBMatchReplacePair` or ``None``
        :param rsp_match_replace_pair: Strings to be matched and replaced with on the response body. This
            should be configured when response_rewrite_enabled is set to true.
        """
        self.response_rewrite_enabled = response_rewrite_enabled
        self.rewritable_content_path = rewritable_content_path
        self.rsp_match_replace_pair = rsp_match_replace_pair
        VapiStruct.__init__(self)


ALBContentRewriteProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_content_rewrite_profile', {
        'response_rewrite_enabled': type.OptionalType(type.BooleanType()),
        'rewritable_content_path': type.OptionalType(type.StringType()),
        'rsp_match_replace_pair': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBMatchReplacePair'))),
    },
    ALBContentRewriteProfile,
    False,
    None))



class ALBControllerClusterInfo(VapiStruct):
    """
    Advanced Load Balancer controller cluster information about nodes in the
    cluster and cluster information.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cluster_name': 'cluster_name',
                            'cluster_state': 'cluster_state',
                            'cluster_uuid': 'cluster_uuid',
                            'error': 'error',
                            'nodes': 'nodes',
                            'reason': 'reason',
                            'version': 'version',
                            'virtual_ip': 'virtual_ip',
                            }

    def __init__(self,
                 cluster_name=None,
                 cluster_state=None,
                 cluster_uuid=None,
                 error=None,
                 nodes=None,
                 reason=None,
                 version=None,
                 virtual_ip=None,
                ):
        """
        :type  cluster_name: :class:`str` or ``None``
        :param cluster_name: Advanced Load Balancer controller cluster name.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cluster_state: :class:`str` or ``None``
        :param cluster_state: Advanced Load Balancer controller cluster state.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cluster_uuid: :class:`str` or ``None``
        :param cluster_uuid: ID of the Cluster maintained internally. Note: This is
            automatically generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  error: :class:`AlbControllerClusterRuntimeError` or ``None``
        :param error: 
        :type  nodes: :class:`list` of :class:`ALBControllerNodeInfo` or ``None``
        :param nodes: Advanced Load Balancer controller node information
        :type  reason: :class:`str` or ``None``
        :param reason: Advanced Load Balancer cluster state not STABLE reason.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  version: :class:`str` or ``None``
        :param version: Advanced Load Balancer controller cluster version.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  virtual_ip: :class:`str` or ``None``
        :param virtual_ip: Advanced Load Balancer controller cluster virtual_ip. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.cluster_name = cluster_name
        self.cluster_state = cluster_state
        self.cluster_uuid = cluster_uuid
        self.error = error
        self.nodes = nodes
        self.reason = reason
        self.version = version
        self.virtual_ip = virtual_ip
        VapiStruct.__init__(self)


ALBControllerClusterInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_cluster_info', {
        'cluster_name': type.OptionalType(type.StringType()),
        'cluster_state': type.OptionalType(type.StringType()),
        'cluster_uuid': type.OptionalType(type.StringType()),
        'error': type.OptionalType(type.ReferenceType(__name__, 'AlbControllerClusterRuntimeError')),
        'nodes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBControllerNodeInfo'))),
        'reason': type.OptionalType(type.StringType()),
        'version': type.OptionalType(type.StringType()),
        'virtual_ip': type.OptionalType(type.StringType()),
    },
    ALBControllerClusterInfo,
    False,
    None))



class ALBControllerClusterTrigger(VapiStruct):
    """
    Advanced Load Balancer controller node clustering trigger response.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'status': 'status',
                            }

    def __init__(self,
                 status=None,
                ):
        """
        :type  status: :class:`str` or ``None``
        :param status: Advanced Load Balancer controller node clustering trigger status.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.status = status
        VapiStruct.__init__(self)


ALBControllerClusterTrigger._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_cluster_trigger', {
        'status': type.OptionalType(type.StringType()),
    },
    ALBControllerClusterTrigger,
    False,
    None))



class ALBControllerConfiguration(VapiStruct):
    """
    Alb Controller config details

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OWNED_BY_LCM = "LCM"
    """


    """
    OWNED_BY_VCF = "VCF"
    """


    """



    _canonical_to_pep_names = {
                            'cluster_ip': 'cluster_ip',
                            'dns_servers': 'dns_servers',
                            'infra_admin_password': 'infra_admin_password',
                            'infra_admin_username': 'infra_admin_username',
                            'ntp_servers': 'ntp_servers',
                            'owned_by': 'owned_by',
                            }

    def __init__(self,
                 cluster_ip=None,
                 dns_servers=None,
                 infra_admin_password=None,
                 infra_admin_username=None,
                 ntp_servers=None,
                 owned_by=None,
                ):
        """
        :type  cluster_ip: :class:`str` or ``None``
        :param cluster_ip: The cluster IP of the Advanced Load Balancer controller node
            cluster. This is mandatory parameter and required for single node
            controller deployments as well. format: ip
        :type  dns_servers: :class:`list` of :class:`str` or ``None``
        :param dns_servers: List of DNS servers. format: ipv4
        :type  infra_admin_password: :class:`str` or ``None``
        :param infra_admin_password: Password for the controller node admin user. For deployment, this
            property is required. The password specified must be at least 8
            characters in length.
        :type  infra_admin_username: :class:`str` or ``None``
        :param infra_admin_username: Username for server authentication.
        :type  ntp_servers: :class:`list` of :class:`str` or ``None``
        :param ntp_servers: List of NTP servers. format: hostname-or-ipv4
        :type  owned_by: :class:`str` or ``None``
        :param owned_by: Possible values are: 
            
            * :attr:`ALBControllerConfiguration.OWNED_BY_LCM`
            * :attr:`ALBControllerConfiguration.OWNED_BY_VCF`
            
             The policy initiates workflow by LCM/VCF
        """
        self.cluster_ip = cluster_ip
        self.dns_servers = dns_servers
        self.infra_admin_password = infra_admin_password
        self.infra_admin_username = infra_admin_username
        self.ntp_servers = ntp_servers
        self.owned_by = owned_by
        VapiStruct.__init__(self)


ALBControllerConfiguration._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_configuration', {
        'cluster_ip': type.OptionalType(type.StringType()),
        'dns_servers': type.OptionalType(type.ListType(type.StringType())),
        'infra_admin_password': type.OptionalType(type.StringType()),
        'infra_admin_username': type.OptionalType(type.StringType()),
        'ntp_servers': type.OptionalType(type.ListType(type.StringType())),
        'owned_by': type.OptionalType(type.StringType()),
    },
    ALBControllerConfiguration,
    False,
    None))



class ALBControllerNodeFormFactor(VapiStruct):
    """
    Advanced Load Balancer node form factor.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_SMALL = "SMALL"
    """


    """
    TYPE_MEDIUM = "MEDIUM"
    """


    """
    TYPE_LARGE = "LARGE"
    """


    """



    _canonical_to_pep_names = {
                            'disk': 'disk',
                            'memory': 'memory',
                            'type': 'type',
                            'vcpu': 'vcpu',
                            }

    def __init__(self,
                 disk=None,
                 memory=None,
                 type=None,
                 vcpu=None,
                ):
        """
        :type  disk: :class:`long` or ``None``
        :param disk: Disk size of the Advanced Load Balancer controller node in Bytes.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  memory: :class:`long` or ``None``
        :param memory: Memory size of the Advanced Load Balancer controller node in Bytes.
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBControllerNodeFormFactor.TYPE_SMALL`
            * :attr:`ALBControllerNodeFormFactor.TYPE_MEDIUM`
            * :attr:`ALBControllerNodeFormFactor.TYPE_LARGE`
            
             Advanced Load Balancer controller node form factor type.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  vcpu: :class:`long` or ``None``
        :param vcpu: Number of virtual cpus on the Advanced Load Balancer controller
            node. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.disk = disk
        self.memory = memory
        self.type = type
        self.vcpu = vcpu
        VapiStruct.__init__(self)


ALBControllerNodeFormFactor._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_form_factor', {
        'disk': type.OptionalType(type.IntegerType()),
        'memory': type.OptionalType(type.IntegerType()),
        'type': type.OptionalType(type.StringType()),
        'vcpu': type.OptionalType(type.IntegerType()),
    },
    ALBControllerNodeFormFactor,
    False,
    None))



class ALBControllerNodeFormFactors(VapiStruct):
    """
    Advanced Load Balancer controller form factors list result

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'form_factors': 'form_factors',
                            }

    def __init__(self,
                 form_factors=None,
                ):
        """
        :type  form_factors: :class:`list` of :class:`ALBControllerNodeFormFactor` or ``None``
        :param form_factors: Advanced Load Balancer controller form factor list
        """
        self.form_factors = form_factors
        VapiStruct.__init__(self)


ALBControllerNodeFormFactors._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_form_factors', {
        'form_factors': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBControllerNodeFormFactor'))),
    },
    ALBControllerNodeFormFactors,
    False,
    None))



class ALBControllerNodeInfo(VapiStruct):
    """
    Advanced Load Balancer controller node information like node IP and node
    name.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'is_dhcp': 'is_dhcp',
                            'node_ip': 'node_ip',
                            'node_name': 'node_name',
                            'node_role': 'node_role',
                            'node_start_time': 'node_start_time',
                            'node_state': 'node_state',
                            'vm_id': 'vm_id',
                            }

    def __init__(self,
                 is_dhcp=None,
                 node_ip=None,
                 node_name=None,
                 node_role=None,
                 node_start_time=None,
                 node_state=None,
                 vm_id=None,
                ):
        """
        :type  is_dhcp: :class:`bool` or ``None``
        :param is_dhcp: Advanced Load Balancer controller node IP configuration is static
            or DHCP.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_ip: :class:`str` or ``None``
        :param node_ip: Advanced Load Balancer controller node IP. format: ip
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_name: :class:`str` or ``None``
        :param node_name: Advanced Load Balancer controller node name.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_role: :class:`str` or ``None``
        :param node_role: Advanced Load Balancer controller node role in cluster.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_start_time: :class:`long` or ``None``
        :param node_start_time: Advanced Load Balancer controller node start time in its local
            timezone. format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  node_state: :class:`str` or ``None``
        :param node_state: Advanced Load Balancer controller node current state in the
            cluster.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  vm_id: :class:`str` or ``None``
        :param vm_id: ID of the VM maintained internally. Note: This is automatically
            generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.is_dhcp = is_dhcp
        self.node_ip = node_ip
        self.node_name = node_name
        self.node_role = node_role
        self.node_start_time = node_start_time
        self.node_state = node_state
        self.vm_id = vm_id
        VapiStruct.__init__(self)


ALBControllerNodeInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_info', {
        'is_dhcp': type.OptionalType(type.BooleanType()),
        'node_ip': type.OptionalType(type.StringType()),
        'node_name': type.OptionalType(type.StringType()),
        'node_role': type.OptionalType(type.StringType()),
        'node_start_time': type.OptionalType(type.IntegerType()),
        'node_state': type.OptionalType(type.StringType()),
        'vm_id': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeInfo,
    False,
    None))



class ALBControllerNodeUserSettings(VapiStruct):
    """


    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'admin_password': 'admin_password',
                            'admin_ssh_key': 'admin_ssh_key',
                            }

    def __init__(self,
                 admin_password=None,
                 admin_ssh_key=None,
                ):
        """
        :type  admin_password: :class:`str` or ``None``
        :param admin_password: Password for the controller node admin user. For deployment, this
            property is required. The password specified must be at least 8
            characters in length.
        :type  admin_ssh_key: :class:`str` or ``None``
        :param admin_ssh_key: To configure ssh into the Advanced Load Balancer controller, this
            property is required.
        """
        self.admin_password = admin_password
        self.admin_ssh_key = admin_ssh_key
        VapiStruct.__init__(self)


ALBControllerNodeUserSettings._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_user_settings', {
        'admin_password': type.OptionalType(type.StringType()),
        'admin_ssh_key': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeUserSettings,
    False,
    None))



class ALBControllerNodeVMClusterConfig(VapiStruct):
    """
    Contains the cluster configuration for a Advanced Load Balancer controller
    node VM cluster.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'cluster_ip': 'cluster_ip',
                            'cluster_name': 'cluster_name',
                            'cluster_uuid': 'cluster_uuid',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 cluster_ip=None,
                 cluster_name=None,
                 cluster_uuid=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  cluster_ip: :class:`str` or ``None``
        :param cluster_ip: The cluster IP of the Advanced Load Balancer controller node
            cluster. This is mandatory parameter and required for single node
            controller deployments as well. format: ip
        :type  cluster_name: :class:`str` or ``None``
        :param cluster_name: The cluster name of the Advanced Load Balancer controller node
            cluster.
        :type  cluster_uuid: :class:`str` or ``None``
        :param cluster_uuid: ID of the Cluster maintained internally. This is different from
            cluster_uuid internal to Advanced Load Balancer controller. Note:
            This is automatically generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.cluster_ip = cluster_ip
        self.cluster_name = cluster_name
        self.cluster_uuid = cluster_uuid
        VapiStruct.__init__(self)


ALBControllerNodeVMClusterConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_cluster_config', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'cluster_ip': type.OptionalType(type.StringType()),
        'cluster_name': type.OptionalType(type.StringType()),
        'cluster_uuid': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeVMClusterConfig,
    False,
    None))



class ALBControllerNodeVMDeploymentConfig(VapiStruct):
    """
    Contains info used to configure the VM on deployment.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    _TYPE_IDENTIFIER = "ALBControllerNodeVMDeploymentConfig"
    """
    Identifier denoting this class, when it is used in polymorphic context. 

    This value should be assigned to the attribute which is used to discriminate
    the actual type used in the polymorphic context.

    """
    PLACEMENT_TYPE_ALBCONTROLLERVSPHERECLUSTERNODEVMDEPLOYMENTCONFIG = "AlbControllerVsphereClusterNodeVmDeploymentConfig"
    """


    """



    _canonical_to_pep_names = {
                            'placement_type': 'placement_type',
                            }

    def __init__(self,
                 placement_type='ALBControllerNodeVMDeploymentConfig',
                ):
        """
        :type  placement_type: :class:`str`
        :param placement_type: Possible values are: 
            
            *
              :attr:`ALBControllerNodeVMDeploymentConfig.PLACEMENT_TYPE_ALBCONTROLLERVSPHERECLUSTERNODEVMDEPLOYMENTCONFIG`
            
            Specifies the config for the platform through which to deploy the
            VM.
        """
        self._placement_type = placement_type
        VapiStruct.__init__(self)

    @property
    def placement_type(self):
        """
        Return the discriminator value
        """
        return self._placement_type

ALBControllerNodeVMDeploymentConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_config', {
        'placement_type': type.StringType(),
    },
    ALBControllerNodeVMDeploymentConfig,
    False,
    None))



class ALBControllerNodeVMDeploymentProgressState(VapiStruct):
    """
    Deployment progress state of Advanced Load Balancer controller VM. This
    Object contains name of current deployment step and overall progress
    percentage.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'current_step_title': 'current_step_title',
                            'progress': 'progress',
                            }

    def __init__(self,
                 current_step_title=None,
                 progress=None,
                ):
        """
        :type  current_step_title: :class:`str` or ``None``
        :param current_step_title: Name of the current running step of deployment
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  progress: :class:`long` or ``None``
        :param progress: Overall progress percentage of deployment completed format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.current_step_title = current_step_title
        self.progress = progress
        VapiStruct.__init__(self)


ALBControllerNodeVMDeploymentProgressState._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_progress_state', {
        'current_step_title': type.OptionalType(type.StringType()),
        'progress': type.OptionalType(type.IntegerType()),
    },
    ALBControllerNodeVMDeploymentProgressState,
    False,
    None))



class ALBControllerNodeVMDeploymentRequest(VapiStruct):
    """
    Contains the deployment information for a Advanced Load Balancer controller
    node VM.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FORM_FACTOR_SMALL = "SMALL"
    """


    """
    FORM_FACTOR_MEDIUM = "MEDIUM"
    """


    """
    FORM_FACTOR_LARGE = "LARGE"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'deployment_config': 'deployment_config',
                            'form_factor': 'form_factor',
                            'user_settings': 'user_settings',
                            'vm_id': 'vm_id',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 deployment_config=None,
                 form_factor=None,
                 user_settings=None,
                 vm_id=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  deployment_config: :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param deployment_config: 
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ALBControllerNodeVMDeploymentConfig`. When methods return a
            value of this class as a return value, the attribute will contain
            all the attributes defined in
            :class:`ALBControllerNodeVMDeploymentConfig`.
        :type  form_factor: :class:`str` or ``None``
        :param form_factor: Possible values are: 
            
            * :attr:`ALBControllerNodeVMDeploymentRequest.FORM_FACTOR_SMALL`
            * :attr:`ALBControllerNodeVMDeploymentRequest.FORM_FACTOR_MEDIUM`
            * :attr:`ALBControllerNodeVMDeploymentRequest.FORM_FACTOR_LARGE`
            
             Specifies the desired \"size\" of the VM
        :type  user_settings: :class:`ALBControllerNodeUserSettings` or ``None``
        :param user_settings: 
        :type  vm_id: :class:`str` or ``None``
        :param vm_id: ID of the VM maintained internally. Note: This is automatically
            generated and cannot be modified.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.deployment_config = deployment_config
        self.form_factor = form_factor
        self.user_settings = user_settings
        self.vm_id = vm_id
        VapiStruct.__init__(self)


ALBControllerNodeVMDeploymentRequest._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_request', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'deployment_config': type.OptionalType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ALBControllerNodeVMDeploymentConfig')])),
        'form_factor': type.OptionalType(type.StringType()),
        'user_settings': type.OptionalType(type.ReferenceType(__name__, 'ALBControllerNodeUserSettings')),
        'vm_id': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeVMDeploymentRequest,
    False,
    None))



class ALBControllerNodeVMDeploymentRequestList(VapiStruct):
    """
    List of Advanced Load Balancer Controller Deployment Requests.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  results: :class:`list` of :class:`ALBControllerNodeVMDeploymentRequest` or ``None``
        :param results: Array of existing Advanced Load Balancer Controller Deployment
            Requests.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.results = results
        VapiStruct.__init__(self)


ALBControllerNodeVMDeploymentRequestList._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_request_list', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBControllerNodeVMDeploymentRequest'))),
    },
    ALBControllerNodeVMDeploymentRequestList,
    False,
    None))



class ALBControllerNodeVMDeploymentStatusReport(VapiStruct):
    """
    Contains up-to-date information relating to an auto-deployed VM, including
    its status and (potentially) an error message.

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_NOT_AVAILABLE = "NOT_AVAILABLE"
    """


    """
    STATUS_VM_DEPLOYMENT_QUEUED = "VM_DEPLOYMENT_QUEUED"
    """


    """
    STATUS_VM_DEPLOYMENT_IN_PROGRESS = "VM_DEPLOYMENT_IN_PROGRESS"
    """


    """
    STATUS_VM_DEPLOYMENT_FAILED = "VM_DEPLOYMENT_FAILED"
    """


    """
    STATUS_VM_POWER_ON_IN_PROGRESS = "VM_POWER_ON_IN_PROGRESS"
    """


    """
    STATUS_VM_POWER_ON_FAILED = "VM_POWER_ON_FAILED"
    """


    """
    STATUS_VM_POWER_ON_SUCCESSFUL = "VM_POWER_ON_SUCCESSFUL"
    """


    """
    STATUS_VM_REGISTRATION_IN_PROGRESS = "VM_REGISTRATION_IN_PROGRESS"
    """


    """
    STATUS_VM_REGISTRATION_SUCCESSFUL = "VM_REGISTRATION_SUCCESSFUL"
    """


    """
    STATUS_VM_REGISTRATION_FAILED = "VM_REGISTRATION_FAILED"
    """


    """
    STATUS_VM_WAITING_TO_COME_ONLINE = "VM_WAITING_TO_COME_ONLINE"
    """


    """
    STATUS_VM_ONLINE_FAILED = "VM_ONLINE_FAILED"
    """


    """
    STATUS_VM_CONFIGURATION_IN_PROGRESS = "VM_CONFIGURATION_IN_PROGRESS"
    """


    """
    STATUS_VM_CONFIGURATION_SUCCESSFUL = "VM_CONFIGURATION_SUCCESSFUL"
    """


    """
    STATUS_VM_CONFIGURATION_FAILED = "VM_CONFIGURATION_FAILED"
    """


    """
    STATUS_VM_CLUSTERING_QUEUED = "VM_CLUSTERING_QUEUED"
    """


    """
    STATUS_VM_CLUSTERING_IN_PROGRESS = "VM_CLUSTERING_IN_PROGRESS"
    """


    """
    STATUS_VM_CLUSTERING_SUCCESSFUL = "VM_CLUSTERING_SUCCESSFUL"
    """


    """
    STATUS_VM_CLUSTERING_FAILED = "VM_CLUSTERING_FAILED"
    """


    """
    STATUS_VM_POWER_OFF_IN_PROGRESS = "VM_POWER_OFF_IN_PROGRESS"
    """


    """
    STATUS_VM_POWER_OFF_FAILED = "VM_POWER_OFF_FAILED"
    """


    """
    STATUS_WAITING_TO_UNDEPLOY_VM = "WAITING_TO_UNDEPLOY_VM"
    """


    """
    STATUS_VM_UNDEPLOY_IN_PROGRESS = "VM_UNDEPLOY_IN_PROGRESS"
    """


    """
    STATUS_VM_UNDEPLOY_FAILED = "VM_UNDEPLOY_FAILED"
    """


    """
    STATUS_VM_UNDEPLOY_SUCCESSFUL = "VM_UNDEPLOY_SUCCESSFUL"
    """


    """
    STATUS_UNKNOWN_STATE = "UNKNOWN_STATE"
    """


    """



    _canonical_to_pep_names = {
                            'deployment_progress_state': 'deployment_progress_state',
                            'failure_code': 'failure_code',
                            'failure_message': 'failure_message',
                            'status': 'status',
                            }

    def __init__(self,
                 deployment_progress_state=None,
                 failure_code=None,
                 failure_message=None,
                 status=None,
                ):
        """
        :type  deployment_progress_state: :class:`ALBControllerNodeVMDeploymentProgressState` or ``None``
        :param deployment_progress_state: 
        :type  failure_code: :class:`long` or ``None``
        :param failure_code: In case of auto-deployment-related failure, the code for the error
            will be stored here. format: int64
        :type  failure_message: :class:`str` or ``None``
        :param failure_message: In case of auto-deployment-related failure, an error message will
            be stored here.
        :type  status: :class:`str` or ``None``
        :param status: Possible values are: 
            
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_NOT_AVAILABLE`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_QUEUED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_DEPLOYMENT_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_ON_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_REGISTRATION_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_REGISTRATION_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_REGISTRATION_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_WAITING_TO_COME_ONLINE`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_ONLINE_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CONFIGURATION_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CONFIGURATION_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CONFIGURATION_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_QUEUED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_CLUSTERING_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_OFF_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_POWER_OFF_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_WAITING_TO_UNDEPLOY_VM`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_IN_PROGRESS`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_FAILED`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_VM_UNDEPLOY_SUCCESSFUL`
            *
              :attr:`ALBControllerNodeVMDeploymentStatusReport.STATUS_UNKNOWN_STATE`
            
            Status of the addition or deletion of an auto-deployed Advanced
            Load Balancer controller node VM.
        """
        self.deployment_progress_state = deployment_progress_state
        self.failure_code = failure_code
        self.failure_message = failure_message
        self.status = status
        VapiStruct.__init__(self)


ALBControllerNodeVMDeploymentStatusReport._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_node_VM_deployment_status_report', {
        'deployment_progress_state': type.OptionalType(type.ReferenceType(__name__, 'ALBControllerNodeVMDeploymentProgressState')),
        'failure_code': type.OptionalType(type.IntegerType()),
        'failure_message': type.OptionalType(type.StringType()),
        'status': type.OptionalType(type.StringType()),
    },
    ALBControllerNodeVMDeploymentStatusReport,
    False,
    None))



class ALBControllerVersion(VapiStruct):
    """
    ALB Controller Version

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'alb_api_version': 'alb_api_version',
                            'alb_controller_version': 'alb_controller_version',
                            }

    def __init__(self,
                 alb_api_version=None,
                 alb_controller_version=None,
                ):
        """
        :type  alb_api_version: :class:`str` or ``None``
        :param alb_api_version: It is ALB API version supported by NSX-ALB.
        :type  alb_controller_version: :class:`str` or ``None``
        :param alb_controller_version: It is ALB Controller version deployed by NSX-ALB.
        """
        self.alb_api_version = alb_api_version
        self.alb_controller_version = alb_controller_version
        VapiStruct.__init__(self)


ALBControllerVersion._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_controller_version', {
        'alb_api_version': type.OptionalType(type.StringType()),
        'alb_controller_version': type.OptionalType(type.StringType()),
    },
    ALBControllerVersion,
    False,
    None))



class ALBCookieMatch(VapiStruct):
    """
    Advanced load balancer CookieMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CASE_SENSITIVE = "SENSITIVE"
    """


    """
    MATCH_CASE_INSENSITIVE = "INSENSITIVE"
    """


    """
    MATCH_CRITERIA_EXISTS = "HDR_EXISTS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EXIST = "HDR_DOES_NOT_EXIST"
    """


    """
    MATCH_CRITERIA_BEGINS_WITH = "HDR_BEGINS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_BEGIN_WITH = "HDR_DOES_NOT_BEGIN_WITH"
    """


    """
    MATCH_CRITERIA_CONTAINS = "HDR_CONTAINS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_CONTAIN = "HDR_DOES_NOT_CONTAIN"
    """


    """
    MATCH_CRITERIA_ENDS_WITH = "HDR_ENDS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_END_WITH = "HDR_DOES_NOT_END_WITH"
    """


    """
    MATCH_CRITERIA_EQUALS = "HDR_EQUALS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EQUAL = "HDR_DOES_NOT_EQUAL"
    """


    """



    _canonical_to_pep_names = {
                            'match_case': 'match_case',
                            'match_criteria': 'match_criteria',
                            'name': 'name',
                            'value': 'value',
                            }

    def __init__(self,
                 match_case=None,
                 match_criteria=None,
                 name=None,
                 value=None,
                ):
        """
        :type  match_case: :class:`str` or ``None``
        :param match_case: Possible values are: 
            
            * :attr:`ALBCookieMatch.MATCH_CASE_SENSITIVE`
            * :attr:`ALBCookieMatch.MATCH_CASE_INSENSITIVE`
            
            Case sensitivity to use for the match. Enum options - SENSITIVE,
            INSENSITIVE. Default value when not specified in API or module is
            interpreted by ALB Controller as INSENSITIVE.
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_EXISTS`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_DOES_NOT_EXIST`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_BEGINS_WITH`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_DOES_NOT_BEGIN_WITH`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_CONTAINS`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_DOES_NOT_CONTAIN`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_ENDS_WITH`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_DOES_NOT_END_WITH`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_EQUALS`
            * :attr:`ALBCookieMatch.MATCH_CRITERIA_DOES_NOT_EQUAL`
            
            Criterion to use for matching the cookie in the HTTP request. Enum
            options - HDR_EXISTS, HDR_DOES_NOT_EXIST, HDR_BEGINS_WITH,
            HDR_DOES_NOT_BEGIN_WITH, HDR_CONTAINS, HDR_DOES_NOT_CONTAIN,
            HDR_ENDS_WITH, HDR_DOES_NOT_END_WITH, HDR_EQUALS,
            HDR_DOES_NOT_EQUAL.
        :type  name: :class:`str` or ``None``
        :param name: Name of the cookie.
        :type  value: :class:`str` or ``None``
        :param value: String value in the cookie.
        """
        self.match_case = match_case
        self.match_criteria = match_criteria
        self.name = name
        self.value = value
        VapiStruct.__init__(self)


ALBCookieMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_cookie_match', {
        'match_case': type.OptionalType(type.StringType()),
        'match_criteria': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.StringType()),
    },
    ALBCookieMatch,
    False,
    None))



class ALBCustomParams(VapiStruct):
    """
    Advanced load balancer CustomParams object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'is_dynamic': 'is_dynamic',
                            'is_sensitive': 'is_sensitive',
                            'name': 'name',
                            'value': 'value',
                            }

    def __init__(self,
                 is_dynamic=None,
                 is_sensitive=None,
                 name=None,
                 value=None,
                ):
        """
        :type  is_dynamic: :class:`bool` or ``None``
        :param is_dynamic: Placeholder for description of property is_dynamic of obj type
            CustomParams field type str type boolean. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  is_sensitive: :class:`bool` or ``None``
        :param is_sensitive: Placeholder for description of property is_sensitive of obj type
            CustomParams field type str type boolean. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  name: :class:`str` or ``None``
        :param name: Name of the object.
        :type  value: :class:`str` or ``None``
        :param value: value of CustomParams.
        """
        self.is_dynamic = is_dynamic
        self.is_sensitive = is_sensitive
        self.name = name
        self.value = value
        VapiStruct.__init__(self)


ALBCustomParams._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_custom_params', {
        'is_dynamic': type.OptionalType(type.BooleanType()),
        'is_sensitive': type.OptionalType(type.BooleanType()),
        'name': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.StringType()),
    },
    ALBCustomParams,
    False,
    None))



class ALBDiscoveredNetwork(VapiStruct):
    """
    Advanced load balancer DiscoveredNetwork object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'network_name': 'network_name',
                            'subnet': 'subnet',
                            'subnet6': 'subnet6',
                            }

    def __init__(self,
                 network_name=None,
                 subnet=None,
                 subnet6=None,
                ):
        """
        :type  network_name: :class:`str` or ``None``
        :param network_name: Discovered network for this IP. It is a reference to an object of
            type Network.
        :type  subnet: :class:`list` of :class:`ALBIpAddrPrefix` or ``None``
        :param subnet: Discovered subnet for this IP.
        :type  subnet6: :class:`list` of :class:`ALBIpAddrPrefix` or ``None``
        :param subnet6: Discovered IPv6 subnet for this IP.
        """
        self.network_name = network_name
        self.subnet = subnet
        self.subnet6 = subnet6
        VapiStruct.__init__(self)


ALBDiscoveredNetwork._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_discovered_network', {
        'network_name': type.OptionalType(type.StringType()),
        'subnet': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrPrefix'))),
        'subnet6': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrPrefix'))),
    },
    ALBDiscoveredNetwork,
    False,
    None))



class ALBDnsAAAARdata(VapiStruct):
    """
    Advanced load balancer DnsAAAARdata object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ip6_address': 'ip6_address',
                            }

    def __init__(self,
                 ip6_address=None,
                ):
        """
        :type  ip6_address: :class:`ALBIpAddr` or ``None``
        :param ip6_address: 
        """
        self.ip6_address = ip6_address
        VapiStruct.__init__(self)


ALBDnsAAAARdata._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_AAAA_rdata', {
        'ip6_address': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
    },
    ALBDnsAAAARdata,
    False,
    None))



class ALBDnsaRdata(VapiStruct):
    """
    Advanced load balancer DnsARdata object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ip_address': 'ip_address',
                            }

    def __init__(self,
                 ip_address=None,
                ):
        """
        :type  ip_address: :class:`ALBIpAddr` or ``None``
        :param ip_address: 
        """
        self.ip_address = ip_address
        VapiStruct.__init__(self)


ALBDnsaRdata._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dnsa_rdata', {
        'ip_address': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
    },
    ALBDnsaRdata,
    False,
    None))



class ALBDnsAttack(VapiStruct):
    """
    Advanced load balancer DnsAttack object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ATTACK_VECTOR_REFLECTION = "DNS_REFLECTION"
    """


    """
    ATTACK_VECTOR_NXDOMAIN = "DNS_NXDOMAIN"
    """


    """
    ATTACK_VECTOR_AMPLIFICATION_EGRESS = "DNS_AMPLIFICATION_EGRESS"
    """


    """



    _canonical_to_pep_names = {
                            'attack_vector': 'attack_vector',
                            'enabled': 'enabled',
                            'max_mitigation_age': 'max_mitigation_age',
                            'mitigation_action': 'mitigation_action',
                            'threshold': 'threshold',
                            }

    def __init__(self,
                 attack_vector=None,
                 enabled=None,
                 max_mitigation_age=None,
                 mitigation_action=None,
                 threshold=None,
                ):
        """
        :type  attack_vector: :class:`str` or ``None``
        :param attack_vector: Possible values are: 
            
            * :attr:`ALBDnsAttack.ATTACK_VECTOR_REFLECTION`
            * :attr:`ALBDnsAttack.ATTACK_VECTOR_NXDOMAIN`
            * :attr:`ALBDnsAttack.ATTACK_VECTOR_AMPLIFICATION_EGRESS`
            
            The DNS attack vector. Enum options - DNS_REFLECTION, DNS_NXDOMAIN,
            DNS_AMPLIFICATION_EGRESS.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable or disable the mitigation of the attack vector. Default
            value when not specified in API or module is interpreted by ALB
            Controller as true.
        :type  max_mitigation_age: :class:`long` or ``None``
        :param max_mitigation_age: Time in minutes after which mitigation will be deactivated. Allowed
            values are 1-4294967295. Special values are 0- 'blocked for ever'.
            Unit is MIN. Default value when not specified in API or module is
            interpreted by ALB Controller as 60. format: int64
        :type  mitigation_action: :class:`ALBAttackMitigationAction` or ``None``
        :param mitigation_action: 
        :type  threshold: :class:`long` or ``None``
        :param threshold: Threshold, in terms of DNS packet per second, for the DNS attack
            vector. format: int64
        """
        self.attack_vector = attack_vector
        self.enabled = enabled
        self.max_mitigation_age = max_mitigation_age
        self.mitigation_action = mitigation_action
        self.threshold = threshold
        VapiStruct.__init__(self)


ALBDnsAttack._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_attack', {
        'attack_vector': type.OptionalType(type.StringType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'max_mitigation_age': type.OptionalType(type.IntegerType()),
        'mitigation_action': type.OptionalType(type.ReferenceType(__name__, 'ALBAttackMitigationAction')),
        'threshold': type.OptionalType(type.IntegerType()),
    },
    ALBDnsAttack,
    False,
    None))



class ALBDnsAttacks(VapiStruct):
    """
    Advanced load balancer DnsAttacks object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OPER_MODE_DETECTION = "DETECTION"
    """


    """
    OPER_MODE_MITIGATION = "MITIGATION"
    """


    """



    _canonical_to_pep_names = {
                            'attacks': 'attacks',
                            'oper_mode': 'oper_mode',
                            }

    def __init__(self,
                 attacks=None,
                 oper_mode=None,
                ):
        """
        :type  attacks: :class:`list` of :class:`ALBDnsAttack` or ``None``
        :param attacks: Mode of dealing with the attacks - perform detection only, or
            detect and mitigate the attacks.
        :type  oper_mode: :class:`str` or ``None``
        :param oper_mode: Possible values are: 
            
            * :attr:`ALBDnsAttacks.OPER_MODE_DETECTION`
            * :attr:`ALBDnsAttacks.OPER_MODE_MITIGATION`
            
            Mode of dealing with the attacks - perform detection only, or
            detect and mitigate the attacks. Enum options - DETECTION,
            MITIGATION.
        """
        self.attacks = attacks
        self.oper_mode = oper_mode
        VapiStruct.__init__(self)


ALBDnsAttacks._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_attacks', {
        'attacks': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsAttack'))),
        'oper_mode': type.OptionalType(type.StringType()),
    },
    ALBDnsAttacks,
    False,
    None))



class ALBDnsClientIpMatch(VapiStruct):
    """
    Advanced load balancer DnsClientIpMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_ip': 'client_ip',
                            'use_edns_client_subnet_ip': 'use_edns_client_subnet_ip',
                            }

    def __init__(self,
                 client_ip=None,
                 use_edns_client_subnet_ip=None,
                ):
        """
        :type  client_ip: :class:`ALBIpAddrMatch` or ``None``
        :param client_ip: 
        :type  use_edns_client_subnet_ip: :class:`bool` or ``None``
        :param use_edns_client_subnet_ip: Use the IP address from the EDNS client subnet option, if
            available, as the source IP address of the client. It should be
            noted that the edns subnet IP may not be a /32 IP address. Default
            value when not specified in API or module is interpreted by ALB
            Controller as true.
        """
        self.client_ip = client_ip
        self.use_edns_client_subnet_ip = use_edns_client_subnet_ip
        VapiStruct.__init__(self)


ALBDnsClientIpMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_client_ip_match', {
        'client_ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrMatch')),
        'use_edns_client_subnet_ip': type.OptionalType(type.BooleanType()),
    },
    ALBDnsClientIpMatch,
    False,
    None))



class ALBDnsCnameRdata(VapiStruct):
    """
    Advanced load balancer DnsCnameRdata object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'cname': 'cname',
                            }

    def __init__(self,
                 cname=None,
                ):
        """
        :type  cname: :class:`str` or ``None``
        :param cname: Canonical name.
        """
        self.cname = cname
        VapiStruct.__init__(self)


ALBDnsCnameRdata._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_cname_rdata', {
        'cname': type.OptionalType(type.StringType()),
    },
    ALBDnsCnameRdata,
    False,
    None))



class ALBDnsGeoLocationMatch(VapiStruct):
    """
    Advanced load balancer DnsGeoLocationMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """



    _canonical_to_pep_names = {
                            'geolocation_name': 'geolocation_name',
                            'geolocation_tag': 'geolocation_tag',
                            'match_criteria': 'match_criteria',
                            'use_edns_client_subnet_ip': 'use_edns_client_subnet_ip',
                            }

    def __init__(self,
                 geolocation_name=None,
                 geolocation_tag=None,
                 match_criteria=None,
                 use_edns_client_subnet_ip=None,
                ):
        """
        :type  geolocation_name: :class:`str` or ``None``
        :param geolocation_name: Geographical location of the client IP to be used in the match.
            This location is of the format Country/State/City e.g. US/CA/Santa
            Clara.
        :type  geolocation_tag: :class:`str` or ``None``
        :param geolocation_tag: Geolocation tag for the client IP. This could be any string value
            for the client IP, e.g. client IPs from US East Coast geolocation
            would be tagged as 'East Coast'.
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBDnsGeoLocationMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBDnsGeoLocationMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for matching the client IP's geographical
            location. Enum options - IS_IN, IS_NOT_IN.
        :type  use_edns_client_subnet_ip: :class:`bool` or ``None``
        :param use_edns_client_subnet_ip: Use the IP address from the EDNS client subnet option, if
            available, to derive geo location of the DNS query. Default value
            when not specified in API or module is interpreted by ALB
            Controller as true.
        """
        self.geolocation_name = geolocation_name
        self.geolocation_tag = geolocation_tag
        self.match_criteria = match_criteria
        self.use_edns_client_subnet_ip = use_edns_client_subnet_ip
        VapiStruct.__init__(self)


ALBDnsGeoLocationMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_geo_location_match', {
        'geolocation_name': type.OptionalType(type.StringType()),
        'geolocation_tag': type.OptionalType(type.StringType()),
        'match_criteria': type.OptionalType(type.StringType()),
        'use_edns_client_subnet_ip': type.OptionalType(type.BooleanType()),
    },
    ALBDnsGeoLocationMatch,
    False,
    None))



class ALBDnsInfo(VapiStruct):
    """
    Advanced load balancer DnsInfo object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ALGORITHM_ROUND_ROBIN = "DNS_RECORD_RESPONSE_ROUND_ROBIN"
    """


    """
    ALGORITHM_CONSISTENT_HASH = "DNS_RECORD_RESPONSE_CONSISTENT_HASH"
    """


    """
    TYPE_OTHER = "DNS_RECORD_OTHER"
    """


    """
    TYPE_A = "DNS_RECORD_A"
    """


    """
    TYPE_NS = "DNS_RECORD_NS"
    """


    """
    TYPE_CNAME = "DNS_RECORD_CNAME"
    """


    """
    TYPE_SOA = "DNS_RECORD_SOA"
    """


    """
    TYPE_PTR = "DNS_RECORD_PTR"
    """


    """
    TYPE_HINFO = "DNS_RECORD_HINFO"
    """


    """
    TYPE_MX = "DNS_RECORD_MX"
    """


    """
    TYPE_TXT = "DNS_RECORD_TXT"
    """


    """
    TYPE_RP = "DNS_RECORD_RP"
    """


    """
    TYPE_DNSKEY = "DNS_RECORD_DNSKEY"
    """


    """
    TYPE_AAAA = "DNS_RECORD_AAAA"
    """


    """
    TYPE_SRV = "DNS_RECORD_SRV"
    """


    """
    TYPE_OPT = "DNS_RECORD_OPT"
    """


    """
    TYPE_RRSIG = "DNS_RECORD_RRSIG"
    """


    """
    TYPE_AXFR = "DNS_RECORD_AXFR"
    """


    """
    TYPE_ANY = "DNS_RECORD_ANY"
    """


    """



    _canonical_to_pep_names = {
                            'algorithm': 'algorithm',
                            'cname': 'cname',
                            'fqdn': 'fqdn',
                            'metadata': 'metadata',
                            'num_records_in_response': 'num_records_in_response',
                            'ttl': 'ttl',
                            'type': 'type',
                            }

    def __init__(self,
                 algorithm=None,
                 cname=None,
                 fqdn=None,
                 metadata=None,
                 num_records_in_response=None,
                 ttl=None,
                 type=None,
                ):
        """
        :type  algorithm: :class:`str` or ``None``
        :param algorithm: Possible values are: 
            
            * :attr:`ALBDnsInfo.ALGORITHM_ROUND_ROBIN`
            * :attr:`ALBDnsInfo.ALGORITHM_CONSISTENT_HASH`
            
            Specifies the algorithm to pick the IP address(es) to be returned,
            when multiple entries are configured. This does not apply if
            num_records_in_response is 0. Default is consistent hash. Enum
            options - DNS_RECORD_RESPONSE_ROUND_ROBIN,
            DNS_RECORD_RESPONSE_CONSISTENT_HASH. Default value when not
            specified in API or module is interpreted by ALB Controller as
            DNS_RECORD_RESPONSE_CONSISTENT_HASH.
        :type  cname: :class:`ALBDnsCnameRdata` or ``None``
        :param cname: 
        :type  fqdn: :class:`str` or ``None``
        :param fqdn: Fully qualified domain name.
        :type  metadata: :class:`str` or ``None``
        :param metadata: Any metadata associated with this record.
        :type  num_records_in_response: :class:`long` or ``None``
        :param num_records_in_response: Specifies the number of records returned for this FQDN. Enter 0 to
            return all records. Default is 0. Allowed values are 0-20. Special
            values are 0- 'Return all records'. format: int64
        :type  ttl: :class:`long` or ``None``
        :param ttl: Time to live for fqdn record. Default value is chosen from DNS
            profile for this cloud if no value provided. format: int64
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBDnsInfo.TYPE_OTHER`
            * :attr:`ALBDnsInfo.TYPE_A`
            * :attr:`ALBDnsInfo.TYPE_NS`
            * :attr:`ALBDnsInfo.TYPE_CNAME`
            * :attr:`ALBDnsInfo.TYPE_SOA`
            * :attr:`ALBDnsInfo.TYPE_PTR`
            * :attr:`ALBDnsInfo.TYPE_HINFO`
            * :attr:`ALBDnsInfo.TYPE_MX`
            * :attr:`ALBDnsInfo.TYPE_TXT`
            * :attr:`ALBDnsInfo.TYPE_RP`
            * :attr:`ALBDnsInfo.TYPE_DNSKEY`
            * :attr:`ALBDnsInfo.TYPE_AAAA`
            * :attr:`ALBDnsInfo.TYPE_SRV`
            * :attr:`ALBDnsInfo.TYPE_OPT`
            * :attr:`ALBDnsInfo.TYPE_RRSIG`
            * :attr:`ALBDnsInfo.TYPE_AXFR`
            * :attr:`ALBDnsInfo.TYPE_ANY`
            
            DNS record type. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A,
            DNS_RECORD_NS, DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR,
            DNS_RECORD_HINFO, DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP,
            DNS_RECORD_DNSKEY, DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT,
            DNS_RECORD_RRSIG, DNS_RECORD_AXFR, DNS_RECORD_ANY. Default value
            when not specified in API or module is interpreted by ALB
            Controller as DNS_RECORD_A.
        """
        self.algorithm = algorithm
        self.cname = cname
        self.fqdn = fqdn
        self.metadata = metadata
        self.num_records_in_response = num_records_in_response
        self.ttl = ttl
        self.type = type
        VapiStruct.__init__(self)


ALBDnsInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_info', {
        'algorithm': type.OptionalType(type.StringType()),
        'cname': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsCnameRdata')),
        'fqdn': type.OptionalType(type.StringType()),
        'metadata': type.OptionalType(type.StringType()),
        'num_records_in_response': type.OptionalType(type.IntegerType()),
        'ttl': type.OptionalType(type.IntegerType()),
        'type': type.OptionalType(type.StringType()),
    },
    ALBDnsInfo,
    False,
    None))



class ALBDnsMxRdata(VapiStruct):
    """
    Advanced load balancer DnsMxRdata object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'host': 'host',
                            'priority': 'priority',
                            }

    def __init__(self,
                 host=None,
                 priority=None,
                ):
        """
        :type  host: :class:`str` or ``None``
        :param host: Fully qualified domain name of a mailserver. The host name maps
            directly to one or more address records in the DNS table, and must
            not point to any CNAME records (RFC 2181).
        :type  priority: :class:`long` or ``None``
        :param priority: The priority field identifies which mail server should be
            preferred. Allowed values are 0-65535. format: int64
        """
        self.host = host
        self.priority = priority
        VapiStruct.__init__(self)


ALBDnsMxRdata._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_mx_rdata', {
        'host': type.OptionalType(type.StringType()),
        'priority': type.OptionalType(type.IntegerType()),
    },
    ALBDnsMxRdata,
    False,
    None))



class ALBDnsNsRdata(VapiStruct):
    """
    Advanced load balancer DnsNsRdata object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ip6_address': 'ip6_address',
                            'ip_address': 'ip_address',
                            'nsname': 'nsname',
                            }

    def __init__(self,
                 ip6_address=None,
                 ip_address=None,
                 nsname=None,
                ):
        """
        :type  ip6_address: :class:`ALBIpAddr` or ``None``
        :param ip6_address: 
        :type  ip_address: :class:`ALBIpAddr` or ``None``
        :param ip_address: 
        :type  nsname: :class:`str` or ``None``
        :param nsname: Name Server name.
        """
        self.ip6_address = ip6_address
        self.ip_address = ip_address
        self.nsname = nsname
        VapiStruct.__init__(self)


ALBDnsNsRdata._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_ns_rdata', {
        'ip6_address': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
        'ip_address': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
        'nsname': type.OptionalType(type.StringType()),
    },
    ALBDnsNsRdata,
    False,
    None))



class ALBDnsPolicies(VapiStruct):
    """
    Advanced load balancer DnsPolicies object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dns_policy_path': 'dns_policy_path',
                            'index': 'index',
                            }

    def __init__(self,
                 dns_policy_path=None,
                 index=None,
                ):
        """
        :type  dns_policy_path: :class:`str` or ``None``
        :param dns_policy_path: path of the dns policy. It is a reference to an object of type
            DnsPolicy.
        :type  index: :class:`long` or ``None``
        :param index: Index of the dns policy. format: int64
        """
        self.dns_policy_path = dns_policy_path
        self.index = index
        VapiStruct.__init__(self)


ALBDnsPolicies._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_policies', {
        'dns_policy_path': type.OptionalType(type.StringType()),
        'index': type.OptionalType(type.IntegerType()),
    },
    ALBDnsPolicies,
    False,
    None))



class ALBDnsPolicy(VapiStruct):
    """
    Advanced load balancer DnsPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'created_by': 'created_by',
                            'markers': 'markers',
                            'rule': 'rule',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 created_by=None,
                 markers=None,
                 rule=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  created_by: :class:`str` or ``None``
        :param created_by: Creator name.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  rule: :class:`list` of :class:`ALBDnsRule` or ``None``
        :param rule: DNS rules.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.created_by = created_by
        self.markers = markers
        self.rule = rule
        VapiStruct.__init__(self)


ALBDnsPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_policy', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'created_by': type.OptionalType(type.StringType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'rule': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsRule'))),
    },
    ALBDnsPolicy,
    False,
    None))



class ALBDnsPolicyApiResponse(VapiStruct):
    """
    DnsPolicyApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBDnsPolicy` or ``None``
        :param results: Array of DnsPolicy
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBDnsPolicyApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_policy_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsPolicy'))),
    },
    ALBDnsPolicyApiResponse,
    False,
    None))



class ALBDnsQueryNameMatch(VapiStruct):
    """
    Advanced load balancer DnsQueryNameMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_BEGINS_WITH = "BEGINS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_BEGIN_WITH = "DOES_NOT_BEGIN_WITH"
    """


    """
    MATCH_CRITERIA_CONTAINS = "CONTAINS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_CONTAIN = "DOES_NOT_CONTAIN"
    """


    """
    MATCH_CRITERIA_ENDS_WITH = "ENDS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_END_WITH = "DOES_NOT_END_WITH"
    """


    """
    MATCH_CRITERIA_EQUALS = "EQUALS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EQUAL = "DOES_NOT_EQUAL"
    """


    """
    MATCH_CRITERIA_REGEX_MATCH = "REGEX_MATCH"
    """


    """
    MATCH_CRITERIA_REGEX_DOES_NOT_MATCH = "REGEX_DOES_NOT_MATCH"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            'query_domain_names': 'query_domain_names',
                            'string_group_paths': 'string_group_paths',
                            }

    def __init__(self,
                 match_criteria=None,
                 query_domain_names=None,
                 string_group_paths=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_BEGINS_WITH`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_DOES_NOT_BEGIN_WITH`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_CONTAINS`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_DOES_NOT_CONTAIN`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_ENDS_WITH`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_DOES_NOT_END_WITH`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_EQUALS`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_DOES_NOT_EQUAL`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_REGEX_MATCH`
            * :attr:`ALBDnsQueryNameMatch.MATCH_CRITERIA_REGEX_DOES_NOT_MATCH`
            
            Criterion to use for string matching the DNS query domain name in
            the question section. Enum options - BEGINS_WITH,
            DOES_NOT_BEGIN_WITH, CONTAINS, DOES_NOT_CONTAIN, ENDS_WITH,
            DOES_NOT_END_WITH, EQUALS, DOES_NOT_EQUAL, REGEX_MATCH,
            REGEX_DOES_NOT_MATCH. Allowed in Basic(Allowed values-
            BEGINS_WITH,DOES_NOT_BEGIN_WITH,CONTAINS,DOES_NOT_CONTAIN,ENDS_WITH,DOES_NOT_END_WITH,EQUALS,DOES_NOT_EQUAL)
            edition, Essentials(Allowed values-
            BEGINS_WITH,DOES_NOT_BEGIN_WITH,CONTAINS,DOES_NOT_CONTAIN,ENDS_WITH,DOES_NOT_END_WITH,EQUALS,DOES_NOT_EQUAL)
            edition, Enterprise edition.
        :type  query_domain_names: :class:`list` of :class:`str` or ``None``
        :param query_domain_names: Domain name to match against that specified in the question section
            of the DNS query.
        :type  string_group_paths: :class:`list` of :class:`str` or ``None``
        :param string_group_paths: path of the string group(s) for matching against DNS query domain
            name in the question section. It is a reference to an object of
            type StringGroup.
        """
        self.match_criteria = match_criteria
        self.query_domain_names = query_domain_names
        self.string_group_paths = string_group_paths
        VapiStruct.__init__(self)


ALBDnsQueryNameMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_query_name_match', {
        'match_criteria': type.OptionalType(type.StringType()),
        'query_domain_names': type.OptionalType(type.ListType(type.StringType())),
        'string_group_paths': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBDnsQueryNameMatch,
    False,
    None))



class ALBDnsQueryTypeMatch(VapiStruct):
    """
    Advanced load balancer DnsQueryTypeMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """
    QUERY_TYPE_OTHER = "DNS_RECORD_OTHER"
    """


    """
    QUERY_TYPE_A = "DNS_RECORD_A"
    """


    """
    QUERY_TYPE_NS = "DNS_RECORD_NS"
    """


    """
    QUERY_TYPE_CNAME = "DNS_RECORD_CNAME"
    """


    """
    QUERY_TYPE_SOA = "DNS_RECORD_SOA"
    """


    """
    QUERY_TYPE_PTR = "DNS_RECORD_PTR"
    """


    """
    QUERY_TYPE_HINFO = "DNS_RECORD_HINFO"
    """


    """
    QUERY_TYPE_MX = "DNS_RECORD_MX"
    """


    """
    QUERY_TYPE_TXT = "DNS_RECORD_TXT"
    """


    """
    QUERY_TYPE_RP = "DNS_RECORD_RP"
    """


    """
    QUERY_TYPE_DNSKEY = "DNS_RECORD_DNSKEY"
    """


    """
    QUERY_TYPE_AAAA = "DNS_RECORD_AAAA"
    """


    """
    QUERY_TYPE_SRV = "DNS_RECORD_SRV"
    """


    """
    QUERY_TYPE_OPT = "DNS_RECORD_OPT"
    """


    """
    QUERY_TYPE_RRSIG = "DNS_RECORD_RRSIG"
    """


    """
    QUERY_TYPE_AXFR = "DNS_RECORD_AXFR"
    """


    """
    QUERY_TYPE_ANY = "DNS_RECORD_ANY"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            'query_type': 'query_type',
                            }

    def __init__(self,
                 match_criteria=None,
                 query_type=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBDnsQueryTypeMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBDnsQueryTypeMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for matching the DNS query typein the question
            section. Enum options - IS_IN, IS_NOT_IN.
        :type  query_type: :class:`list` of :class:`str` or ``None``
        :param query_type: Possible values are: 
            
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_OTHER`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_A`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_NS`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_CNAME`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_SOA`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_PTR`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_HINFO`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_MX`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_TXT`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_RP`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_DNSKEY`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_AAAA`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_SRV`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_OPT`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_RRSIG`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_AXFR`
            * :attr:`ALBDnsQueryTypeMatch.QUERY_TYPE_ANY`
            
            DNS query types in the request query. Enum options -
            DNS_RECORD_OTHER, DNS_RECORD_A, DNS_RECORD_NS, DNS_RECORD_CNAME,
            DNS_RECORD_SOA, DNS_RECORD_PTR, DNS_RECORD_HINFO, DNS_RECORD_MX,
            DNS_RECORD_TXT, DNS_RECORD_RP, DNS_RECORD_DNSKEY, DNS_RECORD_AAAA,
            DNS_RECORD_SRV, DNS_RECORD_OPT, DNS_RECORD_RRSIG, DNS_RECORD_AXFR,
            DNS_RECORD_ANY.
        """
        self.match_criteria = match_criteria
        self.query_type = query_type
        VapiStruct.__init__(self)


ALBDnsQueryTypeMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_query_type_match', {
        'match_criteria': type.OptionalType(type.StringType()),
        'query_type': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBDnsQueryTypeMatch,
    False,
    None))



class ALBDnsRateLimiter(VapiStruct):
    """
    Advanced load balancer DnsRateLimiter object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'rate_limiter_object': 'rate_limiter_object',
                            }

    def __init__(self,
                 action=None,
                 rate_limiter_object=None,
                ):
        """
        :type  action: :class:`ALBDnsRuleRLAction` or ``None``
        :param action: 
        :type  rate_limiter_object: :class:`ALBRateLimiter` or ``None``
        :param rate_limiter_object: 
        """
        self.action = action
        self.rate_limiter_object = rate_limiter_object
        VapiStruct.__init__(self)


ALBDnsRateLimiter._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rate_limiter', {
        'action': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRuleRLAction')),
        'rate_limiter_object': type.OptionalType(type.ReferenceType(__name__, 'ALBRateLimiter')),
    },
    ALBDnsRateLimiter,
    False,
    None))



class ALBDnsRecord(VapiStruct):
    """
    Advanced load balancer DnsRecord object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ALGORITHM_ROUND_ROBIN = "DNS_RECORD_RESPONSE_ROUND_ROBIN"
    """


    """
    ALGORITHM_CONSISTENT_HASH = "DNS_RECORD_RESPONSE_CONSISTENT_HASH"
    """


    """
    TYPE_OTHER = "DNS_RECORD_OTHER"
    """


    """
    TYPE_A = "DNS_RECORD_A"
    """


    """
    TYPE_NS = "DNS_RECORD_NS"
    """


    """
    TYPE_CNAME = "DNS_RECORD_CNAME"
    """


    """
    TYPE_SOA = "DNS_RECORD_SOA"
    """


    """
    TYPE_PTR = "DNS_RECORD_PTR"
    """


    """
    TYPE_HINFO = "DNS_RECORD_HINFO"
    """


    """
    TYPE_MX = "DNS_RECORD_MX"
    """


    """
    TYPE_TXT = "DNS_RECORD_TXT"
    """


    """
    TYPE_RP = "DNS_RECORD_RP"
    """


    """
    TYPE_DNSKEY = "DNS_RECORD_DNSKEY"
    """


    """
    TYPE_AAAA = "DNS_RECORD_AAAA"
    """


    """
    TYPE_SRV = "DNS_RECORD_SRV"
    """


    """
    TYPE_OPT = "DNS_RECORD_OPT"
    """


    """
    TYPE_RRSIG = "DNS_RECORD_RRSIG"
    """


    """
    TYPE_AXFR = "DNS_RECORD_AXFR"
    """


    """
    TYPE_ANY = "DNS_RECORD_ANY"
    """


    """



    _canonical_to_pep_names = {
                            'algorithm': 'algorithm',
                            'cname': 'cname',
                            'delegated': 'delegated',
                            'description': 'description',
                            'fqdn': 'fqdn',
                            'ip6_address': 'ip6_address',
                            'ip_address': 'ip_address',
                            'metadata': 'metadata',
                            'mx_records': 'mx_records',
                            'ns': 'ns',
                            'num_records_in_response': 'num_records_in_response',
                            'service_locator': 'service_locator',
                            'ttl': 'ttl',
                            'txt_records': 'txt_records',
                            'type': 'type',
                            'wildcard_match': 'wildcard_match',
                            }

    def __init__(self,
                 algorithm=None,
                 cname=None,
                 delegated=None,
                 description=None,
                 fqdn=None,
                 ip6_address=None,
                 ip_address=None,
                 metadata=None,
                 mx_records=None,
                 ns=None,
                 num_records_in_response=None,
                 service_locator=None,
                 ttl=None,
                 txt_records=None,
                 type=None,
                 wildcard_match=None,
                ):
        """
        :type  algorithm: :class:`str` or ``None``
        :param algorithm: Possible values are: 
            
            * :attr:`ALBDnsRecord.ALGORITHM_ROUND_ROBIN`
            * :attr:`ALBDnsRecord.ALGORITHM_CONSISTENT_HASH`
            
            Specifies the algorithm to pick the IP address(es) to be returned,
            when multiple entries are configured. This does not apply if
            num_records_in_response is 0. Default is round-robin. Enum options
            - DNS_RECORD_RESPONSE_ROUND_ROBIN,
            DNS_RECORD_RESPONSE_CONSISTENT_HASH. Default value when not
            specified in API or module is interpreted by ALB Controller as
            DNS_RECORD_RESPONSE_ROUND_ROBIN.
        :type  cname: :class:`ALBDnsCnameRdata` or ``None``
        :param cname: 
        :type  delegated: :class:`bool` or ``None``
        :param delegated: Configured FQDNs are delegated domains (i.e. they represent a zone
            cut). Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  description: :class:`str` or ``None``
        :param description: Details of DNS record.
        :type  fqdn: :class:`list` of :class:`str` or ``None``
        :param fqdn: Fully Qualified Domain Name. Minimum of 1 items required.
        :type  ip6_address: :class:`list` of :class:`ALBDnsAAAARdata` or ``None``
        :param ip6_address: IPv6 address in AAAA record. Maximum of 4 items allowed.
        :type  ip_address: :class:`list` of :class:`ALBDnsaRdata` or ``None``
        :param ip_address: IP address in A record. Maximum of 4 items allowed.
        :type  metadata: :class:`str` or ``None``
        :param metadata: Internal metadata for the DNS record.
        :type  mx_records: :class:`list` of :class:`ALBDnsMxRdata` or ``None``
        :param mx_records: MX record. Maximum of 4 items allowed.
        :type  ns: :class:`list` of :class:`ALBDnsNsRdata` or ``None``
        :param ns: Name Server information in NS record. Maximum of 13 items allowed.
        :type  num_records_in_response: :class:`long` or ``None``
        :param num_records_in_response: Specifies the number of records returned by the DNS service. Enter
            0 to return all records. Default is 0. Allowed values are 0-20.
            Special values are 0- 'Return all records'. Default value when not
            specified in API or module is interpreted by ALB Controller as 0.
            format: int64
        :type  service_locator: :class:`list` of :class:`ALBDnsSrvRdata` or ``None``
        :param service_locator: Service locator info in SRV record. Maximum of 4 items allowed.
        :type  ttl: :class:`long` or ``None``
        :param ttl: Time To Live for this DNS record. format: int64
        :type  txt_records: :class:`list` of :class:`ALBDnsTxtRdata` or ``None``
        :param txt_records: Text record. Maximum of 4 items allowed.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBDnsRecord.TYPE_OTHER`
            * :attr:`ALBDnsRecord.TYPE_A`
            * :attr:`ALBDnsRecord.TYPE_NS`
            * :attr:`ALBDnsRecord.TYPE_CNAME`
            * :attr:`ALBDnsRecord.TYPE_SOA`
            * :attr:`ALBDnsRecord.TYPE_PTR`
            * :attr:`ALBDnsRecord.TYPE_HINFO`
            * :attr:`ALBDnsRecord.TYPE_MX`
            * :attr:`ALBDnsRecord.TYPE_TXT`
            * :attr:`ALBDnsRecord.TYPE_RP`
            * :attr:`ALBDnsRecord.TYPE_DNSKEY`
            * :attr:`ALBDnsRecord.TYPE_AAAA`
            * :attr:`ALBDnsRecord.TYPE_SRV`
            * :attr:`ALBDnsRecord.TYPE_OPT`
            * :attr:`ALBDnsRecord.TYPE_RRSIG`
            * :attr:`ALBDnsRecord.TYPE_AXFR`
            * :attr:`ALBDnsRecord.TYPE_ANY`
            
            DNS record type. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A,
            DNS_RECORD_NS, DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR,
            DNS_RECORD_HINFO, DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP,
            DNS_RECORD_DNSKEY, DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT,
            DNS_RECORD_RRSIG, DNS_RECORD_AXFR, DNS_RECORD_ANY.
        :type  wildcard_match: :class:`bool` or ``None``
        :param wildcard_match: Enable wild-card match of fqdn if an exact match is not found in
            the DNS table, the longest match is chosen by wild-carding the fqdn
            in the DNS request. Default is false. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        """
        self.algorithm = algorithm
        self.cname = cname
        self.delegated = delegated
        self.description = description
        self.fqdn = fqdn
        self.ip6_address = ip6_address
        self.ip_address = ip_address
        self.metadata = metadata
        self.mx_records = mx_records
        self.ns = ns
        self.num_records_in_response = num_records_in_response
        self.service_locator = service_locator
        self.ttl = ttl
        self.txt_records = txt_records
        self.type = type
        self.wildcard_match = wildcard_match
        VapiStruct.__init__(self)


ALBDnsRecord._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_record', {
        'algorithm': type.OptionalType(type.StringType()),
        'cname': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsCnameRdata')),
        'delegated': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'fqdn': type.OptionalType(type.ListType(type.StringType())),
        'ip6_address': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsAAAARdata'))),
        'ip_address': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsaRdata'))),
        'metadata': type.OptionalType(type.StringType()),
        'mx_records': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsMxRdata'))),
        'ns': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsNsRdata'))),
        'num_records_in_response': type.OptionalType(type.IntegerType()),
        'service_locator': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsSrvRdata'))),
        'ttl': type.OptionalType(type.IntegerType()),
        'txt_records': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsTxtRdata'))),
        'type': type.OptionalType(type.StringType()),
        'wildcard_match': type.OptionalType(type.BooleanType()),
    },
    ALBDnsRecord,
    False,
    None))



class ALBDnsRrSet(VapiStruct):
    """
    Advanced load balancer DnsRrSet object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_OTHER = "DNS_RECORD_OTHER"
    """


    """
    TYPE_A = "DNS_RECORD_A"
    """


    """
    TYPE_NS = "DNS_RECORD_NS"
    """


    """
    TYPE_CNAME = "DNS_RECORD_CNAME"
    """


    """
    TYPE_SOA = "DNS_RECORD_SOA"
    """


    """
    TYPE_PTR = "DNS_RECORD_PTR"
    """


    """
    TYPE_HINFO = "DNS_RECORD_HINFO"
    """


    """
    TYPE_MX = "DNS_RECORD_MX"
    """


    """
    TYPE_TXT = "DNS_RECORD_TXT"
    """


    """
    TYPE_RP = "DNS_RECORD_RP"
    """


    """
    TYPE_DNSKEY = "DNS_RECORD_DNSKEY"
    """


    """
    TYPE_AAAA = "DNS_RECORD_AAAA"
    """


    """
    TYPE_SRV = "DNS_RECORD_SRV"
    """


    """
    TYPE_OPT = "DNS_RECORD_OPT"
    """


    """
    TYPE_RRSIG = "DNS_RECORD_RRSIG"
    """


    """
    TYPE_AXFR = "DNS_RECORD_AXFR"
    """


    """
    TYPE_ANY = "DNS_RECORD_ANY"
    """


    """



    _canonical_to_pep_names = {
                            'cname': 'cname',
                            'fqdn': 'fqdn',
                            'ip6_addresses': 'ip6_addresses',
                            'ip_addresses': 'ip_addresses',
                            'nses': 'nses',
                            'ttl': 'ttl',
                            'type': 'type',
                            }

    def __init__(self,
                 cname=None,
                 fqdn=None,
                 ip6_addresses=None,
                 ip_addresses=None,
                 nses=None,
                 ttl=None,
                 type=None,
                ):
        """
        :type  cname: :class:`ALBDnsCnameRdata` or ``None``
        :param cname: 
        :type  fqdn: :class:`str` or ``None``
        :param fqdn: Fully Qualified Domain Name.
        :type  ip6_addresses: :class:`list` of :class:`ALBDnsAAAARdata` or ``None``
        :param ip6_addresses: IPv6 address in AAAA record.
        :type  ip_addresses: :class:`list` of :class:`ALBDnsaRdata` or ``None``
        :param ip_addresses: IP address in A record.
        :type  nses: :class:`list` of :class:`ALBDnsNsRdata` or ``None``
        :param nses: Name Server information in NS record.
        :type  ttl: :class:`long` or ``None``
        :param ttl: Time To Live for this DNS record. Allowed values are 0-2147483647.
            format: int64
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBDnsRrSet.TYPE_OTHER`
            * :attr:`ALBDnsRrSet.TYPE_A`
            * :attr:`ALBDnsRrSet.TYPE_NS`
            * :attr:`ALBDnsRrSet.TYPE_CNAME`
            * :attr:`ALBDnsRrSet.TYPE_SOA`
            * :attr:`ALBDnsRrSet.TYPE_PTR`
            * :attr:`ALBDnsRrSet.TYPE_HINFO`
            * :attr:`ALBDnsRrSet.TYPE_MX`
            * :attr:`ALBDnsRrSet.TYPE_TXT`
            * :attr:`ALBDnsRrSet.TYPE_RP`
            * :attr:`ALBDnsRrSet.TYPE_DNSKEY`
            * :attr:`ALBDnsRrSet.TYPE_AAAA`
            * :attr:`ALBDnsRrSet.TYPE_SRV`
            * :attr:`ALBDnsRrSet.TYPE_OPT`
            * :attr:`ALBDnsRrSet.TYPE_RRSIG`
            * :attr:`ALBDnsRrSet.TYPE_AXFR`
            * :attr:`ALBDnsRrSet.TYPE_ANY`
            
            DNS record type. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A,
            DNS_RECORD_NS, DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR,
            DNS_RECORD_HINFO, DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP,
            DNS_RECORD_DNSKEY, DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT,
            DNS_RECORD_RRSIG, DNS_RECORD_AXFR, DNS_RECORD_ANY.
        """
        self.cname = cname
        self.fqdn = fqdn
        self.ip6_addresses = ip6_addresses
        self.ip_addresses = ip_addresses
        self.nses = nses
        self.ttl = ttl
        self.type = type
        VapiStruct.__init__(self)


ALBDnsRrSet._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rr_set', {
        'cname': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsCnameRdata')),
        'fqdn': type.OptionalType(type.StringType()),
        'ip6_addresses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsAAAARdata'))),
        'ip_addresses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsaRdata'))),
        'nses': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsNsRdata'))),
        'ttl': type.OptionalType(type.IntegerType()),
        'type': type.OptionalType(type.StringType()),
    },
    ALBDnsRrSet,
    False,
    None))



class ALBDnsRule(VapiStruct):
    """
    Advanced load balancer DnsRule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'enable': 'enable',
                            'index': 'index',
                            'log': 'log',
                            'match': 'match',
                            'name': 'name',
                            }

    def __init__(self,
                 action=None,
                 enable=None,
                 index=None,
                 log=None,
                 match=None,
                 name=None,
                ):
        """
        :type  action: :class:`ALBDnsRuleAction` or ``None``
        :param action: 
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable the rule. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  index: :class:`long` or ``None``
        :param index: Index of the rule. format: int64
        :type  log: :class:`bool` or ``None``
        :param log: Log DNS query upon rule match.
        :type  match: :class:`ALBDnsRuleMatchTarget` or ``None``
        :param match: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the rule.
        """
        self.action = action
        self.enable = enable
        self.index = index
        self.log = log
        self.match = match
        self.name = name
        VapiStruct.__init__(self)


ALBDnsRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule', {
        'action': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRuleAction')),
        'enable': type.OptionalType(type.BooleanType()),
        'index': type.OptionalType(type.IntegerType()),
        'log': type.OptionalType(type.BooleanType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRuleMatchTarget')),
        'name': type.OptionalType(type.StringType()),
    },
    ALBDnsRule,
    False,
    None))



class ALBDnsRuleAction(VapiStruct):
    """
    Advanced load balancer DnsRuleAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'allow': 'allow',
                            'dns_rate_limiter': 'dns_rate_limiter',
                            'gslb_site_selection': 'gslb_site_selection',
                            'pool_switching': 'pool_switching',
                            'response': 'response',
                            }

    def __init__(self,
                 allow=None,
                 dns_rate_limiter=None,
                 gslb_site_selection=None,
                 pool_switching=None,
                 response=None,
                ):
        """
        :type  allow: :class:`ALBDnsRuleActionAllowDrop` or ``None``
        :param allow: 
        :type  dns_rate_limiter: :class:`ALBDnsRateLimiter` or ``None``
        :param dns_rate_limiter: 
        :type  gslb_site_selection: :class:`ALBDnsRuleActionGslbSiteSelection` or ``None``
        :param gslb_site_selection: 
        :type  pool_switching: :class:`ALBDnsRuleActionPoolSwitching` or ``None``
        :param pool_switching: 
        :type  response: :class:`ALBDnsRuleActionResponse` or ``None``
        :param response: 
        """
        self.allow = allow
        self.dns_rate_limiter = dns_rate_limiter
        self.gslb_site_selection = gslb_site_selection
        self.pool_switching = pool_switching
        self.response = response
        VapiStruct.__init__(self)


ALBDnsRuleAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule_action', {
        'allow': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRuleActionAllowDrop')),
        'dns_rate_limiter': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRateLimiter')),
        'gslb_site_selection': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRuleActionGslbSiteSelection')),
        'pool_switching': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRuleActionPoolSwitching')),
        'response': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRuleActionResponse')),
    },
    ALBDnsRuleAction,
    False,
    None))



class ALBDnsRuleActionAllowDrop(VapiStruct):
    """
    Advanced load balancer DnsRuleActionAllowDrop object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'allow': 'allow',
                            'reset_conn': 'reset_conn',
                            }

    def __init__(self,
                 allow=None,
                 reset_conn=None,
                ):
        """
        :type  allow: :class:`bool` or ``None``
        :param allow: Allow the DNS query. Default value when not specified in API or
            module is interpreted by ALB Controller as true.
        :type  reset_conn: :class:`bool` or ``None``
        :param reset_conn: Reset the TCP connection of the DNS query, if allow is set to false
            to drop the query. Default value when not specified in API or
            module is interpreted by ALB Controller as true.
        """
        self.allow = allow
        self.reset_conn = reset_conn
        VapiStruct.__init__(self)


ALBDnsRuleActionAllowDrop._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule_action_allow_drop', {
        'allow': type.OptionalType(type.BooleanType()),
        'reset_conn': type.OptionalType(type.BooleanType()),
    },
    ALBDnsRuleActionAllowDrop,
    False,
    None))



class ALBDnsRuleActionGslbSiteSelection(VapiStruct):
    """
    Advanced load balancer DnsRuleActionGslbSiteSelection object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'fallback_site_names': 'fallback_site_names',
                            'is_site_preferred': 'is_site_preferred',
                            'site_name': 'site_name',
                            }

    def __init__(self,
                 fallback_site_names=None,
                 is_site_preferred=None,
                 site_name=None,
                ):
        """
        :type  fallback_site_names: :class:`list` of :class:`str` or ``None``
        :param fallback_site_names: GSLB fallback sites to use in case the desired site is down.
            Maximum of 64 items allowed.
        :type  is_site_preferred: :class:`bool` or ``None``
        :param is_site_preferred: When set to true, GSLB site is a preferred site. This setting comes
            into play when the site is down, as well as no configured fallback
            site is available (all fallback sites are also down), then any one
            available site is selected based on the default algorithm for GSLB
            pool member selection. Default value when not specified in API or
            module is interpreted by ALB Controller as true.
        :type  site_name: :class:`str` or ``None``
        :param site_name: GSLB site name.
        """
        self.fallback_site_names = fallback_site_names
        self.is_site_preferred = is_site_preferred
        self.site_name = site_name
        VapiStruct.__init__(self)


ALBDnsRuleActionGslbSiteSelection._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule_action_gslb_site_selection', {
        'fallback_site_names': type.OptionalType(type.ListType(type.StringType())),
        'is_site_preferred': type.OptionalType(type.BooleanType()),
        'site_name': type.OptionalType(type.StringType()),
    },
    ALBDnsRuleActionGslbSiteSelection,
    False,
    None))



class ALBDnsRuleActionPoolSwitching(VapiStruct):
    """
    Advanced load balancer DnsRuleActionPoolSwitching object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'pool_group_path': 'pool_group_path',
                            'pool_path': 'pool_path',
                            }

    def __init__(self,
                 pool_group_path=None,
                 pool_path=None,
                ):
        """
        :type  pool_group_path: :class:`str` or ``None``
        :param pool_group_path: Reference of the pool group to serve the passthrough DNS query
            which cannot be served locally. It is a reference to an object of
            type PoolGroup.
        :type  pool_path: :class:`str` or ``None``
        :param pool_path: Reference of the pool to serve the passthrough DNS query which
            cannot be served locally. It is a reference to an object of type
            Pool.
        """
        self.pool_group_path = pool_group_path
        self.pool_path = pool_path
        VapiStruct.__init__(self)


ALBDnsRuleActionPoolSwitching._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule_action_pool_switching', {
        'pool_group_path': type.OptionalType(type.StringType()),
        'pool_path': type.OptionalType(type.StringType()),
    },
    ALBDnsRuleActionPoolSwitching,
    False,
    None))



class ALBDnsRuleActionResponse(VapiStruct):
    """
    Advanced load balancer DnsRuleActionResponse object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RCODE_NOERROR = "DNS_RCODE_NOERROR"
    """


    """
    RCODE_FORMERR = "DNS_RCODE_FORMERR"
    """


    """
    RCODE_SERVFAIL = "DNS_RCODE_SERVFAIL"
    """


    """
    RCODE_NXDOMAIN = "DNS_RCODE_NXDOMAIN"
    """


    """
    RCODE_NOTIMP = "DNS_RCODE_NOTIMP"
    """


    """
    RCODE_REFUSED = "DNS_RCODE_REFUSED"
    """


    """
    RCODE_YXDOMAIN = "DNS_RCODE_YXDOMAIN"
    """


    """
    RCODE_YXRRSET = "DNS_RCODE_YXRRSET"
    """


    """
    RCODE_NXRRSET = "DNS_RCODE_NXRRSET"
    """


    """
    RCODE_NOTAUTH = "DNS_RCODE_NOTAUTH"
    """


    """
    RCODE_NOTZONE = "DNS_RCODE_NOTZONE"
    """


    """



    _canonical_to_pep_names = {
                            'authoritative': 'authoritative',
                            'rcode': 'rcode',
                            'resource_record_sets': 'resource_record_sets',
                            'truncation': 'truncation',
                            }

    def __init__(self,
                 authoritative=None,
                 rcode=None,
                 resource_record_sets=None,
                 truncation=None,
                ):
        """
        :type  authoritative: :class:`bool` or ``None``
        :param authoritative: DNS response is authoritative. Default value when not specified in
            API or module is interpreted by ALB Controller as true.
        :type  rcode: :class:`str` or ``None``
        :param rcode: Possible values are: 
            
            * :attr:`ALBDnsRuleActionResponse.RCODE_NOERROR`
            * :attr:`ALBDnsRuleActionResponse.RCODE_FORMERR`
            * :attr:`ALBDnsRuleActionResponse.RCODE_SERVFAIL`
            * :attr:`ALBDnsRuleActionResponse.RCODE_NXDOMAIN`
            * :attr:`ALBDnsRuleActionResponse.RCODE_NOTIMP`
            * :attr:`ALBDnsRuleActionResponse.RCODE_REFUSED`
            * :attr:`ALBDnsRuleActionResponse.RCODE_YXDOMAIN`
            * :attr:`ALBDnsRuleActionResponse.RCODE_YXRRSET`
            * :attr:`ALBDnsRuleActionResponse.RCODE_NXRRSET`
            * :attr:`ALBDnsRuleActionResponse.RCODE_NOTAUTH`
            * :attr:`ALBDnsRuleActionResponse.RCODE_NOTZONE`
            
            DNS response code. Enum options - DNS_RCODE_NOERROR,
            DNS_RCODE_FORMERR, DNS_RCODE_SERVFAIL, DNS_RCODE_NXDOMAIN,
            DNS_RCODE_NOTIMP, DNS_RCODE_REFUSED, DNS_RCODE_YXDOMAIN,
            DNS_RCODE_YXRRSET, DNS_RCODE_NXRRSET, DNS_RCODE_NOTAUTH,
            DNS_RCODE_NOTZONE. Default value when not specified in API or
            module is interpreted by ALB Controller as DNS_RCODE_NOERROR.
        :type  resource_record_sets: :class:`list` of :class:`ALBDnsRuleDnsRrSet` or ``None``
        :param resource_record_sets: DNS resource record sets - (resource record set share the DNS
            domain name, type, and class).
        :type  truncation: :class:`bool` or ``None``
        :param truncation: DNS response is truncated. Default value when not specified in API
            or module is interpreted by ALB Controller as false.
        """
        self.authoritative = authoritative
        self.rcode = rcode
        self.resource_record_sets = resource_record_sets
        self.truncation = truncation
        VapiStruct.__init__(self)


ALBDnsRuleActionResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule_action_response', {
        'authoritative': type.OptionalType(type.BooleanType()),
        'rcode': type.OptionalType(type.StringType()),
        'resource_record_sets': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsRuleDnsRrSet'))),
        'truncation': type.OptionalType(type.BooleanType()),
    },
    ALBDnsRuleActionResponse,
    False,
    None))



class ALBDnsRuleDnsRrSet(VapiStruct):
    """
    Advanced load balancer DnsRuleDnsRrSet object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SECTION_QUESTION = "DNS_MESSAGE_SECTION_QUESTION"
    """


    """
    SECTION_ANSWER = "DNS_MESSAGE_SECTION_ANSWER"
    """


    """
    SECTION_AUTHORITY = "DNS_MESSAGE_SECTION_AUTHORITY"
    """


    """
    SECTION_ADDITIONAL = "DNS_MESSAGE_SECTION_ADDITIONAL"
    """


    """



    _canonical_to_pep_names = {
                            'resource_record_set': 'resource_record_set',
                            'section': 'section',
                            }

    def __init__(self,
                 resource_record_set=None,
                 section=None,
                ):
        """
        :type  resource_record_set: :class:`ALBDnsRrSet` or ``None``
        :param resource_record_set: 
        :type  section: :class:`str` or ``None``
        :param section: Possible values are: 
            
            * :attr:`ALBDnsRuleDnsRrSet.SECTION_QUESTION`
            * :attr:`ALBDnsRuleDnsRrSet.SECTION_ANSWER`
            * :attr:`ALBDnsRuleDnsRrSet.SECTION_AUTHORITY`
            * :attr:`ALBDnsRuleDnsRrSet.SECTION_ADDITIONAL`
            
            DNS message section for the resource record set. Enum options -
            DNS_MESSAGE_SECTION_QUESTION, DNS_MESSAGE_SECTION_ANSWER,
            DNS_MESSAGE_SECTION_AUTHORITY, DNS_MESSAGE_SECTION_ADDITIONAL.
            Default value when not specified in API or module is interpreted by
            ALB Controller as DNS_MESSAGE_SECTION_ANSWER.
        """
        self.resource_record_set = resource_record_set
        self.section = section
        VapiStruct.__init__(self)


ALBDnsRuleDnsRrSet._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule_dns_rr_set', {
        'resource_record_set': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsRrSet')),
        'section': type.OptionalType(type.StringType()),
    },
    ALBDnsRuleDnsRrSet,
    False,
    None))



class ALBDnsRuleMatchTarget(VapiStruct):
    """
    Advanced load balancer DnsRuleMatchTarget object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_ip_address': 'client_ip_address',
                            'geo_location': 'geo_location',
                            'protocol': 'protocol',
                            'query_name': 'query_name',
                            'query_type': 'query_type',
                            }

    def __init__(self,
                 client_ip_address=None,
                 geo_location=None,
                 protocol=None,
                 query_name=None,
                 query_type=None,
                ):
        """
        :type  client_ip_address: :class:`ALBDnsClientIpMatch` or ``None``
        :param client_ip_address: 
        :type  geo_location: :class:`ALBDnsGeoLocationMatch` or ``None``
        :param geo_location: 
        :type  protocol: :class:`ALBDnsTransportProtocolMatch` or ``None``
        :param protocol: 
        :type  query_name: :class:`ALBDnsQueryNameMatch` or ``None``
        :param query_name: 
        :type  query_type: :class:`ALBDnsQueryTypeMatch` or ``None``
        :param query_type: 
        """
        self.client_ip_address = client_ip_address
        self.geo_location = geo_location
        self.protocol = protocol
        self.query_name = query_name
        self.query_type = query_type
        VapiStruct.__init__(self)


ALBDnsRuleMatchTarget._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule_match_target', {
        'client_ip_address': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsClientIpMatch')),
        'geo_location': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsGeoLocationMatch')),
        'protocol': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsTransportProtocolMatch')),
        'query_name': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsQueryNameMatch')),
        'query_type': type.OptionalType(type.ReferenceType(__name__, 'ALBDnsQueryTypeMatch')),
    },
    ALBDnsRuleMatchTarget,
    False,
    None))



class ALBDnsRuleRLAction(VapiStruct):
    """
    Advanced load balancer DnsRuleRLAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_NONE = "DNS_RL_ACTION_NONE"
    """


    """
    TYPE_DROP_REQ = "DNS_RL_ACTION_DROP_REQ"
    """


    """



    _canonical_to_pep_names = {
                            'type': 'type',
                            }

    def __init__(self,
                 type=None,
                ):
        """
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBDnsRuleRLAction.TYPE_NONE`
            * :attr:`ALBDnsRuleRLAction.TYPE_DROP_REQ`
            
            Type of action to be enforced upon hitting the rate limit. Enum
            options - DNS_RL_ACTION_NONE, DNS_RL_ACTION_DROP_REQ. Default value
            when not specified in API or module is interpreted by ALB
            Controller as DNS_RL_ACTION_NONE.
        """
        self.type = type
        VapiStruct.__init__(self)


ALBDnsRuleRLAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_rule_RL_action', {
        'type': type.OptionalType(type.StringType()),
    },
    ALBDnsRuleRLAction,
    False,
    None))



class ALBDnsServiceApplicationProfile(VapiStruct):
    """
    Advanced load balancer DnsServiceApplicationProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ERROR_RESPONSE_ERROR = "DNS_ERROR_RESPONSE_ERROR"
    """


    """
    ERROR_RESPONSE_NONE = "DNS_ERROR_RESPONSE_NONE"
    """


    """



    _canonical_to_pep_names = {
                            'aaaa_empty_response': 'aaaa_empty_response',
                            'admin_email': 'admin_email',
                            'dns_over_tcp_enabled': 'dns_over_tcp_enabled',
                            'dns_zones': 'dns_zones',
                            'domain_names': 'domain_names',
                            'ecs_stripping_enabled': 'ecs_stripping_enabled',
                            'edns': 'edns',
                            'edns_client_subnet_prefix_len': 'edns_client_subnet_prefix_len',
                            'error_response': 'error_response',
                            'name_server': 'name_server',
                            'negative_caching_ttl': 'negative_caching_ttl',
                            'num_dns_ip': 'num_dns_ip',
                            'ttl': 'ttl',
                            }

    def __init__(self,
                 aaaa_empty_response=None,
                 admin_email=None,
                 dns_over_tcp_enabled=None,
                 dns_zones=None,
                 domain_names=None,
                 ecs_stripping_enabled=None,
                 edns=None,
                 edns_client_subnet_prefix_len=None,
                 error_response=None,
                 name_server=None,
                 negative_caching_ttl=None,
                 num_dns_ip=None,
                 ttl=None,
                ):
        """
        :type  aaaa_empty_response: :class:`bool` or ``None``
        :param aaaa_empty_response: Respond to AAAA queries with empty response when there are only
            IPV4 records. Default value when not specified in API or module is
            interpreted by ALB Controller as true.
        :type  admin_email: :class:`str` or ``None``
        :param admin_email: Email address of the administrator responsible for this zone. This
            field is used in SOA records (rname) pertaining to all domain names
            specified as authoritative domain names. If not configured, the
            default value 'hostmaster' is used in SOA responses. Default value
            when not specified in API or module is interpreted by ALB
            Controller as hostmaster.
        :type  dns_over_tcp_enabled: :class:`bool` or ``None``
        :param dns_over_tcp_enabled: Enable DNS query/response over TCP. This enables analytics for
            pass-through queries as well. Default value when not specified in
            API or module is interpreted by ALB Controller as true.
        :type  dns_zones: :class:`list` of :class:`ALBDnsZone` or ``None``
        :param dns_zones: DNS zones hosted on this Virtual Service. Maximum of 100 items
            allowed.
        :type  domain_names: :class:`list` of :class:`str` or ``None``
        :param domain_names: Subdomain names serviced by this Virtual Service. These are
            configured as Ends-With semantics. Maximum of 100 items allowed.
        :type  ecs_stripping_enabled: :class:`bool` or ``None``
        :param ecs_stripping_enabled: Enable stripping of EDNS client subnet (ecs) option towards client
            if DNS service inserts ecs option in the DNS query towards upstream
            servers. Default value when not specified in API or module is
            interpreted by ALB Controller as true.
        :type  edns: :class:`bool` or ``None``
        :param edns: Enable DNS service to be aware of EDNS (Extension mechanism for
            DNS). EDNS extensions are parsed and shown in logs. For GSLB
            services, the EDNS client subnet option can be used to influence
            Load Balancing. Default value when not specified in API or module
            is interpreted by ALB Controller as true.
        :type  edns_client_subnet_prefix_len: :class:`long` or ``None``
        :param edns_client_subnet_prefix_len: Specifies the IP address prefix length to use in the EDNS client
            subnet (ECS) option. When the incoming request does not have any
            ECS option and the prefix length is specified, an ECS option is
            inserted in the request passed to upstream server. If the incoming
            request already has an ECS option, the prefix length (and
            correspondingly the address) in the ECS option is updated, with the
            minimum of the prefix length present in the incoming and the
            configured prefix length, before passing the request to upstream
            server. Allowed values are 1-32. format: int64
        :type  error_response: :class:`str` or ``None``
        :param error_response: Possible values are: 
            
            * :attr:`ALBDnsServiceApplicationProfile.ERROR_RESPONSE_ERROR`
            * :attr:`ALBDnsServiceApplicationProfile.ERROR_RESPONSE_NONE`
            
            Drop or respond to client when the DNS service encounters an error
            processing a client query. By default, such a request is dropped
            without any response, or passed through to a passthrough pool, if
            configured. When set to respond, an appropriate response is sent to
            client, e.g. NXDOMAIN response for non-existent records, empty
            NOERROR response for unsupported queries, etc. Enum options -
            DNS_ERROR_RESPONSE_ERROR, DNS_ERROR_RESPONSE_NONE. Default value
            when not specified in API or module is interpreted by ALB
            Controller as DNS_ERROR_RESPONSE_NONE.
        :type  name_server: :class:`str` or ``None``
        :param name_server: 
        :type  negative_caching_ttl: :class:`long` or ``None``
        :param negative_caching_ttl: Specifies the TTL value (in seconds) for SOA (Start of Authority)
            (corresponding to a authoritative domain owned by this DNS Virtual
            Service) record's minimum TTL served by the DNS Virtual Service.
            Allowed values are 0-86400. Unit is SEC. Default value when not
            specified in API or module is interpreted by ALB Controller as 30.
            format: int64
        :type  num_dns_ip: :class:`long` or ``None``
        :param num_dns_ip: Specifies the number of IP addresses returned by the DNS Service.
            Enter 0 to return all IP addresses. Allowed values are 1-20.
            Special values are 0- 'Return all IP addresses'. Default value when
            not specified in API or module is interpreted by ALB Controller as
            1. format: int64
        :type  ttl: :class:`long` or ``None``
        :param ttl: Specifies the TTL value (in seconds) for records served by DNS
            Service. Allowed values are 0-86400. Unit is SEC. Default value
            when not specified in API or module is interpreted by ALB
            Controller as 30. format: int64
        """
        self.aaaa_empty_response = aaaa_empty_response
        self.admin_email = admin_email
        self.dns_over_tcp_enabled = dns_over_tcp_enabled
        self.dns_zones = dns_zones
        self.domain_names = domain_names
        self.ecs_stripping_enabled = ecs_stripping_enabled
        self.edns = edns
        self.edns_client_subnet_prefix_len = edns_client_subnet_prefix_len
        self.error_response = error_response
        self.name_server = name_server
        self.negative_caching_ttl = negative_caching_ttl
        self.num_dns_ip = num_dns_ip
        self.ttl = ttl
        VapiStruct.__init__(self)


ALBDnsServiceApplicationProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_service_application_profile', {
        'aaaa_empty_response': type.OptionalType(type.BooleanType()),
        'admin_email': type.OptionalType(type.StringType()),
        'dns_over_tcp_enabled': type.OptionalType(type.BooleanType()),
        'dns_zones': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDnsZone'))),
        'domain_names': type.OptionalType(type.ListType(type.StringType())),
        'ecs_stripping_enabled': type.OptionalType(type.BooleanType()),
        'edns': type.OptionalType(type.BooleanType()),
        'edns_client_subnet_prefix_len': type.OptionalType(type.IntegerType()),
        'error_response': type.OptionalType(type.StringType()),
        'name_server': type.OptionalType(type.StringType()),
        'negative_caching_ttl': type.OptionalType(type.IntegerType()),
        'num_dns_ip': type.OptionalType(type.IntegerType()),
        'ttl': type.OptionalType(type.IntegerType()),
    },
    ALBDnsServiceApplicationProfile,
    False,
    None))



class ALBDnsSrvRdata(VapiStruct):
    """
    Advanced load balancer DnsSrvRdata object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'port': 'port',
                            'priority': 'priority',
                            'target': 'target',
                            'weight': 'weight',
                            }

    def __init__(self,
                 port=None,
                 priority=None,
                 target=None,
                 weight=None,
                ):
        """
        :type  port: :class:`long` or ``None``
        :param port: Service port. Allowed values are 0-65535. format: int64
        :type  priority: :class:`long` or ``None``
        :param priority: Priority of the target hosting the service, low value implies
            higher priority for this service record. Allowed values are
            0-65535. Default value when not specified in API or module is
            interpreted by ALB Controller as 0. format: int64
        :type  target: :class:`str` or ``None``
        :param target: Canonical hostname, of the machine hosting the service, with no
            trailing period. 'default.host' is valid but not 'default.host.'.
            Default value when not specified in API or module is interpreted by
            ALB Controller as default.host.
        :type  weight: :class:`long` or ``None``
        :param weight: Relative weight for service records with same priority, high value
            implies higher preference for this service record. Allowed values
            are 0-65535. Default value when not specified in API or module is
            interpreted by ALB Controller as 0. format: int64
        """
        self.port = port
        self.priority = priority
        self.target = target
        self.weight = weight
        VapiStruct.__init__(self)


ALBDnsSrvRdata._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_srv_rdata', {
        'port': type.OptionalType(type.IntegerType()),
        'priority': type.OptionalType(type.IntegerType()),
        'target': type.OptionalType(type.StringType()),
        'weight': type.OptionalType(type.IntegerType()),
    },
    ALBDnsSrvRdata,
    False,
    None))



class ALBDnsTransportProtocolMatch(VapiStruct):
    """
    Advanced load balancer DnsTransportProtocolMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """
    PROTOCOL_UDP = "DNS_OVER_UDP"
    """


    """
    PROTOCOL_TCP = "DNS_OVER_TCP"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            'protocol': 'protocol',
                            }

    def __init__(self,
                 match_criteria=None,
                 protocol=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBDnsTransportProtocolMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBDnsTransportProtocolMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for matching the DNS transport protocol. Enum
            options - IS_IN, IS_NOT_IN.
        :type  protocol: :class:`str` or ``None``
        :param protocol: Possible values are: 
            
            * :attr:`ALBDnsTransportProtocolMatch.PROTOCOL_UDP`
            * :attr:`ALBDnsTransportProtocolMatch.PROTOCOL_TCP`
            
            Protocol to match against transport protocol used by DNS query.
            Enum options - DNS_OVER_UDP, DNS_OVER_TCP.
        """
        self.match_criteria = match_criteria
        self.protocol = protocol
        VapiStruct.__init__(self)


ALBDnsTransportProtocolMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_transport_protocol_match', {
        'match_criteria': type.OptionalType(type.StringType()),
        'protocol': type.OptionalType(type.StringType()),
    },
    ALBDnsTransportProtocolMatch,
    False,
    None))



class ALBDnsTxtRdata(VapiStruct):
    """
    Advanced load balancer DnsTxtRdata object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'text_str': 'text_str',
                            }

    def __init__(self,
                 text_str=None,
                ):
        """
        :type  text_str: :class:`str` or ``None``
        :param text_str: Text data associated with the FQDN.
        """
        self.text_str = text_str
        VapiStruct.__init__(self)


ALBDnsTxtRdata._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_txt_rdata', {
        'text_str': type.OptionalType(type.StringType()),
    },
    ALBDnsTxtRdata,
    False,
    None))



class ALBDnsZone(VapiStruct):
    """
    Advanced load balancer DnsZone object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'admin_email': 'admin_email',
                            'domain_name': 'domain_name',
                            'name_server': 'name_server',
                            }

    def __init__(self,
                 admin_email=None,
                 domain_name=None,
                 name_server=None,
                ):
        """
        :type  admin_email: :class:`str` or ``None``
        :param admin_email: Email address of the administrator responsible for this zone. This
            field is used in SOA records as rname (RFC 1035). If not
            configured, it is inherited from the DNS service profile.
        :type  domain_name: :class:`str` or ``None``
        :param domain_name: Domain name authoritatively serviced by this Virtual Service.
            Queries for FQDNs that are sub domains of this domain and do not
            have any DNS record in Avi are dropped or NXDomain response sent.
            For domains which are present, SOA parameters are sent in answer
            section of response if query type is SOA.
        :type  name_server: :class:`str` or ``None``
        :param name_server: The primary name server for this zone. This field is used in SOA
            records as mname (RFC 1035). If not configured, it is inherited
            from the DNS service profile. If even that is not configured, the
            domain name is used instead.
        """
        self.admin_email = admin_email
        self.domain_name = domain_name
        self.name_server = name_server
        VapiStruct.__init__(self)


ALBDnsZone._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dns_zone', {
        'admin_email': type.OptionalType(type.StringType()),
        'domain_name': type.OptionalType(type.StringType()),
        'name_server': type.OptionalType(type.StringType()),
    },
    ALBDnsZone,
    False,
    None))



class ALBDosRateLimitProfile(VapiStruct):
    """
    Advanced load balancer DosRateLimitProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dos_profile': 'dos_profile',
                            'rl_profile': 'rl_profile',
                            }

    def __init__(self,
                 dos_profile=None,
                 rl_profile=None,
                ):
        """
        :type  dos_profile: :class:`ALBDosThresholdProfile` or ``None``
        :param dos_profile: 
        :type  rl_profile: :class:`ALBRateLimiterProfile` or ``None``
        :param rl_profile: 
        """
        self.dos_profile = dos_profile
        self.rl_profile = rl_profile
        VapiStruct.__init__(self)


ALBDosRateLimitProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dos_rate_limit_profile', {
        'dos_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBDosThresholdProfile')),
        'rl_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBRateLimiterProfile')),
    },
    ALBDosRateLimitProfile,
    False,
    None))



class ALBDosThreshold(VapiStruct):
    """
    Advanced load balancer DosThreshold object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ATTACK_LAND = "LAND"
    """


    """
    ATTACK_SMURF = "SMURF"
    """


    """
    ATTACK_ICMP_PING_FLOOD = "ICMP_PING_FLOOD"
    """


    """
    ATTACK_UNKOWN_PROTOCOL = "UNKOWN_PROTOCOL"
    """


    """
    ATTACK_TEARDROP = "TEARDROP"
    """


    """
    ATTACK_IP_FRAG_OVERRUN = "IP_FRAG_OVERRUN"
    """


    """
    ATTACK_IP_FRAG_TOOSMALL = "IP_FRAG_TOOSMALL"
    """


    """
    ATTACK_IP_FRAG_FULL = "IP_FRAG_FULL"
    """


    """
    ATTACK_IP_FRAG_INCOMPLETE = "IP_FRAG_INCOMPLETE"
    """


    """
    ATTACK_PORT_SCAN = "PORT_SCAN"
    """


    """
    ATTACK_TCP_NON_SYN_FLOOD_OLD = "TCP_NON_SYN_FLOOD_OLD"
    """


    """
    ATTACK_SYN_FLOOD = "SYN_FLOOD"
    """


    """
    ATTACK_BAD_RST_FLOOD = "BAD_RST_FLOOD"
    """


    """
    ATTACK_MALFORMED_FLOOD = "MALFORMED_FLOOD"
    """


    """
    ATTACK_FAKE_SESSION = "FAKE_SESSION"
    """


    """
    ATTACK_ZERO_WINDOW_STRESS = "ZERO_WINDOW_STRESS"
    """


    """
    ATTACK_SMALL_WINDOW_STRESS = "SMALL_WINDOW_STRESS"
    """


    """
    ATTACK_DOS_HTTP_TIMEOUT = "DOS_HTTP_TIMEOUT"
    """


    """
    ATTACK_DOS_HTTP_ERROR = "DOS_HTTP_ERROR"
    """


    """
    ATTACK_DOS_HTTP_ABORT = "DOS_HTTP_ABORT"
    """


    """
    ATTACK_DOS_SSL_ERROR = "DOS_SSL_ERROR"
    """


    """
    ATTACK_DOS_APP_ERROR = "DOS_APP_ERROR"
    """


    """
    ATTACK_DOS_REQ_IP_RL_DROP = "DOS_REQ_IP_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_URI_RL_DROP = "DOS_REQ_URI_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_URI_SCAN_BAD_RL_DROP = "DOS_REQ_URI_SCAN_BAD_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_URI_SCAN_UNKNOWN_RL_DROP = "DOS_REQ_URI_SCAN_UNKNOWN_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_IP_URI_RL_DROP = "DOS_REQ_IP_URI_RL_DROP"
    """


    """
    ATTACK_DOS_CONN_IP_RL_DROP = "DOS_CONN_IP_RL_DROP"
    """


    """
    ATTACK_DOS_SLOW_URL = "DOS_SLOW_URL"
    """


    """
    ATTACK_TCP_NON_SYN_FLOOD = "TCP_NON_SYN_FLOOD"
    """


    """
    ATTACK_DOS_REQ_CIP_SCAN_BAD_RL_DROP = "DOS_REQ_CIP_SCAN_BAD_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_CIP_SCAN_UNKNOWN_RL_DROP = "DOS_REQ_CIP_SCAN_UNKNOWN_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_IP_RL_DROP_BAD = "DOS_REQ_IP_RL_DROP_BAD"
    """


    """
    ATTACK_DOS_REQ_URI_RL_DROP_BAD = "DOS_REQ_URI_RL_DROP_BAD"
    """


    """
    ATTACK_DOS_REQ_IP_URI_RL_DROP_BAD = "DOS_REQ_IP_URI_RL_DROP_BAD"
    """


    """
    ATTACK_POLICY_DROPS = "POLICY_DROPS"
    """


    """
    ATTACK_DOS_CONN_RL_DROP = "DOS_CONN_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_RL_DROP = "DOS_REQ_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_HDR_RL_DROP = "DOS_REQ_HDR_RL_DROP"
    """


    """
    ATTACK_DOS_REQ_CUSTOM_RL_DROP = "DOS_REQ_CUSTOM_RL_DROP"
    """


    """
    ATTACK_DNS_ATTACK_REFLECTION = "DNS_ATTACK_REFLECTION"
    """


    """



    _canonical_to_pep_names = {
                            'attack': 'attack',
                            'max_value': 'max_value',
                            'min_value': 'min_value',
                            }

    def __init__(self,
                 attack=None,
                 max_value=None,
                 min_value=None,
                ):
        """
        :type  attack: :class:`str` or ``None``
        :param attack: Possible values are: 
            
            * :attr:`ALBDosThreshold.ATTACK_LAND`
            * :attr:`ALBDosThreshold.ATTACK_SMURF`
            * :attr:`ALBDosThreshold.ATTACK_ICMP_PING_FLOOD`
            * :attr:`ALBDosThreshold.ATTACK_UNKOWN_PROTOCOL`
            * :attr:`ALBDosThreshold.ATTACK_TEARDROP`
            * :attr:`ALBDosThreshold.ATTACK_IP_FRAG_OVERRUN`
            * :attr:`ALBDosThreshold.ATTACK_IP_FRAG_TOOSMALL`
            * :attr:`ALBDosThreshold.ATTACK_IP_FRAG_FULL`
            * :attr:`ALBDosThreshold.ATTACK_IP_FRAG_INCOMPLETE`
            * :attr:`ALBDosThreshold.ATTACK_PORT_SCAN`
            * :attr:`ALBDosThreshold.ATTACK_TCP_NON_SYN_FLOOD_OLD`
            * :attr:`ALBDosThreshold.ATTACK_SYN_FLOOD`
            * :attr:`ALBDosThreshold.ATTACK_BAD_RST_FLOOD`
            * :attr:`ALBDosThreshold.ATTACK_MALFORMED_FLOOD`
            * :attr:`ALBDosThreshold.ATTACK_FAKE_SESSION`
            * :attr:`ALBDosThreshold.ATTACK_ZERO_WINDOW_STRESS`
            * :attr:`ALBDosThreshold.ATTACK_SMALL_WINDOW_STRESS`
            * :attr:`ALBDosThreshold.ATTACK_DOS_HTTP_TIMEOUT`
            * :attr:`ALBDosThreshold.ATTACK_DOS_HTTP_ERROR`
            * :attr:`ALBDosThreshold.ATTACK_DOS_HTTP_ABORT`
            * :attr:`ALBDosThreshold.ATTACK_DOS_SSL_ERROR`
            * :attr:`ALBDosThreshold.ATTACK_DOS_APP_ERROR`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_IP_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_URI_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_URI_SCAN_BAD_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_URI_SCAN_UNKNOWN_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_IP_URI_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_CONN_IP_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_SLOW_URL`
            * :attr:`ALBDosThreshold.ATTACK_TCP_NON_SYN_FLOOD`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_CIP_SCAN_BAD_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_CIP_SCAN_UNKNOWN_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_IP_RL_DROP_BAD`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_URI_RL_DROP_BAD`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_IP_URI_RL_DROP_BAD`
            * :attr:`ALBDosThreshold.ATTACK_POLICY_DROPS`
            * :attr:`ALBDosThreshold.ATTACK_DOS_CONN_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_HDR_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DOS_REQ_CUSTOM_RL_DROP`
            * :attr:`ALBDosThreshold.ATTACK_DNS_ATTACK_REFLECTION`
            
            Attack type. Enum options - LAND, SMURF, ICMP_PING_FLOOD,
            UNKOWN_PROTOCOL, TEARDROP, IP_FRAG_OVERRUN, IP_FRAG_TOOSMALL,
            IP_FRAG_FULL, IP_FRAG_INCOMPLETE, PORT_SCAN, TCP_NON_SYN_FLOOD_OLD,
            SYN_FLOOD, BAD_RST_FLOOD, MALFORMED_FLOOD, FAKE_SESSION,
            ZERO_WINDOW_STRESS, SMALL_WINDOW_STRESS, DOS_HTTP_TIMEOUT,
            DOS_HTTP_ERROR, DOS_HTTP_ABORT...
        :type  max_value: :class:`long` or ``None``
        :param max_value: Maximum number of packets or connections or requests in a given
            interval of time to be deemed as attack. format: int64
        :type  min_value: :class:`long` or ``None``
        :param min_value: Minimum number of packets or connections or requests in a given
            interval of time to be deemed as attack. format: int64
        """
        self.attack = attack
        self.max_value = max_value
        self.min_value = min_value
        VapiStruct.__init__(self)


ALBDosThreshold._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dos_threshold', {
        'attack': type.OptionalType(type.StringType()),
        'max_value': type.OptionalType(type.IntegerType()),
        'min_value': type.OptionalType(type.IntegerType()),
    },
    ALBDosThreshold,
    False,
    None))



class ALBDosThresholdProfile(VapiStruct):
    """
    Advanced load balancer DosThresholdProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'thresh_info': 'thresh_info',
                            'thresh_period': 'thresh_period',
                            }

    def __init__(self,
                 thresh_info=None,
                 thresh_period=None,
                ):
        """
        :type  thresh_info: :class:`list` of :class:`ALBDosThreshold` or ``None``
        :param thresh_info: Attack type, min and max values for DoS attack detection.
        :type  thresh_period: :class:`long` or ``None``
        :param thresh_period: Timer value in seconds to collect DoS attack metrics based on
            threshold on the Service Engine for this Virtual Service. Unit is
            SEC. Default value when not specified in API or module is
            interpreted by ALB Controller as 5. format: int64
        """
        self.thresh_info = thresh_info
        self.thresh_period = thresh_period
        VapiStruct.__init__(self)


ALBDosThresholdProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dos_threshold_profile', {
        'thresh_info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBDosThreshold'))),
        'thresh_period': type.OptionalType(type.IntegerType()),
    },
    ALBDosThresholdProfile,
    False,
    None))



class ALBDsrProfile(VapiStruct):
    """
    Advanced load balancer DsrProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    DSR_ENCAP_TYPE_IPINIP = "ENCAP_IPINIP"
    """


    """
    DSR_TYPE_L2 = "DSR_TYPE_L2"
    """


    """
    DSR_TYPE_L3 = "DSR_TYPE_L3"
    """


    """



    _canonical_to_pep_names = {
                            'dsr_encap_type': 'dsr_encap_type',
                            'dsr_type': 'dsr_type',
                            }

    def __init__(self,
                 dsr_encap_type=None,
                 dsr_type=None,
                ):
        """
        :type  dsr_encap_type: :class:`str` or ``None``
        :param dsr_encap_type: Possible values are: 
            
            * :attr:`ALBDsrProfile.DSR_ENCAP_TYPE_IPINIP`
            
            Encapsulation type to use when DSR is L3. Enum options -
            ENCAP_IPINIP. Default value when not specified in API or module is
            interpreted by ALB Controller as ENCAP_IPINIP.
        :type  dsr_type: :class:`str` or ``None``
        :param dsr_type: Possible values are: 
            
            * :attr:`ALBDsrProfile.DSR_TYPE_L2`
            * :attr:`ALBDsrProfile.DSR_TYPE_L3`
            
            DSR type L2/L3. Enum options - DSR_TYPE_L2, DSR_TYPE_L3. Default
            value when not specified in API or module is interpreted by ALB
            Controller as DSR_TYPE_L3.
        """
        self.dsr_encap_type = dsr_encap_type
        self.dsr_type = dsr_type
        VapiStruct.__init__(self)


ALBDsrProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_dsr_profile', {
        'dsr_encap_type': type.OptionalType(type.StringType()),
        'dsr_type': type.OptionalType(type.StringType()),
    },
    ALBDsrProfile,
    False,
    None))



class ALBEquivalentLabels(VapiStruct):
    """
    Advanced load balancer EquivalentLabels object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'labels': 'labels',
                            }

    def __init__(self,
                 labels=None,
                ):
        """
        :type  labels: :class:`list` of :class:`str` or ``None``
        :param labels: Equivalent labels.
        """
        self.labels = labels
        VapiStruct.__init__(self)


ALBEquivalentLabels._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_equivalent_labels', {
        'labels': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBEquivalentLabels,
    False,
    None))



class ALBErrorPage(VapiStruct):
    """
    Advanced load balancer ErrorPage object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enable': 'enable',
                            'error_page_body_path': 'error_page_body_path',
                            'error_redirect': 'error_redirect',
                            'index': 'index',
                            'match': 'match',
                            }

    def __init__(self,
                 enable=None,
                 error_page_body_path=None,
                 error_redirect=None,
                 index=None,
                 match=None,
                ):
        """
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable the error page. Default value when not specified
            in API or module is interpreted by ALB Controller as true.
        :type  error_page_body_path: :class:`str` or ``None``
        :param error_page_body_path: Custom error page body used to sent to the client. It is a
            reference to an object of type ErrorPageBody.
        :type  error_redirect: :class:`str` or ``None``
        :param error_redirect: Redirect sent to client when match.
        :type  index: :class:`long` or ``None``
        :param index: Index of the error page. format: int64
        :type  match: :class:`ALBHTTPStatusMatch` or ``None``
        :param match: 
        """
        self.enable = enable
        self.error_page_body_path = error_page_body_path
        self.error_redirect = error_redirect
        self.index = index
        self.match = match
        VapiStruct.__init__(self)


ALBErrorPage._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_error_page', {
        'enable': type.OptionalType(type.BooleanType()),
        'error_page_body_path': type.OptionalType(type.StringType()),
        'error_redirect': type.OptionalType(type.StringType()),
        'index': type.OptionalType(type.IntegerType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPStatusMatch')),
    },
    ALBErrorPage,
    False,
    None))



class ALBErrorPageBody(VapiStruct):
    """
    Advanced load balancer ErrorPageBody object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    FORMAT_HTML = "ERROR_PAGE_FORMAT_HTML"
    """


    """
    FORMAT_JSON = "ERROR_PAGE_FORMAT_JSON"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'error_page_body': 'error_page_body',
                            'format': 'format',
                            'markers': 'markers',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 error_page_body=None,
                 format=None,
                 markers=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  error_page_body: :class:`str` or ``None``
        :param error_page_body: Error page body sent to client when match.
        :type  format: :class:`str` or ``None``
        :param format: Possible values are: 
            
            * :attr:`ALBErrorPageBody.FORMAT_HTML`
            * :attr:`ALBErrorPageBody.FORMAT_JSON`
            
            Format of an error page body HTML or JSON. Enum options -
            ERROR_PAGE_FORMAT_HTML, ERROR_PAGE_FORMAT_JSON. Default value when
            not specified in API or module is interpreted by ALB Controller as
            ERROR_PAGE_FORMAT_HTML.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.error_page_body = error_page_body
        self.format = format
        self.markers = markers
        VapiStruct.__init__(self)


ALBErrorPageBody._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_error_page_body', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'error_page_body': type.OptionalType(type.StringType()),
        'format': type.OptionalType(type.StringType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
    },
    ALBErrorPageBody,
    False,
    None))



class ALBErrorPageBodyApiResponse(VapiStruct):
    """
    ErrorPageBodyApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBErrorPageBody` or ``None``
        :param results: Array of ErrorPageBody
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBErrorPageBodyApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_error_page_body_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBErrorPageBody'))),
    },
    ALBErrorPageBodyApiResponse,
    False,
    None))



class ALBErrorPageProfile(VapiStruct):
    """
    Advanced load balancer ErrorPageProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'error_pages': 'error_pages',
                            'markers': 'markers',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 error_pages=None,
                 markers=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  error_pages: :class:`list` of :class:`ALBErrorPage` or ``None``
        :param error_pages: Defined Error Pages for HTTP status codes.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.error_pages = error_pages
        self.markers = markers
        VapiStruct.__init__(self)


ALBErrorPageProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_error_page_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'error_pages': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBErrorPage'))),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
    },
    ALBErrorPageProfile,
    False,
    None))



class ALBErrorPageProfileApiResponse(VapiStruct):
    """
    ErrorPageProfileApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBErrorPageProfile` or ``None``
        :param results: Array of ErrorPageProfile
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBErrorPageProfileApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_error_page_profile_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBErrorPageProfile'))),
    },
    ALBErrorPageProfileApiResponse,
    False,
    None))



class ALBFailAction(VapiStruct):
    """
    Advanced load balancer FailAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_HTTP_REDIRECT = "FAIL_ACTION_HTTP_REDIRECT"
    """


    """
    TYPE_HTTP_LOCAL_RSP = "FAIL_ACTION_HTTP_LOCAL_RSP"
    """


    """
    TYPE_CLOSE_CONN = "FAIL_ACTION_CLOSE_CONN"
    """


    """



    _canonical_to_pep_names = {
                            'local_rsp': 'local_rsp',
                            'redirect': 'redirect',
                            'type': 'type',
                            }

    def __init__(self,
                 local_rsp=None,
                 redirect=None,
                 type=None,
                ):
        """
        :type  local_rsp: :class:`ALBFailActionHTTPLocalResponse` or ``None``
        :param local_rsp: 
        :type  redirect: :class:`ALBFailActionHTTPRedirect` or ``None``
        :param redirect: 
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBFailAction.TYPE_HTTP_REDIRECT`
            * :attr:`ALBFailAction.TYPE_HTTP_LOCAL_RSP`
            * :attr:`ALBFailAction.TYPE_CLOSE_CONN`
            
            Enables a response to client when pool experiences a failure. By
            default TCP connection is closed. Enum options -
            FAIL_ACTION_HTTP_REDIRECT, FAIL_ACTION_HTTP_LOCAL_RSP,
            FAIL_ACTION_CLOSE_CONN. Allowed in Basic(Allowed values-
            FAIL_ACTION_CLOSE_CONN,FAIL_ACTION_HTTP_REDIRECT) edition,
            Essentials(Allowed values- FAIL_ACTION_CLOSE_CONN) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as FAIL_ACTION_CLOSE_CONN.
        """
        self.local_rsp = local_rsp
        self.redirect = redirect
        self.type = type
        VapiStruct.__init__(self)


ALBFailAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_fail_action', {
        'local_rsp': type.OptionalType(type.ReferenceType(__name__, 'ALBFailActionHTTPLocalResponse')),
        'redirect': type.OptionalType(type.ReferenceType(__name__, 'ALBFailActionHTTPRedirect')),
        'type': type.OptionalType(type.StringType()),
    },
    ALBFailAction,
    False,
    None))



class ALBFailActionHTTPLocalResponse(VapiStruct):
    """
    Advanced load balancer FailActionHTTPLocalResponse object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    STATUS_CODE_200 = "FAIL_HTTP_STATUS_CODE_200"
    """


    """
    STATUS_CODE_503 = "FAIL_HTTP_STATUS_CODE_503"
    """


    """



    _canonical_to_pep_names = {
                            'file': 'file',
                            'status_code': 'status_code',
                            }

    def __init__(self,
                 file=None,
                 status_code=None,
                ):
        """
        :type  file: :class:`ALBHTTPLocalFile` or ``None``
        :param file: 
        :type  status_code: :class:`str` or ``None``
        :param status_code: Possible values are: 
            
            * :attr:`ALBFailActionHTTPLocalResponse.STATUS_CODE__200`
            * :attr:`ALBFailActionHTTPLocalResponse.STATUS_CODE__503`
            
            Enum options - FAIL_HTTP_STATUS_CODE_200,
            FAIL_HTTP_STATUS_CODE_503. Default value when not specified in API
            or module is interpreted by ALB Controller as
            FAIL_HTTP_STATUS_CODE_503.
        """
        self.file = file
        self.status_code = status_code
        VapiStruct.__init__(self)


ALBFailActionHTTPLocalResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_fail_action_HTTP_local_response', {
        'file': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPLocalFile')),
        'status_code': type.OptionalType(type.StringType()),
    },
    ALBFailActionHTTPLocalResponse,
    False,
    None))



class ALBFailActionHTTPRedirect(VapiStruct):
    """
    Advanced load balancer FailActionHTTPRedirect object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    PROTOCOL_HTTP = "HTTP"
    """


    """
    PROTOCOL_HTTPS = "HTTPS"
    """


    """
    STATUS_CODE_301 = "HTTP_REDIRECT_STATUS_CODE_301"
    """


    """
    STATUS_CODE_302 = "HTTP_REDIRECT_STATUS_CODE_302"
    """


    """
    STATUS_CODE_307 = "HTTP_REDIRECT_STATUS_CODE_307"
    """


    """



    _canonical_to_pep_names = {
                            'host': 'host',
                            'path': 'path',
                            'protocol': 'protocol',
                            'query': 'query',
                            'status_code': 'status_code',
                            }

    def __init__(self,
                 host=None,
                 path=None,
                 protocol=None,
                 query=None,
                 status_code=None,
                ):
        """
        :type  host: :class:`str` or ``None``
        :param host: host of FailActionHTTPRedirect.
        :type  path: :class:`str` or ``None``
        :param path: path of FailActionHTTPRedirect.
        :type  protocol: :class:`str` or ``None``
        :param protocol: Possible values are: 
            
            * :attr:`ALBFailActionHTTPRedirect.PROTOCOL_HTTP`
            * :attr:`ALBFailActionHTTPRedirect.PROTOCOL_HTTPS`
            
            Enum options - HTTP, HTTPS. Allowed in Basic(Allowed values- HTTP)
            edition, Enterprise edition. Special default for Basic edition is
            HTTP, Enterprise is HTTPS. Default value when not specified in API
            or module is interpreted by ALB Controller as HTTP.
        :type  query: :class:`str` or ``None``
        :param query: query of FailActionHTTPRedirect.
        :type  status_code: :class:`str` or ``None``
        :param status_code: Possible values are: 
            
            * :attr:`ALBFailActionHTTPRedirect.STATUS_CODE__301`
            * :attr:`ALBFailActionHTTPRedirect.STATUS_CODE__302`
            * :attr:`ALBFailActionHTTPRedirect.STATUS_CODE__307`
            
            Enum options - HTTP_REDIRECT_STATUS_CODE_301,
            HTTP_REDIRECT_STATUS_CODE_302, HTTP_REDIRECT_STATUS_CODE_307.
            Allowed in Basic(Allowed values- HTTP_REDIRECT_STATUS_CODE_302)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as
            HTTP_REDIRECT_STATUS_CODE_302.
        """
        self.host = host
        self.path = path
        self.protocol = protocol
        self.query = query
        self.status_code = status_code
        VapiStruct.__init__(self)


ALBFailActionHTTPRedirect._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_fail_action_HTTP_redirect', {
        'host': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'protocol': type.OptionalType(type.StringType()),
        'query': type.OptionalType(type.StringType()),
        'status_code': type.OptionalType(type.StringType()),
    },
    ALBFailActionHTTPRedirect,
    False,
    None))



class ALBFullClientLogs(VapiStruct):
    """
    Advanced load balancer FullClientLogs object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'duration': 'duration',
                            'enabled': 'enabled',
                            'throttle': 'throttle',
                            }

    def __init__(self,
                 duration=None,
                 enabled=None,
                 throttle=None,
                ):
        """
        :type  duration: :class:`long` or ``None``
        :param duration: How long should the system capture all logs, measured in minutes.
            Set to 0 for infinite. Special values are 0 - 'infinite'. Unit is
            MIN. Default value when not specified in API or module is
            interpreted by ALB Controller as 30. format: int64
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Capture all client logs including connections and requests. When
            deactivated, only errors will be logged. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Special default for Basic edition is false,
            Essentials edition is false, Enterprise is False. Default value
            when not specified in API or module is interpreted by ALB
            Controller as false.
        :type  throttle: :class:`long` or ``None``
        :param throttle: This setting limits the number of non-significant logs generated
            per second for this VS on each SE. Default is 10 logs per second.
            Set it to zero (0) to deactivate throttling. Unit is PER_SECOND.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 10. format: int64
        """
        self.duration = duration
        self.enabled = enabled
        self.throttle = throttle
        VapiStruct.__init__(self)


ALBFullClientLogs._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_full_client_logs', {
        'duration': type.OptionalType(type.IntegerType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'throttle': type.OptionalType(type.IntegerType()),
    },
    ALBFullClientLogs,
    False,
    None))



class ALBGeoLocation(VapiStruct):
    """
    Advanced load balancer GeoLocation object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'latitude': 'latitude',
                            'longitude': 'longitude',
                            'name': 'name',
                            'tag': 'tag',
                            }

    def __init__(self,
                 latitude=None,
                 longitude=None,
                 name=None,
                 tag=None,
                ):
        """
        :type  latitude: :class:`float` or ``None``
        :param latitude: Latitude of the location. This is represented as degrees.minutes.
            The range is from -90.0 (south) to +90.0 (north). Allowed values
            are -90.0-+90.0.
        :type  longitude: :class:`float` or ``None``
        :param longitude: Longitude of the location. This is represented as degrees.minutes.
            The range is from -180.0 (west) to +180.0 (east). Allowed values
            are -180.0-+180.0.
        :type  name: :class:`str` or ``None``
        :param name: Location name in the format Country/State/City.
        :type  tag: :class:`str` or ``None``
        :param tag: Location tag string - example USEast.
        """
        self.latitude = latitude
        self.longitude = longitude
        self.name = name
        self.tag = tag
        VapiStruct.__init__(self)


ALBGeoLocation._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_geo_location', {
        'latitude': type.OptionalType(type.DoubleType()),
        'longitude': type.OptionalType(type.DoubleType()),
        'name': type.OptionalType(type.StringType()),
        'tag': type.OptionalType(type.StringType()),
    },
    ALBGeoLocation,
    False,
    None))



class ALBHSMAwsCloudHsm(VapiStruct):
    """
    Advanced load balancer HSMAwsCloudHsm object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_config': 'client_config',
                            'cluster_cert': 'cluster_cert',
                            'crypto_user_name': 'crypto_user_name',
                            'crypto_user_password': 'crypto_user_password',
                            'hsm_ip': 'hsm_ip',
                            'mgmt_config': 'mgmt_config',
                            }

    def __init__(self,
                 client_config=None,
                 cluster_cert=None,
                 crypto_user_name=None,
                 crypto_user_password=None,
                 hsm_ip=None,
                 mgmt_config=None,
                ):
        """
        :type  client_config: :class:`str` or ``None``
        :param client_config: client_config of HSMAwsCloudHsm.
        :type  cluster_cert: :class:`str` or ``None``
        :param cluster_cert: AWS CloudHSM Cluster Certificate.
        :type  crypto_user_name: :class:`str` or ``None``
        :param crypto_user_name: Username of the Crypto User. This will be used to access the keys
            on the HSM .
        :type  crypto_user_password: :class:`str` or ``None``
        :param crypto_user_password: Password of the Crypto User. This will be used to access the keys
            on the HSM .
        :type  hsm_ip: :class:`list` of :class:`str` or ``None``
        :param hsm_ip: IP address of the HSM in the cluster. If there are more than one
            HSMs, only one is sufficient.
        :type  mgmt_config: :class:`str` or ``None``
        :param mgmt_config: mgmt_config of HSMAwsCloudHsm.
        """
        self.client_config = client_config
        self.cluster_cert = cluster_cert
        self.crypto_user_name = crypto_user_name
        self.crypto_user_password = crypto_user_password
        self.hsm_ip = hsm_ip
        self.mgmt_config = mgmt_config
        VapiStruct.__init__(self)


ALBHSMAwsCloudHsm._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHSM_aws_cloud_hsm', {
        'client_config': type.OptionalType(type.StringType()),
        'cluster_cert': type.OptionalType(type.StringType()),
        'crypto_user_name': type.OptionalType(type.StringType()),
        'crypto_user_password': type.OptionalType(type.StringType()),
        'hsm_ip': type.OptionalType(type.ListType(type.StringType())),
        'mgmt_config': type.OptionalType(type.StringType()),
    },
    ALBHSMAwsCloudHsm,
    False,
    None))



class ALBHSMSafenetClientInfo(VapiStruct):
    """
    Advanced load balancer HSMSafenetClientInfo object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'chrystoki_conf': 'chrystoki_conf',
                            'client_cert': 'client_cert',
                            'client_ip': 'client_ip',
                            'client_priv_key': 'client_priv_key',
                            'session_major_number': 'session_major_number',
                            'session_minor_number': 'session_minor_number',
                            }

    def __init__(self,
                 chrystoki_conf=None,
                 client_cert=None,
                 client_ip=None,
                 client_priv_key=None,
                 session_major_number=None,
                 session_minor_number=None,
                ):
        """
        :type  chrystoki_conf: :class:`str` or ``None``
        :param chrystoki_conf: Generated File - Chrystoki.conf .
        :type  client_cert: :class:`str` or ``None``
        :param client_cert: Client Certificate generated by createCert.
        :type  client_ip: :class:`str` or ``None``
        :param client_ip: Name prepended to client key and certificate filename.
        :type  client_priv_key: :class:`str` or ``None``
        :param client_priv_key: Client Private Key generated by createCert.
        :type  session_major_number: :class:`long` or ``None``
        :param session_major_number: Major number of the sesseion. format: int64
        :type  session_minor_number: :class:`long` or ``None``
        :param session_minor_number: Minor number of the sesseion. format: int64
        """
        self.chrystoki_conf = chrystoki_conf
        self.client_cert = client_cert
        self.client_ip = client_ip
        self.client_priv_key = client_priv_key
        self.session_major_number = session_major_number
        self.session_minor_number = session_minor_number
        VapiStruct.__init__(self)


ALBHSMSafenetClientInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHSM_safenet_client_info', {
        'chrystoki_conf': type.OptionalType(type.StringType()),
        'client_cert': type.OptionalType(type.StringType()),
        'client_ip': type.OptionalType(type.StringType()),
        'client_priv_key': type.OptionalType(type.StringType()),
        'session_major_number': type.OptionalType(type.IntegerType()),
        'session_minor_number': type.OptionalType(type.IntegerType()),
    },
    ALBHSMSafenetClientInfo,
    False,
    None))



class ALBHSMSafenetLuna(VapiStruct):
    """
    Advanced load balancer HSMSafenetLuna object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ha_group_num': 'ha_group_num',
                            'is_ha': 'is_ha',
                            'node_info': 'node_info',
                            'server': 'server',
                            'server_pem': 'server_pem',
                            'use_dedicated_network': 'use_dedicated_network',
                            }

    def __init__(self,
                 ha_group_num=None,
                 is_ha=None,
                 node_info=None,
                 server=None,
                 server_pem=None,
                 use_dedicated_network=None,
                ):
        """
        :type  ha_group_num: :class:`long` or ``None``
        :param ha_group_num: Group Number of generated HA Group. format: int64
        :type  is_ha: :class:`bool` or ``None``
        :param is_ha: Set to indicate HA across more than one servers. Default value when
            not specified in API or module is interpreted by ALB Controller as
            false.
        :type  node_info: :class:`list` of :class:`ALBHSMSafenetClientInfo` or ``None``
        :param node_info: Node specific information.
        :type  server: :class:`list` of :class:`ALBHSMSafenetLunaServer` or ``None``
        :param server: SafeNet/Gemalto HSM Servers used for crypto operations.
        :type  server_pem: :class:`str` or ``None``
        :param server_pem: Generated File - server.pem.
        :type  use_dedicated_network: :class:`bool` or ``None``
        :param use_dedicated_network: If enabled, dedicated network is used to communicate with HSM,else,
            the management network is used. Default value when not specified in
            API or module is interpreted by ALB Controller as false.
        """
        self.ha_group_num = ha_group_num
        self.is_ha = is_ha
        self.node_info = node_info
        self.server = server
        self.server_pem = server_pem
        self.use_dedicated_network = use_dedicated_network
        VapiStruct.__init__(self)


ALBHSMSafenetLuna._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHSM_safenet_luna', {
        'ha_group_num': type.OptionalType(type.IntegerType()),
        'is_ha': type.OptionalType(type.BooleanType()),
        'node_info': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHSMSafenetClientInfo'))),
        'server': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHSMSafenetLunaServer'))),
        'server_pem': type.OptionalType(type.StringType()),
        'use_dedicated_network': type.OptionalType(type.BooleanType()),
    },
    ALBHSMSafenetLuna,
    False,
    None))



class ALBHSMSafenetLunaServer(VapiStruct):
    """
    Advanced load balancer HSMSafenetLunaServer object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'index': 'index',
                            'partition_passwd': 'partition_passwd',
                            'partition_serial_number': 'partition_serial_number',
                            'remote_ip': 'remote_ip',
                            'server_cert': 'server_cert',
                            }

    def __init__(self,
                 index=None,
                 partition_passwd=None,
                 partition_serial_number=None,
                 remote_ip=None,
                 server_cert=None,
                ):
        """
        :type  index: :class:`long` or ``None``
        :param index: Number of index. format: int64
        :type  partition_passwd: :class:`str` or ``None``
        :param partition_passwd: Password of the partition assigned to this client.
        :type  partition_serial_number: :class:`str` or ``None``
        :param partition_serial_number: Serial number of the partition assigned to this client.
        :type  remote_ip: :class:`str` or ``None``
        :param remote_ip: IP address of the Safenet/Gemalto HSM device.
        :type  server_cert: :class:`str` or ``None``
        :param server_cert: CA certificate of the server.
        """
        self.index = index
        self.partition_passwd = partition_passwd
        self.partition_serial_number = partition_serial_number
        self.remote_ip = remote_ip
        self.server_cert = server_cert
        VapiStruct.__init__(self)


ALBHSMSafenetLunaServer._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHSM_safenet_luna_server', {
        'index': type.OptionalType(type.IntegerType()),
        'partition_passwd': type.OptionalType(type.StringType()),
        'partition_serial_number': type.OptionalType(type.StringType()),
        'remote_ip': type.OptionalType(type.StringType()),
        'server_cert': type.OptionalType(type.StringType()),
    },
    ALBHSMSafenetLunaServer,
    False,
    None))



class ALBHSMThalesNetHsm(VapiStruct):
    """
    Advanced load balancer HSMThalesNetHsm object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'esn': 'esn',
                            'keyhash': 'keyhash',
                            'module_id': 'module_id',
                            'priority': 'priority',
                            'remote_ip': 'remote_ip',
                            'remote_port': 'remote_port',
                            }

    def __init__(self,
                 esn=None,
                 keyhash=None,
                 module_id=None,
                 priority=None,
                 remote_ip=None,
                 remote_port=None,
                ):
        """
        :type  esn: :class:`str` or ``None``
        :param esn: Electronic serial number of the netHSM device. Use Thales anonkneti
            utility to find the netHSM ESN.
        :type  keyhash: :class:`str` or ``None``
        :param keyhash: Hash of the key that netHSM device uses to authenticate itself. Use
            Thales anonkneti utility to find the netHSM keyhash.
        :type  module_id: :class:`long` or ``None``
        :param module_id: Local module id of the netHSM device. Default value when not
            specified in API or module is interpreted by ALB Controller as 0.
            format: int64
        :type  priority: :class:`long` or ``None``
        :param priority: Priority class of the nethsm in an high availability setup. 1 is
            the highest priority and 100 is the lowest priority. Allowed values
            are 1-100. Default value when not specified in API or module is
            interpreted by ALB Controller as 100. format: int64
        :type  remote_ip: :class:`ALBIpAddr` or ``None``
        :param remote_ip: 
        :type  remote_port: :class:`long` or ``None``
        :param remote_port: Port at which the netHSM device accepts the connection. Allowed
            values are 1-65535. Default value when not specified in API or
            module is interpreted by ALB Controller as 9004. format: int64
        """
        self.esn = esn
        self.keyhash = keyhash
        self.module_id = module_id
        self.priority = priority
        self.remote_ip = remote_ip
        self.remote_port = remote_port
        VapiStruct.__init__(self)


ALBHSMThalesNetHsm._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHSM_thales_net_hsm', {
        'esn': type.OptionalType(type.StringType()),
        'keyhash': type.OptionalType(type.StringType()),
        'module_id': type.OptionalType(type.IntegerType()),
        'priority': type.OptionalType(type.IntegerType()),
        'remote_ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
        'remote_port': type.OptionalType(type.IntegerType()),
    },
    ALBHSMThalesNetHsm,
    False,
    None))



class ALBHSMThalesRFS(VapiStruct):
    """
    Advanced load balancer HSMThalesRFS object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ip': 'ip',
                            'port': 'port',
                            }

    def __init__(self,
                 ip=None,
                 port=None,
                ):
        """
        :type  ip: :class:`ALBIpAddr` or ``None``
        :param ip: 
        :type  port: :class:`long` or ``None``
        :param port: Port at which the RFS server accepts the sync request from clients
            for Thales encrypted private key. Allowed values are 1-65535.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 9004. format: int64
        """
        self.ip = ip
        self.port = port
        VapiStruct.__init__(self)


ALBHSMThalesRFS._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHSM_thales_RFS', {
        'ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
        'port': type.OptionalType(type.IntegerType()),
    },
    ALBHSMThalesRFS,
    False,
    None))



class ALBHTTP2ApplicationProfile(VapiStruct):
    """
    Advanced load balancer HTTP2ApplicationProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'http2_initial_window_size': 'http2_initial_window_size',
                            'max_http2_concurrent_streams_per_connection': 'max_http2_concurrent_streams_per_connection',
                            'max_http2_control_frames_per_connection': 'max_http2_control_frames_per_connection',
                            'max_http2_empty_data_frames_per_connection': 'max_http2_empty_data_frames_per_connection',
                            'max_http2_header_field_size': 'max_http2_header_field_size',
                            'max_http2_queued_frames_to_client_per_connection': 'max_http2_queued_frames_to_client_per_connection',
                            'max_http2_requests_per_connection': 'max_http2_requests_per_connection',
                            }

    def __init__(self,
                 http2_initial_window_size=None,
                 max_http2_concurrent_streams_per_connection=None,
                 max_http2_control_frames_per_connection=None,
                 max_http2_empty_data_frames_per_connection=None,
                 max_http2_header_field_size=None,
                 max_http2_queued_frames_to_client_per_connection=None,
                 max_http2_requests_per_connection=None,
                ):
        """
        :type  http2_initial_window_size: :class:`long` or ``None``
        :param http2_initial_window_size: The initial flow control window size in KB for HTTP/2 streams.
            Allowed values are 64-32768. Unit is KB. Default value when not
            specified in API or module is interpreted by ALB Controller as 64.
            format: int64
        :type  max_http2_concurrent_streams_per_connection: :class:`long` or ``None``
        :param max_http2_concurrent_streams_per_connection: The max number of concurrent streams over a client side HTTP/2
            connection. Allowed values are 1-256. Default value when not
            specified in API or module is interpreted by ALB Controller as 128.
            format: int64
        :type  max_http2_control_frames_per_connection: :class:`long` or ``None``
        :param max_http2_control_frames_per_connection: The max number of control frames that client can send over an
            HTTP/2 connection. '0' means unlimited. Allowed values are 0-10000.
            Special values are 0- 'Unlimited control frames on a client side
            HTTP/2 connection'. Default value when not specified in API or
            module is interpreted by ALB Controller as 1000. format: int64
        :type  max_http2_empty_data_frames_per_connection: :class:`long` or ``None``
        :param max_http2_empty_data_frames_per_connection: The max number of empty data frames that client can send over an
            HTTP/2 connection. '0' means unlimited. Allowed values are 0-10000.
            Special values are 0- 'Unlimited empty data frames over a client
            side HTTP/2 connection'. Default value when not specified in API or
            module is interpreted by ALB Controller as 1000. format: int64
        :type  max_http2_header_field_size: :class:`long` or ``None``
        :param max_http2_header_field_size: The maximum size in bytes of the compressed request header field.
            The limit applies equally to both name and value. Allowed values
            are 1-8192. Unit is BYTES. Default value when not specified in API
            or module is interpreted by ALB Controller as 4096. format: int64
        :type  max_http2_queued_frames_to_client_per_connection: :class:`long` or ``None``
        :param max_http2_queued_frames_to_client_per_connection: The max number of frames that can be queued waiting to be sent over
            a client side HTTP/2 connection at any given time. '0' means
            unlimited. Allowed values are 0-10000. Special values are 0-
            'Unlimited frames can be queued on a client side HTTP/2
            connection'. Default value when not specified in API or module is
            interpreted by ALB Controller as 1000. format: int64
        :type  max_http2_requests_per_connection: :class:`long` or ``None``
        :param max_http2_requests_per_connection: The maximum number of requests over a client side HTTP/2
            connection. Allowed values are 0-10000. Special values are 0-
            'Unlimited requests on a client side HTTP/2 connection'. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 1000. format: int64
        """
        self.http2_initial_window_size = http2_initial_window_size
        self.max_http2_concurrent_streams_per_connection = max_http2_concurrent_streams_per_connection
        self.max_http2_control_frames_per_connection = max_http2_control_frames_per_connection
        self.max_http2_empty_data_frames_per_connection = max_http2_empty_data_frames_per_connection
        self.max_http2_header_field_size = max_http2_header_field_size
        self.max_http2_queued_frames_to_client_per_connection = max_http2_queued_frames_to_client_per_connection
        self.max_http2_requests_per_connection = max_http2_requests_per_connection
        VapiStruct.__init__(self)


ALBHTTP2ApplicationProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTT_p2_application_profile', {
        'http2_initial_window_size': type.OptionalType(type.IntegerType()),
        'max_http2_concurrent_streams_per_connection': type.OptionalType(type.IntegerType()),
        'max_http2_control_frames_per_connection': type.OptionalType(type.IntegerType()),
        'max_http2_empty_data_frames_per_connection': type.OptionalType(type.IntegerType()),
        'max_http2_header_field_size': type.OptionalType(type.IntegerType()),
        'max_http2_queued_frames_to_client_per_connection': type.OptionalType(type.IntegerType()),
        'max_http2_requests_per_connection': type.OptionalType(type.IntegerType()),
    },
    ALBHTTP2ApplicationProfile,
    False,
    None))



class ALBHTTPApplicationProfile(VapiStruct):
    """
    Advanced load balancer HTTPApplicationProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SSL_CLIENT_CERTIFICATE_MODE_NONE = "SSL_CLIENT_CERTIFICATE_NONE"
    """


    """
    SSL_CLIENT_CERTIFICATE_MODE_REQUEST = "SSL_CLIENT_CERTIFICATE_REQUEST"
    """


    """
    SSL_CLIENT_CERTIFICATE_MODE_REQUIRE = "SSL_CLIENT_CERTIFICATE_REQUIRE"
    """


    """



    _canonical_to_pep_names = {
                            'allow_dots_in_header_name': 'allow_dots_in_header_name',
                            'cache_config': 'cache_config',
                            'client_body_timeout': 'client_body_timeout',
                            'client_header_timeout': 'client_header_timeout',
                            'client_max_body_size': 'client_max_body_size',
                            'client_max_header_size': 'client_max_header_size',
                            'client_max_request_size': 'client_max_request_size',
                            'compression_profile': 'compression_profile',
                            'connection_multiplexing_enabled': 'connection_multiplexing_enabled',
                            'disable_keepalive_posts_msie6': 'disable_keepalive_posts_msie6',
                            'disable_sni_hostname_check': 'disable_sni_hostname_check',
                            'enable_chunk_merge': 'enable_chunk_merge',
                            'enable_fire_and_forget': 'enable_fire_and_forget',
                            'enable_request_body_buffering': 'enable_request_body_buffering',
                            'enable_request_body_metrics': 'enable_request_body_metrics',
                            'fwd_close_hdr_for_bound_connections': 'fwd_close_hdr_for_bound_connections',
                            'hsts_enabled': 'hsts_enabled',
                            'hsts_max_age': 'hsts_max_age',
                            'hsts_subdomains_enabled': 'hsts_subdomains_enabled',
                            'http2_profile': 'http2_profile',
                            'http_to_https': 'http_to_https',
                            'http_upstream_buffer_size': 'http_upstream_buffer_size',
                            'httponly_enabled': 'httponly_enabled',
                            'keepalive_header': 'keepalive_header',
                            'keepalive_timeout': 'keepalive_timeout',
                            'max_bad_rps_cip': 'max_bad_rps_cip',
                            'max_bad_rps_cip_uri': 'max_bad_rps_cip_uri',
                            'max_bad_rps_uri': 'max_bad_rps_uri',
                            'max_keepalive_requests': 'max_keepalive_requests',
                            'max_response_headers_size': 'max_response_headers_size',
                            'max_rps_cip': 'max_rps_cip',
                            'max_rps_cip_uri': 'max_rps_cip_uri',
                            'max_rps_unknown_cip': 'max_rps_unknown_cip',
                            'max_rps_unknown_uri': 'max_rps_unknown_uri',
                            'max_rps_uri': 'max_rps_uri',
                            'pki_profile_path': 'pki_profile_path',
                            'post_accept_timeout': 'post_accept_timeout',
                            'reset_conn_http_on_ssl_port': 'reset_conn_http_on_ssl_port',
                            'respond_with_100_continue': 'respond_with100_continue',
                            'secure_cookie_enabled': 'secure_cookie_enabled',
                            'server_side_redirect_to_https': 'server_side_redirect_to_https',
                            'ssl_client_certificate_action': 'ssl_client_certificate_action',
                            'ssl_client_certificate_mode': 'ssl_client_certificate_mode',
                            'use_app_keepalive_timeout': 'use_app_keepalive_timeout',
                            'websockets_enabled': 'websockets_enabled',
                            'x_forwarded_proto_enabled': 'x_forwarded_proto_enabled',
                            'xff_alternate_name': 'xff_alternate_name',
                            'xff_enabled': 'xff_enabled',
                            }

    def __init__(self,
                 allow_dots_in_header_name=None,
                 cache_config=None,
                 client_body_timeout=None,
                 client_header_timeout=None,
                 client_max_body_size=None,
                 client_max_header_size=None,
                 client_max_request_size=None,
                 compression_profile=None,
                 connection_multiplexing_enabled=None,
                 disable_keepalive_posts_msie6=None,
                 disable_sni_hostname_check=None,
                 enable_chunk_merge=None,
                 enable_fire_and_forget=None,
                 enable_request_body_buffering=None,
                 enable_request_body_metrics=None,
                 fwd_close_hdr_for_bound_connections=None,
                 hsts_enabled=None,
                 hsts_max_age=None,
                 hsts_subdomains_enabled=None,
                 http2_profile=None,
                 http_to_https=None,
                 http_upstream_buffer_size=None,
                 httponly_enabled=None,
                 keepalive_header=None,
                 keepalive_timeout=None,
                 max_bad_rps_cip=None,
                 max_bad_rps_cip_uri=None,
                 max_bad_rps_uri=None,
                 max_keepalive_requests=None,
                 max_response_headers_size=None,
                 max_rps_cip=None,
                 max_rps_cip_uri=None,
                 max_rps_unknown_cip=None,
                 max_rps_unknown_uri=None,
                 max_rps_uri=None,
                 pki_profile_path=None,
                 post_accept_timeout=None,
                 reset_conn_http_on_ssl_port=None,
                 respond_with100_continue=None,
                 secure_cookie_enabled=None,
                 server_side_redirect_to_https=None,
                 ssl_client_certificate_action=None,
                 ssl_client_certificate_mode=None,
                 use_app_keepalive_timeout=None,
                 websockets_enabled=None,
                 x_forwarded_proto_enabled=None,
                 xff_alternate_name=None,
                 xff_enabled=None,
                ):
        """
        :type  allow_dots_in_header_name: :class:`bool` or ``None``
        :param allow_dots_in_header_name: Allow use of dot (.) in HTTP header names, for instance
            Header.app.special PickAppVersionX. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  cache_config: :class:`ALBHttpCacheConfig` or ``None``
        :param cache_config: 
        :type  client_body_timeout: :class:`long` or ``None``
        :param client_body_timeout: The maximum length of time allowed between consecutive read
            operations for a client request body. The value '0' specifies no
            timeout. This setting generally impacts the length of time allowed
            for a client to send a POST. Allowed values are 0-100000000. Unit
            is MILLISECONDS. Allowed in Basic(Allowed values- 30000) edition,
            Essentials(Allowed values- 30000) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 30000. format: int64
        :type  client_header_timeout: :class:`long` or ``None``
        :param client_header_timeout: The maximum length of time allowed for a client to transmit an
            entire request header. This helps mitigate various forms of
            SlowLoris attacks. Allowed values are 10-100000000. Unit is
            MILLISECONDS. Allowed in Basic(Allowed values- 10000) edition,
            Essentials(Allowed values- 10000) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 10000. format: int64
        :type  client_max_body_size: :class:`long` or ``None``
        :param client_max_body_size: Maximum size for the client request body. This limits the size of
            the client data that can be uploaded/posted as part of a single
            HTTP Request. Default 0 => Unlimited. Unit is KB. Default value
            when not specified in API or module is interpreted by ALB
            Controller as 0. format: int64
        :type  client_max_header_size: :class:`long` or ``None``
        :param client_max_header_size: Maximum size in Kbytes of a single HTTP header in the client
            request. Allowed values are 1-64. Unit is KB. Allowed in
            Basic(Allowed values- 12) edition, Essentials(Allowed values- 12)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 12. format: int64
        :type  client_max_request_size: :class:`long` or ``None``
        :param client_max_request_size: Maximum size in Kbytes of all the client HTTP request headers.
            Allowed values are 1-256. Unit is KB. Default value when not
            specified in API or module is interpreted by ALB Controller as 48.
            format: int64
        :type  compression_profile: :class:`ALBCompressionProfile` or ``None``
        :param compression_profile: 
        :type  connection_multiplexing_enabled: :class:`bool` or ``None``
        :param connection_multiplexing_enabled: Allows HTTP requests, not just TCP connections, to be load balanced
            across servers. Proxied TCP connections to servers may be reused by
            multiple clients to improve performance. Not compatible with
            Preserve Client IP. Default value when not specified in API or
            module is interpreted by ALB Controller as true.
        :type  disable_keepalive_posts_msie6: :class:`bool` or ``None``
        :param disable_keepalive_posts_msie6: Disable keep-alive client side connections for older browsers based
            off MS Internet Explorer 6.0 (MSIE6). For some applications, this
            might break NTLM authentication for older clients based off MSIE6.
            For such applications, set this option to false to allow keep-alive
            connections. Allowed in Basic(Allowed values- true) edition,
            Essentials(Allowed values- true) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as true.
        :type  disable_sni_hostname_check: :class:`bool` or ``None``
        :param disable_sni_hostname_check: Disable strict check between TLS servername and HTTP Host name.
            Default value when not specified in API or module is interpreted by
            ALB Controller as false.
        :type  enable_chunk_merge: :class:`bool` or ``None``
        :param enable_chunk_merge: Enable chunk body merge for chunked transfer encoding response.
            Default value when not specified in API or module is interpreted by
            ALB Controller as true.
        :type  enable_fire_and_forget: :class:`bool` or ``None``
        :param enable_fire_and_forget: Enable support for fire and forget feature. If enabled, request
            from client is forwarded to server even if client prematurely
            closes the connection. Allowed in Basic(Allowed values- false)
            edition, Essentials(Allowed values- false) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  enable_request_body_buffering: :class:`bool` or ``None``
        :param enable_request_body_buffering: Enable request body buffering for POST requests. If enabled, max
            buffer size is set to lower of 32M or the value (non-zero)
            configured in client_max_body_size. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  enable_request_body_metrics: :class:`bool` or ``None``
        :param enable_request_body_metrics: Enable HTTP request body metrics. If enabled, requests from clients
            are parsed and relevant statistics about them are gathered.
            Currently, it processes HTTP POST requests with Content-Type
            application/x-www-form-urlencoded or multipart/form-data, and adds
            the number of detected parameters to the
            l7_client.http_params_count. This is an experimental feature and it
            may have performance impact. Use it when detailed information about
            the number of HTTP POST parameters is needed, e.g. for WAF sizing.
            Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
            values- false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  fwd_close_hdr_for_bound_connections: :class:`bool` or ``None``
        :param fwd_close_hdr_for_bound_connections: Forward the Connection Close header coming from backend server to
            the client if connection-switching is enabled, i.e. front-end and
            backend connections are bound together. Default value when not
            specified in API or module is interpreted by ALB Controller as
            true.
        :type  hsts_enabled: :class:`bool` or ``None``
        :param hsts_enabled: Inserts HTTP Strict-Transport-Security header in the HTTPS
            response. HSTS can help mitigate man-in-the-middle attacks by
            telling browsers that support HSTS that they should only access
            this site via HTTPS. Allowed in Basic(Allowed values- false)
            edition, Essentials(Allowed values- false) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  hsts_max_age: :class:`long` or ``None``
        :param hsts_max_age: Number of days for which the client should regard this virtual
            service as a known HSTS host. Allowed values are 0-10000. Allowed
            in Basic(Allowed values- 365) edition, Essentials(Allowed values-
            365) edition, Enterprise edition. Default value when not specified
            in API or module is interpreted by ALB Controller as 365. format:
            int64
        :type  hsts_subdomains_enabled: :class:`bool` or ``None``
        :param hsts_subdomains_enabled: Insert the 'includeSubdomains' directive in the HTTP
            Strict-Transport-Security header. Adding the includeSubdomains
            directive signals the User-Agent that the HSTS Policy applies to
            this HSTS Host as well as any subdomains of the host's domain name.
            Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
            values- false) edition, Enterprise edition. Special default for
            Basic edition is false, Essentials edition is false, Enterprise is
            True. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  http2_profile: :class:`ALBHTTP2ApplicationProfile` or ``None``
        :param http2_profile: 
        :type  http_to_https: :class:`bool` or ``None``
        :param http_to_https: Client requests received via HTTP will be redirected to HTTPS.
            Allowed in Essentials(Allowed values- false) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  http_upstream_buffer_size: :class:`long` or ``None``
        :param http_upstream_buffer_size: Size of HTTP buffer in kB. Allowed values are 1-256. Special values
            are 0- 'Auto compute the size of buffer'. Unit is KB. Allowed in
            Basic(Allowed values- 0) edition, Essentials(Allowed values- 0)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 0. format: int64
        :type  httponly_enabled: :class:`bool` or ``None``
        :param httponly_enabled: Mark HTTP cookies as HTTPonly. This helps mitigate cross site
            scripting attacks as browsers will not allow these cookies to be
            read by third parties, such as javascript. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  keepalive_header: :class:`bool` or ``None``
        :param keepalive_header: Send HTTP 'Keep-Alive' header to the client. By default, the
            timeout specified in the 'Keep-Alive Timeout' field will be used
            unless the 'Use App Keepalive Timeout' flag is set, in which case
            the timeout sent by the application will be honored. Default value
            when not specified in API or module is interpreted by ALB
            Controller as false.
        :type  keepalive_timeout: :class:`long` or ``None``
        :param keepalive_timeout: The max idle time allowed between HTTP requests over a Keep-alive
            connection. Allowed values are 10-100000000. Unit is MILLISECONDS.
            Allowed in Essentials(Allowed values- 30000) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 30000. format: int64
        :type  max_bad_rps_cip: :class:`long` or ``None``
        :param max_bad_rps_cip: Maximum bad requests per second per client IP. Allowed values are
            10-1000. Special values are 0- 'unlimited'. Default value when not
            specified in API or module is interpreted by ALB Controller as 0.
            format: int64
        :type  max_bad_rps_cip_uri: :class:`long` or ``None``
        :param max_bad_rps_cip_uri: Maximum bad requests per second per client IP and URI. Allowed
            values are 10-1000. Special values are 0- 'unlimited'. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 0. format: int64
        :type  max_bad_rps_uri: :class:`long` or ``None``
        :param max_bad_rps_uri: Maximum bad requests per second per URI. Allowed values are
            10-1000. Special values are 0- 'unlimited'. Default value when not
            specified in API or module is interpreted by ALB Controller as 0.
            format: int64
        :type  max_keepalive_requests: :class:`long` or ``None``
        :param max_keepalive_requests: The max number of HTTP requests that can be sent over a Keep-Alive
            connection. '0' means unlimited. Allowed values are 0-1000000.
            Special values are 0- 'Unlimited requests on a connection'. Allowed
            in Basic(Allowed values- 100) edition, Essentials(Allowed values-
            100) edition, Enterprise edition. Default value when not specified
            in API or module is interpreted by ALB Controller as 100. format:
            int64
        :type  max_response_headers_size: :class:`long` or ``None``
        :param max_response_headers_size: Maximum size in Kbytes of all the HTTP response headers. Allowed
            values are 1-256. Unit is KB. Allowed in Basic(Allowed values- 48)
            edition, Essentials(Allowed values- 48) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as 48. format: int64
        :type  max_rps_cip: :class:`long` or ``None``
        :param max_rps_cip: Maximum requests per second per client IP. Allowed values are
            10-1000. Special values are 0- 'unlimited'. Default value when not
            specified in API or module is interpreted by ALB Controller as 0.
            format: int64
        :type  max_rps_cip_uri: :class:`long` or ``None``
        :param max_rps_cip_uri: Maximum requests per second per client IP and URI. Allowed values
            are 10-1000. Special values are 0- 'unlimited'. Default value when
            not specified in API or module is interpreted by ALB Controller as
            0. format: int64
        :type  max_rps_unknown_cip: :class:`long` or ``None``
        :param max_rps_unknown_cip: Maximum unknown client IPs per second. Allowed values are 10-1000.
            Special values are 0- 'unlimited'. Default value when not specified
            in API or module is interpreted by ALB Controller as 0. format:
            int64
        :type  max_rps_unknown_uri: :class:`long` or ``None``
        :param max_rps_unknown_uri: Maximum unknown URIs per second. Allowed values are 10-1000.
            Special values are 0- 'unlimited'. Default value when not specified
            in API or module is interpreted by ALB Controller as 0. format:
            int64
        :type  max_rps_uri: :class:`long` or ``None``
        :param max_rps_uri: Maximum requests per second per URI. Allowed values are 10-1000.
            Special values are 0- 'unlimited'. Default value when not specified
            in API or module is interpreted by ALB Controller as 0. format:
            int64
        :type  pki_profile_path: :class:`str` or ``None``
        :param pki_profile_path: Select the PKI profile to be associated with the Virtual Service.
            This profile defines the Certificate Authority and Revocation List.
            It is a reference to an object of type PKIProfile.
        :type  post_accept_timeout: :class:`long` or ``None``
        :param post_accept_timeout: The max allowed length of time between a client establishing a TCP
            connection and Avi receives the first byte of the client's HTTP
            request. Allowed values are 10-100000000. Unit is MILLISECONDS.
            Allowed in Basic(Allowed values- 30000) edition, Essentials(Allowed
            values- 30000) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            30000. format: int64
        :type  reset_conn_http_on_ssl_port: :class:`bool` or ``None``
        :param reset_conn_http_on_ssl_port: If enabled, an HTTP request on an SSL port will result in
            connection close instead of a 400 response. Allowed in
            Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  respond_with100_continue: :class:`bool` or ``None``
        :param respond_with100_continue: Avi will respond with 100-Continue response if Expect 100-Continue
            header received from client. Default value when not specified in
            API or module is interpreted by ALB Controller as true.
        :type  secure_cookie_enabled: :class:`bool` or ``None``
        :param secure_cookie_enabled: Mark server cookies with the 'Secure' attribute. Client browsers
            will not send a cookie marked as secure over an unencrypted
            connection. If Avi is terminating SSL from clients and passing it
            as HTTP to the server, the server may return cookies without the
            secure flag set. Allowed in Basic(Allowed values- false) edition,
            Essentials(Allowed values- false) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as false.
        :type  server_side_redirect_to_https: :class:`bool` or ``None``
        :param server_side_redirect_to_https: When terminating client SSL sessions at Avi, servers may
            incorrectly send redirect to clients as HTTP. This option will
            rewrite the server's redirect responses for this virtual service
            from HTTP to HTTPS. Allowed in Basic(Allowed values- false)
            edition, Essentials(Allowed values- false) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  ssl_client_certificate_action: :class:`ALBSSLClientCertificateAction` or ``None``
        :param ssl_client_certificate_action: 
        :type  ssl_client_certificate_mode: :class:`str` or ``None``
        :param ssl_client_certificate_mode: Possible values are: 
            
            *
              :attr:`ALBHTTPApplicationProfile.SSL_CLIENT_CERTIFICATE_MODE_NONE`
            *
              :attr:`ALBHTTPApplicationProfile.SSL_CLIENT_CERTIFICATE_MODE_REQUEST`
            *
              :attr:`ALBHTTPApplicationProfile.SSL_CLIENT_CERTIFICATE_MODE_REQUIRE`
            
            Specifies whether the client side verification is set to none,
            request or require. Enum options - SSL_CLIENT_CERTIFICATE_NONE,
            SSL_CLIENT_CERTIFICATE_REQUEST, SSL_CLIENT_CERTIFICATE_REQUIRE.
            Allowed in Basic(Allowed values-
            SSL_CLIENT_CERTIFICATE_NONE,SSL_CLIENT_CERTIFICATE_REQUIRE)
            edition, Essentials(Allowed values-
            SSL_CLIENT_CERTIFICATE_NONE,SSL_CLIENT_CERTIFICATE_REQUIRE)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as
            SSL_CLIENT_CERTIFICATE_NONE.
        :type  use_app_keepalive_timeout: :class:`bool` or ``None``
        :param use_app_keepalive_timeout: Use 'Keep-Alive' header timeout sent by application instead of
            sending the HTTP Keep-Alive Timeout. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  websockets_enabled: :class:`bool` or ``None``
        :param websockets_enabled: Enable Websockets proxy for traffic from clients to the virtual
            service. Connections to this VS start in HTTP mode. If the client
            requests an Upgrade to Websockets, and the server responds back
            with success, then the connection is upgraded to WebSockets mode.
            Default value when not specified in API or module is interpreted by
            ALB Controller as true.
        :type  x_forwarded_proto_enabled: :class:`bool` or ``None``
        :param x_forwarded_proto_enabled: Insert an X-Forwarded-Proto header in the request sent to the
            server. When the client connects via SSL, Avi terminates the SSL,
            and then forwards the requests to the servers via HTTP, so the
            servers can determine the original protocol via this header. In
            this example, the value will be 'https'. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  xff_alternate_name: :class:`str` or ``None``
        :param xff_alternate_name: Provide a custom name for the X-Forwarded-For header sent to the
            servers. Default value when not specified in API or module is
            interpreted by ALB Controller as X-Forwarded-For.
        :type  xff_enabled: :class:`bool` or ``None``
        :param xff_enabled: The client's original IP address is inserted into an HTTP request
            header sent to the server. Servers may use this address for logging
            or other purposes, rather than Avi's source NAT address used in the
            Avi to server IP connection. Default value when not specified in
            API or module is interpreted by ALB Controller as true.
        """
        self.allow_dots_in_header_name = allow_dots_in_header_name
        self.cache_config = cache_config
        self.client_body_timeout = client_body_timeout
        self.client_header_timeout = client_header_timeout
        self.client_max_body_size = client_max_body_size
        self.client_max_header_size = client_max_header_size
        self.client_max_request_size = client_max_request_size
        self.compression_profile = compression_profile
        self.connection_multiplexing_enabled = connection_multiplexing_enabled
        self.disable_keepalive_posts_msie6 = disable_keepalive_posts_msie6
        self.disable_sni_hostname_check = disable_sni_hostname_check
        self.enable_chunk_merge = enable_chunk_merge
        self.enable_fire_and_forget = enable_fire_and_forget
        self.enable_request_body_buffering = enable_request_body_buffering
        self.enable_request_body_metrics = enable_request_body_metrics
        self.fwd_close_hdr_for_bound_connections = fwd_close_hdr_for_bound_connections
        self.hsts_enabled = hsts_enabled
        self.hsts_max_age = hsts_max_age
        self.hsts_subdomains_enabled = hsts_subdomains_enabled
        self.http2_profile = http2_profile
        self.http_to_https = http_to_https
        self.http_upstream_buffer_size = http_upstream_buffer_size
        self.httponly_enabled = httponly_enabled
        self.keepalive_header = keepalive_header
        self.keepalive_timeout = keepalive_timeout
        self.max_bad_rps_cip = max_bad_rps_cip
        self.max_bad_rps_cip_uri = max_bad_rps_cip_uri
        self.max_bad_rps_uri = max_bad_rps_uri
        self.max_keepalive_requests = max_keepalive_requests
        self.max_response_headers_size = max_response_headers_size
        self.max_rps_cip = max_rps_cip
        self.max_rps_cip_uri = max_rps_cip_uri
        self.max_rps_unknown_cip = max_rps_unknown_cip
        self.max_rps_unknown_uri = max_rps_unknown_uri
        self.max_rps_uri = max_rps_uri
        self.pki_profile_path = pki_profile_path
        self.post_accept_timeout = post_accept_timeout
        self.reset_conn_http_on_ssl_port = reset_conn_http_on_ssl_port
        self.respond_with100_continue = respond_with100_continue
        self.secure_cookie_enabled = secure_cookie_enabled
        self.server_side_redirect_to_https = server_side_redirect_to_https
        self.ssl_client_certificate_action = ssl_client_certificate_action
        self.ssl_client_certificate_mode = ssl_client_certificate_mode
        self.use_app_keepalive_timeout = use_app_keepalive_timeout
        self.websockets_enabled = websockets_enabled
        self.x_forwarded_proto_enabled = x_forwarded_proto_enabled
        self.xff_alternate_name = xff_alternate_name
        self.xff_enabled = xff_enabled
        VapiStruct.__init__(self)


ALBHTTPApplicationProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_application_profile', {
        'allow_dots_in_header_name': type.OptionalType(type.BooleanType()),
        'cache_config': type.OptionalType(type.ReferenceType(__name__, 'ALBHttpCacheConfig')),
        'client_body_timeout': type.OptionalType(type.IntegerType()),
        'client_header_timeout': type.OptionalType(type.IntegerType()),
        'client_max_body_size': type.OptionalType(type.IntegerType()),
        'client_max_header_size': type.OptionalType(type.IntegerType()),
        'client_max_request_size': type.OptionalType(type.IntegerType()),
        'compression_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBCompressionProfile')),
        'connection_multiplexing_enabled': type.OptionalType(type.BooleanType()),
        'disable_keepalive_posts_msie6': type.OptionalType(type.BooleanType()),
        'disable_sni_hostname_check': type.OptionalType(type.BooleanType()),
        'enable_chunk_merge': type.OptionalType(type.BooleanType()),
        'enable_fire_and_forget': type.OptionalType(type.BooleanType()),
        'enable_request_body_buffering': type.OptionalType(type.BooleanType()),
        'enable_request_body_metrics': type.OptionalType(type.BooleanType()),
        'fwd_close_hdr_for_bound_connections': type.OptionalType(type.BooleanType()),
        'hsts_enabled': type.OptionalType(type.BooleanType()),
        'hsts_max_age': type.OptionalType(type.IntegerType()),
        'hsts_subdomains_enabled': type.OptionalType(type.BooleanType()),
        'http2_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTP2ApplicationProfile')),
        'http_to_https': type.OptionalType(type.BooleanType()),
        'http_upstream_buffer_size': type.OptionalType(type.IntegerType()),
        'httponly_enabled': type.OptionalType(type.BooleanType()),
        'keepalive_header': type.OptionalType(type.BooleanType()),
        'keepalive_timeout': type.OptionalType(type.IntegerType()),
        'max_bad_rps_cip': type.OptionalType(type.IntegerType()),
        'max_bad_rps_cip_uri': type.OptionalType(type.IntegerType()),
        'max_bad_rps_uri': type.OptionalType(type.IntegerType()),
        'max_keepalive_requests': type.OptionalType(type.IntegerType()),
        'max_response_headers_size': type.OptionalType(type.IntegerType()),
        'max_rps_cip': type.OptionalType(type.IntegerType()),
        'max_rps_cip_uri': type.OptionalType(type.IntegerType()),
        'max_rps_unknown_cip': type.OptionalType(type.IntegerType()),
        'max_rps_unknown_uri': type.OptionalType(type.IntegerType()),
        'max_rps_uri': type.OptionalType(type.IntegerType()),
        'pki_profile_path': type.OptionalType(type.StringType()),
        'post_accept_timeout': type.OptionalType(type.IntegerType()),
        'reset_conn_http_on_ssl_port': type.OptionalType(type.BooleanType()),
        'respond_with_100_continue': type.OptionalType(type.BooleanType()),
        'secure_cookie_enabled': type.OptionalType(type.BooleanType()),
        'server_side_redirect_to_https': type.OptionalType(type.BooleanType()),
        'ssl_client_certificate_action': type.OptionalType(type.ReferenceType(__name__, 'ALBSSLClientCertificateAction')),
        'ssl_client_certificate_mode': type.OptionalType(type.StringType()),
        'use_app_keepalive_timeout': type.OptionalType(type.BooleanType()),
        'websockets_enabled': type.OptionalType(type.BooleanType()),
        'x_forwarded_proto_enabled': type.OptionalType(type.BooleanType()),
        'xff_alternate_name': type.OptionalType(type.StringType()),
        'xff_enabled': type.OptionalType(type.BooleanType()),
    },
    ALBHTTPApplicationProfile,
    False,
    None))



class ALBHTTPClientAuthenticationParams(VapiStruct):
    """
    Advanced load balancer HTTPClientAuthenticationParams object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_AUTH = "HTTP_BASIC_AUTH"
    """


    """



    _canonical_to_pep_names = {
                            'auth_profile_path': 'auth_profile_path',
                            'realm': 'realm',
                            'request_uri_path': 'request_uri_path',
                            'type': 'type',
                            }

    def __init__(self,
                 auth_profile_path=None,
                 realm=None,
                 request_uri_path=None,
                 type=None,
                ):
        """
        :type  auth_profile_path: :class:`str` or ``None``
        :param auth_profile_path: Auth Profile to use for validating users. It is a reference to an
            object of type AuthProfile.
        :type  realm: :class:`str` or ``None``
        :param realm: Basic authentication realm to present to a user along with the
            prompt for credentials.
        :type  request_uri_path: :class:`ALBStringMatch` or ``None``
        :param request_uri_path: 
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBHTTPClientAuthenticationParams.TYPE_AUTH`
            
             type of client authentication. Enum options - HTTP_BASIC_AUTH.
        """
        self.auth_profile_path = auth_profile_path
        self.realm = realm
        self.request_uri_path = request_uri_path
        self.type = type
        VapiStruct.__init__(self)


ALBHTTPClientAuthenticationParams._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_client_authentication_params', {
        'auth_profile_path': type.OptionalType(type.StringType()),
        'realm': type.OptionalType(type.StringType()),
        'request_uri_path': type.OptionalType(type.ReferenceType(__name__, 'ALBStringMatch')),
        'type': type.OptionalType(type.StringType()),
    },
    ALBHTTPClientAuthenticationParams,
    False,
    None))



class ALBHTTPCookieData(VapiStruct):
    """
    Advanced load balancer HTTPCookieData object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'value': 'value',
                            }

    def __init__(self,
                 name=None,
                 value=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: Cookie name.
        :type  value: :class:`str` or ``None``
        :param value: Cookie value.
        """
        self.name = name
        self.value = value
        VapiStruct.__init__(self)


ALBHTTPCookieData._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_cookie_data', {
        'name': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.StringType()),
    },
    ALBHTTPCookieData,
    False,
    None))



class ALBHTTPHdrAction(VapiStruct):
    """
    Advanced load balancer HTTPHdrAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTION_ADD_HDR = "HTTP_ADD_HDR"
    """


    """
    ACTION_REMOVE_HDR = "HTTP_REMOVE_HDR"
    """


    """
    ACTION_REPLACE_HDR = "HTTP_REPLACE_HDR"
    """


    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'cookie': 'cookie',
                            'hdr': 'hdr',
                            }

    def __init__(self,
                 action=None,
                 cookie=None,
                 hdr=None,
                ):
        """
        :type  action: :class:`str` or ``None``
        :param action: Possible values are: 
            
            * :attr:`ALBHTTPHdrAction.ACTION_ADD_HDR`
            * :attr:`ALBHTTPHdrAction.ACTION_REMOVE_HDR`
            * :attr:`ALBHTTPHdrAction.ACTION_REPLACE_HDR`
            
            ADD A new header with the new value is added irrespective of the
            existence of an HTTP header of the given name. REPLACE A new header
            with the new value is added if no header of the given name exists,
            else existing headers with the given name are removed and a new
            header with the new value is added. REMOVE All the headers of the
            given name are removed. Enum options - HTTP_ADD_HDR,
            HTTP_REMOVE_HDR, HTTP_REPLACE_HDR. Allowed in Basic(Allowed values-
            HTTP_REMOVE_HDR,HTTP_REPLACE_HDR) edition, Essentials(Allowed
            values- HTTP_REMOVE_HDR,HTTP_REPLACE_HDR) edition, Enterprise
            edition.
        :type  cookie: :class:`ALBHTTPCookieData` or ``None``
        :param cookie: 
        :type  hdr: :class:`ALBHTTPHdrData` or ``None``
        :param hdr: 
        """
        self.action = action
        self.cookie = cookie
        self.hdr = hdr
        VapiStruct.__init__(self)


ALBHTTPHdrAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_hdr_action', {
        'action': type.OptionalType(type.StringType()),
        'cookie': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPCookieData')),
        'hdr': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPHdrData')),
    },
    ALBHTTPHdrAction,
    False,
    None))



class ALBHTTPHdrData(VapiStruct):
    """
    Advanced load balancer HTTPHdrData object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'name': 'name',
                            'value': 'value',
                            }

    def __init__(self,
                 name=None,
                 value=None,
                ):
        """
        :type  name: :class:`str` or ``None``
        :param name: HTTP header name.
        :type  value: :class:`ALBHTTPHdrValue` or ``None``
        :param value: 
        """
        self.name = name
        self.value = value
        VapiStruct.__init__(self)


ALBHTTPHdrData._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_hdr_data', {
        'name': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPHdrValue')),
    },
    ALBHTTPHdrData,
    False,
    None))



class ALBHTTPHdrValue(VapiStruct):
    """
    Advanced load balancer HTTPHdrValue object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    VAR_CLIENT_IP = "HTTP_POLICY_VAR_CLIENT_IP"
    """


    """
    VAR_VS_PORT = "HTTP_POLICY_VAR_VS_PORT"
    """


    """
    VAR_VS_IP = "HTTP_POLICY_VAR_VS_IP"
    """


    """
    VAR_HTTP_HDR = "HTTP_POLICY_VAR_HTTP_HDR"
    """


    """
    VAR_SSL_CLIENT_FINGERPRINT = "HTTP_POLICY_VAR_SSL_CLIENT_FINGERPRINT"
    """


    """
    VAR_SSL_CLIENT_SERIAL = "HTTP_POLICY_VAR_SSL_CLIENT_SERIAL"
    """


    """
    VAR_SSL_CLIENT_ISSUER = "HTTP_POLICY_VAR_SSL_CLIENT_ISSUER"
    """


    """
    VAR_SSL_CLIENT_SUBJECT = "HTTP_POLICY_VAR_SSL_CLIENT_SUBJECT"
    """


    """
    VAR_SSL_CLIENT_RAW = "HTTP_POLICY_VAR_SSL_CLIENT_RAW"
    """


    """
    VAR_SSL_PROTOCOL = "HTTP_POLICY_VAR_SSL_PROTOCOL"
    """


    """
    VAR_SSL_SERVER_NAME = "HTTP_POLICY_VAR_SSL_SERVER_NAME"
    """


    """
    VAR_USER_NAME = "HTTP_POLICY_VAR_USER_NAME"
    """


    """
    VAR_SSL_CIPHER = "HTTP_POLICY_VAR_SSL_CIPHER"
    """


    """
    VAR_REQUEST_ID = "HTTP_POLICY_VAR_REQUEST_ID"
    """


    """
    VAR_SSL_CLIENT_VERSION = "HTTP_POLICY_VAR_SSL_CLIENT_VERSION"
    """


    """
    VAR_SSL_CLIENT_SIGALG = "HTTP_POLICY_VAR_SSL_CLIENT_SIGALG"
    """


    """
    VAR_SSL_CLIENT_NOTVALIDBEFORE = "HTTP_POLICY_VAR_SSL_CLIENT_NOTVALIDBEFORE"
    """


    """
    VAR_SSL_CLIENT_NOTVALIDAFTER = "HTTP_POLICY_VAR_SSL_CLIENT_NOTVALIDAFTER"
    """


    """



    _canonical_to_pep_names = {
                            'val': 'val',
                            'var': 'var',
                            }

    def __init__(self,
                 val=None,
                 var=None,
                ):
        """
        :type  val: :class:`str` or ``None``
        :param val: HTTP header value or variable representing an HTTP header.
        :type  var: :class:`str` or ``None``
        :param var: Possible values are: 
            
            * :attr:`ALBHTTPHdrValue.VAR_CLIENT_IP`
            * :attr:`ALBHTTPHdrValue.VAR_VS_PORT`
            * :attr:`ALBHTTPHdrValue.VAR_VS_IP`
            * :attr:`ALBHTTPHdrValue.VAR_HTTP_HDR`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_FINGERPRINT`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_SERIAL`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_ISSUER`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_SUBJECT`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_RAW`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_PROTOCOL`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_SERVER_NAME`
            * :attr:`ALBHTTPHdrValue.VAR_USER_NAME`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CIPHER`
            * :attr:`ALBHTTPHdrValue.VAR_REQUEST_ID`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_VERSION`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_SIGALG`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_NOTVALIDBEFORE`
            * :attr:`ALBHTTPHdrValue.VAR_SSL_CLIENT_NOTVALIDAFTER`
            
            Variable. Enum options - HTTP_POLICY_VAR_CLIENT_IP,
            HTTP_POLICY_VAR_VS_PORT, HTTP_POLICY_VAR_VS_IP,
            HTTP_POLICY_VAR_HTTP_HDR, HTTP_POLICY_VAR_SSL_CLIENT_FINGERPRINT,
            HTTP_POLICY_VAR_SSL_CLIENT_SERIAL,
            HTTP_POLICY_VAR_SSL_CLIENT_ISSUER,
            HTTP_POLICY_VAR_SSL_CLIENT_SUBJECT, HTTP_POLICY_VAR_SSL_CLIENT_RAW,
            HTTP_POLICY_VAR_SSL_PROTOCOL, HTTP_POLICY_VAR_SSL_SERVER_NAME,
            HTTP_POLICY_VAR_USER_NAME, HTTP_POLICY_VAR_SSL_CIPHER,
            HTTP_POLICY_VAR_REQUEST_ID, HTTP_POLICY_VAR_SSL_CLIENT_VERSION,
            HTTP_POLICY_VAR_SSL_CLIENT_SIGALG,
            HTTP_POLICY_VAR_SSL_CLIENT_NOTVALIDBEFORE,
            HTTP_POLICY_VAR_SSL_CLIENT_NOTVALIDAFTER.
        """
        self.val = val
        self.var = var
        VapiStruct.__init__(self)


ALBHTTPHdrValue._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_hdr_value', {
        'val': type.OptionalType(type.StringType()),
        'var': type.OptionalType(type.StringType()),
    },
    ALBHTTPHdrValue,
    False,
    None))



class ALBHTTPLocalFile(VapiStruct):
    """
    Advanced load balancer HTTPLocalFile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'content_type': 'content_type',
                            'file_content': 'file_content',
                            }

    def __init__(self,
                 content_type=None,
                 file_content=None,
                ):
        """
        :type  content_type: :class:`str` or ``None``
        :param content_type: Mime-type of the content in the file.
        :type  file_content: :class:`str` or ``None``
        :param file_content: File content to used in the local HTTP response body.
        """
        self.content_type = content_type
        self.file_content = file_content
        VapiStruct.__init__(self)


ALBHTTPLocalFile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_local_file', {
        'content_type': type.OptionalType(type.StringType()),
        'file_content': type.OptionalType(type.StringType()),
    },
    ALBHTTPLocalFile,
    False,
    None))



class ALBHTTPPolicies(VapiStruct):
    """
    Advanced load balancer HTTPPolicies object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'http_policy_set_path': 'http_policy_set_path',
                            'index': 'index',
                            }

    def __init__(self,
                 http_policy_set_path=None,
                 index=None,
                ):
        """
        :type  http_policy_set_path: :class:`str` or ``None``
        :param http_policy_set_path: path of the virtual service HTTP policy collection. It is a
            reference to an object of type HTTPPolicySet.
        :type  index: :class:`long` or ``None``
        :param index: Index of the virtual service HTTP policy collection. format: int64
        """
        self.http_policy_set_path = http_policy_set_path
        self.index = index
        VapiStruct.__init__(self)


ALBHTTPPolicies._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_policies', {
        'http_policy_set_path': type.OptionalType(type.StringType()),
        'index': type.OptionalType(type.IntegerType()),
    },
    ALBHTTPPolicies,
    False,
    None))



class ALBHTTPPolicySet(VapiStruct):
    """
    Advanced load balancer HTTPPolicySet object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'cloud_config_cksum': 'cloud_config_cksum',
                            'created_by': 'created_by',
                            'http_request_policy': 'http_request_policy',
                            'http_response_policy': 'http_response_policy',
                            'http_security_policy': 'http_security_policy',
                            'is_internal_policy': 'is_internal_policy',
                            'markers': 'markers',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 cloud_config_cksum=None,
                 created_by=None,
                 http_request_policy=None,
                 http_response_policy=None,
                 http_security_policy=None,
                 is_internal_policy=None,
                 markers=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cloud_config_cksum: :class:`str` or ``None``
        :param cloud_config_cksum: Checksum of cloud configuration for Pool. Internally set by cloud
            connector.
        :type  created_by: :class:`str` or ``None``
        :param created_by: Creator name.
        :type  http_request_policy: :class:`ALBHTTPRequestPolicy` or ``None``
        :param http_request_policy: 
        :type  http_response_policy: :class:`ALBHTTPResponsePolicy` or ``None``
        :param http_response_policy: 
        :type  http_security_policy: :class:`ALBHTTPSecurityPolicy` or ``None``
        :param http_security_policy: 
        :type  is_internal_policy: :class:`bool` or ``None``
        :param is_internal_policy: Placeholder for description of property is_internal_policy of obj
            type HTTPPolicySet field type str type boolean. Default value when
            not specified in API or module is interpreted by ALB Controller as
            false.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.cloud_config_cksum = cloud_config_cksum
        self.created_by = created_by
        self.http_request_policy = http_request_policy
        self.http_response_policy = http_response_policy
        self.http_security_policy = http_security_policy
        self.is_internal_policy = is_internal_policy
        self.markers = markers
        VapiStruct.__init__(self)


ALBHTTPPolicySet._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_policy_set', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'cloud_config_cksum': type.OptionalType(type.StringType()),
        'created_by': type.OptionalType(type.StringType()),
        'http_request_policy': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPRequestPolicy')),
        'http_response_policy': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPResponsePolicy')),
        'http_security_policy': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPSecurityPolicy')),
        'is_internal_policy': type.OptionalType(type.BooleanType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
    },
    ALBHTTPPolicySet,
    False,
    None))



class ALBHTTPPolicySetApiResponse(VapiStruct):
    """
    HTTPPolicySetApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBHTTPPolicySet` or ``None``
        :param results: Array of HTTPPolicySet
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBHTTPPolicySetApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_policy_set_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPPolicySet'))),
    },
    ALBHTTPPolicySetApiResponse,
    False,
    None))



class ALBHTTPRedirectAction(VapiStruct):
    """
    Advanced load balancer HTTPRedirectAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    PROTOCOL_HTTP = "HTTP"
    """


    """
    PROTOCOL_HTTPS = "HTTPS"
    """


    """
    STATUS_CODE_301 = "HTTP_REDIRECT_STATUS_CODE_301"
    """


    """
    STATUS_CODE_302 = "HTTP_REDIRECT_STATUS_CODE_302"
    """


    """
    STATUS_CODE_307 = "HTTP_REDIRECT_STATUS_CODE_307"
    """


    """



    _canonical_to_pep_names = {
                            'host': 'host',
                            'keep_query': 'keep_query',
                            'path': 'path',
                            'port': 'port',
                            'protocol': 'protocol',
                            'status_code': 'status_code',
                            }

    def __init__(self,
                 host=None,
                 keep_query=None,
                 path=None,
                 port=None,
                 protocol=None,
                 status_code=None,
                ):
        """
        :type  host: :class:`ALBURIParam` or ``None``
        :param host: 
        :type  keep_query: :class:`bool` or ``None``
        :param keep_query: Keep or drop the query of the incoming request URI in the
            redirected URI. Default value when not specified in API or module
            is interpreted by ALB Controller as true.
        :type  path: :class:`ALBURIParam` or ``None``
        :param path: 
        :type  port: :class:`long` or ``None``
        :param port: Port to which redirect the request. Allowed values are 1-65535.
            format: int64
        :type  protocol: :class:`str` or ``None``
        :param protocol: Possible values are: 
            
            * :attr:`ALBHTTPRedirectAction.PROTOCOL_HTTP`
            * :attr:`ALBHTTPRedirectAction.PROTOCOL_HTTPS`
            
             Protocol type. Enum options - HTTP, HTTPS.
        :type  status_code: :class:`str` or ``None``
        :param status_code: Possible values are: 
            
            * :attr:`ALBHTTPRedirectAction.STATUS_CODE__301`
            * :attr:`ALBHTTPRedirectAction.STATUS_CODE__302`
            * :attr:`ALBHTTPRedirectAction.STATUS_CODE__307`
            
            HTTP redirect status code. Enum options -
            HTTP_REDIRECT_STATUS_CODE_301, HTTP_REDIRECT_STATUS_CODE_302,
            HTTP_REDIRECT_STATUS_CODE_307. Default value when not specified in
            API or module is interpreted by ALB Controller as
            HTTP_REDIRECT_STATUS_CODE_302.
        """
        self.host = host
        self.keep_query = keep_query
        self.path = path
        self.port = port
        self.protocol = protocol
        self.status_code = status_code
        VapiStruct.__init__(self)


ALBHTTPRedirectAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_redirect_action', {
        'host': type.OptionalType(type.ReferenceType(__name__, 'ALBURIParam')),
        'keep_query': type.OptionalType(type.BooleanType()),
        'path': type.OptionalType(type.ReferenceType(__name__, 'ALBURIParam')),
        'port': type.OptionalType(type.IntegerType()),
        'protocol': type.OptionalType(type.StringType()),
        'status_code': type.OptionalType(type.StringType()),
    },
    ALBHTTPRedirectAction,
    False,
    None))



class ALBHTTPRequestPolicy(VapiStruct):
    """
    Advanced load balancer HTTPRequestPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rules': 'rules',
                            }

    def __init__(self,
                 rules=None,
                ):
        """
        :type  rules: :class:`list` of :class:`ALBHTTPRequestRule` or ``None``
        :param rules: Add rules to the HTTP request policy.
        """
        self.rules = rules
        VapiStruct.__init__(self)


ALBHTTPRequestPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_request_policy', {
        'rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPRequestRule'))),
    },
    ALBHTTPRequestPolicy,
    False,
    None))



class ALBHTTPRequestRule(VapiStruct):
    """
    Advanced load balancer HTTPRequestRule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'all_headers': 'all_headers',
                            'enable': 'enable',
                            'hdr_action': 'hdr_action',
                            'index': 'index',
                            'log': 'log',
                            'match': 'match',
                            'name': 'name',
                            'redirect_action': 'redirect_action',
                            'rewrite_url_action': 'rewrite_url_action',
                            'switching_action': 'switching_action',
                            }

    def __init__(self,
                 all_headers=None,
                 enable=None,
                 hdr_action=None,
                 index=None,
                 log=None,
                 match=None,
                 name=None,
                 redirect_action=None,
                 rewrite_url_action=None,
                 switching_action=None,
                ):
        """
        :type  all_headers: :class:`bool` or ``None``
        :param all_headers: Log all HTTP headers upon rule match.
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable the rule. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  hdr_action: :class:`list` of :class:`ALBHTTPHdrAction` or ``None``
        :param hdr_action: HTTP header rewrite action.
        :type  index: :class:`long` or ``None``
        :param index: Index of the rule. format: int64
        :type  log: :class:`bool` or ``None``
        :param log: Log HTTP request upon rule match.
        :type  match: :class:`ALBMatchTarget` or ``None``
        :param match: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the rule.
        :type  redirect_action: :class:`ALBHTTPRedirectAction` or ``None``
        :param redirect_action: 
        :type  rewrite_url_action: :class:`ALBHTTPRewriteURLAction` or ``None``
        :param rewrite_url_action: 
        :type  switching_action: :class:`ALBHTTPSwitchingAction` or ``None``
        :param switching_action: 
        """
        self.all_headers = all_headers
        self.enable = enable
        self.hdr_action = hdr_action
        self.index = index
        self.log = log
        self.match = match
        self.name = name
        self.redirect_action = redirect_action
        self.rewrite_url_action = rewrite_url_action
        self.switching_action = switching_action
        VapiStruct.__init__(self)


ALBHTTPRequestRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_request_rule', {
        'all_headers': type.OptionalType(type.BooleanType()),
        'enable': type.OptionalType(type.BooleanType()),
        'hdr_action': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPHdrAction'))),
        'index': type.OptionalType(type.IntegerType()),
        'log': type.OptionalType(type.BooleanType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBMatchTarget')),
        'name': type.OptionalType(type.StringType()),
        'redirect_action': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPRedirectAction')),
        'rewrite_url_action': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPRewriteURLAction')),
        'switching_action': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPSwitchingAction')),
    },
    ALBHTTPRequestRule,
    False,
    None))



class ALBHTTPReselectRespCode(VapiStruct):
    """
    Advanced load balancer HTTPReselectRespCode object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    RESP_CODE_BLOCK_4XX = "HTTP_RSP_4XX"
    """


    """
    RESP_CODE_BLOCK_5XX = "HTTP_RSP_5XX"
    """


    """



    _canonical_to_pep_names = {
                            'codes': 'codes',
                            'ranges': 'ranges',
                            'resp_code_block': 'resp_code_block',
                            }

    def __init__(self,
                 codes=None,
                 ranges=None,
                 resp_code_block=None,
                ):
        """
        :type  codes: :class:`list` of :class:`long` or ``None``
        :param codes: HTTP response code to be matched. Allowed values are 400-599.
            format: int64
        :type  ranges: :class:`list` of :class:`ALBHTTPStatusRange` or ``None``
        :param ranges: HTTP response code ranges to match.
        :type  resp_code_block: :class:`list` of :class:`str` or ``None``
        :param resp_code_block: Possible values are: 
            
            * :attr:`ALBHTTPReselectRespCode.RESP_CODE_BLOCK__4XX`
            * :attr:`ALBHTTPReselectRespCode.RESP_CODE_BLOCK__5XX`
            
            Block of HTTP response codes to match for server reselect. Enum
            options - HTTP_RSP_4XX, HTTP_RSP_5XX.
        """
        self.codes = codes
        self.ranges = ranges
        self.resp_code_block = resp_code_block
        VapiStruct.__init__(self)


ALBHTTPReselectRespCode._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_reselect_resp_code', {
        'codes': type.OptionalType(type.ListType(type.IntegerType())),
        'ranges': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPStatusRange'))),
        'resp_code_block': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBHTTPReselectRespCode,
    False,
    None))



class ALBHTTPResponsePolicy(VapiStruct):
    """
    Advanced load balancer HTTPResponsePolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rules': 'rules',
                            }

    def __init__(self,
                 rules=None,
                ):
        """
        :type  rules: :class:`list` of :class:`ALBHTTPResponseRule` or ``None``
        :param rules: Add rules to the HTTP response policy.
        """
        self.rules = rules
        VapiStruct.__init__(self)


ALBHTTPResponsePolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_response_policy', {
        'rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPResponseRule'))),
    },
    ALBHTTPResponsePolicy,
    False,
    None))



class ALBHTTPResponseRule(VapiStruct):
    """
    Advanced load balancer HTTPResponseRule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'all_headers': 'all_headers',
                            'enable': 'enable',
                            'hdr_action': 'hdr_action',
                            'index': 'index',
                            'loc_hdr_action': 'loc_hdr_action',
                            'log': 'log',
                            'match': 'match',
                            'name': 'name',
                            }

    def __init__(self,
                 all_headers=None,
                 enable=None,
                 hdr_action=None,
                 index=None,
                 loc_hdr_action=None,
                 log=None,
                 match=None,
                 name=None,
                ):
        """
        :type  all_headers: :class:`bool` or ``None``
        :param all_headers: Log all HTTP headers upon rule match.
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable the rule. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  hdr_action: :class:`list` of :class:`ALBHTTPHdrAction` or ``None``
        :param hdr_action: HTTP header rewrite action.
        :type  index: :class:`long` or ``None``
        :param index: Index of the rule. format: int64
        :type  loc_hdr_action: :class:`ALBHTTPRewriteLocHdrAction` or ``None``
        :param loc_hdr_action: 
        :type  log: :class:`bool` or ``None``
        :param log: Log HTTP request upon rule match.
        :type  match: :class:`ALBResponseMatchTarget` or ``None``
        :param match: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the rule.
        """
        self.all_headers = all_headers
        self.enable = enable
        self.hdr_action = hdr_action
        self.index = index
        self.loc_hdr_action = loc_hdr_action
        self.log = log
        self.match = match
        self.name = name
        VapiStruct.__init__(self)


ALBHTTPResponseRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_response_rule', {
        'all_headers': type.OptionalType(type.BooleanType()),
        'enable': type.OptionalType(type.BooleanType()),
        'hdr_action': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPHdrAction'))),
        'index': type.OptionalType(type.IntegerType()),
        'loc_hdr_action': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPRewriteLocHdrAction')),
        'log': type.OptionalType(type.BooleanType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBResponseMatchTarget')),
        'name': type.OptionalType(type.StringType()),
    },
    ALBHTTPResponseRule,
    False,
    None))



class ALBHTTPRewriteLocHdrAction(VapiStruct):
    """
    Advanced load balancer HTTPRewriteLocHdrAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    PROTOCOL_HTTP = "HTTP"
    """


    """
    PROTOCOL_HTTPS = "HTTPS"
    """


    """



    _canonical_to_pep_names = {
                            'host': 'host',
                            'keep_query': 'keep_query',
                            'path': 'path',
                            'port': 'port',
                            'protocol': 'protocol',
                            }

    def __init__(self,
                 host=None,
                 keep_query=None,
                 path=None,
                 port=None,
                 protocol=None,
                ):
        """
        :type  host: :class:`ALBURIParam` or ``None``
        :param host: 
        :type  keep_query: :class:`bool` or ``None``
        :param keep_query: Keep or drop the query from the server side redirect URI. Default
            value when not specified in API or module is interpreted by ALB
            Controller as true.
        :type  path: :class:`ALBURIParam` or ``None``
        :param path: 
        :type  port: :class:`long` or ``None``
        :param port: Port to use in the redirected URI. Allowed values are 1-65535.
            format: int64
        :type  protocol: :class:`str` or ``None``
        :param protocol: Possible values are: 
            
            * :attr:`ALBHTTPRewriteLocHdrAction.PROTOCOL_HTTP`
            * :attr:`ALBHTTPRewriteLocHdrAction.PROTOCOL_HTTPS`
            
             HTTP protocol type. Enum options - HTTP, HTTPS.
        """
        self.host = host
        self.keep_query = keep_query
        self.path = path
        self.port = port
        self.protocol = protocol
        VapiStruct.__init__(self)


ALBHTTPRewriteLocHdrAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_rewrite_loc_hdr_action', {
        'host': type.OptionalType(type.ReferenceType(__name__, 'ALBURIParam')),
        'keep_query': type.OptionalType(type.BooleanType()),
        'path': type.OptionalType(type.ReferenceType(__name__, 'ALBURIParam')),
        'port': type.OptionalType(type.IntegerType()),
        'protocol': type.OptionalType(type.StringType()),
    },
    ALBHTTPRewriteLocHdrAction,
    False,
    None))



class ALBHTTPRewriteURLAction(VapiStruct):
    """
    Advanced load balancer HTTPRewriteURLAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'host_hdr': 'host_hdr',
                            'path': 'path',
                            'query': 'query',
                            }

    def __init__(self,
                 host_hdr=None,
                 path=None,
                 query=None,
                ):
        """
        :type  host_hdr: :class:`ALBURIParam` or ``None``
        :param host_hdr: 
        :type  path: :class:`ALBURIParam` or ``None``
        :param path: 
        :type  query: :class:`ALBURIParamQuery` or ``None``
        :param query: 
        """
        self.host_hdr = host_hdr
        self.path = path
        self.query = query
        VapiStruct.__init__(self)


ALBHTTPRewriteURLAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_rewrite_URL_action', {
        'host_hdr': type.OptionalType(type.ReferenceType(__name__, 'ALBURIParam')),
        'path': type.OptionalType(type.ReferenceType(__name__, 'ALBURIParam')),
        'query': type.OptionalType(type.ReferenceType(__name__, 'ALBURIParamQuery')),
    },
    ALBHTTPRewriteURLAction,
    False,
    None))



class ALBHTTPSecurityAction(VapiStruct):
    """
    Advanced load balancer HTTPSecurityAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTION_CLOSE_CONN = "HTTP_SECURITY_ACTION_CLOSE_CONN"
    """


    """
    ACTION_SEND_RESPONSE = "HTTP_SECURITY_ACTION_SEND_RESPONSE"
    """


    """
    ACTION_ALLOW = "HTTP_SECURITY_ACTION_ALLOW"
    """


    """
    ACTION_REDIRECT_TO_HTTPS = "HTTP_SECURITY_ACTION_REDIRECT_TO_HTTPS"
    """


    """
    ACTION_RATE_LIMIT = "HTTP_SECURITY_ACTION_RATE_LIMIT"
    """


    """
    ACTION_REQUEST_CHECK_ICAP = "HTTP_SECURITY_ACTION_REQUEST_CHECK_ICAP"
    """


    """
    STATUS_CODE_200 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_200"
    """


    """
    STATUS_CODE_204 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_204"
    """


    """
    STATUS_CODE_403 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_403"
    """


    """
    STATUS_CODE_404 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_404"
    """


    """
    STATUS_CODE_429 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_429"
    """


    """
    STATUS_CODE_501 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_501"
    """


    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'file': 'file',
                            'https_port': 'https_port',
                            'rate_profile': 'rate_profile',
                            'status_code': 'status_code',
                            }

    def __init__(self,
                 action=None,
                 file=None,
                 https_port=None,
                 rate_profile=None,
                 status_code=None,
                ):
        """
        :type  action: :class:`str` or ``None``
        :param action: Possible values are: 
            
            * :attr:`ALBHTTPSecurityAction.ACTION_CLOSE_CONN`
            * :attr:`ALBHTTPSecurityAction.ACTION_SEND_RESPONSE`
            * :attr:`ALBHTTPSecurityAction.ACTION_ALLOW`
            * :attr:`ALBHTTPSecurityAction.ACTION_REDIRECT_TO_HTTPS`
            * :attr:`ALBHTTPSecurityAction.ACTION_RATE_LIMIT`
            * :attr:`ALBHTTPSecurityAction.ACTION_REQUEST_CHECK_ICAP`
            
            Type of the security action to perform. Enum options -
            HTTP_SECURITY_ACTION_CLOSE_CONN,
            HTTP_SECURITY_ACTION_SEND_RESPONSE, HTTP_SECURITY_ACTION_ALLOW,
            HTTP_SECURITY_ACTION_REDIRECT_TO_HTTPS,
            HTTP_SECURITY_ACTION_RATE_LIMIT,
            HTTP_SECURITY_ACTION_REQUEST_CHECK_ICAP. Allowed in Basic(Allowed
            values-
            HTTP_SECURITY_ACTION_CLOSE_CONN,HTTP_SECURITY_ACTION_SEND_RESPONSE,HTTP_SECURITY_ACTION_REDIRECT_TO_HTTPS)
            edition, Essentials(Allowed values-
            HTTP_SECURITY_ACTION_CLOSE_CONN,HTTP_SECURITY_ACTION_SEND_RESPONSE,HTTP_SECURITY_ACTION_REDIRECT_TO_HTTPS)
            edition, Enterprise edition.
        :type  file: :class:`ALBHTTPLocalFile` or ``None``
        :param file: 
        :type  https_port: :class:`long` or ``None``
        :param https_port: Secure SSL/TLS port to redirect the HTTP request to. Allowed values
            are 1-65535. format: int64
        :type  rate_profile: :class:`ALBHTTPSecurityActionRateProfile` or ``None``
        :param rate_profile: 
        :type  status_code: :class:`str` or ``None``
        :param status_code: Possible values are: 
            
            * :attr:`ALBHTTPSecurityAction.STATUS_CODE__200`
            * :attr:`ALBHTTPSecurityAction.STATUS_CODE__204`
            * :attr:`ALBHTTPSecurityAction.STATUS_CODE__403`
            * :attr:`ALBHTTPSecurityAction.STATUS_CODE__404`
            * :attr:`ALBHTTPSecurityAction.STATUS_CODE__429`
            * :attr:`ALBHTTPSecurityAction.STATUS_CODE__501`
            
            HTTP status code to use for local response. Enum options -
            HTTP_LOCAL_RESPONSE_STATUS_CODE_200,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_204,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_403,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_404,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_429,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_501.
        """
        self.action = action
        self.file = file
        self.https_port = https_port
        self.rate_profile = rate_profile
        self.status_code = status_code
        VapiStruct.__init__(self)


ALBHTTPSecurityAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_security_action', {
        'action': type.OptionalType(type.StringType()),
        'file': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPLocalFile')),
        'https_port': type.OptionalType(type.IntegerType()),
        'rate_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPSecurityActionRateProfile')),
        'status_code': type.OptionalType(type.StringType()),
    },
    ALBHTTPSecurityAction,
    False,
    None))



class ALBHTTPSecurityActionRateProfile(VapiStruct):
    """
    Advanced load balancer HTTPSecurityActionRateProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'per_client_ip': 'per_client_ip',
                            'per_uri_path': 'per_uri_path',
                            'rate_limiter': 'rate_limiter',
                            }

    def __init__(self,
                 action=None,
                 per_client_ip=None,
                 per_uri_path=None,
                 rate_limiter=None,
                ):
        """
        :type  action: :class:`ALBRateLimiterAction` or ``None``
        :param action: 
        :type  per_client_ip: :class:`bool` or ``None``
        :param per_client_ip: Rate limiting should be done on a per client ip basis.
        :type  per_uri_path: :class:`bool` or ``None``
        :param per_uri_path: Rate limiting should be done on a per request uri path basis.
        :type  rate_limiter: :class:`ALBRateLimiter` or ``None``
        :param rate_limiter: 
        """
        self.action = action
        self.per_client_ip = per_client_ip
        self.per_uri_path = per_uri_path
        self.rate_limiter = rate_limiter
        VapiStruct.__init__(self)


ALBHTTPSecurityActionRateProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_security_action_rate_profile', {
        'action': type.OptionalType(type.ReferenceType(__name__, 'ALBRateLimiterAction')),
        'per_client_ip': type.OptionalType(type.BooleanType()),
        'per_uri_path': type.OptionalType(type.BooleanType()),
        'rate_limiter': type.OptionalType(type.ReferenceType(__name__, 'ALBRateLimiter')),
    },
    ALBHTTPSecurityActionRateProfile,
    False,
    None))



class ALBHTTPSecurityPolicy(VapiStruct):
    """
    Advanced load balancer HTTPSecurityPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rules': 'rules',
                            }

    def __init__(self,
                 rules=None,
                ):
        """
        :type  rules: :class:`list` of :class:`ALBHTTPSecurityRule` or ``None``
        :param rules: Add rules to the HTTP security policy.
        """
        self.rules = rules
        VapiStruct.__init__(self)


ALBHTTPSecurityPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_security_policy', {
        'rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPSecurityRule'))),
    },
    ALBHTTPSecurityPolicy,
    False,
    None))



class ALBHTTPSecurityRule(VapiStruct):
    """
    Advanced load balancer HTTPSecurityRule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'enable': 'enable',
                            'index': 'index',
                            'log': 'log',
                            'match': 'match',
                            'name': 'name',
                            }

    def __init__(self,
                 action=None,
                 enable=None,
                 index=None,
                 log=None,
                 match=None,
                 name=None,
                ):
        """
        :type  action: :class:`ALBHTTPSecurityAction` or ``None``
        :param action: 
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable the rule. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  index: :class:`long` or ``None``
        :param index: Index of the rule. format: int64
        :type  log: :class:`bool` or ``None``
        :param log: Log HTTP request upon rule match.
        :type  match: :class:`ALBMatchTarget` or ``None``
        :param match: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the rule.
        """
        self.action = action
        self.enable = enable
        self.index = index
        self.log = log
        self.match = match
        self.name = name
        VapiStruct.__init__(self)


ALBHTTPSecurityRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_security_rule', {
        'action': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPSecurityAction')),
        'enable': type.OptionalType(type.BooleanType()),
        'index': type.OptionalType(type.IntegerType()),
        'log': type.OptionalType(type.BooleanType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBMatchTarget')),
        'name': type.OptionalType(type.StringType()),
    },
    ALBHTTPSecurityRule,
    False,
    None))



class ALBHTTPServerReselect(VapiStruct):
    """
    Advanced load balancer HTTPServerReselect object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enabled': 'enabled',
                            'num_retries': 'num_retries',
                            'retry_nonidempotent': 'retry_nonidempotent',
                            'retry_timeout': 'retry_timeout',
                            'svr_resp_code': 'svr_resp_code',
                            }

    def __init__(self,
                 enabled=None,
                 num_retries=None,
                 retry_nonidempotent=None,
                 retry_timeout=None,
                 svr_resp_code=None,
                ):
        """
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable HTTP request reselect when server responds with specific
            response codes. Allowed in Basic(Allowed values- false) edition,
            Essentials(Allowed values- false) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as false.
        :type  num_retries: :class:`long` or ``None``
        :param num_retries: Number of times to retry an HTTP request when server responds with
            configured status codes. Default value when not specified in API or
            module is interpreted by ALB Controller as 4. format: int64
        :type  retry_nonidempotent: :class:`bool` or ``None``
        :param retry_nonidempotent: Allow retry of non-idempotent HTTP requests. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  retry_timeout: :class:`long` or ``None``
        :param retry_timeout: Timeout per retry attempt, for a given request. Value of 0
            indicates default timeout. Allowed values are 0-3600000. Unit is
            MILLISECONDS. Default value when not specified in API or module is
            interpreted by ALB Controller as 0. format: int64
        :type  svr_resp_code: :class:`ALBHTTPReselectRespCode` or ``None``
        :param svr_resp_code: 
        """
        self.enabled = enabled
        self.num_retries = num_retries
        self.retry_nonidempotent = retry_nonidempotent
        self.retry_timeout = retry_timeout
        self.svr_resp_code = svr_resp_code
        VapiStruct.__init__(self)


ALBHTTPServerReselect._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_server_reselect', {
        'enabled': type.OptionalType(type.BooleanType()),
        'num_retries': type.OptionalType(type.IntegerType()),
        'retry_nonidempotent': type.OptionalType(type.BooleanType()),
        'retry_timeout': type.OptionalType(type.IntegerType()),
        'svr_resp_code': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPReselectRespCode')),
    },
    ALBHTTPServerReselect,
    False,
    None))



class ALBHTTPStatusMatch(VapiStruct):
    """
    Advanced load balancer HTTPStatusMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            'ranges': 'ranges',
                            'status_codes': 'status_codes',
                            }

    def __init__(self,
                 match_criteria=None,
                 ranges=None,
                 status_codes=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBHTTPStatusMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBHTTPStatusMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for matching the HTTP response status code(s).
            Enum options - IS_IN, IS_NOT_IN.
        :type  ranges: :class:`list` of :class:`ALBHTTPStatusRange` or ``None``
        :param ranges: HTTP response status code range(s).
        :type  status_codes: :class:`list` of :class:`long` or ``None``
        :param status_codes: HTTP response status code(s). format: int64
        """
        self.match_criteria = match_criteria
        self.ranges = ranges
        self.status_codes = status_codes
        VapiStruct.__init__(self)


ALBHTTPStatusMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_status_match', {
        'match_criteria': type.OptionalType(type.StringType()),
        'ranges': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHTTPStatusRange'))),
        'status_codes': type.OptionalType(type.ListType(type.IntegerType())),
    },
    ALBHTTPStatusMatch,
    False,
    None))



class ALBHTTPStatusRange(VapiStruct):
    """
    Advanced load balancer HTTPStatusRange object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'begin': 'begin',
                            'end': 'end',
                            }

    def __init__(self,
                 begin=None,
                 end=None,
                ):
        """
        :type  begin: :class:`long` or ``None``
        :param begin: Starting HTTP response status code. format: int64
        :type  end: :class:`long` or ``None``
        :param end: Ending HTTP response status code. format: int64
        """
        self.begin = begin
        self.end = end
        VapiStruct.__init__(self)


ALBHTTPStatusRange._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_status_range', {
        'begin': type.OptionalType(type.IntegerType()),
        'end': type.OptionalType(type.IntegerType()),
    },
    ALBHTTPStatusRange,
    False,
    None))



class ALBHTTPSwitchingAction(VapiStruct):
    """
    Advanced load balancer HTTPSwitchingAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTION_POOL = "HTTP_SWITCHING_SELECT_POOL"
    """


    """
    ACTION_LOCAL = "HTTP_SWITCHING_SELECT_LOCAL"
    """


    """
    ACTION_POOLGROUP = "HTTP_SWITCHING_SELECT_POOLGROUP"
    """


    """
    STATUS_CODE_200 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_200"
    """


    """
    STATUS_CODE_204 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_204"
    """


    """
    STATUS_CODE_403 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_403"
    """


    """
    STATUS_CODE_404 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_404"
    """


    """
    STATUS_CODE_429 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_429"
    """


    """
    STATUS_CODE_501 = "HTTP_LOCAL_RESPONSE_STATUS_CODE_501"
    """


    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'file': 'file',
                            'pool_group_path': 'pool_group_path',
                            'pool_path': 'pool_path',
                            'server': 'server',
                            'status_code': 'status_code',
                            }

    def __init__(self,
                 action=None,
                 file=None,
                 pool_group_path=None,
                 pool_path=None,
                 server=None,
                 status_code=None,
                ):
        """
        :type  action: :class:`str` or ``None``
        :param action: Possible values are: 
            
            * :attr:`ALBHTTPSwitchingAction.ACTION_POOL`
            * :attr:`ALBHTTPSwitchingAction.ACTION_LOCAL`
            * :attr:`ALBHTTPSwitchingAction.ACTION_POOLGROUP`
            
            Content switching action type. Enum options -
            HTTP_SWITCHING_SELECT_POOL, HTTP_SWITCHING_SELECT_LOCAL,
            HTTP_SWITCHING_SELECT_POOLGROUP. Allowed in Essentials(Allowed
            values- HTTP_SWITCHING_SELECT_POOL,HTTP_SWITCHING_SELECT_LOCAL)
            edition, Enterprise edition.
        :type  file: :class:`ALBHTTPLocalFile` or ``None``
        :param file: 
        :type  pool_group_path: :class:`str` or ``None``
        :param pool_group_path: path of the pool group to serve the request. It is a reference to
            an object of type PoolGroup.
        :type  pool_path: :class:`str` or ``None``
        :param pool_path: path of the pool of servers to serve the request. It is a reference
            to an object of type Pool.
        :type  server: :class:`ALBPoolServer` or ``None``
        :param server: 
        :type  status_code: :class:`str` or ``None``
        :param status_code: Possible values are: 
            
            * :attr:`ALBHTTPSwitchingAction.STATUS_CODE__200`
            * :attr:`ALBHTTPSwitchingAction.STATUS_CODE__204`
            * :attr:`ALBHTTPSwitchingAction.STATUS_CODE__403`
            * :attr:`ALBHTTPSwitchingAction.STATUS_CODE__404`
            * :attr:`ALBHTTPSwitchingAction.STATUS_CODE__429`
            * :attr:`ALBHTTPSwitchingAction.STATUS_CODE__501`
            
            HTTP status code to use when serving local response. Enum options -
            HTTP_LOCAL_RESPONSE_STATUS_CODE_200,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_204,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_403,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_404,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_429,
            HTTP_LOCAL_RESPONSE_STATUS_CODE_501.
        """
        self.action = action
        self.file = file
        self.pool_group_path = pool_group_path
        self.pool_path = pool_path
        self.server = server
        self.status_code = status_code
        VapiStruct.__init__(self)


ALBHTTPSwitchingAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_switching_action', {
        'action': type.OptionalType(type.StringType()),
        'file': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPLocalFile')),
        'pool_group_path': type.OptionalType(type.StringType()),
        'pool_path': type.OptionalType(type.StringType()),
        'server': type.OptionalType(type.ReferenceType(__name__, 'ALBPoolServer')),
        'status_code': type.OptionalType(type.StringType()),
    },
    ALBHTTPSwitchingAction,
    False,
    None))



class ALBHTTPVersionMatch(VapiStruct):
    """
    Advanced load balancer HTTPVersionMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """
    VERSIONS_ZERO_NINE = "ZERO_NINE"
    """


    """
    VERSIONS_ONE_ZERO = "ONE_ZERO"
    """


    """
    VERSIONS_ONE_ONE = "ONE_ONE"
    """


    """
    VERSIONS_TWO_ZERO = "TWO_ZERO"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            'versions': 'versions',
                            }

    def __init__(self,
                 match_criteria=None,
                 versions=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBHTTPVersionMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBHTTPVersionMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for HTTP version matching the version used in the
            HTTP request. Enum options - IS_IN, IS_NOT_IN.
        :type  versions: :class:`list` of :class:`str` or ``None``
        :param versions: Possible values are: 
            
            * :attr:`ALBHTTPVersionMatch.VERSIONS_ZERO_NINE`
            * :attr:`ALBHTTPVersionMatch.VERSIONS_ONE_ZERO`
            * :attr:`ALBHTTPVersionMatch.VERSIONS_ONE_ONE`
            * :attr:`ALBHTTPVersionMatch.VERSIONS_TWO_ZERO`
            
            HTTP protocol version. Enum options - ZERO_NINE, ONE_ZERO, ONE_ONE,
            TWO_ZERO. Minimum of 1 items required. Maximum of 8 items allowed.
            Allowed in Basic(Allowed values- ONE_ZERO,ONE_ONE) edition,
            Essentials(Allowed values- ONE_ZERO,ONE_ONE) edition, Enterprise
            edition.
        """
        self.match_criteria = match_criteria
        self.versions = versions
        VapiStruct.__init__(self)


ALBHTTPVersionMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBHTTP_version_match', {
        'match_criteria': type.OptionalType(type.StringType()),
        'versions': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBHTTPVersionMatch,
    False,
    None))



class ALBHardwareSecurityModule(VapiStruct):
    """
    Advanced load balancer HardwareSecurityModule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_THALES_NETHSM = "HSM_TYPE_THALES_NETHSM"
    """


    """
    TYPE_SAFENET_LUNA = "HSM_TYPE_SAFENET_LUNA"
    """


    """
    TYPE_AWS_CLOUDHSM = "HSM_TYPE_AWS_CLOUDHSM"
    """


    """



    _canonical_to_pep_names = {
                            'cloudhsm': 'cloudhsm',
                            'nethsm': 'nethsm',
                            'rfs': 'rfs',
                            'sluna': 'sluna',
                            'type': 'type',
                            }

    def __init__(self,
                 cloudhsm=None,
                 nethsm=None,
                 rfs=None,
                 sluna=None,
                 type=None,
                ):
        """
        :type  cloudhsm: :class:`ALBHSMAwsCloudHsm` or ``None``
        :param cloudhsm: 
        :type  nethsm: :class:`list` of :class:`ALBHSMThalesNetHsm` or ``None``
        :param nethsm: Thales netHSM specific configuration.
        :type  rfs: :class:`ALBHSMThalesRFS` or ``None``
        :param rfs: 
        :type  sluna: :class:`ALBHSMSafenetLuna` or ``None``
        :param sluna: 
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBHardwareSecurityModule.TYPE_THALES_NETHSM`
            * :attr:`ALBHardwareSecurityModule.TYPE_SAFENET_LUNA`
            * :attr:`ALBHardwareSecurityModule.TYPE_AWS_CLOUDHSM`
            
            HSM type to use. Enum options - HSM_TYPE_THALES_NETHSM,
            HSM_TYPE_SAFENET_LUNA, HSM_TYPE_AWS_CLOUDHSM.
        """
        self.cloudhsm = cloudhsm
        self.nethsm = nethsm
        self.rfs = rfs
        self.sluna = sluna
        self.type = type
        VapiStruct.__init__(self)


ALBHardwareSecurityModule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_hardware_security_module', {
        'cloudhsm': type.OptionalType(type.ReferenceType(__name__, 'ALBHSMAwsCloudHsm')),
        'nethsm': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHSMThalesNetHsm'))),
        'rfs': type.OptionalType(type.ReferenceType(__name__, 'ALBHSMThalesRFS')),
        'sluna': type.OptionalType(type.ReferenceType(__name__, 'ALBHSMSafenetLuna')),
        'type': type.OptionalType(type.StringType()),
    },
    ALBHardwareSecurityModule,
    False,
    None))



class ALBHardwareSecurityModuleGroup(VapiStruct):
    """
    Advanced load balancer HardwareSecurityModuleGroup object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'hsm': 'hsm',
                            'markers': 'markers',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 hsm=None,
                 markers=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  hsm: :class:`ALBHardwareSecurityModule` or ``None``
        :param hsm: 
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.hsm = hsm
        self.markers = markers
        VapiStruct.__init__(self)


ALBHardwareSecurityModuleGroup._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_hardware_security_module_group', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'hsm': type.OptionalType(type.ReferenceType(__name__, 'ALBHardwareSecurityModule')),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
    },
    ALBHardwareSecurityModuleGroup,
    False,
    None))



class ALBHardwareSecurityModuleGroupApiResponse(VapiStruct):
    """
    HardwareSecurityModuleGroupApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBHardwareSecurityModuleGroup` or ``None``
        :param results: Array of HardwareSecurityModuleGroup
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBHardwareSecurityModuleGroupApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_hardware_security_module_group_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHardwareSecurityModuleGroup'))),
    },
    ALBHardwareSecurityModuleGroupApiResponse,
    False,
    None))



class ALBHdrMatch(VapiStruct):
    """
    Advanced load balancer HdrMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CASE_SENSITIVE = "SENSITIVE"
    """


    """
    MATCH_CASE_INSENSITIVE = "INSENSITIVE"
    """


    """
    MATCH_CRITERIA_EXISTS = "HDR_EXISTS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EXIST = "HDR_DOES_NOT_EXIST"
    """


    """
    MATCH_CRITERIA_BEGINS_WITH = "HDR_BEGINS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_BEGIN_WITH = "HDR_DOES_NOT_BEGIN_WITH"
    """


    """
    MATCH_CRITERIA_CONTAINS = "HDR_CONTAINS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_CONTAIN = "HDR_DOES_NOT_CONTAIN"
    """


    """
    MATCH_CRITERIA_ENDS_WITH = "HDR_ENDS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_END_WITH = "HDR_DOES_NOT_END_WITH"
    """


    """
    MATCH_CRITERIA_EQUALS = "HDR_EQUALS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EQUAL = "HDR_DOES_NOT_EQUAL"
    """


    """



    _canonical_to_pep_names = {
                            'hdr': 'hdr',
                            'match_case': 'match_case',
                            'match_criteria': 'match_criteria',
                            'value': 'value',
                            }

    def __init__(self,
                 hdr=None,
                 match_case=None,
                 match_criteria=None,
                 value=None,
                ):
        """
        :type  hdr: :class:`str` or ``None``
        :param hdr: Name of the HTTP header whose value is to be matched.
        :type  match_case: :class:`str` or ``None``
        :param match_case: Possible values are: 
            
            * :attr:`ALBHdrMatch.MATCH_CASE_SENSITIVE`
            * :attr:`ALBHdrMatch.MATCH_CASE_INSENSITIVE`
            
            Case sensitivity to use for the match. Enum options - SENSITIVE,
            INSENSITIVE. Default value when not specified in API or module is
            interpreted by ALB Controller as INSENSITIVE.
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_EXISTS`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_DOES_NOT_EXIST`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_BEGINS_WITH`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_DOES_NOT_BEGIN_WITH`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_CONTAINS`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_DOES_NOT_CONTAIN`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_ENDS_WITH`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_DOES_NOT_END_WITH`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_EQUALS`
            * :attr:`ALBHdrMatch.MATCH_CRITERIA_DOES_NOT_EQUAL`
            
            Criterion to use for matching headers in the HTTP request. Enum
            options - HDR_EXISTS, HDR_DOES_NOT_EXIST, HDR_BEGINS_WITH,
            HDR_DOES_NOT_BEGIN_WITH, HDR_CONTAINS, HDR_DOES_NOT_CONTAIN,
            HDR_ENDS_WITH, HDR_DOES_NOT_END_WITH, HDR_EQUALS,
            HDR_DOES_NOT_EQUAL.
        :type  value: :class:`list` of :class:`str` or ``None``
        :param value: String values to match in the HTTP header.
        """
        self.hdr = hdr
        self.match_case = match_case
        self.match_criteria = match_criteria
        self.value = value
        VapiStruct.__init__(self)


ALBHdrMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_hdr_match', {
        'hdr': type.OptionalType(type.StringType()),
        'match_case': type.OptionalType(type.StringType()),
        'match_criteria': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBHdrMatch,
    False,
    None))



class ALBHdrPersistenceProfile(VapiStruct):
    """
    Advanced load balancer HdrPersistenceProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'prst_hdr_name': 'prst_hdr_name',
                            }

    def __init__(self,
                 prst_hdr_name=None,
                ):
        """
        :type  prst_hdr_name: :class:`str` or ``None``
        :param prst_hdr_name: Header name for custom header persistence.
        """
        self.prst_hdr_name = prst_hdr_name
        VapiStruct.__init__(self)


ALBHdrPersistenceProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_hdr_persistence_profile', {
        'prst_hdr_name': type.OptionalType(type.StringType()),
    },
    ALBHdrPersistenceProfile,
    False,
    None))



class ALBHealthMonitor(VapiStruct):
    """
    Advanced load balancer HealthMonitor object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_PING = "HEALTH_MONITOR_PING"
    """


    """
    TYPE_TCP = "HEALTH_MONITOR_TCP"
    """


    """
    TYPE_HTTP = "HEALTH_MONITOR_HTTP"
    """


    """
    TYPE_HTTPS = "HEALTH_MONITOR_HTTPS"
    """


    """
    TYPE_EXTERNAL = "HEALTH_MONITOR_EXTERNAL"
    """


    """
    TYPE_UDP = "HEALTH_MONITOR_UDP"
    """


    """
    TYPE_DNS = "HEALTH_MONITOR_DNS"
    """


    """
    TYPE_GSLB = "HEALTH_MONITOR_GSLB"
    """


    """
    TYPE_SIP = "HEALTH_MONITOR_SIP"
    """


    """
    TYPE_RADIUS = "HEALTH_MONITOR_RADIUS"
    """


    """
    TYPE_SMTP = "HEALTH_MONITOR_SMTP"
    """


    """
    TYPE_SMTPS = "HEALTH_MONITOR_SMTPS"
    """


    """
    TYPE_POP3 = "HEALTH_MONITOR_POP3"
    """


    """
    TYPE_POP3S = "HEALTH_MONITOR_POP3S"
    """


    """
    TYPE_IMAP = "HEALTH_MONITOR_IMAP"
    """


    """
    TYPE_IMAPS = "HEALTH_MONITOR_IMAPS"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'allow_duplicate_monitors': 'allow_duplicate_monitors',
                            'authentication': 'authentication',
                            'disable_quickstart': 'disable_quickstart',
                            'dns_monitor': 'dns_monitor',
                            'external_monitor': 'external_monitor',
                            'failed_checks': 'failed_checks',
                            'http_monitor': 'http_monitor',
                            'https_monitor': 'https_monitor',
                            'imap_monitor': 'imap_monitor',
                            'imaps_monitor': 'imaps_monitor',
                            'is_federated': 'is_federated',
                            'markers': 'markers',
                            'monitor_port': 'monitor_port',
                            'pop3_monitor': 'pop3_monitor',
                            'pop3s_monitor': 'pop3s_monitor',
                            'radius_monitor': 'radius_monitor',
                            'receive_timeout': 'receive_timeout',
                            'send_interval': 'send_interval',
                            'sip_monitor': 'sip_monitor',
                            'smtp_monitor': 'smtp_monitor',
                            'smtps_monitor': 'smtps_monitor',
                            'successful_checks': 'successful_checks',
                            'tcp_monitor': 'tcp_monitor',
                            'type': 'type',
                            'udp_monitor': 'udp_monitor',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 allow_duplicate_monitors=None,
                 authentication=None,
                 disable_quickstart=None,
                 dns_monitor=None,
                 external_monitor=None,
                 failed_checks=None,
                 http_monitor=None,
                 https_monitor=None,
                 imap_monitor=None,
                 imaps_monitor=None,
                 is_federated=None,
                 markers=None,
                 monitor_port=None,
                 pop3_monitor=None,
                 pop3s_monitor=None,
                 radius_monitor=None,
                 receive_timeout=None,
                 send_interval=None,
                 sip_monitor=None,
                 smtp_monitor=None,
                 smtps_monitor=None,
                 successful_checks=None,
                 tcp_monitor=None,
                 type=None,
                 udp_monitor=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  allow_duplicate_monitors: :class:`bool` or ``None``
        :param allow_duplicate_monitors: By default, multiple instances of the same healthmonitor to the
            same server are suppressed intelligently. In rare cases, the
            monitor may have specific constructs that go beyond the server keys
            (ip, port, etc.) during which such suppression is not desired. Use
            this knob to allow duplicates. Allowed in Basic(Allowed values-
            true) edition, Essentials(Allowed values- true) edition, Enterprise
            edition.
        :type  authentication: :class:`ALBHealthMonitorAuthInfo` or ``None``
        :param authentication: 
        :type  disable_quickstart: :class:`bool` or ``None``
        :param disable_quickstart: During addition of a server or healthmonitors or during bootup, Avi
            performs sequential health checks rather than waiting for
            send-interval to kick in, to mark the server up as soon as
            possible. This knob may be used to turn this feature off. Allowed
            in Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition.
        :type  dns_monitor: :class:`ALBHealthMonitorDNS` or ``None``
        :param dns_monitor: 
        :type  external_monitor: :class:`ALBHealthMonitorExternal` or ``None``
        :param external_monitor: 
        :type  failed_checks: :class:`long` or ``None``
        :param failed_checks: Number of continuous failed health checks before the server is
            marked down. Allowed values are 1-50. Default value when not
            specified in API or module is interpreted by ALB Controller as 2.
            format: int64
        :type  http_monitor: :class:`ALBHealthMonitorHttp` or ``None``
        :param http_monitor: 
        :type  https_monitor: :class:`ALBHealthMonitorHttp` or ``None``
        :param https_monitor: 
        :type  imap_monitor: :class:`ALBHealthMonitorImap` or ``None``
        :param imap_monitor: 
        :type  imaps_monitor: :class:`ALBHealthMonitorImap` or ``None``
        :param imaps_monitor: 
        :type  is_federated: :class:`bool` or ``None``
        :param is_federated: This field describes the object's replication scope. If the field
            is set to false, then the object is visible within the
            controller-cluster and its associated service-engines. If the field
            is set to true, then the object is replicated across the
            federation. Allowed in Basic(Allowed values- false) edition,
            Essentials(Allowed values- false) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as false.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  monitor_port: :class:`long` or ``None``
        :param monitor_port: Use this port instead of the port defined for the server in the
            Pool. If the monitor succeeds to this port, the load balanced
            traffic will still be sent to the port of the server defined within
            the Pool. Allowed values are 1-65535. Special values are 0 - 'Use
            server port'. format: int64
        :type  pop3_monitor: :class:`ALBHealthMonitorPop3` or ``None``
        :param pop3_monitor: 
        :type  pop3s_monitor: :class:`ALBHealthMonitorPop3` or ``None``
        :param pop3s_monitor: 
        :type  radius_monitor: :class:`ALBHealthMonitorRadius` or ``None``
        :param radius_monitor: 
        :type  receive_timeout: :class:`long` or ``None``
        :param receive_timeout: A valid response from the server is expected within the receive
            timeout window. This timeout must be less than the send interval.
            If server status is regularly flapping up and down, consider
            increasing this value. Allowed values are 1-2400. Unit is SEC.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 4. format: int64
        :type  send_interval: :class:`long` or ``None``
        :param send_interval: Frequency, in seconds, that monitors are sent to a server. Allowed
            values are 1-3600. Unit is SEC. Default value when not specified in
            API or module is interpreted by ALB Controller as 10. format: int64
        :type  sip_monitor: :class:`ALBHealthMonitorSIP` or ``None``
        :param sip_monitor: 
        :type  smtp_monitor: :class:`ALBHealthMonitorSmtp` or ``None``
        :param smtp_monitor: 
        :type  smtps_monitor: :class:`ALBHealthMonitorSmtp` or ``None``
        :param smtps_monitor: 
        :type  successful_checks: :class:`long` or ``None``
        :param successful_checks: Number of continuous successful health checks before server is
            marked up. Allowed values are 1-50. Default value when not
            specified in API or module is interpreted by ALB Controller as 2.
            format: int64
        :type  tcp_monitor: :class:`ALBHealthMonitorTcp` or ``None``
        :param tcp_monitor: 
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBHealthMonitor.TYPE_PING`
            * :attr:`ALBHealthMonitor.TYPE_TCP`
            * :attr:`ALBHealthMonitor.TYPE_HTTP`
            * :attr:`ALBHealthMonitor.TYPE_HTTPS`
            * :attr:`ALBHealthMonitor.TYPE_EXTERNAL`
            * :attr:`ALBHealthMonitor.TYPE_UDP`
            * :attr:`ALBHealthMonitor.TYPE_DNS`
            * :attr:`ALBHealthMonitor.TYPE_GSLB`
            * :attr:`ALBHealthMonitor.TYPE_SIP`
            * :attr:`ALBHealthMonitor.TYPE_RADIUS`
            * :attr:`ALBHealthMonitor.TYPE_SMTP`
            * :attr:`ALBHealthMonitor.TYPE_SMTPS`
            * :attr:`ALBHealthMonitor.TYPE_POP3`
            * :attr:`ALBHealthMonitor.TYPE_POP3S`
            * :attr:`ALBHealthMonitor.TYPE_IMAP`
            * :attr:`ALBHealthMonitor.TYPE_IMAPS`
            
            Type of the health monitor. Enum options - HEALTH_MONITOR_PING,
            HEALTH_MONITOR_TCP, HEALTH_MONITOR_HTTP, HEALTH_MONITOR_HTTPS,
            HEALTH_MONITOR_EXTERNAL, HEALTH_MONITOR_UDP, HEALTH_MONITOR_DNS,
            HEALTH_MONITOR_GSLB, HEALTH_MONITOR_SIP, HEALTH_MONITOR_RADIUS,
            HEALTH_MONITOR_SMTP, HEALTH_MONITOR_SMTPS, HEALTH_MONITOR_POP3,
            HEALTH_MONITOR_POP3S, HEALTH_MONITOR_IMAP, HEALTH_MONITOR_IMAPS.
            Allowed in Basic(Allowed values-
            HEALTH_MONITOR_PING,HEALTH_MONITOR_TCP,HEALTH_MONITOR_UDP,HEALTH_MONITOR_HTTP,HEALTH_MONITOR_HTTPS)
            edition, Essentials(Allowed values-
            HEALTH_MONITOR_PING,HEALTH_MONITOR_TCP,HEALTH_MONITOR_UDP) edition,
            Enterprise edition.
        :type  udp_monitor: :class:`ALBHealthMonitorUdp` or ``None``
        :param udp_monitor: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.allow_duplicate_monitors = allow_duplicate_monitors
        self.authentication = authentication
        self.disable_quickstart = disable_quickstart
        self.dns_monitor = dns_monitor
        self.external_monitor = external_monitor
        self.failed_checks = failed_checks
        self.http_monitor = http_monitor
        self.https_monitor = https_monitor
        self.imap_monitor = imap_monitor
        self.imaps_monitor = imaps_monitor
        self.is_federated = is_federated
        self.markers = markers
        self.monitor_port = monitor_port
        self.pop3_monitor = pop3_monitor
        self.pop3s_monitor = pop3s_monitor
        self.radius_monitor = radius_monitor
        self.receive_timeout = receive_timeout
        self.send_interval = send_interval
        self.sip_monitor = sip_monitor
        self.smtp_monitor = smtp_monitor
        self.smtps_monitor = smtps_monitor
        self.successful_checks = successful_checks
        self.tcp_monitor = tcp_monitor
        self.type = type
        self.udp_monitor = udp_monitor
        VapiStruct.__init__(self)


ALBHealthMonitor._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'allow_duplicate_monitors': type.OptionalType(type.BooleanType()),
        'authentication': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorAuthInfo')),
        'disable_quickstart': type.OptionalType(type.BooleanType()),
        'dns_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorDNS')),
        'external_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorExternal')),
        'failed_checks': type.OptionalType(type.IntegerType()),
        'http_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorHttp')),
        'https_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorHttp')),
        'imap_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorImap')),
        'imaps_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorImap')),
        'is_federated': type.OptionalType(type.BooleanType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'monitor_port': type.OptionalType(type.IntegerType()),
        'pop3_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorPop3')),
        'pop3s_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorPop3')),
        'radius_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorRadius')),
        'receive_timeout': type.OptionalType(type.IntegerType()),
        'send_interval': type.OptionalType(type.IntegerType()),
        'sip_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorSIP')),
        'smtp_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorSmtp')),
        'smtps_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorSmtp')),
        'successful_checks': type.OptionalType(type.IntegerType()),
        'tcp_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorTcp')),
        'type': type.OptionalType(type.StringType()),
        'udp_monitor': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorUdp')),
    },
    ALBHealthMonitor,
    False,
    None))



class ALBHealthMonitorApiResponse(VapiStruct):
    """
    HealthMonitorApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBHealthMonitor` or ``None``
        :param results: Array of HealthMonitor
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBHealthMonitorApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHealthMonitor'))),
    },
    ALBHealthMonitorApiResponse,
    False,
    None))



class ALBHealthMonitorAuthInfo(VapiStruct):
    """
    Advanced load balancer HealthMonitorAuthInfo object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'password': 'password',
                            'username': 'username',
                            }

    def __init__(self,
                 password=None,
                 username=None,
                ):
        """
        :type  password: :class:`str` or ``None``
        :param password: Password for server authentication.
        :type  username: :class:`str` or ``None``
        :param username: Username for server authentication.
        """
        self.password = password
        self.username = username
        VapiStruct.__init__(self)


ALBHealthMonitorAuthInfo._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_auth_info', {
        'password': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    ALBHealthMonitorAuthInfo,
    False,
    None))



class ALBHealthMonitorDNS(VapiStruct):
    """
    Advanced load balancer HealthMonitorDNS object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    QTYPE_QUERY_TYPE = "DNS_QUERY_TYPE"
    """


    """
    QTYPE_ANY_TYPE = "DNS_ANY_TYPE"
    """


    """
    QTYPE_ANY_THING = "DNS_ANY_THING"
    """


    """
    RCODE_NO_ERROR = "RCODE_NO_ERROR"
    """


    """
    RCODE_ANYTHING = "RCODE_ANYTHING"
    """


    """
    RECORD_TYPE_OTHER = "DNS_RECORD_OTHER"
    """


    """
    RECORD_TYPE_A = "DNS_RECORD_A"
    """


    """
    RECORD_TYPE_NS = "DNS_RECORD_NS"
    """


    """
    RECORD_TYPE_CNAME = "DNS_RECORD_CNAME"
    """


    """
    RECORD_TYPE_SOA = "DNS_RECORD_SOA"
    """


    """
    RECORD_TYPE_PTR = "DNS_RECORD_PTR"
    """


    """
    RECORD_TYPE_HINFO = "DNS_RECORD_HINFO"
    """


    """
    RECORD_TYPE_MX = "DNS_RECORD_MX"
    """


    """
    RECORD_TYPE_TXT = "DNS_RECORD_TXT"
    """


    """
    RECORD_TYPE_RP = "DNS_RECORD_RP"
    """


    """
    RECORD_TYPE_DNSKEY = "DNS_RECORD_DNSKEY"
    """


    """
    RECORD_TYPE_AAAA = "DNS_RECORD_AAAA"
    """


    """
    RECORD_TYPE_SRV = "DNS_RECORD_SRV"
    """


    """
    RECORD_TYPE_OPT = "DNS_RECORD_OPT"
    """


    """
    RECORD_TYPE_RRSIG = "DNS_RECORD_RRSIG"
    """


    """
    RECORD_TYPE_AXFR = "DNS_RECORD_AXFR"
    """


    """
    RECORD_TYPE_ANY = "DNS_RECORD_ANY"
    """


    """



    _canonical_to_pep_names = {
                            'qtype': 'qtype',
                            'query_name': 'query_name',
                            'rcode': 'rcode',
                            'record_type': 'record_type',
                            'response_string': 'response_string',
                            }

    def __init__(self,
                 qtype=None,
                 query_name=None,
                 rcode=None,
                 record_type=None,
                 response_string=None,
                ):
        """
        :type  qtype: :class:`str` or ``None``
        :param qtype: Possible values are: 
            
            * :attr:`ALBHealthMonitorDNS.QTYPE_QUERY_TYPE`
            * :attr:`ALBHealthMonitorDNS.QTYPE_ANY_TYPE`
            * :attr:`ALBHealthMonitorDNS.QTYPE_ANY_THING`
            
            Query_Type Response has atleast one answer of which the resource
            record type matches the query type Any_Type Response should contain
            atleast one answer AnyThing An empty answer is enough. Enum options
            - DNS_QUERY_TYPE, DNS_ANY_TYPE, DNS_ANY_THING. Default value when
            not specified in API or module is interpreted by ALB Controller as
            DNS_QUERY_TYPE.
        :type  query_name: :class:`str` or ``None``
        :param query_name: The DNS monitor will query the DNS server for the fully qualified
            name in this field.
        :type  rcode: :class:`str` or ``None``
        :param rcode: Possible values are: 
            
            * :attr:`ALBHealthMonitorDNS.RCODE_NO_ERROR`
            * :attr:`ALBHealthMonitorDNS.RCODE_ANYTHING`
            
            When No Error is selected, a DNS query will be marked failed is any
            error code is returned by the server. With Any selected, the
            monitor ignores error code in the responses. Enum options -
            RCODE_NO_ERROR, RCODE_ANYTHING. Default value when not specified in
            API or module is interpreted by ALB Controller as RCODE_NO_ERROR.
        :type  record_type: :class:`str` or ``None``
        :param record_type: Possible values are: 
            
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_OTHER`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_A`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_NS`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_CNAME`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_SOA`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_PTR`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_HINFO`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_MX`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_TXT`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_RP`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_DNSKEY`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_AAAA`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_SRV`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_OPT`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_RRSIG`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_AXFR`
            * :attr:`ALBHealthMonitorDNS.RECORD_TYPE_ANY`
            
            Resource record type used in the healthmonitor DNS query, only A or
            AAAA type supported. Enum options - DNS_RECORD_OTHER, DNS_RECORD_A,
            DNS_RECORD_NS, DNS_RECORD_CNAME, DNS_RECORD_SOA, DNS_RECORD_PTR,
            DNS_RECORD_HINFO, DNS_RECORD_MX, DNS_RECORD_TXT, DNS_RECORD_RP,
            DNS_RECORD_DNSKEY, DNS_RECORD_AAAA, DNS_RECORD_SRV, DNS_RECORD_OPT,
            DNS_RECORD_RRSIG, DNS_RECORD_AXFR, DNS_RECORD_ANY. Default value
            when not specified in API or module is interpreted by ALB
            Controller as DNS_RECORD_A.
        :type  response_string: :class:`str` or ``None``
        :param response_string: The resource record of the queried DNS server's response for the
            Request Name must include the IP address defined in this field.
        """
        self.qtype = qtype
        self.query_name = query_name
        self.rcode = rcode
        self.record_type = record_type
        self.response_string = response_string
        VapiStruct.__init__(self)


ALBHealthMonitorDNS._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_DNS', {
        'qtype': type.OptionalType(type.StringType()),
        'query_name': type.OptionalType(type.StringType()),
        'rcode': type.OptionalType(type.StringType()),
        'record_type': type.OptionalType(type.StringType()),
        'response_string': type.OptionalType(type.StringType()),
    },
    ALBHealthMonitorDNS,
    False,
    None))



class ALBHealthMonitorExternal(VapiStruct):
    """
    Advanced load balancer HealthMonitorExternal object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'command_code': 'command_code',
                            'command_parameters': 'command_parameters',
                            'command_path': 'command_path',
                            'command_variables': 'command_variables',
                            }

    def __init__(self,
                 command_code=None,
                 command_parameters=None,
                 command_path=None,
                 command_variables=None,
                ):
        """
        :type  command_code: :class:`str` or ``None``
        :param command_code: Command script provided inline.
        :type  command_parameters: :class:`str` or ``None``
        :param command_parameters: Optional arguments to feed into the script.
        :type  command_path: :class:`str` or ``None``
        :param command_path: Path of external health monitor script.
        :type  command_variables: :class:`str` or ``None``
        :param command_variables: Environment variables to be fed into the script.
        """
        self.command_code = command_code
        self.command_parameters = command_parameters
        self.command_path = command_path
        self.command_variables = command_variables
        VapiStruct.__init__(self)


ALBHealthMonitorExternal._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_external', {
        'command_code': type.OptionalType(type.StringType()),
        'command_parameters': type.OptionalType(type.StringType()),
        'command_path': type.OptionalType(type.StringType()),
        'command_variables': type.OptionalType(type.StringType()),
    },
    ALBHealthMonitorExternal,
    False,
    None))



class ALBHealthMonitorHttp(VapiStruct):
    """
    Advanced load balancer HealthMonitorHttp object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    AUTH_TYPE_BASIC = "AUTH_BASIC"
    """


    """
    AUTH_TYPE_NTLM = "AUTH_NTLM"
    """


    """
    HTTP_RESPONSE_CODE_ANY = "HTTP_ANY"
    """


    """
    HTTP_RESPONSE_CODE_1XX = "HTTP_1XX"
    """


    """
    HTTP_RESPONSE_CODE_2XX = "HTTP_2XX"
    """


    """
    HTTP_RESPONSE_CODE_3XX = "HTTP_3XX"
    """


    """
    HTTP_RESPONSE_CODE_4XX = "HTTP_4XX"
    """


    """
    HTTP_RESPONSE_CODE_5XX = "HTTP_5XX"
    """


    """



    _canonical_to_pep_names = {
                            'auth_type': 'auth_type',
                            'exact_http_request': 'exact_http_request',
                            'http_request': 'http_request',
                            'http_request_body': 'http_request_body',
                            'http_response': 'http_response',
                            'http_response_code': 'http_response_code',
                            'maintenance_code': 'maintenance_code',
                            'maintenance_response': 'maintenance_response',
                            'response_size': 'response_size',
                            'ssl_attributes': 'ssl_attributes',
                            }

    def __init__(self,
                 auth_type=None,
                 exact_http_request=None,
                 http_request=None,
                 http_request_body=None,
                 http_response=None,
                 http_response_code=None,
                 maintenance_code=None,
                 maintenance_response=None,
                 response_size=None,
                 ssl_attributes=None,
                ):
        """
        :type  auth_type: :class:`str` or ``None``
        :param auth_type: Possible values are: 
            
            * :attr:`ALBHealthMonitorHttp.AUTH_TYPE_BASIC`
            * :attr:`ALBHealthMonitorHttp.AUTH_TYPE_NTLM`
            
            Type of the authentication method. Enum options - AUTH_BASIC,
            AUTH_NTLM. Allowed in Basic edition, Essentials edition, Enterprise
            edition.
        :type  exact_http_request: :class:`bool` or ``None``
        :param exact_http_request: Use the exact http_request string as specified by user, without any
            automatic insert of headers like Host header. Default value when
            not specified in API or module is interpreted by ALB Controller as
            false.
        :type  http_request: :class:`str` or ``None``
        :param http_request: Send an HTTP request to the server. The default GET / HTTP/1.0 may
            be extended with additional headers or information. For instance,
            GET /index.htm HTTP/1.1 Host www.site.com Connection Close. Default
            value when not specified in API or module is interpreted by ALB
            Controller as GET / HTTP/1.0.
        :type  http_request_body: :class:`str` or ``None``
        :param http_request_body: HTTP request body.
        :type  http_response: :class:`str` or ``None``
        :param http_response: Match for a keyword in the first 2Kb of the server header and body
            response.
        :type  http_response_code: :class:`list` of :class:`str` or ``None``
        :param http_response_code: Possible values are: 
            
            * :attr:`ALBHealthMonitorHttp.HTTP_RESPONSE_CODE_ANY`
            * :attr:`ALBHealthMonitorHttp.HTTP_RESPONSE_CODE__1XX`
            * :attr:`ALBHealthMonitorHttp.HTTP_RESPONSE_CODE__2XX`
            * :attr:`ALBHealthMonitorHttp.HTTP_RESPONSE_CODE__3XX`
            * :attr:`ALBHealthMonitorHttp.HTTP_RESPONSE_CODE__4XX`
            * :attr:`ALBHealthMonitorHttp.HTTP_RESPONSE_CODE__5XX`
            
            List of HTTP response codes to match as successful. Default is 2xx.
            Enum options - HTTP_ANY, HTTP_1XX, HTTP_2XX, HTTP_3XX, HTTP_4XX,
            HTTP_5XX. Minimum of 1 items required.
        :type  maintenance_code: :class:`list` of :class:`long` or ``None``
        :param maintenance_code: Match or look for this HTTP response code indicating server
            maintenance. A successful match results in the server being marked
            down. Allowed values are 101-599. Maximum of 4 items allowed.
            format: int64
        :type  maintenance_response: :class:`str` or ``None``
        :param maintenance_response: Match or look for this keyword in the first 2KB of server header
            and body response indicating server maintenance. A successful match
            results in the server being marked down.
        :type  response_size: :class:`long` or ``None``
        :param response_size: Expected http/https response page size. Allowed values are
            2048-16384. format: int64
        :type  ssl_attributes: :class:`ALBHealthMonitorSSLAttributes` or ``None``
        :param ssl_attributes: 
        """
        self.auth_type = auth_type
        self.exact_http_request = exact_http_request
        self.http_request = http_request
        self.http_request_body = http_request_body
        self.http_response = http_response
        self.http_response_code = http_response_code
        self.maintenance_code = maintenance_code
        self.maintenance_response = maintenance_response
        self.response_size = response_size
        self.ssl_attributes = ssl_attributes
        VapiStruct.__init__(self)


ALBHealthMonitorHttp._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_http', {
        'auth_type': type.OptionalType(type.StringType()),
        'exact_http_request': type.OptionalType(type.BooleanType()),
        'http_request': type.OptionalType(type.StringType()),
        'http_request_body': type.OptionalType(type.StringType()),
        'http_response': type.OptionalType(type.StringType()),
        'http_response_code': type.OptionalType(type.ListType(type.StringType())),
        'maintenance_code': type.OptionalType(type.ListType(type.IntegerType())),
        'maintenance_response': type.OptionalType(type.StringType()),
        'response_size': type.OptionalType(type.IntegerType()),
        'ssl_attributes': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorSSLAttributes')),
    },
    ALBHealthMonitorHttp,
    False,
    None))



class ALBHealthMonitorImap(VapiStruct):
    """
    Advanced load balancer HealthMonitorImap object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'folder': 'folder',
                            'ssl_attributes': 'ssl_attributes',
                            }

    def __init__(self,
                 folder=None,
                 ssl_attributes=None,
                ):
        """
        :type  folder: :class:`str` or ``None``
        :param folder: Folder to access.
        :type  ssl_attributes: :class:`ALBHealthMonitorSSLAttributes` or ``None``
        :param ssl_attributes: 
        """
        self.folder = folder
        self.ssl_attributes = ssl_attributes
        VapiStruct.__init__(self)


ALBHealthMonitorImap._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_imap', {
        'folder': type.OptionalType(type.StringType()),
        'ssl_attributes': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorSSLAttributes')),
    },
    ALBHealthMonitorImap,
    False,
    None))



class ALBHealthMonitorPop3(VapiStruct):
    """
    Advanced load balancer HealthMonitorPop3 object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ssl_attributes': 'ssl_attributes',
                            }

    def __init__(self,
                 ssl_attributes=None,
                ):
        """
        :type  ssl_attributes: :class:`ALBHealthMonitorSSLAttributes` or ``None``
        :param ssl_attributes: 
        """
        self.ssl_attributes = ssl_attributes
        VapiStruct.__init__(self)


ALBHealthMonitorPop3._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_pop3', {
        'ssl_attributes': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorSSLAttributes')),
    },
    ALBHealthMonitorPop3,
    False,
    None))



class ALBHealthMonitorRadius(VapiStruct):
    """
    Advanced load balancer HealthMonitorRadius object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'password': 'password',
                            'shared_secret': 'shared_secret',
                            'username': 'username',
                            }

    def __init__(self,
                 password=None,
                 shared_secret=None,
                 username=None,
                ):
        """
        :type  password: :class:`str` or ``None``
        :param password: Radius monitor will query Radius server with this password.
        :type  shared_secret: :class:`str` or ``None``
        :param shared_secret: Radius monitor will query Radius server with this shared secret.
        :type  username: :class:`str` or ``None``
        :param username: Radius monitor will query Radius server with this username.
        """
        self.password = password
        self.shared_secret = shared_secret
        self.username = username
        VapiStruct.__init__(self)


ALBHealthMonitorRadius._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_radius', {
        'password': type.OptionalType(type.StringType()),
        'shared_secret': type.OptionalType(type.StringType()),
        'username': type.OptionalType(type.StringType()),
    },
    ALBHealthMonitorRadius,
    False,
    None))



class ALBHealthMonitorSIP(VapiStruct):
    """
    Advanced load balancer HealthMonitorSIP object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SIP_MONITOR_TRANSPORT_UDP_PROTO = "SIP_UDP_PROTO"
    """


    """
    SIP_MONITOR_TRANSPORT_TCP_PROTO = "SIP_TCP_PROTO"
    """


    """
    SIP_REQUEST_CODE_OPTIONS = "SIP_OPTIONS"
    """


    """



    _canonical_to_pep_names = {
                            'sip_monitor_transport': 'sip_monitor_transport',
                            'sip_request_code': 'sip_request_code',
                            'sip_response': 'sip_response',
                            }

    def __init__(self,
                 sip_monitor_transport=None,
                 sip_request_code=None,
                 sip_response=None,
                ):
        """
        :type  sip_monitor_transport: :class:`str` or ``None``
        :param sip_monitor_transport: Possible values are: 
            
            * :attr:`ALBHealthMonitorSIP.SIP_MONITOR_TRANSPORT_UDP_PROTO`
            * :attr:`ALBHealthMonitorSIP.SIP_MONITOR_TRANSPORT_TCP_PROTO`
            
            Specify the transport protocol TCP or UDP, to be used for SIP
            health monitor. The default transport is UDP. Enum options -
            SIP_UDP_PROTO, SIP_TCP_PROTO. Default value when not specified in
            API or module is interpreted by ALB Controller as SIP_UDP_PROTO.
        :type  sip_request_code: :class:`str` or ``None``
        :param sip_request_code: Possible values are: 
            
            * :attr:`ALBHealthMonitorSIP.SIP_REQUEST_CODE_OPTIONS`
            
            Specify the SIP request to be sent to the server. By default, SIP
            OPTIONS request will be sent. Enum options - SIP_OPTIONS. Default
            value when not specified in API or module is interpreted by ALB
            Controller as SIP_OPTIONS.
        :type  sip_response: :class:`str` or ``None``
        :param sip_response: Match for a keyword in the first 2KB of the server header and body
            response. By default, it matches for SIP/2.0. Default value when
            not specified in API or module is interpreted by ALB Controller as
            SIP/2.0.
        """
        self.sip_monitor_transport = sip_monitor_transport
        self.sip_request_code = sip_request_code
        self.sip_response = sip_response
        VapiStruct.__init__(self)


ALBHealthMonitorSIP._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_SIP', {
        'sip_monitor_transport': type.OptionalType(type.StringType()),
        'sip_request_code': type.OptionalType(type.StringType()),
        'sip_response': type.OptionalType(type.StringType()),
    },
    ALBHealthMonitorSIP,
    False,
    None))



class ALBHealthMonitorSSLAttributes(VapiStruct):
    """
    Advanced load balancer HealthMonitorSSLAttributes object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'pki_profile_path': 'pki_profile_path',
                            'server_name': 'server_name',
                            'ssl_key_and_certificate_path': 'ssl_key_and_certificate_path',
                            'ssl_profile_path': 'ssl_profile_path',
                            }

    def __init__(self,
                 pki_profile_path=None,
                 server_name=None,
                 ssl_key_and_certificate_path=None,
                 ssl_profile_path=None,
                ):
        """
        :type  pki_profile_path: :class:`str` or ``None``
        :param pki_profile_path: PKI profile used to validate the SSL certificate presented by a
            server. It is a reference to an object of type PKIProfile.
        :type  server_name: :class:`str` or ``None``
        :param server_name: Fully qualified DNS hostname which will be used in the TLS SNI
            extension in server connections indicating SNI is enabled.
        :type  ssl_key_and_certificate_path: :class:`str` or ``None``
        :param ssl_key_and_certificate_path: Service engines will present this SSL certificate to the server. It
            is a reference to an object of type SSLKeyAndCertificate.
        :type  ssl_profile_path: :class:`str` or ``None``
        :param ssl_profile_path: SSL profile defines ciphers and SSL versions to be used for
            healthmonitor traffic to the back-end servers. It is a reference to
            an object of type SSLProfile.
        """
        self.pki_profile_path = pki_profile_path
        self.server_name = server_name
        self.ssl_key_and_certificate_path = ssl_key_and_certificate_path
        self.ssl_profile_path = ssl_profile_path
        VapiStruct.__init__(self)


ALBHealthMonitorSSLAttributes._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_SSL_attributes', {
        'pki_profile_path': type.OptionalType(type.StringType()),
        'server_name': type.OptionalType(type.StringType()),
        'ssl_key_and_certificate_path': type.OptionalType(type.StringType()),
        'ssl_profile_path': type.OptionalType(type.StringType()),
    },
    ALBHealthMonitorSSLAttributes,
    False,
    None))



class ALBHealthMonitorSmtp(VapiStruct):
    """
    Advanced load balancer HealthMonitorSmtp object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'domainname': 'domainname',
                            'mail_data': 'mail_data',
                            'recipients_ids': 'recipients_ids',
                            'sender_id': 'sender_id',
                            'ssl_attributes': 'ssl_attributes',
                            }

    def __init__(self,
                 domainname=None,
                 mail_data=None,
                 recipients_ids=None,
                 sender_id=None,
                 ssl_attributes=None,
                ):
        """
        :type  domainname: :class:`str` or ``None``
        :param domainname: Sender domain name.
        :type  mail_data: :class:`str` or ``None``
        :param mail_data: Mail data.
        :type  recipients_ids: :class:`list` of :class:`str` or ``None``
        :param recipients_ids: Mail recipients.
        :type  sender_id: :class:`str` or ``None``
        :param sender_id: Mail sender.
        :type  ssl_attributes: :class:`ALBHealthMonitorSSLAttributes` or ``None``
        :param ssl_attributes: 
        """
        self.domainname = domainname
        self.mail_data = mail_data
        self.recipients_ids = recipients_ids
        self.sender_id = sender_id
        self.ssl_attributes = ssl_attributes
        VapiStruct.__init__(self)


ALBHealthMonitorSmtp._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_smtp', {
        'domainname': type.OptionalType(type.StringType()),
        'mail_data': type.OptionalType(type.StringType()),
        'recipients_ids': type.OptionalType(type.ListType(type.StringType())),
        'sender_id': type.OptionalType(type.StringType()),
        'ssl_attributes': type.OptionalType(type.ReferenceType(__name__, 'ALBHealthMonitorSSLAttributes')),
    },
    ALBHealthMonitorSmtp,
    False,
    None))



class ALBHealthMonitorTcp(VapiStruct):
    """
    Advanced load balancer HealthMonitorTcp object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'maintenance_response': 'maintenance_response',
                            'tcp_half_open': 'tcp_half_open',
                            'tcp_request': 'tcp_request',
                            'tcp_response': 'tcp_response',
                            }

    def __init__(self,
                 maintenance_response=None,
                 tcp_half_open=None,
                 tcp_request=None,
                 tcp_response=None,
                ):
        """
        :type  maintenance_response: :class:`str` or ``None``
        :param maintenance_response: Match or look for this keyword in the first 2KB of server's
            response indicating server maintenance. A successful match results
            in the server being marked down.
        :type  tcp_half_open: :class:`bool` or ``None``
        :param tcp_half_open: Configure TCP health monitor to use half-open TCP connections to
            monitor the health of backend servers thereby avoiding consumption
            of a full fledged server side connection and the overhead and logs
            associated with it. This method is light-weight as it makes use of
            listener in server's kernel layer to measure the health and a child
            socket or user thread is not created on the server side. Allowed in
            Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  tcp_request: :class:`str` or ``None``
        :param tcp_request: Request data to send after completing the TCP handshake.
        :type  tcp_response: :class:`str` or ``None``
        :param tcp_response: Match for the desired keyword in the first 2Kb of the server's TCP
            response. If this field is left blank, no server response is
            required.
        """
        self.maintenance_response = maintenance_response
        self.tcp_half_open = tcp_half_open
        self.tcp_request = tcp_request
        self.tcp_response = tcp_response
        VapiStruct.__init__(self)


ALBHealthMonitorTcp._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_tcp', {
        'maintenance_response': type.OptionalType(type.StringType()),
        'tcp_half_open': type.OptionalType(type.BooleanType()),
        'tcp_request': type.OptionalType(type.StringType()),
        'tcp_response': type.OptionalType(type.StringType()),
    },
    ALBHealthMonitorTcp,
    False,
    None))



class ALBHealthMonitorUdp(VapiStruct):
    """
    Advanced load balancer HealthMonitorUdp object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'maintenance_response': 'maintenance_response',
                            'udp_request': 'udp_request',
                            'udp_response': 'udp_response',
                            }

    def __init__(self,
                 maintenance_response=None,
                 udp_request=None,
                 udp_response=None,
                ):
        """
        :type  maintenance_response: :class:`str` or ``None``
        :param maintenance_response: Match or look for this keyword in the first 2KB of server's
            response indicating server maintenance. A successful match results
            in the server being marked down.
        :type  udp_request: :class:`str` or ``None``
        :param udp_request: Send UDP request.
        :type  udp_response: :class:`str` or ``None``
        :param udp_response: Match for keyword in the UDP response.
        """
        self.maintenance_response = maintenance_response
        self.udp_request = udp_request
        self.udp_response = udp_response
        VapiStruct.__init__(self)


ALBHealthMonitorUdp._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_health_monitor_udp', {
        'maintenance_response': type.OptionalType(type.StringType()),
        'udp_request': type.OptionalType(type.StringType()),
        'udp_response': type.OptionalType(type.StringType()),
    },
    ALBHealthMonitorUdp,
    False,
    None))



class ALBHostHdrMatch(VapiStruct):
    """
    Advanced load balancer HostHdrMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CASE_SENSITIVE = "SENSITIVE"
    """


    """
    MATCH_CASE_INSENSITIVE = "INSENSITIVE"
    """


    """
    MATCH_CRITERIA_EXISTS = "HDR_EXISTS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EXIST = "HDR_DOES_NOT_EXIST"
    """


    """
    MATCH_CRITERIA_BEGINS_WITH = "HDR_BEGINS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_BEGIN_WITH = "HDR_DOES_NOT_BEGIN_WITH"
    """


    """
    MATCH_CRITERIA_CONTAINS = "HDR_CONTAINS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_CONTAIN = "HDR_DOES_NOT_CONTAIN"
    """


    """
    MATCH_CRITERIA_ENDS_WITH = "HDR_ENDS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_END_WITH = "HDR_DOES_NOT_END_WITH"
    """


    """
    MATCH_CRITERIA_EQUALS = "HDR_EQUALS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EQUAL = "HDR_DOES_NOT_EQUAL"
    """


    """



    _canonical_to_pep_names = {
                            'match_case': 'match_case',
                            'match_criteria': 'match_criteria',
                            'value': 'value',
                            }

    def __init__(self,
                 match_case=None,
                 match_criteria=None,
                 value=None,
                ):
        """
        :type  match_case: :class:`str` or ``None``
        :param match_case: Possible values are: 
            
            * :attr:`ALBHostHdrMatch.MATCH_CASE_SENSITIVE`
            * :attr:`ALBHostHdrMatch.MATCH_CASE_INSENSITIVE`
            
            Case sensitivity to use for the match. Enum options - SENSITIVE,
            INSENSITIVE. Default value when not specified in API or module is
            interpreted by ALB Controller as INSENSITIVE.
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_EXISTS`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_DOES_NOT_EXIST`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_BEGINS_WITH`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_DOES_NOT_BEGIN_WITH`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_CONTAINS`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_DOES_NOT_CONTAIN`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_ENDS_WITH`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_DOES_NOT_END_WITH`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_EQUALS`
            * :attr:`ALBHostHdrMatch.MATCH_CRITERIA_DOES_NOT_EQUAL`
            
            Criterion to use for the host header value match. Enum options -
            HDR_EXISTS, HDR_DOES_NOT_EXIST, HDR_BEGINS_WITH,
            HDR_DOES_NOT_BEGIN_WITH, HDR_CONTAINS, HDR_DOES_NOT_CONTAIN,
            HDR_ENDS_WITH, HDR_DOES_NOT_END_WITH, HDR_EQUALS,
            HDR_DOES_NOT_EQUAL.
        :type  value: :class:`list` of :class:`str` or ``None``
        :param value: String value(s) in the host header.
        """
        self.match_case = match_case
        self.match_criteria = match_criteria
        self.value = value
        VapiStruct.__init__(self)


ALBHostHdrMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_host_hdr_match', {
        'match_case': type.OptionalType(type.StringType()),
        'match_criteria': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBHostHdrMatch,
    False,
    None))



class ALBHttpCacheConfig(VapiStruct):
    """
    Advanced load balancer HttpCacheConfig object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'age_header': 'age_header',
                            'aggressive': 'aggressive',
                            'date_header': 'date_header',
                            'default_expire': 'default_expire',
                            'enabled': 'enabled',
                            'heuristic_expire': 'heuristic_expire',
                            'ignore_request_cache_control': 'ignore_request_cache_control',
                            'max_cache_size': 'max_cache_size',
                            'max_object_size': 'max_object_size',
                            'mime_types_block_group_paths': 'mime_types_block_group_paths',
                            'mime_types_block_lists': 'mime_types_block_lists',
                            'mime_types_group_paths': 'mime_types_group_paths',
                            'mime_types_list': 'mime_types_list',
                            'min_object_size': 'min_object_size',
                            'query_cacheable': 'query_cacheable',
                            'uri_non_cacheable': 'uri_non_cacheable',
                            'xcache_header': 'xcache_header',
                            }

    def __init__(self,
                 age_header=None,
                 aggressive=None,
                 date_header=None,
                 default_expire=None,
                 enabled=None,
                 heuristic_expire=None,
                 ignore_request_cache_control=None,
                 max_cache_size=None,
                 max_object_size=None,
                 mime_types_block_group_paths=None,
                 mime_types_block_lists=None,
                 mime_types_group_paths=None,
                 mime_types_list=None,
                 min_object_size=None,
                 query_cacheable=None,
                 uri_non_cacheable=None,
                 xcache_header=None,
                ):
        """
        :type  age_header: :class:`bool` or ``None``
        :param age_header: Add an Age header to content served from cache, which indicates to
            the client the number of seconds the object has been in the cache.
            Default value when not specified in API or module is interpreted by
            ALB Controller as true.
        :type  aggressive: :class:`bool` or ``None``
        :param aggressive: Enable/disable caching objects without Cache-Control headers.
            Default value when not specified in API or module is interpreted by
            ALB Controller as false.
        :type  date_header: :class:`bool` or ``None``
        :param date_header: If a Date header was not added by the server, add a Date header to
            the object served from cache. This indicates to the client when the
            object was originally sent by the server to the cache. Default
            value when not specified in API or module is interpreted by ALB
            Controller as true.
        :type  default_expire: :class:`long` or ``None``
        :param default_expire: Default expiration time of cache objects received from the server
            without a Cache-Control expiration header. This value may be
            overwritten by the Heuristic Expire setting. Default value when not
            specified in API or module is interpreted by ALB Controller as 600.
            format: int64
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable/disable HTTP object caching.When enabling caching for the
            first time, SE Group app_cache_percent must be set to allocate
            shared memory required for caching (A service engine restart is
            needed after setting/resetting the SE group value). Default value
            when not specified in API or module is interpreted by ALB
            Controller as false.
        :type  heuristic_expire: :class:`bool` or ``None``
        :param heuristic_expire: If a response object from the server does not include the
            Cache-Control header, but does include a Last-Modified header, the
            system will use this time to calculate the Cache-Control
            expiration. If unable to solicit an Last-Modified header, then the
            system will fall back to the Cache Expire Time value. Default value
            when not specified in API or module is interpreted by ALB
            Controller as false.
        :type  ignore_request_cache_control: :class:`bool` or ``None``
        :param ignore_request_cache_control: Ignore client's cache control headers when fetching or storing from
            and to the cache. Default value when not specified in API or module
            is interpreted by ALB Controller as false.
        :type  max_cache_size: :class:`long` or ``None``
        :param max_cache_size: Max size, in bytes, of the cache. The default, zero, indicates auto
            configuration. Default value when not specified in API or module is
            interpreted by ALB Controller as 0. format: int64
        :type  max_object_size: :class:`long` or ``None``
        :param max_object_size: Maximum size of an object to store in the cache. Default value when
            not specified in API or module is interpreted by ALB Controller as
            4194304. format: int64
        :type  mime_types_block_group_paths: :class:`list` of :class:`str` or ``None``
        :param mime_types_block_group_paths: Blocklist string group of non-cacheable mime types. It is a
            reference to an object of type StringGroup.
        :type  mime_types_block_lists: :class:`list` of :class:`str` or ``None``
        :param mime_types_block_lists: Blocklist of non-cacheable mime types.
        :type  mime_types_group_paths: :class:`list` of :class:`str` or ``None``
        :param mime_types_group_paths: Allowlist string group of cacheable mime types. If both Cacheable
            Mime Types string list and string group are empty, this defaults to
            (STAR)/(STAR). It is a reference to an object of type StringGroup.
        :type  mime_types_list: :class:`list` of :class:`str` or ``None``
        :param mime_types_list: Allowlist of cacheable mime types. If both Cacheable Mime Types
            string list and string group are empty, this defaults to
            (STAR)/(STAR).
        :type  min_object_size: :class:`long` or ``None``
        :param min_object_size: Minimum size of an object to store in the cache. Default value when
            not specified in API or module is interpreted by ALB Controller as
            100. format: int64
        :type  query_cacheable: :class:`bool` or ``None``
        :param query_cacheable: Allow caching of objects whose URI included a query argument. When
            disabled, these objects are not cached. When enabled, the request
            must match the URI query to be considered a hit. Default value when
            not specified in API or module is interpreted by ALB Controller as
            false.
        :type  uri_non_cacheable: :class:`ALBPathMatch` or ``None``
        :param uri_non_cacheable: 
        :type  xcache_header: :class:`bool` or ``None``
        :param xcache_header: Add an X-Cache header to content served from cache, which indicates
            to the client that the object was served from an intermediate
            cache. Default value when not specified in API or module is
            interpreted by ALB Controller as true.
        """
        self.age_header = age_header
        self.aggressive = aggressive
        self.date_header = date_header
        self.default_expire = default_expire
        self.enabled = enabled
        self.heuristic_expire = heuristic_expire
        self.ignore_request_cache_control = ignore_request_cache_control
        self.max_cache_size = max_cache_size
        self.max_object_size = max_object_size
        self.mime_types_block_group_paths = mime_types_block_group_paths
        self.mime_types_block_lists = mime_types_block_lists
        self.mime_types_group_paths = mime_types_group_paths
        self.mime_types_list = mime_types_list
        self.min_object_size = min_object_size
        self.query_cacheable = query_cacheable
        self.uri_non_cacheable = uri_non_cacheable
        self.xcache_header = xcache_header
        VapiStruct.__init__(self)


ALBHttpCacheConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_http_cache_config', {
        'age_header': type.OptionalType(type.BooleanType()),
        'aggressive': type.OptionalType(type.BooleanType()),
        'date_header': type.OptionalType(type.BooleanType()),
        'default_expire': type.OptionalType(type.IntegerType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'heuristic_expire': type.OptionalType(type.BooleanType()),
        'ignore_request_cache_control': type.OptionalType(type.BooleanType()),
        'max_cache_size': type.OptionalType(type.IntegerType()),
        'max_object_size': type.OptionalType(type.IntegerType()),
        'mime_types_block_group_paths': type.OptionalType(type.ListType(type.StringType())),
        'mime_types_block_lists': type.OptionalType(type.ListType(type.StringType())),
        'mime_types_group_paths': type.OptionalType(type.ListType(type.StringType())),
        'mime_types_list': type.OptionalType(type.ListType(type.StringType())),
        'min_object_size': type.OptionalType(type.IntegerType()),
        'query_cacheable': type.OptionalType(type.BooleanType()),
        'uri_non_cacheable': type.OptionalType(type.ReferenceType(__name__, 'ALBPathMatch')),
        'xcache_header': type.OptionalType(type.BooleanType()),
    },
    ALBHttpCacheConfig,
    False,
    None))



class ALBHttpCookiePersistenceKey(VapiStruct):
    """
    Advanced load balancer HttpCookiePersistenceKey object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'aes_key': 'aes_key',
                            'hmac_key': 'hmac_key',
                            'name': 'name',
                            }

    def __init__(self,
                 aes_key=None,
                 hmac_key=None,
                 name=None,
                ):
        """
        :type  aes_key: :class:`str` or ``None``
        :param aes_key: aes_key of HttpCookiePersistenceKey.
        :type  hmac_key: :class:`str` or ``None``
        :param hmac_key: hmac_key of HttpCookiePersistenceKey.
        :type  name: :class:`str` or ``None``
        :param name: name to use for cookie encryption.
        """
        self.aes_key = aes_key
        self.hmac_key = hmac_key
        self.name = name
        VapiStruct.__init__(self)


ALBHttpCookiePersistenceKey._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_http_cookie_persistence_key', {
        'aes_key': type.OptionalType(type.StringType()),
        'hmac_key': type.OptionalType(type.StringType()),
        'name': type.OptionalType(type.StringType()),
    },
    ALBHttpCookiePersistenceKey,
    False,
    None))



class ALBHttpCookiePersistenceProfile(VapiStruct):
    """
    Advanced load balancer HttpCookiePersistenceProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'always_send_cookie': 'always_send_cookie',
                            'cookie_name': 'cookie_name',
                            'encryption_key': 'encryption_key',
                            'key': 'key',
                            'timeout': 'timeout',
                            }

    def __init__(self,
                 always_send_cookie=None,
                 cookie_name=None,
                 encryption_key=None,
                 key=None,
                 timeout=None,
                ):
        """
        :type  always_send_cookie: :class:`bool` or ``None``
        :param always_send_cookie: If no persistence cookie was received from the client, always send
            it. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  cookie_name: :class:`str` or ``None``
        :param cookie_name: HTTP cookie name for cookie persistence.
        :type  encryption_key: :class:`str` or ``None``
        :param encryption_key: Key name to use for cookie encryption.
        :type  key: :class:`list` of :class:`ALBHttpCookiePersistenceKey` or ``None``
        :param key: Placeholder for description of property key of obj type
            HttpCookiePersistenceProfile field type str type array.
        :type  timeout: :class:`long` or ``None``
        :param timeout: The maximum lifetime of any session cookie. No value or 'zero'
            indicates no timeout. Allowed values are 1-14400. Special values
            are 0- 'No Timeout'. Unit is MIN. format: int64
        """
        self.always_send_cookie = always_send_cookie
        self.cookie_name = cookie_name
        self.encryption_key = encryption_key
        self.key = key
        self.timeout = timeout
        VapiStruct.__init__(self)


ALBHttpCookiePersistenceProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_http_cookie_persistence_profile', {
        'always_send_cookie': type.OptionalType(type.BooleanType()),
        'cookie_name': type.OptionalType(type.StringType()),
        'encryption_key': type.OptionalType(type.StringType()),
        'key': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHttpCookiePersistenceKey'))),
        'timeout': type.OptionalType(type.IntegerType()),
    },
    ALBHttpCookiePersistenceProfile,
    False,
    None))



class ALBIPNetworkSubnet(VapiStruct):
    """
    Advanced load balancer IPNetworkSubnet object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'network_name': 'network_name',
                            'subnet': 'subnet',
                            'subnet6': 'subnet6',
                            'subnet6_uuid': 'subnet6_uuid',
                            'subnet_uuid': 'subnet_uuid',
                            }

    def __init__(self,
                 network_name=None,
                 subnet=None,
                 subnet6=None,
                 subnet6_uuid=None,
                 subnet_uuid=None,
                ):
        """
        :type  network_name: :class:`str` or ``None``
        :param network_name: Network for VirtualService IP allocation with Vantage as the IPAM
            provider. Network should be created before this is configured. It
            is a reference to an object of type Network.
        :type  subnet: :class:`ALBIpAddrPrefix` or ``None``
        :param subnet: 
        :type  subnet6: :class:`ALBIpAddrPrefix` or ``None``
        :param subnet6: 
        :type  subnet6_uuid: :class:`str` or ``None``
        :param subnet6_uuid: Subnet UUID or Name or Prefix for VirtualService IPv6 allocation
            with AWS or OpenStack as the IPAM provider. Only one of subnet or
            subnet_uuid configuration is allowed. Allowed in Basic edition,
            Essentials edition, Enterprise edition.
        :type  subnet_uuid: :class:`str` or ``None``
        :param subnet_uuid: Subnet UUID or Name or Prefix for VirtualService IP allocation with
            AWS or OpenStack as the IPAM provider. Only one of subnet or
            subnet_uuid configuration is allowed.
        """
        self.network_name = network_name
        self.subnet = subnet
        self.subnet6 = subnet6
        self.subnet6_uuid = subnet6_uuid
        self.subnet_uuid = subnet_uuid
        VapiStruct.__init__(self)


ALBIPNetworkSubnet._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBIP_network_subnet', {
        'network_name': type.OptionalType(type.StringType()),
        'subnet': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrPrefix')),
        'subnet6': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrPrefix')),
        'subnet6_uuid': type.OptionalType(type.StringType()),
        'subnet_uuid': type.OptionalType(type.StringType()),
    },
    ALBIPNetworkSubnet,
    False,
    None))



class ALBIPPersistenceProfile(VapiStruct):
    """
    Advanced load balancer IPPersistenceProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ip_mask': 'ip_mask',
                            'ip_persistent_timeout': 'ip_persistent_timeout',
                            }

    def __init__(self,
                 ip_mask=None,
                 ip_persistent_timeout=None,
                ):
        """
        :type  ip_mask: :class:`long` or ``None``
        :param ip_mask: Mask to be applied on client IP. This may be used to persist
            clients from a subnet to the same server. When set to 0, all
            requests are sent to the same server. Allowed values are 0-128.
            Allowed in Basic edition, Essentials edition, Enterprise edition.
            format: int64
        :type  ip_persistent_timeout: :class:`long` or ``None``
        :param ip_persistent_timeout: The length of time after a client's connections have closed before
            expiring the client's persistence to a server. Allowed values are
            1-720. Unit is MIN. Default value when not specified in API or
            module is interpreted by ALB Controller as 5. format: int64
        """
        self.ip_mask = ip_mask
        self.ip_persistent_timeout = ip_persistent_timeout
        VapiStruct.__init__(self)


ALBIPPersistenceProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBIP_persistence_profile', {
        'ip_mask': type.OptionalType(type.IntegerType()),
        'ip_persistent_timeout': type.OptionalType(type.IntegerType()),
    },
    ALBIPPersistenceProfile,
    False,
    None))



class ALBIpAddr(VapiStruct):
    """
    Advanced load balancer IpAddr object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_V4 = "V4"
    """


    """
    TYPE_DNS = "DNS"
    """


    """
    TYPE_V6 = "V6"
    """


    """



    _canonical_to_pep_names = {
                            'addr': 'addr',
                            'type': 'type',
                            }

    def __init__(self,
                 addr=None,
                 type=None,
                ):
        """
        :type  addr: :class:`str` or ``None``
        :param addr: IP address.
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBIpAddr.TYPE_V4`
            * :attr:`ALBIpAddr.TYPE_DNS`
            * :attr:`ALBIpAddr.TYPE_V6`
            
             Enum options - V4, DNS, V6.
        """
        self.addr = addr
        self.type = type
        VapiStruct.__init__(self)


ALBIpAddr._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ip_addr', {
        'addr': type.OptionalType(type.StringType()),
        'type': type.OptionalType(type.StringType()),
    },
    ALBIpAddr,
    False,
    None))



class ALBIpAddrGroup(VapiStruct):
    """
    Advanced load balancer IpAddrGroup object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'addrs': 'addrs',
                            'apic_epg_name': 'apic_epg_name',
                            'country_codes': 'country_codes',
                            'ip_ports': 'ip_ports',
                            'marathon_app_name': 'marathon_app_name',
                            'marathon_service_port': 'marathon_service_port',
                            'markers': 'markers',
                            'prefixes': 'prefixes',
                            'ranges': 'ranges',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 addrs=None,
                 apic_epg_name=None,
                 country_codes=None,
                 ip_ports=None,
                 marathon_app_name=None,
                 marathon_service_port=None,
                 markers=None,
                 prefixes=None,
                 ranges=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  addrs: :class:`list` of :class:`ALBIpAddr` or ``None``
        :param addrs: Configure IP address(es).
        :type  apic_epg_name: :class:`str` or ``None``
        :param apic_epg_name: Populate IP addresses from members of this Cisco APIC EPG.
        :type  country_codes: :class:`list` of :class:`str` or ``None``
        :param country_codes: Populate the IP address ranges from the geo database for this
            country.
        :type  ip_ports: :class:`list` of :class:`ALBIpAddrPort` or ``None``
        :param ip_ports: Configure (IP address, port) tuple(s).
        :type  marathon_app_name: :class:`str` or ``None``
        :param marathon_app_name: Populate IP addresses from tasks of this Marathon app.
        :type  marathon_service_port: :class:`long` or ``None``
        :param marathon_service_port: Task port associated with marathon service port. If Marathon app
            has multiple service ports, this is required. Else, the first task
            port is used. format: int64
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  prefixes: :class:`list` of :class:`ALBIpAddrPrefix` or ``None``
        :param prefixes: Configure IP address prefix(es).
        :type  ranges: :class:`list` of :class:`ALBIpAddrRange` or ``None``
        :param ranges: Configure IP address range(s).
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.addrs = addrs
        self.apic_epg_name = apic_epg_name
        self.country_codes = country_codes
        self.ip_ports = ip_ports
        self.marathon_app_name = marathon_app_name
        self.marathon_service_port = marathon_service_port
        self.markers = markers
        self.prefixes = prefixes
        self.ranges = ranges
        VapiStruct.__init__(self)


ALBIpAddrGroup._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ip_addr_group', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'addrs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddr'))),
        'apic_epg_name': type.OptionalType(type.StringType()),
        'country_codes': type.OptionalType(type.ListType(type.StringType())),
        'ip_ports': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrPort'))),
        'marathon_app_name': type.OptionalType(type.StringType()),
        'marathon_service_port': type.OptionalType(type.IntegerType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'prefixes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrPrefix'))),
        'ranges': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrRange'))),
    },
    ALBIpAddrGroup,
    False,
    None))



class ALBIpAddrGroupApiResponse(VapiStruct):
    """
    IpAddrGroupApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBIpAddrGroup` or ``None``
        :param results: Array of IpAddrGroup
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBIpAddrGroupApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ip_addr_group_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrGroup'))),
    },
    ALBIpAddrGroupApiResponse,
    False,
    None))



class ALBIpAddrMatch(VapiStruct):
    """
    Advanced load balancer IpAddrMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """



    _canonical_to_pep_names = {
                            'addrs': 'addrs',
                            'group_paths': 'group_paths',
                            'match_criteria': 'match_criteria',
                            'prefixes': 'prefixes',
                            'ranges': 'ranges',
                            }

    def __init__(self,
                 addrs=None,
                 group_paths=None,
                 match_criteria=None,
                 prefixes=None,
                 ranges=None,
                ):
        """
        :type  addrs: :class:`list` of :class:`ALBIpAddr` or ``None``
        :param addrs: IP address(es).
        :type  group_paths: :class:`list` of :class:`str` or ``None``
        :param group_paths: path of IP address group(s). It is a reference to an object of type
            IpAddrGroup.
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBIpAddrMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBIpAddrMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for IP address matching the HTTP request. Enum
            options - IS_IN, IS_NOT_IN.
        :type  prefixes: :class:`list` of :class:`ALBIpAddrPrefix` or ``None``
        :param prefixes: IP address prefix(es).
        :type  ranges: :class:`list` of :class:`ALBIpAddrRange` or ``None``
        :param ranges: IP address range(s).
        """
        self.addrs = addrs
        self.group_paths = group_paths
        self.match_criteria = match_criteria
        self.prefixes = prefixes
        self.ranges = ranges
        VapiStruct.__init__(self)


ALBIpAddrMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ip_addr_match', {
        'addrs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddr'))),
        'group_paths': type.OptionalType(type.ListType(type.StringType())),
        'match_criteria': type.OptionalType(type.StringType()),
        'prefixes': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrPrefix'))),
        'ranges': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBIpAddrRange'))),
    },
    ALBIpAddrMatch,
    False,
    None))



class ALBIpAddrPort(VapiStruct):
    """
    Advanced load balancer IpAddrPort object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'hostname': 'hostname',
                            'ip': 'ip',
                            'name': 'name',
                            'port': 'port',
                            }

    def __init__(self,
                 hostname=None,
                 ip=None,
                 name=None,
                 port=None,
                ):
        """
        :type  hostname: :class:`str` or ``None``
        :param hostname: Hostname of server. One of IP address or hostname should be set.
        :type  ip: :class:`ALBIpAddr` or ``None``
        :param ip: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the object.
        :type  port: :class:`long` or ``None``
        :param port: Port number of server. Allowed values are 1-65535. format: int64
        """
        self.hostname = hostname
        self.ip = ip
        self.name = name
        self.port = port
        VapiStruct.__init__(self)


ALBIpAddrPort._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ip_addr_port', {
        'hostname': type.OptionalType(type.StringType()),
        'ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
        'name': type.OptionalType(type.StringType()),
        'port': type.OptionalType(type.IntegerType()),
    },
    ALBIpAddrPort,
    False,
    None))



class ALBIpAddrPrefix(VapiStruct):
    """
    Advanced load balancer IpAddrPrefix object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'ip_addr': 'ip_addr',
                            'mask': 'mask',
                            }

    def __init__(self,
                 ip_addr=None,
                 mask=None,
                ):
        """
        :type  ip_addr: :class:`ALBIpAddr` or ``None``
        :param ip_addr: 
        :type  mask: :class:`long` or ``None``
        :param mask: Number of mask. format: int64
        """
        self.ip_addr = ip_addr
        self.mask = mask
        VapiStruct.__init__(self)


ALBIpAddrPrefix._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ip_addr_prefix', {
        'ip_addr': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
        'mask': type.OptionalType(type.IntegerType()),
    },
    ALBIpAddrPrefix,
    False,
    None))



class ALBIpAddrRange(VapiStruct):
    """
    Advanced load balancer IpAddrRange object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'begin': 'begin',
                            'end': 'end',
                            }

    def __init__(self,
                 begin=None,
                 end=None,
                ):
        """
        :type  begin: :class:`ALBIpAddr` or ``None``
        :param begin: 
        :type  end: :class:`ALBIpAddr` or ``None``
        :param end: 
        """
        self.begin = begin
        self.end = end
        VapiStruct.__init__(self)


ALBIpAddrRange._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ip_addr_range', {
        'begin': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
        'end': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddr')),
    },
    ALBIpAddrRange,
    False,
    None))



class ALBKeyValue(VapiStruct):
    """
    Advanced load balancer KeyValue object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'key': 'key',
                            'value': 'value',
                            }

    def __init__(self,
                 key=None,
                 value=None,
                ):
        """
        :type  key: :class:`str` or ``None``
        :param key: Key.
        :type  value: :class:`str` or ``None``
        :param value: Value.
        """
        self.key = key
        self.value = value
        VapiStruct.__init__(self)


ALBKeyValue._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_key_value', {
        'key': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.StringType()),
    },
    ALBKeyValue,
    False,
    None))



class ALBL4ConnectionPolicy(VapiStruct):
    """
    Advanced load balancer L4ConnectionPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'rules': 'rules',
                            }

    def __init__(self,
                 rules=None,
                ):
        """
        :type  rules: :class:`list` of :class:`ALBL4Rule` or ``None``
        :param rules: Rules to apply when a new transport connection is setup.
        """
        self.rules = rules
        VapiStruct.__init__(self)


ALBL4ConnectionPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_connection_policy', {
        'rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBL4Rule'))),
    },
    ALBL4ConnectionPolicy,
    False,
    None))



class ALBL4Policies(VapiStruct):
    """
    Advanced load balancer L4Policies object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'index': 'index',
                            'l4_policy_set_path': 'l4_policy_set_path',
                            }

    def __init__(self,
                 index=None,
                 l4_policy_set_path=None,
                ):
        """
        :type  index: :class:`long` or ``None``
        :param index: Index of the virtual service L4 policy set. format: int64
        :type  l4_policy_set_path: :class:`str` or ``None``
        :param l4_policy_set_path: ID of the virtual service L4 policy set. It is a reference to an
            object of type L4PolicySet.
        """
        self.index = index
        self.l4_policy_set_path = l4_policy_set_path
        VapiStruct.__init__(self)


ALBL4Policies._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_policies', {
        'index': type.OptionalType(type.IntegerType()),
        'l4_policy_set_path': type.OptionalType(type.StringType()),
    },
    ALBL4Policies,
    False,
    None))



class ALBL4PolicySet(VapiStruct):
    """
    Advanced load balancer L4PolicySet object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'created_by': 'created_by',
                            'is_internal_policy': 'is_internal_policy',
                            'l4_connection_policy': 'l4_connection_policy',
                            'markers': 'markers',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 created_by=None,
                 is_internal_policy=None,
                 l4_connection_policy=None,
                 markers=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  created_by: :class:`str` or ``None``
        :param created_by: Creator name.
        :type  is_internal_policy: :class:`bool` or ``None``
        :param is_internal_policy: Placeholder for description of property is_internal_policy of obj
            type L4PolicySet field type str type boolean. Default value when
            not specified in API or module is interpreted by ALB Controller as
            false.
        :type  l4_connection_policy: :class:`ALBL4ConnectionPolicy` or ``None``
        :param l4_connection_policy: 
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.created_by = created_by
        self.is_internal_policy = is_internal_policy
        self.l4_connection_policy = l4_connection_policy
        self.markers = markers
        VapiStruct.__init__(self)


ALBL4PolicySet._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_policy_set', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'created_by': type.OptionalType(type.StringType()),
        'is_internal_policy': type.OptionalType(type.BooleanType()),
        'l4_connection_policy': type.OptionalType(type.ReferenceType(__name__, 'ALBL4ConnectionPolicy')),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
    },
    ALBL4PolicySet,
    False,
    None))



class ALBL4PolicySetApiResponse(VapiStruct):
    """
    L4PolicySetApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBL4PolicySet` or ``None``
        :param results: Array of L4PolicySet
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBL4PolicySetApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_policy_set_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBL4PolicySet'))),
    },
    ALBL4PolicySetApiResponse,
    False,
    None))



class ALBL4Rule(VapiStruct):
    """
    Advanced load balancer L4Rule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'enable': 'enable',
                            'index': 'index',
                            'match': 'match',
                            'name': 'name',
                            }

    def __init__(self,
                 action=None,
                 enable=None,
                 index=None,
                 match=None,
                 name=None,
                ):
        """
        :type  action: :class:`ALBL4RuleAction` or ``None``
        :param action: 
        :type  enable: :class:`bool` or ``None``
        :param enable: Enable or disable the rule. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  index: :class:`long` or ``None``
        :param index: Index of the rule. format: int64
        :type  match: :class:`ALBL4RuleMatchTarget` or ``None``
        :param match: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the rule.
        """
        self.action = action
        self.enable = enable
        self.index = index
        self.match = match
        self.name = name
        VapiStruct.__init__(self)


ALBL4Rule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_rule', {
        'action': type.OptionalType(type.ReferenceType(__name__, 'ALBL4RuleAction')),
        'enable': type.OptionalType(type.BooleanType()),
        'index': type.OptionalType(type.IntegerType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBL4RuleMatchTarget')),
        'name': type.OptionalType(type.StringType()),
    },
    ALBL4Rule,
    False,
    None))



class ALBL4RuleAction(VapiStruct):
    """
    Advanced load balancer L4RuleAction object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'select_pool': 'select_pool',
                            }

    def __init__(self,
                 select_pool=None,
                ):
        """
        :type  select_pool: :class:`ALBL4RuleActionSelectPool` or ``None``
        :param select_pool: 
        """
        self.select_pool = select_pool
        VapiStruct.__init__(self)


ALBL4RuleAction._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_rule_action', {
        'select_pool': type.OptionalType(type.ReferenceType(__name__, 'ALBL4RuleActionSelectPool')),
    },
    ALBL4RuleAction,
    False,
    None))



class ALBL4RuleActionSelectPool(VapiStruct):
    """
    Advanced load balancer L4RuleActionSelectPool object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTION_TYPE_POOL = "L4_RULE_ACTION_SELECT_POOL"
    """


    """
    ACTION_TYPE_POOLGROUP = "L4_RULE_ACTION_SELECT_POOLGROUP"
    """


    """



    _canonical_to_pep_names = {
                            'action_type': 'action_type',
                            'pool_group_path': 'pool_group_path',
                            'pool_path': 'pool_path',
                            }

    def __init__(self,
                 action_type=None,
                 pool_group_path=None,
                 pool_path=None,
                ):
        """
        :type  action_type: :class:`str` or ``None``
        :param action_type: Possible values are: 
            
            * :attr:`ALBL4RuleActionSelectPool.ACTION_TYPE_POOL`
            * :attr:`ALBL4RuleActionSelectPool.ACTION_TYPE_POOLGROUP`
            
            Indicates action to take on rule match. Enum options -
            L4_RULE_ACTION_SELECT_POOL, L4_RULE_ACTION_SELECT_POOLGROUP.
            Allowed in Basic(Allowed values- L4_RULE_ACTION_SELECT_POOL)
            edition, Essentials(Allowed values- L4_RULE_ACTION_SELECT_POOL)
            edition, Enterprise edition.
        :type  pool_group_path: :class:`str` or ``None``
        :param pool_group_path: ID of the pool group to serve the request. It is a reference to an
            object of type PoolGroup. Allowed in Basic edition, Essentials
            edition, Enterprise edition.
        :type  pool_path: :class:`str` or ``None``
        :param pool_path: ID of the pool of servers to serve the request. It is a reference
            to an object of type Pool.
        """
        self.action_type = action_type
        self.pool_group_path = pool_group_path
        self.pool_path = pool_path
        VapiStruct.__init__(self)


ALBL4RuleActionSelectPool._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_rule_action_select_pool', {
        'action_type': type.OptionalType(type.StringType()),
        'pool_group_path': type.OptionalType(type.StringType()),
        'pool_path': type.OptionalType(type.StringType()),
    },
    ALBL4RuleActionSelectPool,
    False,
    None))



class ALBL4RuleMatchTarget(VapiStruct):
    """
    Advanced load balancer L4RuleMatchTarget object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_ip': 'client_ip',
                            'port': 'port',
                            'protocol': 'protocol',
                            }

    def __init__(self,
                 client_ip=None,
                 port=None,
                 protocol=None,
                ):
        """
        :type  client_ip: :class:`ALBIpAddrMatch` or ``None``
        :param client_ip: 
        :type  port: :class:`ALBL4RulePortMatch` or ``None``
        :param port: 
        :type  protocol: :class:`ALBL4RuleProtocolMatch` or ``None``
        :param protocol: 
        """
        self.client_ip = client_ip
        self.port = port
        self.protocol = protocol
        VapiStruct.__init__(self)


ALBL4RuleMatchTarget._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_rule_match_target', {
        'client_ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrMatch')),
        'port': type.OptionalType(type.ReferenceType(__name__, 'ALBL4RulePortMatch')),
        'protocol': type.OptionalType(type.ReferenceType(__name__, 'ALBL4RuleProtocolMatch')),
    },
    ALBL4RuleMatchTarget,
    False,
    None))



class ALBL4RulePortMatch(VapiStruct):
    """
    Advanced load balancer L4RulePortMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            'port_ranges': 'port_ranges',
                            'ports': 'ports',
                            }

    def __init__(self,
                 match_criteria=None,
                 port_ranges=None,
                 ports=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBL4RulePortMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBL4RulePortMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for Virtual Service port matching. Enum options -
            IS_IN, IS_NOT_IN.
        :type  port_ranges: :class:`list` of :class:`ALBPortRange` or ``None``
        :param port_ranges: Range of TCP/UDP port numbers of the Virtual Service.
        :type  ports: :class:`list` of :class:`long` or ``None``
        :param ports: Virtual Service's listening port(s). Allowed values are 1-65535.
            format: int64
        """
        self.match_criteria = match_criteria
        self.port_ranges = port_ranges
        self.ports = ports
        VapiStruct.__init__(self)


ALBL4RulePortMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_rule_port_match', {
        'match_criteria': type.OptionalType(type.StringType()),
        'port_ranges': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBPortRange'))),
        'ports': type.OptionalType(type.ListType(type.IntegerType())),
    },
    ALBL4RulePortMatch,
    False,
    None))



class ALBL4RuleProtocolMatch(VapiStruct):
    """
    Advanced load balancer L4RuleProtocolMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """
    PROTOCOL_ICMP = "PROTOCOL_ICMP"
    """


    """
    PROTOCOL_TCP = "PROTOCOL_TCP"
    """


    """
    PROTOCOL_UDP = "PROTOCOL_UDP"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            'protocol': 'protocol',
                            }

    def __init__(self,
                 match_criteria=None,
                 protocol=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBL4RuleProtocolMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBL4RuleProtocolMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for transport protocol matching. Enum options -
            IS_IN, IS_NOT_IN.
        :type  protocol: :class:`str` or ``None``
        :param protocol: Possible values are: 
            
            * :attr:`ALBL4RuleProtocolMatch.PROTOCOL_ICMP`
            * :attr:`ALBL4RuleProtocolMatch.PROTOCOL_TCP`
            * :attr:`ALBL4RuleProtocolMatch.PROTOCOL_UDP`
            
            Transport protocol to match. Enum options - PROTOCOL_ICMP,
            PROTOCOL_TCP, PROTOCOL_UDP.
        """
        self.match_criteria = match_criteria
        self.protocol = protocol
        VapiStruct.__init__(self)


ALBL4RuleProtocolMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_l4_rule_protocol_match', {
        'match_criteria': type.OptionalType(type.StringType()),
        'protocol': type.OptionalType(type.StringType()),
    },
    ALBL4RuleProtocolMatch,
    False,
    None))



class ALBLdapAuthSettings(VapiStruct):
    """
    Advanced load balancer LdapAuthSettings object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SECURITY_MODE_NONE = "AUTH_LDAP_SECURE_NONE"
    """


    """
    SECURITY_MODE_USE_LDAPS = "AUTH_LDAP_SECURE_USE_LDAPS"
    """


    """



    _canonical_to_pep_names = {
                            'base_dn': 'base_dn',
                            'bind_as_administrator': 'bind_as_administrator',
                            'email_attribute': 'email_attribute',
                            'full_name_attribute': 'full_name_attribute',
                            'port': 'port',
                            'security_mode': 'security_mode',
                            'server': 'server',
                            'settings': 'settings',
                            'user_bind': 'user_bind',
                            }

    def __init__(self,
                 base_dn=None,
                 bind_as_administrator=None,
                 email_attribute=None,
                 full_name_attribute=None,
                 port=None,
                 security_mode=None,
                 server=None,
                 settings=None,
                 user_bind=None,
                ):
        """
        :type  base_dn: :class:`str` or ``None``
        :param base_dn: The LDAP base DN. For example, avinetworks.com would be
            DC=avinetworks,DC=com.
        :type  bind_as_administrator: :class:`bool` or ``None``
        :param bind_as_administrator: LDAP administrator credentials are used to search for users and
            group memberships. Default value when not specified in API or
            module is interpreted by ALB Controller as true.
        :type  email_attribute: :class:`str` or ``None``
        :param email_attribute: LDAP attribute that refers to user email. Default value when not
            specified in API or module is interpreted by ALB Controller as
            email.
        :type  full_name_attribute: :class:`str` or ``None``
        :param full_name_attribute: LDAP attribute that refers to user's full name. Default value when
            not specified in API or module is interpreted by ALB Controller as
            name.
        :type  port: :class:`long` or ``None``
        :param port: Query the LDAP servers on this port. Default value when not
            specified in API or module is interpreted by ALB Controller as 389.
            format: int64
        :type  security_mode: :class:`str` or ``None``
        :param security_mode: Possible values are: 
            
            * :attr:`ALBLdapAuthSettings.SECURITY_MODE_NONE`
            * :attr:`ALBLdapAuthSettings.SECURITY_MODE_USE_LDAPS`
            
            LDAP connection security mode. Enum options -
            AUTH_LDAP_SECURE_NONE, AUTH_LDAP_SECURE_USE_LDAPS.
        :type  server: :class:`list` of :class:`str` or ``None``
        :param server: LDAP server IP address or Hostname. Use IP address if an auth
            profile is used to configure Virtual Service. Minimum of 1 items
            required.
        :type  settings: :class:`ALBLdapDirectorySettings` or ``None``
        :param settings: 
        :type  user_bind: :class:`ALBLdapUserBindSettings` or ``None``
        :param user_bind: 
        """
        self.base_dn = base_dn
        self.bind_as_administrator = bind_as_administrator
        self.email_attribute = email_attribute
        self.full_name_attribute = full_name_attribute
        self.port = port
        self.security_mode = security_mode
        self.server = server
        self.settings = settings
        self.user_bind = user_bind
        VapiStruct.__init__(self)


ALBLdapAuthSettings._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ldap_auth_settings', {
        'base_dn': type.OptionalType(type.StringType()),
        'bind_as_administrator': type.OptionalType(type.BooleanType()),
        'email_attribute': type.OptionalType(type.StringType()),
        'full_name_attribute': type.OptionalType(type.StringType()),
        'port': type.OptionalType(type.IntegerType()),
        'security_mode': type.OptionalType(type.StringType()),
        'server': type.OptionalType(type.ListType(type.StringType())),
        'settings': type.OptionalType(type.ReferenceType(__name__, 'ALBLdapDirectorySettings')),
        'user_bind': type.OptionalType(type.ReferenceType(__name__, 'ALBLdapUserBindSettings')),
    },
    ALBLdapAuthSettings,
    False,
    None))



class ALBLdapDirectorySettings(VapiStruct):
    """
    Advanced load balancer LdapDirectorySettings object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    GROUP_SEARCH_SCOPE_BASE = "AUTH_LDAP_SCOPE_BASE"
    """


    """
    GROUP_SEARCH_SCOPE_ONE = "AUTH_LDAP_SCOPE_ONE"
    """


    """
    GROUP_SEARCH_SCOPE_SUBTREE = "AUTH_LDAP_SCOPE_SUBTREE"
    """


    """
    USER_SEARCH_SCOPE_BASE = "AUTH_LDAP_SCOPE_BASE"
    """


    """
    USER_SEARCH_SCOPE_ONE = "AUTH_LDAP_SCOPE_ONE"
    """


    """
    USER_SEARCH_SCOPE_SUBTREE = "AUTH_LDAP_SCOPE_SUBTREE"
    """


    """



    _canonical_to_pep_names = {
                            'admin_bind_dn': 'admin_bind_dn',
                            'group_filter': 'group_filter',
                            'group_member_attribute': 'group_member_attribute',
                            'group_member_is_full_dn': 'group_member_is_full_dn',
                            'group_search_dn': 'group_search_dn',
                            'group_search_scope': 'group_search_scope',
                            'ignore_referrals': 'ignore_referrals',
                            'password': 'password',
                            'user_attributes': 'user_attributes',
                            'user_id_attribute': 'user_id_attribute',
                            'user_search_dn': 'user_search_dn',
                            'user_search_scope': 'user_search_scope',
                            }

    def __init__(self,
                 admin_bind_dn=None,
                 group_filter=None,
                 group_member_attribute=None,
                 group_member_is_full_dn=None,
                 group_search_dn=None,
                 group_search_scope=None,
                 ignore_referrals=None,
                 password=None,
                 user_attributes=None,
                 user_id_attribute=None,
                 user_search_dn=None,
                 user_search_scope=None,
                ):
        """
        :type  admin_bind_dn: :class:`str` or ``None``
        :param admin_bind_dn: LDAP Admin User DN. Administrator credentials are required to
            search for users under user search DN or groups under group search
            DN.
        :type  group_filter: :class:`str` or ``None``
        :param group_filter: Group filter is used to identify groups during search. Default
            value when not specified in API or module is interpreted by ALB
            Controller as (objectClass=(STAR)).
        :type  group_member_attribute: :class:`str` or ``None``
        :param group_member_attribute: LDAP group attribute that identifies each of the group members.
            Default value when not specified in API or module is interpreted by
            ALB Controller as member.
        :type  group_member_is_full_dn: :class:`bool` or ``None``
        :param group_member_is_full_dn: Group member entries contain full DNs instead of just user id
            attribute values. Default value when not specified in API or module
            is interpreted by ALB Controller as true.
        :type  group_search_dn: :class:`str` or ``None``
        :param group_search_dn: LDAP group search DN is the root of search for a given group in the
            LDAP directory. Only matching groups present in this LDAP directory
            sub-tree will be checked for user membership.
        :type  group_search_scope: :class:`str` or ``None``
        :param group_search_scope: Possible values are: 
            
            * :attr:`ALBLdapDirectorySettings.GROUP_SEARCH_SCOPE_BASE`
            * :attr:`ALBLdapDirectorySettings.GROUP_SEARCH_SCOPE_ONE`
            * :attr:`ALBLdapDirectorySettings.GROUP_SEARCH_SCOPE_SUBTREE`
            
            LDAP group search scope defines how deep to search for the group
            starting from the group search DN. Enum options -
            AUTH_LDAP_SCOPE_BASE, AUTH_LDAP_SCOPE_ONE, AUTH_LDAP_SCOPE_SUBTREE.
            Default value when not specified in API or module is interpreted by
            ALB Controller as AUTH_LDAP_SCOPE_SUBTREE.
        :type  ignore_referrals: :class:`bool` or ``None``
        :param ignore_referrals: During user or group search, ignore searching referrals. Default
            value when not specified in API or module is interpreted by ALB
            Controller as false.
        :type  password: :class:`str` or ``None``
        :param password: LDAP Admin User Password.
        :type  user_attributes: :class:`list` of :class:`str` or ``None``
        :param user_attributes: LDAP user attributes to fetch on a successful user bind.
        :type  user_id_attribute: :class:`str` or ``None``
        :param user_id_attribute: LDAP user id attribute is the login attribute that uniquely
            identifies a single user record.
        :type  user_search_dn: :class:`str` or ``None``
        :param user_search_dn: LDAP user search DN is the root of search for a given user in the
            LDAP directory. Only user records present in this LDAP directory
            sub-tree will be validated.
        :type  user_search_scope: :class:`str` or ``None``
        :param user_search_scope: Possible values are: 
            
            * :attr:`ALBLdapDirectorySettings.USER_SEARCH_SCOPE_BASE`
            * :attr:`ALBLdapDirectorySettings.USER_SEARCH_SCOPE_ONE`
            * :attr:`ALBLdapDirectorySettings.USER_SEARCH_SCOPE_SUBTREE`
            
            LDAP user search scope defines how deep to search for the user
            starting from user search DN. Enum options - AUTH_LDAP_SCOPE_BASE,
            AUTH_LDAP_SCOPE_ONE, AUTH_LDAP_SCOPE_SUBTREE. Default value when
            not specified in API or module is interpreted by ALB Controller as
            AUTH_LDAP_SCOPE_ONE.
        """
        self.admin_bind_dn = admin_bind_dn
        self.group_filter = group_filter
        self.group_member_attribute = group_member_attribute
        self.group_member_is_full_dn = group_member_is_full_dn
        self.group_search_dn = group_search_dn
        self.group_search_scope = group_search_scope
        self.ignore_referrals = ignore_referrals
        self.password = password
        self.user_attributes = user_attributes
        self.user_id_attribute = user_id_attribute
        self.user_search_dn = user_search_dn
        self.user_search_scope = user_search_scope
        VapiStruct.__init__(self)


ALBLdapDirectorySettings._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ldap_directory_settings', {
        'admin_bind_dn': type.OptionalType(type.StringType()),
        'group_filter': type.OptionalType(type.StringType()),
        'group_member_attribute': type.OptionalType(type.StringType()),
        'group_member_is_full_dn': type.OptionalType(type.BooleanType()),
        'group_search_dn': type.OptionalType(type.StringType()),
        'group_search_scope': type.OptionalType(type.StringType()),
        'ignore_referrals': type.OptionalType(type.BooleanType()),
        'password': type.OptionalType(type.StringType()),
        'user_attributes': type.OptionalType(type.ListType(type.StringType())),
        'user_id_attribute': type.OptionalType(type.StringType()),
        'user_search_dn': type.OptionalType(type.StringType()),
        'user_search_scope': type.OptionalType(type.StringType()),
    },
    ALBLdapDirectorySettings,
    False,
    None))



class ALBLdapUserBindSettings(VapiStruct):
    """
    Advanced load balancer LdapUserBindSettings object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'dn_template': 'dn_template',
                            'token': 'token',
                            'user_attributes': 'user_attributes',
                            'user_id_attribute': 'user_id_attribute',
                            }

    def __init__(self,
                 dn_template=None,
                 token=None,
                 user_attributes=None,
                 user_id_attribute=None,
                ):
        """
        :type  dn_template: :class:`str` or ``None``
        :param dn_template: LDAP user DN pattern is used to bind LDAP user after replacing the
            user token with real username.
        :type  token: :class:`str` or ``None``
        :param token: 
        :type  user_attributes: :class:`list` of :class:`str` or ``None``
        :param user_attributes: LDAP user attributes to fetch on a successful user bind.
        :type  user_id_attribute: :class:`str` or ``None``
        :param user_id_attribute: LDAP user id attribute is the login attribute that uniquely
            identifies a single user record.
        """
        self.dn_template = dn_template
        self.token = token
        self.user_attributes = user_attributes
        self.user_id_attribute = user_id_attribute
        VapiStruct.__init__(self)


ALBLdapUserBindSettings._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_ldap_user_bind_settings', {
        'dn_template': type.OptionalType(type.StringType()),
        'token': type.OptionalType(type.StringType()),
        'user_attributes': type.OptionalType(type.ListType(type.StringType())),
        'user_id_attribute': type.OptionalType(type.StringType()),
    },
    ALBLdapUserBindSettings,
    False,
    None))



class ALBLocationHdrMatch(VapiStruct):
    """
    Advanced load balancer LocationHdrMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CASE_SENSITIVE = "SENSITIVE"
    """


    """
    MATCH_CASE_INSENSITIVE = "INSENSITIVE"
    """


    """
    MATCH_CRITERIA_EXISTS = "HDR_EXISTS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EXIST = "HDR_DOES_NOT_EXIST"
    """


    """
    MATCH_CRITERIA_BEGINS_WITH = "HDR_BEGINS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_BEGIN_WITH = "HDR_DOES_NOT_BEGIN_WITH"
    """


    """
    MATCH_CRITERIA_CONTAINS = "HDR_CONTAINS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_CONTAIN = "HDR_DOES_NOT_CONTAIN"
    """


    """
    MATCH_CRITERIA_ENDS_WITH = "HDR_ENDS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_END_WITH = "HDR_DOES_NOT_END_WITH"
    """


    """
    MATCH_CRITERIA_EQUALS = "HDR_EQUALS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EQUAL = "HDR_DOES_NOT_EQUAL"
    """


    """



    _canonical_to_pep_names = {
                            'match_case': 'match_case',
                            'match_criteria': 'match_criteria',
                            'value': 'value',
                            }

    def __init__(self,
                 match_case=None,
                 match_criteria=None,
                 value=None,
                ):
        """
        :type  match_case: :class:`str` or ``None``
        :param match_case: Possible values are: 
            
            * :attr:`ALBLocationHdrMatch.MATCH_CASE_SENSITIVE`
            * :attr:`ALBLocationHdrMatch.MATCH_CASE_INSENSITIVE`
            
            Case sensitivity to use for the match. Enum options - SENSITIVE,
            INSENSITIVE. Default value when not specified in API or module is
            interpreted by ALB Controller as INSENSITIVE.
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_EXISTS`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_DOES_NOT_EXIST`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_BEGINS_WITH`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_DOES_NOT_BEGIN_WITH`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_CONTAINS`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_DOES_NOT_CONTAIN`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_ENDS_WITH`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_DOES_NOT_END_WITH`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_EQUALS`
            * :attr:`ALBLocationHdrMatch.MATCH_CRITERIA_DOES_NOT_EQUAL`
            
            Criterion to use for matching location header value in the HTTP
            response. Enum options - HDR_EXISTS, HDR_DOES_NOT_EXIST,
            HDR_BEGINS_WITH, HDR_DOES_NOT_BEGIN_WITH, HDR_CONTAINS,
            HDR_DOES_NOT_CONTAIN, HDR_ENDS_WITH, HDR_DOES_NOT_END_WITH,
            HDR_EQUALS, HDR_DOES_NOT_EQUAL.
        :type  value: :class:`list` of :class:`str` or ``None``
        :param value: String value(s) in the location header.
        """
        self.match_case = match_case
        self.match_criteria = match_criteria
        self.value = value
        VapiStruct.__init__(self)


ALBLocationHdrMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_location_hdr_match', {
        'match_case': type.OptionalType(type.StringType()),
        'match_criteria': type.OptionalType(type.StringType()),
        'value': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBLocationHdrMatch,
    False,
    None))



class ALBMatchReplacePair(VapiStruct):
    """
    Advanced load balancer MatchReplacePair object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'match_string': 'match_string',
                            'replacement_string': 'replacement_string',
                            }

    def __init__(self,
                 match_string=None,
                 replacement_string=None,
                ):
        """
        :type  match_string: :class:`str` or ``None``
        :param match_string: String to be matched.
        :type  replacement_string: :class:`ALBReplaceStringVar` or ``None``
        :param replacement_string: 
        """
        self.match_string = match_string
        self.replacement_string = replacement_string
        VapiStruct.__init__(self)


ALBMatchReplacePair._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_match_replace_pair', {
        'match_string': type.OptionalType(type.StringType()),
        'replacement_string': type.OptionalType(type.ReferenceType(__name__, 'ALBReplaceStringVar')),
    },
    ALBMatchReplacePair,
    False,
    None))



class ALBMatchTarget(VapiStruct):
    """
    Advanced load balancer MatchTarget object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_ip': 'client_ip',
                            'cookie': 'cookie',
                            'hdrs': 'hdrs',
                            'host_hdr': 'host_hdr',
                            'method': 'method',
                            'path': 'path',
                            'protocol': 'protocol',
                            'query': 'query',
                            'version': 'version',
                            'vs_port': 'vs_port',
                            }

    def __init__(self,
                 client_ip=None,
                 cookie=None,
                 hdrs=None,
                 host_hdr=None,
                 method=None,
                 path=None,
                 protocol=None,
                 query=None,
                 version=None,
                 vs_port=None,
                ):
        """
        :type  client_ip: :class:`ALBIpAddrMatch` or ``None``
        :param client_ip: 
        :type  cookie: :class:`ALBCookieMatch` or ``None``
        :param cookie: 
        :type  hdrs: :class:`list` of :class:`ALBHdrMatch` or ``None``
        :param hdrs: Configure HTTP header(s).
        :type  host_hdr: :class:`ALBHostHdrMatch` or ``None``
        :param host_hdr: 
        :type  method: :class:`ALBMethodMatch` or ``None``
        :param method: 
        :type  path: :class:`ALBPathMatch` or ``None``
        :param path: 
        :type  protocol: :class:`ALBProtocolMatch` or ``None``
        :param protocol: 
        :type  query: :class:`ALBQueryMatch` or ``None``
        :param query: 
        :type  version: :class:`ALBHTTPVersionMatch` or ``None``
        :param version: 
        :type  vs_port: :class:`ALBPortMatch` or ``None``
        :param vs_port: 
        """
        self.client_ip = client_ip
        self.cookie = cookie
        self.hdrs = hdrs
        self.host_hdr = host_hdr
        self.method = method
        self.path = path
        self.protocol = protocol
        self.query = query
        self.version = version
        self.vs_port = vs_port
        VapiStruct.__init__(self)


ALBMatchTarget._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_match_target', {
        'client_ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrMatch')),
        'cookie': type.OptionalType(type.ReferenceType(__name__, 'ALBCookieMatch')),
        'hdrs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBHdrMatch'))),
        'host_hdr': type.OptionalType(type.ReferenceType(__name__, 'ALBHostHdrMatch')),
        'method': type.OptionalType(type.ReferenceType(__name__, 'ALBMethodMatch')),
        'path': type.OptionalType(type.ReferenceType(__name__, 'ALBPathMatch')),
        'protocol': type.OptionalType(type.ReferenceType(__name__, 'ALBProtocolMatch')),
        'query': type.OptionalType(type.ReferenceType(__name__, 'ALBQueryMatch')),
        'version': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPVersionMatch')),
        'vs_port': type.OptionalType(type.ReferenceType(__name__, 'ALBPortMatch')),
    },
    ALBMatchTarget,
    False,
    None))



class ALBMethodMatch(VapiStruct):
    """
    Advanced load balancer MethodMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """
    METHODS_GET = "HTTP_METHOD_GET"
    """


    """
    METHODS_HEAD = "HTTP_METHOD_HEAD"
    """


    """
    METHODS_PUT = "HTTP_METHOD_PUT"
    """


    """
    METHODS_DELETE = "HTTP_METHOD_DELETE"
    """


    """
    METHODS_POST = "HTTP_METHOD_POST"
    """


    """
    METHODS_OPTIONS = "HTTP_METHOD_OPTIONS"
    """


    """
    METHODS_TRACE = "HTTP_METHOD_TRACE"
    """


    """
    METHODS_CONNECT = "HTTP_METHOD_CONNECT"
    """


    """
    METHODS_PATCH = "HTTP_METHOD_PATCH"
    """


    """
    METHODS_PROPFIND = "HTTP_METHOD_PROPFIND"
    """


    """
    METHODS_PROPPATCH = "HTTP_METHOD_PROPPATCH"
    """


    """
    METHODS_MKCOL = "HTTP_METHOD_MKCOL"
    """


    """
    METHODS_COPY = "HTTP_METHOD_COPY"
    """


    """
    METHODS_MOVE = "HTTP_METHOD_MOVE"
    """


    """
    METHODS_LOCK = "HTTP_METHOD_LOCK"
    """


    """
    METHODS_UNLOCK = "HTTP_METHOD_UNLOCK"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            'methods': 'methods',
                            }

    def __init__(self,
                 match_criteria=None,
                 methods=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBMethodMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBMethodMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for HTTP method matching the method in the HTTP
            request. Enum options - IS_IN, IS_NOT_IN.
        :type  methods: :class:`list` of :class:`str` or ``None``
        :param methods: Possible values are: 
            
            * :attr:`ALBMethodMatch.METHODS_GET`
            * :attr:`ALBMethodMatch.METHODS_HEAD`
            * :attr:`ALBMethodMatch.METHODS_PUT`
            * :attr:`ALBMethodMatch.METHODS_DELETE`
            * :attr:`ALBMethodMatch.METHODS_POST`
            * :attr:`ALBMethodMatch.METHODS_OPTIONS`
            * :attr:`ALBMethodMatch.METHODS_TRACE`
            * :attr:`ALBMethodMatch.METHODS_CONNECT`
            * :attr:`ALBMethodMatch.METHODS_PATCH`
            * :attr:`ALBMethodMatch.METHODS_PROPFIND`
            * :attr:`ALBMethodMatch.METHODS_PROPPATCH`
            * :attr:`ALBMethodMatch.METHODS_MKCOL`
            * :attr:`ALBMethodMatch.METHODS_COPY`
            * :attr:`ALBMethodMatch.METHODS_MOVE`
            * :attr:`ALBMethodMatch.METHODS_LOCK`
            * :attr:`ALBMethodMatch.METHODS_UNLOCK`
            
            Configure HTTP method(s). Enum options - HTTP_METHOD_GET,
            HTTP_METHOD_HEAD, HTTP_METHOD_PUT, HTTP_METHOD_DELETE,
            HTTP_METHOD_POST, HTTP_METHOD_OPTIONS, HTTP_METHOD_TRACE,
            HTTP_METHOD_CONNECT, HTTP_METHOD_PATCH, HTTP_METHOD_PROPFIND,
            HTTP_METHOD_PROPPATCH, HTTP_METHOD_MKCOL, HTTP_METHOD_COPY,
            HTTP_METHOD_MOVE, HTTP_METHOD_LOCK, HTTP_METHOD_UNLOCK. Minimum of
            1 items required. Maximum of 16 items allowed. Allowed in
            Basic(Allowed values-
            HTTP_METHOD_GET,HTTP_METHOD_PUT,HTTP_METHOD_POST,HTTP_METHOD_HEAD,HTTP_METHOD_OPTIONS)
            edition, Essentials(Allowed values-
            HTTP_METHOD_GET,HTTP_METHOD_PUT,HTTP_METHOD_POST,HTTP_METHOD_HEAD,HTTP_METHOD_OPTIONS)
            edition, Enterprise edition.
        """
        self.match_criteria = match_criteria
        self.methods = methods
        VapiStruct.__init__(self)


ALBMethodMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_method_match', {
        'match_criteria': type.OptionalType(type.StringType()),
        'methods': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBMethodMatch,
    False,
    None))



class ALBMetricsRealTimeUpdate(VapiStruct):
    """
    Advanced load balancer MetricsRealTimeUpdate object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'duration': 'duration',
                            'enabled': 'enabled',
                            }

    def __init__(self,
                 duration=None,
                 enabled=None,
                ):
        """
        :type  duration: :class:`long` or ``None``
        :param duration: Real time metrics collection duration in minutes. 0 for infinite.
            Special values are 0 - 'infinite'. Unit is MIN. Default value when
            not specified in API or module is interpreted by ALB Controller as
            30. format: int64
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enables real time metrics collection. When deactivated, 6 hour view
            is the most granular the system will track. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        """
        self.duration = duration
        self.enabled = enabled
        VapiStruct.__init__(self)


ALBMetricsRealTimeUpdate._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_metrics_real_time_update', {
        'duration': type.OptionalType(type.IntegerType()),
        'enabled': type.OptionalType(type.BooleanType()),
    },
    ALBMetricsRealTimeUpdate,
    False,
    None))



class ALBMicroServiceMatch(VapiStruct):
    """
    Advanced load balancer MicroServiceMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CRITERIA_IN = "IS_IN"
    """


    """
    MATCH_CRITERIA_NOT_IN = "IS_NOT_IN"
    """


    """



    _canonical_to_pep_names = {
                            'match_criteria': 'match_criteria',
                            }

    def __init__(self,
                 match_criteria=None,
                ):
        """
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBMicroServiceMatch.MATCH_CRITERIA_IN`
            * :attr:`ALBMicroServiceMatch.MATCH_CRITERIA_NOT_IN`
            
            Criterion to use for Micro Service matching the HTTP request. Enum
            options - IS_IN, IS_NOT_IN.
        """
        self.match_criteria = match_criteria
        VapiStruct.__init__(self)


ALBMicroServiceMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_micro_service_match', {
        'match_criteria': type.OptionalType(type.StringType()),
    },
    ALBMicroServiceMatch,
    False,
    None))



class ALBNetworkFilter(VapiStruct):
    """
    Advanced load balancer NetworkFilter object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'server_filter': 'server_filter',
                            }

    def __init__(self,
                 server_filter=None,
                ):
        """
        :type  server_filter: :class:`str` or ``None``
        :param server_filter: server_filter of NetworkFilter.
        """
        self.server_filter = server_filter
        VapiStruct.__init__(self)


ALBNetworkFilter._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_filter', {
        'server_filter': type.OptionalType(type.StringType()),
    },
    ALBNetworkFilter,
    False,
    None))



class ALBNetworkProfile(VapiStruct):
    """
    Advanced load balancer NetworkProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'connection_mirror': 'connection_mirror',
                            'markers': 'markers',
                            'profile': 'profile',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 connection_mirror=None,
                 markers=None,
                 profile=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  connection_mirror: :class:`bool` or ``None``
        :param connection_mirror: When enabled, Avi mirrors all TCP fastpath connections to standby.
            Applicable only in Legacy HA Mode. Default value when not specified
            in API or module is interpreted by ALB Controller as false.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  profile: :class:`ALBNetworkProfileUnion` or ``None``
        :param profile: 
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.connection_mirror = connection_mirror
        self.markers = markers
        self.profile = profile
        VapiStruct.__init__(self)


ALBNetworkProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'connection_mirror': type.OptionalType(type.BooleanType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'profile': type.OptionalType(type.ReferenceType(__name__, 'ALBNetworkProfileUnion')),
    },
    ALBNetworkProfile,
    False,
    None))



class ALBNetworkProfileApiResponse(VapiStruct):
    """
    NetworkProfileApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBNetworkProfile` or ``None``
        :param results: Array of NetworkProfile
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBNetworkProfileApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_profile_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBNetworkProfile'))),
    },
    ALBNetworkProfileApiResponse,
    False,
    None))



class ALBNetworkProfileUnion(VapiStruct):
    """
    Advanced load balancer NetworkProfileUnion object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    TYPE_TCP_PROXY = "PROTOCOL_TYPE_TCP_PROXY"
    """


    """
    TYPE_TCP_FAST_PATH = "PROTOCOL_TYPE_TCP_FAST_PATH"
    """


    """
    TYPE_UDP_FAST_PATH = "PROTOCOL_TYPE_UDP_FAST_PATH"
    """


    """
    TYPE_UDP_PROXY = "PROTOCOL_TYPE_UDP_PROXY"
    """


    """



    _canonical_to_pep_names = {
                            'tcp_fast_path_profile': 'tcp_fast_path_profile',
                            'tcp_proxy_profile': 'tcp_proxy_profile',
                            'type': 'type',
                            'udp_fast_path_profile': 'udp_fast_path_profile',
                            'udp_proxy_profile': 'udp_proxy_profile',
                            }

    def __init__(self,
                 tcp_fast_path_profile=None,
                 tcp_proxy_profile=None,
                 type=None,
                 udp_fast_path_profile=None,
                 udp_proxy_profile=None,
                ):
        """
        :type  tcp_fast_path_profile: :class:`ALBTCPFastPathProfile` or ``None``
        :param tcp_fast_path_profile: 
        :type  tcp_proxy_profile: :class:`ALBTCPProxyProfile` or ``None``
        :param tcp_proxy_profile: 
        :type  type: :class:`str` or ``None``
        :param type: Possible values are: 
            
            * :attr:`ALBNetworkProfileUnion.TYPE_TCP_PROXY`
            * :attr:`ALBNetworkProfileUnion.TYPE_TCP_FAST_PATH`
            * :attr:`ALBNetworkProfileUnion.TYPE_UDP_FAST_PATH`
            * :attr:`ALBNetworkProfileUnion.TYPE_UDP_PROXY`
            
            Configure one of either proxy or fast path profiles. Enum options -
            PROTOCOL_TYPE_TCP_PROXY, PROTOCOL_TYPE_TCP_FAST_PATH,
            PROTOCOL_TYPE_UDP_FAST_PATH, PROTOCOL_TYPE_UDP_PROXY. Allowed in
            Basic(Allowed values-
            PROTOCOL_TYPE_TCP_PROXY,PROTOCOL_TYPE_TCP_FAST_PATH,PROTOCOL_TYPE_UDP_FAST_PATH)
            edition, Essentials(Allowed values-
            PROTOCOL_TYPE_TCP_FAST_PATH,PROTOCOL_TYPE_UDP_FAST_PATH) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as PROTOCOL_TYPE_TCP_PROXY.
        :type  udp_fast_path_profile: :class:`ALBUDPFastPathProfile` or ``None``
        :param udp_fast_path_profile: 
        :type  udp_proxy_profile: :class:`ALBUDPProxyProfile` or ``None``
        :param udp_proxy_profile: 
        """
        self.tcp_fast_path_profile = tcp_fast_path_profile
        self.tcp_proxy_profile = tcp_proxy_profile
        self.type = type
        self.udp_fast_path_profile = udp_fast_path_profile
        self.udp_proxy_profile = udp_proxy_profile
        VapiStruct.__init__(self)


ALBNetworkProfileUnion._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_profile_union', {
        'tcp_fast_path_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBTCPFastPathProfile')),
        'tcp_proxy_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBTCPProxyProfile')),
        'type': type.OptionalType(type.StringType()),
        'udp_fast_path_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBUDPFastPathProfile')),
        'udp_proxy_profile': type.OptionalType(type.ReferenceType(__name__, 'ALBUDPProxyProfile')),
    },
    ALBNetworkProfileUnion,
    False,
    None))



class ALBNetworkSecurityMatchTarget(VapiStruct):
    """
    Advanced load balancer NetworkSecurityMatchTarget object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'client_ip': 'client_ip',
                            'microservice': 'microservice',
                            'vs_port': 'vs_port',
                            }

    def __init__(self,
                 client_ip=None,
                 microservice=None,
                 vs_port=None,
                ):
        """
        :type  client_ip: :class:`ALBIpAddrMatch` or ``None``
        :param client_ip: 
        :type  microservice: :class:`ALBMicroServiceMatch` or ``None``
        :param microservice: 
        :type  vs_port: :class:`ALBPortMatch` or ``None``
        :param vs_port: 
        """
        self.client_ip = client_ip
        self.microservice = microservice
        self.vs_port = vs_port
        VapiStruct.__init__(self)


ALBNetworkSecurityMatchTarget._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_security_match_target', {
        'client_ip': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrMatch')),
        'microservice': type.OptionalType(type.ReferenceType(__name__, 'ALBMicroServiceMatch')),
        'vs_port': type.OptionalType(type.ReferenceType(__name__, 'ALBPortMatch')),
    },
    ALBNetworkSecurityMatchTarget,
    False,
    None))



class ALBNetworkSecurityPolicy(VapiStruct):
    """
    Advanced load balancer NetworkSecurityPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'cloud_config_cksum': 'cloud_config_cksum',
                            'created_by': 'created_by',
                            'markers': 'markers',
                            'rules': 'rules',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 cloud_config_cksum=None,
                 created_by=None,
                 markers=None,
                 rules=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cloud_config_cksum: :class:`str` or ``None``
        :param cloud_config_cksum: Checksum of cloud configuration for Network Sec Policy. Internally
            set by cloud connector.
        :type  created_by: :class:`str` or ``None``
        :param created_by: Creator name.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  rules: :class:`list` of :class:`ALBNetworkSecurityRule` or ``None``
        :param rules: Placeholder for description of property rules of obj type
            NetworkSecurityPolicy field type str type array.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.cloud_config_cksum = cloud_config_cksum
        self.created_by = created_by
        self.markers = markers
        self.rules = rules
        VapiStruct.__init__(self)


ALBNetworkSecurityPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_security_policy', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'cloud_config_cksum': type.OptionalType(type.StringType()),
        'created_by': type.OptionalType(type.StringType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'rules': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBNetworkSecurityRule'))),
    },
    ALBNetworkSecurityPolicy,
    False,
    None))



class ALBNetworkSecurityPolicyActionRLParam(VapiStruct):
    """
    Advanced load balancer NetworkSecurityPolicyActionRLParam object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'burst_size': 'burst_size',
                            'max_rate': 'max_rate',
                            }

    def __init__(self,
                 burst_size=None,
                 max_rate=None,
                ):
        """
        :type  burst_size: :class:`long` or ``None``
        :param burst_size: Maximum number of connections or requests or packets to be rate
            limited instantaneously. Default value when not specified in API or
            module is interpreted by ALB Controller as 0. format: int64
        :type  max_rate: :class:`long` or ``None``
        :param max_rate: Maximum number of connections or requests or packets per second.
            Allowed values are 1-4294967295. format: int64
        """
        self.burst_size = burst_size
        self.max_rate = max_rate
        VapiStruct.__init__(self)


ALBNetworkSecurityPolicyActionRLParam._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_security_policy_action_RL_param', {
        'burst_size': type.OptionalType(type.IntegerType()),
        'max_rate': type.OptionalType(type.IntegerType()),
    },
    ALBNetworkSecurityPolicyActionRLParam,
    False,
    None))



class ALBNetworkSecurityPolicyApiResponse(VapiStruct):
    """
    NetworkSecurityPolicyApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBNetworkSecurityPolicy` or ``None``
        :param results: Array of NetworkSecurityPolicy
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBNetworkSecurityPolicyApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_security_policy_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBNetworkSecurityPolicy'))),
    },
    ALBNetworkSecurityPolicyApiResponse,
    False,
    None))



class ALBNetworkSecurityRule(VapiStruct):
    """
    Advanced load balancer NetworkSecurityRule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    ACTION_ALLOW = "NETWORK_SECURITY_POLICY_ACTION_TYPE_ALLOW"
    """


    """
    ACTION_DENY = "NETWORK_SECURITY_POLICY_ACTION_TYPE_DENY"
    """


    """
    ACTION_RATE_LIMIT = "NETWORK_SECURITY_POLICY_ACTION_TYPE_RATE_LIMIT"
    """


    """



    _canonical_to_pep_names = {
                            'action': 'action',
                            'age': 'age',
                            'created_by': 'created_by',
                            'enable': 'enable',
                            'index': 'index',
                            'log': 'log',
                            'match': 'match',
                            'name': 'name',
                            'rl_param': 'rl_param',
                            }

    def __init__(self,
                 action=None,
                 age=None,
                 created_by=None,
                 enable=None,
                 index=None,
                 log=None,
                 match=None,
                 name=None,
                 rl_param=None,
                ):
        """
        :type  action: :class:`str` or ``None``
        :param action: Possible values are: 
            
            * :attr:`ALBNetworkSecurityRule.ACTION_ALLOW`
            * :attr:`ALBNetworkSecurityRule.ACTION_DENY`
            * :attr:`ALBNetworkSecurityRule.ACTION_RATE_LIMIT`
            
            Enum options - NETWORK_SECURITY_POLICY_ACTION_TYPE_ALLOW,
            NETWORK_SECURITY_POLICY_ACTION_TYPE_DENY,
            NETWORK_SECURITY_POLICY_ACTION_TYPE_RATE_LIMIT. Allowed in
            Basic(Allowed values- NETWORK_SECURITY_POLICY_ACTION_TYPE_DENY)
            edition, Essentials(Allowed values-
            NETWORK_SECURITY_POLICY_ACTION_TYPE_DENY) edition, Enterprise
            edition.
        :type  age: :class:`long` or ``None``
        :param age: Time in minutes after which rule will be deleted. Allowed values
            are 1-4294967295. Special values are 0- 'blocked for ever'. Unit is
            MIN. Allowed in Basic(Allowed values- 0) edition,
            Essentials(Allowed values- 0) edition, Enterprise edition. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 0. format: int64
        :type  created_by: :class:`str` or ``None``
        :param created_by: Creator name.
        :type  enable: :class:`bool` or ``None``
        :param enable: Placeholder for description of property enable of obj type
            NetworkSecurityRule field type str type boolean.
        :type  index: :class:`long` or ``None``
        :param index: Number of index. format: int64
        :type  log: :class:`bool` or ``None``
        :param log: Allowed in Basic(Allowed values- false) edition, Essentials(Allowed
            values- false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  match: :class:`ALBNetworkSecurityMatchTarget` or ``None``
        :param match: 
        :type  name: :class:`str` or ``None``
        :param name: Name of the object.
        :type  rl_param: :class:`ALBNetworkSecurityPolicyActionRLParam` or ``None``
        :param rl_param: 
        """
        self.action = action
        self.age = age
        self.created_by = created_by
        self.enable = enable
        self.index = index
        self.log = log
        self.match = match
        self.name = name
        self.rl_param = rl_param
        VapiStruct.__init__(self)


ALBNetworkSecurityRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_network_security_rule', {
        'action': type.OptionalType(type.StringType()),
        'age': type.OptionalType(type.IntegerType()),
        'created_by': type.OptionalType(type.StringType()),
        'enable': type.OptionalType(type.BooleanType()),
        'index': type.OptionalType(type.IntegerType()),
        'log': type.OptionalType(type.BooleanType()),
        'match': type.OptionalType(type.ReferenceType(__name__, 'ALBNetworkSecurityMatchTarget')),
        'name': type.OptionalType(type.StringType()),
        'rl_param': type.OptionalType(type.ReferenceType(__name__, 'ALBNetworkSecurityPolicyActionRLParam')),
    },
    ALBNetworkSecurityRule,
    False,
    None))



class ALBOCSPConfig(VapiStruct):
    """
    Advanced load balancer OCSPConfig object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    URL_ACTION_FAILOVER = "OCSP_RESPONDER_URL_FAILOVER"
    """


    """
    URL_ACTION_OVERRIDE = "OCSP_RESPONDER_URL_OVERRIDE"
    """


    """



    _canonical_to_pep_names = {
                            'failed_ocsp_jobs_retry_interval': 'failed_ocsp_jobs_retry_interval',
                            'max_tries': 'max_tries',
                            'ocsp_req_interval': 'ocsp_req_interval',
                            'ocsp_resp_timeout': 'ocsp_resp_timeout',
                            'responder_url_lists': 'responder_url_lists',
                            'url_action': 'url_action',
                            }

    def __init__(self,
                 failed_ocsp_jobs_retry_interval=None,
                 max_tries=None,
                 ocsp_req_interval=None,
                 ocsp_resp_timeout=None,
                 responder_url_lists=None,
                 url_action=None,
                ):
        """
        :type  failed_ocsp_jobs_retry_interval: :class:`long` or ``None``
        :param failed_ocsp_jobs_retry_interval: Describes the Time Interval after which the next OCSP job needs to
            be scheduled in case of the OCSP job failures. Allowed values are
            60-86400. Unit is SEC. Default value when not specified in API or
            module is interpreted by ALB Controller as 3600. format: int64
        :type  max_tries: :class:`long` or ``None``
        :param max_tries: Maximum number of times the failed OCSP jobs can be scheduled.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 10. format: int64
        :type  ocsp_req_interval: :class:`long` or ``None``
        :param ocsp_req_interval: Interval between the OCSP queries. Allowed values are 60-31536000.
            Unit is SEC. Default value when not specified in API or module is
            interpreted by ALB Controller as 86400. format: int64
        :type  ocsp_resp_timeout: :class:`long` or ``None``
        :param ocsp_resp_timeout: Time in seconds that the system waits for a reply from the OCSP
            responder before dropping the connection. Unit is SEC. format:
            int64
        :type  responder_url_lists: :class:`list` of :class:`str` or ``None``
        :param responder_url_lists: List of Responder URLs configured by user to do failover/override
            the AIA extension contained in the OCSP responder's SSL/TLS
            certificate.
        :type  url_action: :class:`str` or ``None``
        :param url_action: Possible values are: 
            
            * :attr:`ALBOCSPConfig.URL_ACTION_FAILOVER`
            * :attr:`ALBOCSPConfig.URL_ACTION_OVERRIDE`
            
            Describes the type of action to take with the Responder URLs. Enum
            options - OCSP_RESPONDER_URL_FAILOVER, OCSP_RESPONDER_URL_OVERRIDE.
            Default value when not specified in API or module is interpreted by
            ALB Controller as OCSP_RESPONDER_URL_FAILOVER.
        """
        self.failed_ocsp_jobs_retry_interval = failed_ocsp_jobs_retry_interval
        self.max_tries = max_tries
        self.ocsp_req_interval = ocsp_req_interval
        self.ocsp_resp_timeout = ocsp_resp_timeout
        self.responder_url_lists = responder_url_lists
        self.url_action = url_action
        VapiStruct.__init__(self)


ALBOCSPConfig._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBOCSP_config', {
        'failed_ocsp_jobs_retry_interval': type.OptionalType(type.IntegerType()),
        'max_tries': type.OptionalType(type.IntegerType()),
        'ocsp_req_interval': type.OptionalType(type.IntegerType()),
        'ocsp_resp_timeout': type.OptionalType(type.IntegerType()),
        'responder_url_lists': type.OptionalType(type.ListType(type.StringType())),
        'url_action': type.OptionalType(type.StringType()),
    },
    ALBOCSPConfig,
    False,
    None))



class ALBPGDeploymentRule(VapiStruct):
    """
    Advanced load balancer PGDeploymentRule object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    OPERATOR_EQ = "CO_EQ"
    """


    """
    OPERATOR_GT = "CO_GT"
    """


    """
    OPERATOR_GE = "CO_GE"
    """


    """
    OPERATOR_LT = "CO_LT"
    """


    """
    OPERATOR_LE = "CO_LE"
    """


    """
    OPERATOR_NE = "CO_NE"
    """


    """



    _canonical_to_pep_names = {
                            'metric_id': 'metric_id',
                            'operator': 'operator',
                            'threshold': 'threshold',
                            }

    def __init__(self,
                 metric_id=None,
                 operator=None,
                 threshold=None,
                ):
        """
        :type  metric_id: :class:`str` or ``None``
        :param metric_id: metric_id of PGDeploymentRule. Default value when not specified in
            API or module is interpreted by ALB Controller as
            health.health_score_value.
        :type  operator: :class:`str` or ``None``
        :param operator: Possible values are: 
            
            * :attr:`ALBPGDeploymentRule.OPERATOR_EQ`
            * :attr:`ALBPGDeploymentRule.OPERATOR_GT`
            * :attr:`ALBPGDeploymentRule.OPERATOR_GE`
            * :attr:`ALBPGDeploymentRule.OPERATOR_LT`
            * :attr:`ALBPGDeploymentRule.OPERATOR_LE`
            * :attr:`ALBPGDeploymentRule.OPERATOR_NE`
            
            Enum options - CO_EQ, CO_GT, CO_GE, CO_LT, CO_LE, CO_NE. Default
            value when not specified in API or module is interpreted by ALB
            Controller as CO_GE.
        :type  threshold: :class:`float` or ``None``
        :param threshold: metric threshold that is used as the pass fail. If it is not
            provided then it will simply compare it with current pool vs new
            pool.
        """
        self.metric_id = metric_id
        self.operator = operator
        self.threshold = threshold
        VapiStruct.__init__(self)


ALBPGDeploymentRule._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBPG_deployment_rule', {
        'metric_id': type.OptionalType(type.StringType()),
        'operator': type.OptionalType(type.StringType()),
        'threshold': type.OptionalType(type.DoubleType()),
    },
    ALBPGDeploymentRule,
    False,
    None))



class ALBPKIProfile(VapiStruct):
    """
    Advanced load balancer PKIProfile object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'ca_certs': 'ca_certs',
                            'created_by': 'created_by',
                            'crl_check': 'crl_check',
                            'crls': 'crls',
                            'ignore_peer_chain': 'ignore_peer_chain',
                            'is_federated': 'is_federated',
                            'markers': 'markers',
                            'validate_only_leaf_crl': 'validate_only_leaf_crl',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 ca_certs=None,
                 created_by=None,
                 crl_check=None,
                 crls=None,
                 ignore_peer_chain=None,
                 is_federated=None,
                 markers=None,
                 validate_only_leaf_crl=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  ca_certs: :class:`list` of :class:`ALBSSLCertificate` or ``None``
        :param ca_certs: List of Certificate Authorities (Root and Intermediate) trusted
            that is used for certificate validation.
        :type  created_by: :class:`str` or ``None``
        :param created_by: Creator name.
        :type  crl_check: :class:`bool` or ``None``
        :param crl_check: When enabled, Avi will verify via CRL checks that certificates in
            the trust chain have not been revoked. Default value when not
            specified in API or module is interpreted by ALB Controller as
            true.
        :type  crls: :class:`list` of :class:`ALBCRL` or ``None``
        :param crls: Certificate Revocation Lists.
        :type  ignore_peer_chain: :class:`bool` or ``None``
        :param ignore_peer_chain: When enabled, Avi will not trust Intermediate and Root certs
            presented by a client. Instead, only the chain certs configured in
            the Certificate Authority section will be used to verify trust of
            the client's cert. Allowed in Basic(Allowed values- true) edition,
            Essentials(Allowed values- true) edition, Enterprise edition.
            Special default for Basic edition is true, Essentials edition is
            true, Enterprise is False. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  is_federated: :class:`bool` or ``None``
        :param is_federated: This field describes the object's replication scope. If the field
            is set to false, then the object is visible within the
            controller-cluster and its associated service-engines. If the field
            is set to true, then the object is replicated across the
            federation. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  validate_only_leaf_crl: :class:`bool` or ``None``
        :param validate_only_leaf_crl: When enabled, Avi will only validate the revocation status of the
            leaf certificate using CRL. To enable validation for the entire
            chain, disable this option and provide all the relevant CRLs.
            Allowed in Basic(Allowed values- true) edition, Essentials(Allowed
            values- true) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            true.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.ca_certs = ca_certs
        self.created_by = created_by
        self.crl_check = crl_check
        self.crls = crls
        self.ignore_peer_chain = ignore_peer_chain
        self.is_federated = is_federated
        self.markers = markers
        self.validate_only_leaf_crl = validate_only_leaf_crl
        VapiStruct.__init__(self)


ALBPKIProfile._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBPKI_profile', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'ca_certs': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBSSLCertificate'))),
        'created_by': type.OptionalType(type.StringType()),
        'crl_check': type.OptionalType(type.BooleanType()),
        'crls': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBCRL'))),
        'ignore_peer_chain': type.OptionalType(type.BooleanType()),
        'is_federated': type.OptionalType(type.BooleanType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'validate_only_leaf_crl': type.OptionalType(type.BooleanType()),
    },
    ALBPKIProfile,
    False,
    None))



class ALBPKIProfileApiResponse(VapiStruct):
    """
    PKIProfileApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBPKIProfile` or ``None``
        :param results: Array of PKIProfile
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBPKIProfileApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALBPKI_profile_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBPKIProfile'))),
    },
    ALBPKIProfileApiResponse,
    False,
    None))



class ALBPathMatch(VapiStruct):
    """
    Advanced load balancer PathMatch object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    MATCH_CASE_SENSITIVE = "SENSITIVE"
    """


    """
    MATCH_CASE_INSENSITIVE = "INSENSITIVE"
    """


    """
    MATCH_CRITERIA_BEGINS_WITH = "BEGINS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_BEGIN_WITH = "DOES_NOT_BEGIN_WITH"
    """


    """
    MATCH_CRITERIA_CONTAINS = "CONTAINS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_CONTAIN = "DOES_NOT_CONTAIN"
    """


    """
    MATCH_CRITERIA_ENDS_WITH = "ENDS_WITH"
    """


    """
    MATCH_CRITERIA_DOES_NOT_END_WITH = "DOES_NOT_END_WITH"
    """


    """
    MATCH_CRITERIA_EQUALS = "EQUALS"
    """


    """
    MATCH_CRITERIA_DOES_NOT_EQUAL = "DOES_NOT_EQUAL"
    """


    """
    MATCH_CRITERIA_REGEX_MATCH = "REGEX_MATCH"
    """


    """
    MATCH_CRITERIA_REGEX_DOES_NOT_MATCH = "REGEX_DOES_NOT_MATCH"
    """


    """



    _canonical_to_pep_names = {
                            'match_case': 'match_case',
                            'match_criteria': 'match_criteria',
                            'match_str': 'match_str',
                            'string_group_paths': 'string_group_paths',
                            }

    def __init__(self,
                 match_case=None,
                 match_criteria=None,
                 match_str=None,
                 string_group_paths=None,
                ):
        """
        :type  match_case: :class:`str` or ``None``
        :param match_case: Possible values are: 
            
            * :attr:`ALBPathMatch.MATCH_CASE_SENSITIVE`
            * :attr:`ALBPathMatch.MATCH_CASE_INSENSITIVE`
            
            Case sensitivity to use for the matching. Enum options - SENSITIVE,
            INSENSITIVE. Default value when not specified in API or module is
            interpreted by ALB Controller as INSENSITIVE.
        :type  match_criteria: :class:`str` or ``None``
        :param match_criteria: Possible values are: 
            
            * :attr:`ALBPathMatch.MATCH_CRITERIA_BEGINS_WITH`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_DOES_NOT_BEGIN_WITH`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_CONTAINS`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_DOES_NOT_CONTAIN`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_ENDS_WITH`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_DOES_NOT_END_WITH`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_EQUALS`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_DOES_NOT_EQUAL`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_REGEX_MATCH`
            * :attr:`ALBPathMatch.MATCH_CRITERIA_REGEX_DOES_NOT_MATCH`
            
            Criterion to use for matching the path in the HTTP request URI.
            Enum options - BEGINS_WITH, DOES_NOT_BEGIN_WITH, CONTAINS,
            DOES_NOT_CONTAIN, ENDS_WITH, DOES_NOT_END_WITH, EQUALS,
            DOES_NOT_EQUAL, REGEX_MATCH, REGEX_DOES_NOT_MATCH. Allowed in
            Basic(Allowed values-
            BEGINS_WITH,DOES_NOT_BEGIN_WITH,CONTAINS,DOES_NOT_CONTAIN,ENDS_WITH,DOES_NOT_END_WITH,EQUALS,DOES_NOT_EQUAL)
            edition, Essentials(Allowed values-
            BEGINS_WITH,DOES_NOT_BEGIN_WITH,CONTAINS,DOES_NOT_CONTAIN,ENDS_WITH,DOES_NOT_END_WITH,EQUALS,DOES_NOT_EQUAL)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as CONTAINS.
        :type  match_str: :class:`list` of :class:`str` or ``None``
        :param match_str: String values.
        :type  string_group_paths: :class:`list` of :class:`str` or ``None``
        :param string_group_paths: path of the string group(s). It is a reference to an object of type
            StringGroup.
        """
        self.match_case = match_case
        self.match_criteria = match_criteria
        self.match_str = match_str
        self.string_group_paths = string_group_paths
        VapiStruct.__init__(self)


ALBPathMatch._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_path_match', {
        'match_case': type.OptionalType(type.StringType()),
        'match_criteria': type.OptionalType(type.StringType()),
        'match_str': type.OptionalType(type.ListType(type.StringType())),
        'string_group_paths': type.OptionalType(type.ListType(type.StringType())),
    },
    ALBPathMatch,
    False,
    None))



class ALBPerformanceLimits(VapiStruct):
    """
    Advanced load balancer PerformanceLimits object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'max_concurrent_connections': 'max_concurrent_connections',
                            'max_throughput': 'max_throughput',
                            }

    def __init__(self,
                 max_concurrent_connections=None,
                 max_throughput=None,
                ):
        """
        :type  max_concurrent_connections: :class:`long` or ``None``
        :param max_concurrent_connections: The maximum number of concurrent client conections allowed to the
            Virtual Service. format: int64
        :type  max_throughput: :class:`long` or ``None``
        :param max_throughput: The maximum throughput per second for all clients allowed through
            the client side of the Virtual Service. format: int64
        """
        self.max_concurrent_connections = max_concurrent_connections
        self.max_throughput = max_throughput
        VapiStruct.__init__(self)


ALBPerformanceLimits._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_performance_limits', {
        'max_concurrent_connections': type.OptionalType(type.IntegerType()),
        'max_throughput': type.OptionalType(type.IntegerType()),
    },
    ALBPerformanceLimits,
    False,
    None))



class ALBPlacementNetwork(VapiStruct):
    """
    Advanced load balancer PlacementNetwork object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'network_name': 'network_name',
                            'subnet': 'subnet',
                            }

    def __init__(self,
                 network_name=None,
                 subnet=None,
                ):
        """
        :type  network_name: :class:`str` or ``None``
        :param network_name: It is a reference to an object of type Network.
        :type  subnet: :class:`ALBIpAddrPrefix` or ``None``
        :param subnet: 
        """
        self.network_name = network_name
        self.subnet = subnet
        VapiStruct.__init__(self)


ALBPlacementNetwork._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_placement_network', {
        'network_name': type.OptionalType(type.StringType()),
        'subnet': type.OptionalType(type.ReferenceType(__name__, 'ALBIpAddrPrefix')),
    },
    ALBPlacementNetwork,
    False,
    None))



class ALBPool(VapiStruct):
    """
    Advanced load balancer Pool object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    LB_ALGORITHM_LEAST_CONNECTIONS = "LB_ALGORITHM_LEAST_CONNECTIONS"
    """


    """
    LB_ALGORITHM_ROUND_ROBIN = "LB_ALGORITHM_ROUND_ROBIN"
    """


    """
    LB_ALGORITHM_FASTEST_RESPONSE = "LB_ALGORITHM_FASTEST_RESPONSE"
    """


    """
    LB_ALGORITHM_CONSISTENT_HASH = "LB_ALGORITHM_CONSISTENT_HASH"
    """


    """
    LB_ALGORITHM_LEAST_LOAD = "LB_ALGORITHM_LEAST_LOAD"
    """


    """
    LB_ALGORITHM_FEWEST_SERVERS = "LB_ALGORITHM_FEWEST_SERVERS"
    """


    """
    LB_ALGORITHM_RANDOM = "LB_ALGORITHM_RANDOM"
    """


    """
    LB_ALGORITHM_FEWEST_TASKS = "LB_ALGORITHM_FEWEST_TASKS"
    """


    """
    LB_ALGORITHM_NEAREST_SERVER = "LB_ALGORITHM_NEAREST_SERVER"
    """


    """
    LB_ALGORITHM_CORE_AFFINITY = "LB_ALGORITHM_CORE_AFFINITY"
    """


    """
    LB_ALGORITHM_TOPOLOGY = "LB_ALGORITHM_TOPOLOGY"
    """


    """
    LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS = "LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS"
    """


    """
    LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS_AND_PORT = "LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS_AND_PORT"
    """


    """
    LB_ALGORITHM_HASH_URI = "LB_ALGORITHM_CONSISTENT_HASH_URI"
    """


    """
    LB_ALGORITHM_HASH_CUSTOM_HEADER = "LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_HEADER"
    """


    """
    LB_ALGORITHM_HASH_CUSTOM_STRING = "LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_STRING"
    """


    """
    LB_ALGORITHM_HASH_CALLID = "LB_ALGORITHM_CONSISTENT_HASH_CALLID"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'analytics_policy': 'analytics_policy',
                            'analytics_profile_path': 'analytics_profile_path',
                            'apic_epg_name': 'apic_epg_name',
                            'application_persistence_profile_path': 'application_persistence_profile_path',
                            'autoscale_launch_config_path': 'autoscale_launch_config_path',
                            'autoscale_networks': 'autoscale_networks',
                            'autoscale_policy_path': 'autoscale_policy_path',
                            'capacity_estimation': 'capacity_estimation',
                            'capacity_estimation_ttfb_thresh': 'capacity_estimation_ttfb_thresh',
                            'cloud_config_cksum': 'cloud_config_cksum',
                            'cloud_name': 'cloud_name',
                            'conn_pool_properties': 'conn_pool_properties',
                            'connection_ramp_duration': 'connection_ramp_duration',
                            'created_by': 'created_by',
                            'default_server_port': 'default_server_port',
                            'delete_server_on_dns_refresh': 'delete_server_on_dns_refresh',
                            'domain_name': 'domain_name',
                            'east_west': 'east_west',
                            'enable_http2': 'enable_http2',
                            'enabled': 'enabled',
                            'external_autoscale_groups': 'external_autoscale_groups',
                            'fail_action': 'fail_action',
                            'fewest_tasks_feedback_delay': 'fewest_tasks_feedback_delay',
                            'graceful_disable_timeout': 'graceful_disable_timeout',
                            'group_paths': 'group_paths',
                            'gslb_sp_enabled': 'gslb_sp_enabled',
                            'health_monitor_paths': 'health_monitor_paths',
                            'host_check_enabled': 'host_check_enabled',
                            'ignore_server_port': 'ignore_server_port',
                            'inline_health_monitor': 'inline_health_monitor',
                            'ipaddrgroup_path': 'ipaddrgroup_path',
                            'lb_algorithm': 'lb_algorithm',
                            'lb_algorithm_consistent_hash_hdr': 'lb_algorithm_consistent_hash_hdr',
                            'lb_algorithm_core_nonaffinity': 'lb_algorithm_core_nonaffinity',
                            'lb_algorithm_hash': 'lb_algorithm_hash',
                            'lookup_server_by_name': 'lookup_server_by_name',
                            'markers': 'markers',
                            'max_concurrent_connections_per_server': 'max_concurrent_connections_per_server',
                            'max_conn_rate_per_server': 'max_conn_rate_per_server',
                            'min_health_monitors_up': 'min_health_monitors_up',
                            'min_servers_up': 'min_servers_up',
                            'networks': 'networks',
                            'pki_profile_path': 'pki_profile_path',
                            'placement_networks': 'placement_networks',
                            'request_queue_depth': 'request_queue_depth',
                            'request_queue_enabled': 'request_queue_enabled',
                            'rewrite_host_header_to_server_name': 'rewrite_host_header_to_server_name',
                            'rewrite_host_header_to_sni': 'rewrite_host_header_to_sni',
                            'routing_pool': 'routing_pool',
                            'server_name': 'server_name',
                            'server_reselect': 'server_reselect',
                            'server_timeout': 'server_timeout',
                            'servers': 'servers',
                            'service_metadata': 'service_metadata',
                            'sni_enabled': 'sni_enabled',
                            'ssl_key_and_certificate_path': 'ssl_key_and_certificate_path',
                            'ssl_profile_path': 'ssl_profile_path',
                            'tier1_path': 'tier1_path',
                            'use_service_port': 'use_service_port',
                            'vrf_name': 'vrf_name',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 analytics_policy=None,
                 analytics_profile_path=None,
                 apic_epg_name=None,
                 application_persistence_profile_path=None,
                 autoscale_launch_config_path=None,
                 autoscale_networks=None,
                 autoscale_policy_path=None,
                 capacity_estimation=None,
                 capacity_estimation_ttfb_thresh=None,
                 cloud_config_cksum=None,
                 cloud_name=None,
                 conn_pool_properties=None,
                 connection_ramp_duration=None,
                 created_by=None,
                 default_server_port=None,
                 delete_server_on_dns_refresh=None,
                 domain_name=None,
                 east_west=None,
                 enable_http2=None,
                 enabled=None,
                 external_autoscale_groups=None,
                 fail_action=None,
                 fewest_tasks_feedback_delay=None,
                 graceful_disable_timeout=None,
                 group_paths=None,
                 gslb_sp_enabled=None,
                 health_monitor_paths=None,
                 host_check_enabled=None,
                 ignore_server_port=None,
                 inline_health_monitor=None,
                 ipaddrgroup_path=None,
                 lb_algorithm=None,
                 lb_algorithm_consistent_hash_hdr=None,
                 lb_algorithm_core_nonaffinity=None,
                 lb_algorithm_hash=None,
                 lookup_server_by_name=None,
                 markers=None,
                 max_concurrent_connections_per_server=None,
                 max_conn_rate_per_server=None,
                 min_health_monitors_up=None,
                 min_servers_up=None,
                 networks=None,
                 pki_profile_path=None,
                 placement_networks=None,
                 request_queue_depth=None,
                 request_queue_enabled=None,
                 rewrite_host_header_to_server_name=None,
                 rewrite_host_header_to_sni=None,
                 routing_pool=None,
                 server_name=None,
                 server_reselect=None,
                 server_timeout=None,
                 servers=None,
                 service_metadata=None,
                 sni_enabled=None,
                 ssl_key_and_certificate_path=None,
                 ssl_profile_path=None,
                 tier1_path=None,
                 use_service_port=None,
                 vrf_name=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  analytics_policy: :class:`ALBPoolAnalyticsPolicy` or ``None``
        :param analytics_policy: 
        :type  analytics_profile_path: :class:`str` or ``None``
        :param analytics_profile_path: Specifies settings related to analytics. It is a reference to an
            object of type AnalyticsProfile.
        :type  apic_epg_name: :class:`str` or ``None``
        :param apic_epg_name: Synchronize Cisco APIC EPG members with pool servers.
        :type  application_persistence_profile_path: :class:`str` or ``None``
        :param application_persistence_profile_path: Persistence will ensure the same user sticks to the same server for
            a desired duration of time. It is a reference to an object of type
            ApplicationPersistenceProfile.
        :type  autoscale_launch_config_path: :class:`str` or ``None``
        :param autoscale_launch_config_path: If configured then Avi will trigger orchestration of pool server
            creation and deletion. It is a reference to an object of type
            AutoScaleLaunchConfig.
        :type  autoscale_networks: :class:`list` of :class:`str` or ``None``
        :param autoscale_networks: Network Ids for the launch configuration.
        :type  autoscale_policy_path: :class:`str` or ``None``
        :param autoscale_policy_path: Reference to Server Autoscale Policy. It is a reference to an
            object of type ServerAutoScalePolicy.
        :type  capacity_estimation: :class:`bool` or ``None``
        :param capacity_estimation: Inline estimation of capacity of servers. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  capacity_estimation_ttfb_thresh: :class:`long` or ``None``
        :param capacity_estimation_ttfb_thresh: The maximum time-to-first-byte of a server. Allowed values are
            1-5000. Special values are 0 - 'Automatic'. Unit is MILLISECONDS.
            Allowed in Basic(Allowed values- 0) edition, Essentials(Allowed
            values- 0) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as 0.
            format: int64
        :type  cloud_config_cksum: :class:`str` or ``None``
        :param cloud_config_cksum: Checksum of cloud configuration for Pool. Internally set by cloud
            connector.
        :type  cloud_name: :class:`str` or ``None``
        :param cloud_name: It is a reference to an object of type Cloud.
        :type  conn_pool_properties: :class:`ALBConnPoolProperties` or ``None``
        :param conn_pool_properties: 
        :type  connection_ramp_duration: :class:`long` or ``None``
        :param connection_ramp_duration: Duration for which new connections will be gradually ramped up to a
            server recently brought online. Useful for LB algorithms that are
            least connection based. Allowed values are 1-300. Special values
            are 0 - 'Immediate'. Unit is MIN. Allowed in Basic(Allowed values-
            0) edition, Essentials(Allowed values- 0) edition, Enterprise
            edition. Special default for Basic edition is 0, Essentials edition
            is 0, Enterprise is 10. Default value when not specified in API or
            module is interpreted by ALB Controller as 0. format: int64
        :type  created_by: :class:`str` or ``None``
        :param created_by: Creator name.
        :type  default_server_port: :class:`long` or ``None``
        :param default_server_port: Traffic sent to servers will use this destination server port
            unless overridden by the server's specific port attribute. The SSL
            checkbox enables Avi to server encryption. Allowed values are
            1-65535. Default value when not specified in API or module is
            interpreted by ALB Controller as 80. format: int64
        :type  delete_server_on_dns_refresh: :class:`bool` or ``None``
        :param delete_server_on_dns_refresh: Indicates whether existing IPs are disabled(false) or deleted(true)
            on dns hostname refreshDetail -- On a dns refresh, some IPs set on
            pool may no longer be returned by the resolver. These IPs are
            deleted from the pool when this knob is set to true. They are
            disabled, if the knob is set to false. Allowed in Basic(Allowed
            values- true) edition, Essentials(Allowed values- true) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as true.
        :type  domain_name: :class:`list` of :class:`str` or ``None``
        :param domain_name: Comma separated list of domain names which will be used to verify
            the common names or subject alternative names presented by server
            certificates. It is performed only when common name check
            host_check_enabled is enabled.
        :type  east_west: :class:`bool` or ``None``
        :param east_west: Inherited config from VirtualService.
        :type  enable_http2: :class:`bool` or ``None``
        :param enable_http2: Enable HTTP/2 for traffic from VirtualService to all backend
            servers in this pool. Allowed in Basic(Allowed values- false)
            edition, Essentials(Allowed values- false) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as false.
        :type  enabled: :class:`bool` or ``None``
        :param enabled: Enable or disable the pool. Disabling will terminate all open
            connections and pause health monitors. Default value when not
            specified in API or module is interpreted by ALB Controller as
            true.
        :type  external_autoscale_groups: :class:`list` of :class:`str` or ``None``
        :param external_autoscale_groups: Names of external auto-scale groups for pool servers. Currently
            available only for AWS and Azure.
        :type  fail_action: :class:`ALBFailAction` or ``None``
        :param fail_action: 
        :type  fewest_tasks_feedback_delay: :class:`long` or ``None``
        :param fewest_tasks_feedback_delay: Periodicity of feedback for fewest tasks server selection
            algorithm. Allowed values are 1-300. Unit is SEC. Default value
            when not specified in API or module is interpreted by ALB
            Controller as 10. format: int64
        :type  graceful_disable_timeout: :class:`long` or ``None``
        :param graceful_disable_timeout: Used to gracefully disable a server. Virtual service waits for the
            specified time before terminating the existing connections to the
            servers that are disabled. Allowed values are 1-7200. Special
            values are 0 - 'Immediate', -1 - 'Infinite'. Unit is MIN. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 1. format: int64
        :type  group_paths: :class:`list` of :class:`str` or ``None``
        :param group_paths: A list of NSX Groups where the Servers for the Pool are created .
        :type  gslb_sp_enabled: :class:`bool` or ``None``
        :param gslb_sp_enabled: Indicates if the pool is a site-persistence pool. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  health_monitor_paths: :class:`list` of :class:`str` or ``None``
        :param health_monitor_paths: Verify server health by applying one or more health monitors.
            Active monitors generate synthetic traffic from each Service Engine
            and mark a server up or down based on the response. The Passive
            monitor listens only to client to server communication. It raises
            or lowers the ratio of traffic destined to a server based on
            successful responses. It is a reference to an object of type
            HealthMonitor. Maximum of 50 items allowed.
        :type  host_check_enabled: :class:`bool` or ``None``
        :param host_check_enabled: Enable common name check for server certificate. If enabled and no
            explicit domain name is specified, Avi will use the incoming host
            header to do the match. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  ignore_server_port: :class:`bool` or ``None``
        :param ignore_server_port: Ignore the server port in building the load balancing
            state.Applicable only for consistent hash load balancing algorithm
            or Disable Port translation (use_service_port) use cases. Default
            value when not specified in API or module is interpreted by ALB
            Controller as false.
        :type  inline_health_monitor: :class:`bool` or ``None``
        :param inline_health_monitor: The Passive monitor will monitor client to server connections and
            requests and adjust traffic load to servers based on successful
            responses. This may alter the expected behavior of the LB method,
            such as Round Robin. Default value when not specified in API or
            module is interpreted by ALB Controller as true.
        :type  ipaddrgroup_path: :class:`str` or ``None``
        :param ipaddrgroup_path: Use list of servers from Ip Address Group. It is a reference to an
            object of type IpAddrGroup.
        :type  lb_algorithm: :class:`str` or ``None``
        :param lb_algorithm: Possible values are: 
            
            * :attr:`ALBPool.LB_ALGORITHM_LEAST_CONNECTIONS`
            * :attr:`ALBPool.LB_ALGORITHM_ROUND_ROBIN`
            * :attr:`ALBPool.LB_ALGORITHM_FASTEST_RESPONSE`
            * :attr:`ALBPool.LB_ALGORITHM_CONSISTENT_HASH`
            * :attr:`ALBPool.LB_ALGORITHM_LEAST_LOAD`
            * :attr:`ALBPool.LB_ALGORITHM_FEWEST_SERVERS`
            * :attr:`ALBPool.LB_ALGORITHM_RANDOM`
            * :attr:`ALBPool.LB_ALGORITHM_FEWEST_TASKS`
            * :attr:`ALBPool.LB_ALGORITHM_NEAREST_SERVER`
            * :attr:`ALBPool.LB_ALGORITHM_CORE_AFFINITY`
            * :attr:`ALBPool.LB_ALGORITHM_TOPOLOGY`
            
            The load balancing algorithm will pick a server within the pool's
            list of available servers. Values LB_ALGORITHM_NEAREST_SERVER and
            LB_ALGORITHM_TOPOLOGY are only allowed for GSLB pool. Enum options
            - LB_ALGORITHM_LEAST_CONNECTIONS, LB_ALGORITHM_ROUND_ROBIN,
            LB_ALGORITHM_FASTEST_RESPONSE, LB_ALGORITHM_CONSISTENT_HASH,
            LB_ALGORITHM_LEAST_LOAD, LB_ALGORITHM_FEWEST_SERVERS,
            LB_ALGORITHM_RANDOM, LB_ALGORITHM_FEWEST_TASKS,
            LB_ALGORITHM_NEAREST_SERVER, LB_ALGORITHM_CORE_AFFINITY,
            LB_ALGORITHM_TOPOLOGY. Allowed in Basic(Allowed values-
            LB_ALGORITHM_LEAST_CONNECTIONS,LB_ALGORITHM_ROUND_ROBIN,LB_ALGORITHM_CONSISTENT_HASH)
            edition, Essentials(Allowed values-
            LB_ALGORITHM_LEAST_CONNECTIONS,LB_ALGORITHM_ROUND_ROBIN,LB_ALGORITHM_CONSISTENT_HASH)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as
            LB_ALGORITHM_LEAST_CONNECTIONS.
        :type  lb_algorithm_consistent_hash_hdr: :class:`str` or ``None``
        :param lb_algorithm_consistent_hash_hdr: HTTP header name to be used for the hash key.
        :type  lb_algorithm_core_nonaffinity: :class:`long` or ``None``
        :param lb_algorithm_core_nonaffinity: Degree of non-affinity for core affinity based server selection.
            Allowed values are 1-65535. Allowed in Basic(Allowed values- 2)
            edition, Essentials(Allowed values- 2) edition, Enterprise edition.
            Default value when not specified in API or module is interpreted by
            ALB Controller as 2. format: int64
        :type  lb_algorithm_hash: :class:`str` or ``None``
        :param lb_algorithm_hash: Possible values are: 
            
            * :attr:`ALBPool.LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS`
            * :attr:`ALBPool.LB_ALGORITHM_HASH_SOURCE_IP_ADDRESS_AND_PORT`
            * :attr:`ALBPool.LB_ALGORITHM_HASH_URI`
            * :attr:`ALBPool.LB_ALGORITHM_HASH_CUSTOM_HEADER`
            * :attr:`ALBPool.LB_ALGORITHM_HASH_CUSTOM_STRING`
            * :attr:`ALBPool.LB_ALGORITHM_HASH_CALLID`
            
            Criteria used as a key for determining the hash between the client
            and server. Enum options -
            LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS,
            LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS_AND_PORT,
            LB_ALGORITHM_CONSISTENT_HASH_URI,
            LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_HEADER,
            LB_ALGORITHM_CONSISTENT_HASH_CUSTOM_STRING,
            LB_ALGORITHM_CONSISTENT_HASH_CALLID. Allowed in Basic(Allowed
            values- LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS) edition,
            Essentials(Allowed values-
            LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS) edition, Enterprise
            edition. Default value when not specified in API or module is
            interpreted by ALB Controller as
            LB_ALGORITHM_CONSISTENT_HASH_SOURCE_IP_ADDRESS.
        :type  lookup_server_by_name: :class:`bool` or ``None``
        :param lookup_server_by_name: Allow server lookup by name. Allowed in Basic(Allowed values-
            false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  max_concurrent_connections_per_server: :class:`long` or ``None``
        :param max_concurrent_connections_per_server: The maximum number of concurrent connections allowed to each server
            within the pool. NOTE applied value will be no less than the number
            of service engines that the pool is placed on. If set to 0, no
            limit is applied. Default value when not specified in API or module
            is interpreted by ALB Controller as 0. format: int64
        :type  max_conn_rate_per_server: :class:`ALBRateProfile` or ``None``
        :param max_conn_rate_per_server: 
        :type  min_health_monitors_up: :class:`long` or ``None``
        :param min_health_monitors_up: Minimum number of health monitors in UP state to mark server UP.
            Allowed in Basic edition, Essentials edition, Enterprise edition.
            format: int64
        :type  min_servers_up: :class:`long` or ``None``
        :param min_servers_up: Minimum number of servers in UP state for marking the pool UP.
            format: int64
        :type  networks: :class:`list` of :class:`ALBNetworkFilter` or ``None``
        :param networks: (internal-use) Networks designated as containing servers for this
            pool. The servers may be further narrowed down by a filter. This
            field is used internally by Avi, not editable by the user.
        :type  pki_profile_path: :class:`str` or ``None``
        :param pki_profile_path: Avi will validate the SSL certificate present by a server against
            the selected PKI Profile. It is a reference to an object of type
            PKIProfile.
        :type  placement_networks: :class:`list` of :class:`ALBPlacementNetwork` or ``None``
        :param placement_networks: Manually select the networks and subnets used to provide
            reachability to the pool's servers. Specify the Subnet using the
            following syntax 10-1-1-0/24. Use static routes in VRF
            configuration when pool servers are not directly connected but
            routable from the service engine.
        :type  request_queue_depth: :class:`long` or ``None``
        :param request_queue_depth: Minimum number of requests to be queued when pool is full. Allowed
            in Basic(Allowed values- 128) edition, Essentials(Allowed values-
            128) edition, Enterprise edition. Default value when not specified
            in API or module is interpreted by ALB Controller as 128. format:
            int64
        :type  request_queue_enabled: :class:`bool` or ``None``
        :param request_queue_enabled: Enable request queue when pool is full. Allowed in Basic(Allowed
            values- false) edition, Essentials(Allowed values- false) edition,
            Enterprise edition. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  rewrite_host_header_to_server_name: :class:`bool` or ``None``
        :param rewrite_host_header_to_server_name: Rewrite incoming Host Header to server name of the server to which
            the request is proxied. Enabling this feature rewrites Host Header
            for requests to all servers in the pool. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  rewrite_host_header_to_sni: :class:`bool` or ``None``
        :param rewrite_host_header_to_sni: If SNI server name is specified, rewrite incoming host header to
            the SNI server name. Default value when not specified in API or
            module is interpreted by ALB Controller as false.
        :type  routing_pool: :class:`bool` or ``None``
        :param routing_pool: Enable to do routing when this pool is selected to send traffic. No
            servers present in routing pool. Default value when not specified
            in API or module is interpreted by ALB Controller as false.
        :type  server_name: :class:`str` or ``None``
        :param server_name: Fully qualified DNS hostname which will be used in the TLS SNI
            extension in server connections if SNI is enabled. If no value is
            specified, Avi will use the incoming host header instead.
        :type  server_reselect: :class:`ALBHTTPServerReselect` or ``None``
        :param server_reselect: 
        :type  server_timeout: :class:`long` or ``None``
        :param server_timeout: Server timeout value specifies the time within which a server
            connection needs to be established and a request-response exchange
            completes between AVI and the server. Value of 0 results in using
            default timeout of 60 minutes. Allowed values are 0-21600000. Unit
            is MILLISECONDS. Default value when not specified in API or module
            is interpreted by ALB Controller as 0. format: int64
        :type  servers: :class:`list` of :class:`ALBServer` or ``None``
        :param servers: The pool directs load balanced traffic to this list of destination
            servers. The servers can be configured by IP address, name, network
            or via IP Address Group. Maximum of 5000 items allowed.
        :type  service_metadata: :class:`str` or ``None``
        :param service_metadata: Metadata pertaining to the service provided by this Pool. In
            Openshift/Kubernetes environments, app metadata info is stored. Any
            user input to this field will be overwritten by Avi Vantage.
        :type  sni_enabled: :class:`bool` or ``None``
        :param sni_enabled: Enable TLS SNI for server connections. If disabled, Avi will not
            send the SNI extension as part of the handshake. Default value when
            not specified in API or module is interpreted by ALB Controller as
            true.
        :type  ssl_key_and_certificate_path: :class:`str` or ``None``
        :param ssl_key_and_certificate_path: Service Engines will present a client SSL certificate to the
            server. It is a reference to an object of type
            SSLKeyAndCertificate.
        :type  ssl_profile_path: :class:`str` or ``None``
        :param ssl_profile_path: When enabled, Avi re-encrypts traffic to the backend servers. The
            specific SSL profile defines which ciphers and SSL versions will be
            supported. It is a reference to an object of type SSLProfile.
        :type  tier1_path: :class:`str` or ``None``
        :param tier1_path: This tier1_lr field should be set same as VirtualService associated
            for NSX-T.
        :type  use_service_port: :class:`bool` or ``None``
        :param use_service_port: Do not translate the client's destination port when sending the
            connection to the server. The pool or servers specified service
            port will still be used for health monitoring. Allowed in
            Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  vrf_name: :class:`str` or ``None``
        :param vrf_name: Virtual Routing Context that the pool is bound to. This is used to
            provide the isolation of the set of networks the pool is attached
            to. The pool inherits the Virtual Routing Conext of the Virtual
            Service, and this field is used only internally, and is set by
            pb-transform. It is a reference to an object of type VrfContext.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.analytics_policy = analytics_policy
        self.analytics_profile_path = analytics_profile_path
        self.apic_epg_name = apic_epg_name
        self.application_persistence_profile_path = application_persistence_profile_path
        self.autoscale_launch_config_path = autoscale_launch_config_path
        self.autoscale_networks = autoscale_networks
        self.autoscale_policy_path = autoscale_policy_path
        self.capacity_estimation = capacity_estimation
        self.capacity_estimation_ttfb_thresh = capacity_estimation_ttfb_thresh
        self.cloud_config_cksum = cloud_config_cksum
        self.cloud_name = cloud_name
        self.conn_pool_properties = conn_pool_properties
        self.connection_ramp_duration = connection_ramp_duration
        self.created_by = created_by
        self.default_server_port = default_server_port
        self.delete_server_on_dns_refresh = delete_server_on_dns_refresh
        self.domain_name = domain_name
        self.east_west = east_west
        self.enable_http2 = enable_http2
        self.enabled = enabled
        self.external_autoscale_groups = external_autoscale_groups
        self.fail_action = fail_action
        self.fewest_tasks_feedback_delay = fewest_tasks_feedback_delay
        self.graceful_disable_timeout = graceful_disable_timeout
        self.group_paths = group_paths
        self.gslb_sp_enabled = gslb_sp_enabled
        self.health_monitor_paths = health_monitor_paths
        self.host_check_enabled = host_check_enabled
        self.ignore_server_port = ignore_server_port
        self.inline_health_monitor = inline_health_monitor
        self.ipaddrgroup_path = ipaddrgroup_path
        self.lb_algorithm = lb_algorithm
        self.lb_algorithm_consistent_hash_hdr = lb_algorithm_consistent_hash_hdr
        self.lb_algorithm_core_nonaffinity = lb_algorithm_core_nonaffinity
        self.lb_algorithm_hash = lb_algorithm_hash
        self.lookup_server_by_name = lookup_server_by_name
        self.markers = markers
        self.max_concurrent_connections_per_server = max_concurrent_connections_per_server
        self.max_conn_rate_per_server = max_conn_rate_per_server
        self.min_health_monitors_up = min_health_monitors_up
        self.min_servers_up = min_servers_up
        self.networks = networks
        self.pki_profile_path = pki_profile_path
        self.placement_networks = placement_networks
        self.request_queue_depth = request_queue_depth
        self.request_queue_enabled = request_queue_enabled
        self.rewrite_host_header_to_server_name = rewrite_host_header_to_server_name
        self.rewrite_host_header_to_sni = rewrite_host_header_to_sni
        self.routing_pool = routing_pool
        self.server_name = server_name
        self.server_reselect = server_reselect
        self.server_timeout = server_timeout
        self.servers = servers
        self.service_metadata = service_metadata
        self.sni_enabled = sni_enabled
        self.ssl_key_and_certificate_path = ssl_key_and_certificate_path
        self.ssl_profile_path = ssl_profile_path
        self.tier1_path = tier1_path
        self.use_service_port = use_service_port
        self.vrf_name = vrf_name
        VapiStruct.__init__(self)


ALBPool._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_pool', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'analytics_policy': type.OptionalType(type.ReferenceType(__name__, 'ALBPoolAnalyticsPolicy')),
        'analytics_profile_path': type.OptionalType(type.StringType()),
        'apic_epg_name': type.OptionalType(type.StringType()),
        'application_persistence_profile_path': type.OptionalType(type.StringType()),
        'autoscale_launch_config_path': type.OptionalType(type.StringType()),
        'autoscale_networks': type.OptionalType(type.ListType(type.StringType())),
        'autoscale_policy_path': type.OptionalType(type.StringType()),
        'capacity_estimation': type.OptionalType(type.BooleanType()),
        'capacity_estimation_ttfb_thresh': type.OptionalType(type.IntegerType()),
        'cloud_config_cksum': type.OptionalType(type.StringType()),
        'cloud_name': type.OptionalType(type.StringType()),
        'conn_pool_properties': type.OptionalType(type.ReferenceType(__name__, 'ALBConnPoolProperties')),
        'connection_ramp_duration': type.OptionalType(type.IntegerType()),
        'created_by': type.OptionalType(type.StringType()),
        'default_server_port': type.OptionalType(type.IntegerType()),
        'delete_server_on_dns_refresh': type.OptionalType(type.BooleanType()),
        'domain_name': type.OptionalType(type.ListType(type.StringType())),
        'east_west': type.OptionalType(type.BooleanType()),
        'enable_http2': type.OptionalType(type.BooleanType()),
        'enabled': type.OptionalType(type.BooleanType()),
        'external_autoscale_groups': type.OptionalType(type.ListType(type.StringType())),
        'fail_action': type.OptionalType(type.ReferenceType(__name__, 'ALBFailAction')),
        'fewest_tasks_feedback_delay': type.OptionalType(type.IntegerType()),
        'graceful_disable_timeout': type.OptionalType(type.IntegerType()),
        'group_paths': type.OptionalType(type.ListType(type.StringType())),
        'gslb_sp_enabled': type.OptionalType(type.BooleanType()),
        'health_monitor_paths': type.OptionalType(type.ListType(type.StringType())),
        'host_check_enabled': type.OptionalType(type.BooleanType()),
        'ignore_server_port': type.OptionalType(type.BooleanType()),
        'inline_health_monitor': type.OptionalType(type.BooleanType()),
        'ipaddrgroup_path': type.OptionalType(type.StringType()),
        'lb_algorithm': type.OptionalType(type.StringType()),
        'lb_algorithm_consistent_hash_hdr': type.OptionalType(type.StringType()),
        'lb_algorithm_core_nonaffinity': type.OptionalType(type.IntegerType()),
        'lb_algorithm_hash': type.OptionalType(type.StringType()),
        'lookup_server_by_name': type.OptionalType(type.BooleanType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'max_concurrent_connections_per_server': type.OptionalType(type.IntegerType()),
        'max_conn_rate_per_server': type.OptionalType(type.ReferenceType(__name__, 'ALBRateProfile')),
        'min_health_monitors_up': type.OptionalType(type.IntegerType()),
        'min_servers_up': type.OptionalType(type.IntegerType()),
        'networks': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBNetworkFilter'))),
        'pki_profile_path': type.OptionalType(type.StringType()),
        'placement_networks': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBPlacementNetwork'))),
        'request_queue_depth': type.OptionalType(type.IntegerType()),
        'request_queue_enabled': type.OptionalType(type.BooleanType()),
        'rewrite_host_header_to_server_name': type.OptionalType(type.BooleanType()),
        'rewrite_host_header_to_sni': type.OptionalType(type.BooleanType()),
        'routing_pool': type.OptionalType(type.BooleanType()),
        'server_name': type.OptionalType(type.StringType()),
        'server_reselect': type.OptionalType(type.ReferenceType(__name__, 'ALBHTTPServerReselect')),
        'server_timeout': type.OptionalType(type.IntegerType()),
        'servers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBServer'))),
        'service_metadata': type.OptionalType(type.StringType()),
        'sni_enabled': type.OptionalType(type.BooleanType()),
        'ssl_key_and_certificate_path': type.OptionalType(type.StringType()),
        'ssl_profile_path': type.OptionalType(type.StringType()),
        'tier1_path': type.OptionalType(type.StringType()),
        'use_service_port': type.OptionalType(type.BooleanType()),
        'vrf_name': type.OptionalType(type.StringType()),
    },
    ALBPool,
    False,
    None))



class ALBPoolAnalyticsPolicy(VapiStruct):
    """
    Advanced load balancer PoolAnalyticsPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            'enable_realtime_metrics': 'enable_realtime_metrics',
                            }

    def __init__(self,
                 enable_realtime_metrics=None,
                ):
        """
        :type  enable_realtime_metrics: :class:`bool` or ``None``
        :param enable_realtime_metrics: Enable real time metrics for server and pool metrics eg.
            l4_server.xxx, l7_server.xxx. Default value when not specified in
            API or module is interpreted by ALB Controller as false.
        """
        self.enable_realtime_metrics = enable_realtime_metrics
        VapiStruct.__init__(self)


ALBPoolAnalyticsPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_pool_analytics_policy', {
        'enable_realtime_metrics': type.OptionalType(type.BooleanType()),
    },
    ALBPoolAnalyticsPolicy,
    False,
    None))



class ALBPoolApiResponse(VapiStruct):
    """
    PoolApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBPool` or ``None``
        :param results: Array of Pool
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBPoolApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_pool_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBPool'))),
    },
    ALBPoolApiResponse,
    False,
    None))



class ALBPoolGroup(VapiStruct):
    """
    Advanced load balancer PoolGroup object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'cloud_config_cksum': 'cloud_config_cksum',
                            'cloud_name': 'cloud_name',
                            'created_by': 'created_by',
                            'deactivate_primary_pool_on_down': 'deactivate_primary_pool_on_down',
                            'deployment_policy_path': 'deployment_policy_path',
                            'enable_http2': 'enable_http2',
                            'fail_action': 'fail_action',
                            'implicit_priority_labels': 'implicit_priority_labels',
                            'markers': 'markers',
                            'members': 'members',
                            'min_servers': 'min_servers',
                            'priority_labels_path': 'priority_labels_path',
                            'service_metadata': 'service_metadata',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 cloud_config_cksum=None,
                 cloud_name=None,
                 created_by=None,
                 deactivate_primary_pool_on_down=None,
                 deployment_policy_path=None,
                 enable_http2=None,
                 fail_action=None,
                 implicit_priority_labels=None,
                 markers=None,
                 members=None,
                 min_servers=None,
                 priority_labels_path=None,
                 service_metadata=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  cloud_config_cksum: :class:`str` or ``None``
        :param cloud_config_cksum: Checksum of cloud configuration for PoolGroup. Internally set by
            cloud connector.
        :type  cloud_name: :class:`str` or ``None``
        :param cloud_name: It is a reference to an object of type Cloud.
        :type  created_by: :class:`str` or ``None``
        :param created_by: Name of the user who created the object.
        :type  deactivate_primary_pool_on_down: :class:`bool` or ``None``
        :param deactivate_primary_pool_on_down: Deactivate primary pool for selection when down until it is
            activated by user via clear poolgroup command. Default value when
            not specified in API or module is interpreted by ALB Controller as
            false.
        :type  deployment_policy_path: :class:`str` or ``None``
        :param deployment_policy_path: When setup autoscale manager will automatically promote new pools
            into production when deployment goals are met. It is a reference to
            an object of type PoolGroupDeploymentPolicy.
        :type  enable_http2: :class:`bool` or ``None``
        :param enable_http2: Enable HTTP/2 for traffic from VirtualService to all the backend
            servers in all the pools configured under this PoolGroup. Allowed
            in Basic(Allowed values- false) edition, Essentials(Allowed values-
            false) edition, Enterprise edition. Default value when not
            specified in API or module is interpreted by ALB Controller as
            false.
        :type  fail_action: :class:`ALBFailAction` or ``None``
        :param fail_action: 
        :type  implicit_priority_labels: :class:`bool` or ``None``
        :param implicit_priority_labels: Whether an implicit set of priority labels is generated. Default
            value when not specified in API or module is interpreted by ALB
            Controller as false.
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  members: :class:`list` of :class:`ALBPoolGroupMember` or ``None``
        :param members: List of pool group members object of type PoolGroupMember.
        :type  min_servers: :class:`long` or ``None``
        :param min_servers: The minimum number of servers to distribute traffic to. Allowed
            values are 1-65535. Special values are 0 - 'Disable'. Allowed in
            Basic(Allowed values- 0) edition, Essentials(Allowed values- 0)
            edition, Enterprise edition. Default value when not specified in
            API or module is interpreted by ALB Controller as 0. format: int64
        :type  priority_labels_path: :class:`str` or ``None``
        :param priority_labels_path: path of the priority labels. If not provided, pool group member
            priority label will be interpreted as a number with a larger number
            considered higher priority. It is a reference to an object of type
            PriorityLabels.
        :type  service_metadata: :class:`str` or ``None``
        :param service_metadata: Metadata pertaining to the service provided by this PoolGroup. In
            Openshift/Kubernetes environments, app metadata info is stored. Any
            user input to this field will be overwritten by Avi Vantage.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.cloud_config_cksum = cloud_config_cksum
        self.cloud_name = cloud_name
        self.created_by = created_by
        self.deactivate_primary_pool_on_down = deactivate_primary_pool_on_down
        self.deployment_policy_path = deployment_policy_path
        self.enable_http2 = enable_http2
        self.fail_action = fail_action
        self.implicit_priority_labels = implicit_priority_labels
        self.markers = markers
        self.members = members
        self.min_servers = min_servers
        self.priority_labels_path = priority_labels_path
        self.service_metadata = service_metadata
        VapiStruct.__init__(self)


ALBPoolGroup._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_pool_group', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'cloud_config_cksum': type.OptionalType(type.StringType()),
        'cloud_name': type.OptionalType(type.StringType()),
        'created_by': type.OptionalType(type.StringType()),
        'deactivate_primary_pool_on_down': type.OptionalType(type.BooleanType()),
        'deployment_policy_path': type.OptionalType(type.StringType()),
        'enable_http2': type.OptionalType(type.BooleanType()),
        'fail_action': type.OptionalType(type.ReferenceType(__name__, 'ALBFailAction')),
        'implicit_priority_labels': type.OptionalType(type.BooleanType()),
        'markers': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBRoleFilterMatchLabel'))),
        'members': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBPoolGroupMember'))),
        'min_servers': type.OptionalType(type.IntegerType()),
        'priority_labels_path': type.OptionalType(type.StringType()),
        'service_metadata': type.OptionalType(type.StringType()),
    },
    ALBPoolGroup,
    False,
    None))



class ALBPoolGroupApiResponse(VapiStruct):
    """
    PoolGroupApiResponse

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            'cursor': 'cursor',
                            'result_count': 'result_count',
                            'sort_ascending': 'sort_ascending',
                            'sort_by': 'sort_by',
                            'count': 'count',
                            'results': 'results',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 cursor=None,
                 result_count=None,
                 sort_ascending=None,
                 sort_by=None,
                 count=None,
                 results=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page)
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  result_count: :class:`long` or ``None``
        :param result_count: Count of results found (across all pages), set only on first page
            format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: If true, results are sorted in ascending order
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  count: :class:`long` or ``None``
        :param count: count format: int32
        :type  results: :class:`list` of :class:`ALBPoolGroup` or ``None``
        :param results: Array of PoolGroup
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.cursor = cursor
        self.result_count = result_count
        self.sort_ascending = sort_ascending
        self.sort_by = sort_by
        self.count = count
        self.results = results
        VapiStruct.__init__(self)


ALBPoolGroupApiResponse._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_pool_group_api_response', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        'cursor': type.OptionalType(type.StringType()),
        'result_count': type.OptionalType(type.IntegerType()),
        'sort_ascending': type.OptionalType(type.BooleanType()),
        'sort_by': type.OptionalType(type.StringType()),
        'count': type.OptionalType(type.IntegerType()),
        'results': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ALBPoolGroup'))),
    },
    ALBPoolGroupApiResponse,
    False,
    None))



class ALBPoolGroupDeploymentPolicy(VapiStruct):
    """
    Advanced load balancer PoolGroupDeploymentPolicy object

    .. tip::
        The arguments are used to initialize data attributes with the same
        names.
    """
    SCHEME_BLUE_GREEN = "BLUE_GREEN"
    """


    """
    SCHEME_CANARY = "CANARY"
    """


    """



    _canonical_to_pep_names = {
                            '_links': 'links',
                            '_schema': 'schema',
                            '_self': 'self_',
                            '_revision': 'revision',
                            '_create_time': 'create_time',
                            '_create_user': 'create_user',
                            '_last_modified_time': 'last_modified_time',
                            '_last_modified_user': 'last_modified_user',
                            '_protection': 'protection',
                            '_system_owned': 'system_owned',
                            'description': 'description',
                            'display_name': 'display_name',
                            'id': 'id',
                            'resource_type': 'resource_type',
                            'tags': 'tags',
                            'parent_path': 'parent_path',
                            'path': 'path',
                            'realization_id': 'realization_id',
                            'relative_path': 'relative_path',
                            'unique_id': 'unique_id',
                            'children': 'children',
                            'marked_for_delete': 'marked_for_delete',
                            'overridden': 'overridden',
                            'auto_disable_old_prod_pools': 'auto_disable_old_prod_pools',
                            'evaluation_duration': 'evaluation_duration',
                            'markers': 'markers',
                            'rules': 'rules',
                            'scheme': 'scheme',
                            'target_test_traffic_ratio': 'target_test_traffic_ratio',
                            'test_traffic_ratio_rampup': 'test_traffic_ratio_rampup',
                            'webhook_path': 'webhook_path',
                            }

    def __init__(self,
                 links=None,
                 schema=None,
                 self_=None,
                 revision=None,
                 create_time=None,
                 create_user=None,
                 last_modified_time=None,
                 last_modified_user=None,
                 protection=None,
                 system_owned=None,
                 description=None,
                 display_name=None,
                 id=None,
                 resource_type=None,
                 tags=None,
                 parent_path=None,
                 path=None,
                 realization_id=None,
                 relative_path=None,
                 unique_id=None,
                 children=None,
                 marked_for_delete=None,
                 overridden=None,
                 auto_disable_old_prod_pools=None,
                 evaluation_duration=None,
                 markers=None,
                 rules=None,
                 scheme=None,
                 target_test_traffic_ratio=None,
                 test_traffic_ratio_rampup=None,
                 webhook_path=None,
                ):
        """
        :type  links: :class:`list` of :class:`ResourceLink` or ``None``
        :param links: The server will populate this field when returing the resource.
            Ignored on PUT and POST.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  schema: :class:`str` or ``None``
        :param schema: Schema for this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  self_: :class:`SelfResourceLink` or ``None``
        :param self_: 
        :type  revision: :class:`long` or ``None``
        :param revision: The _revision property describes the current revision of the
            resource. To prevent clients from overwriting each other's changes,
            PUT operations must include the current _revision of the resource,
            which clients should obtain by issuing a GET operation. If the
            _revision provided in a PUT request is missing or stale, the
            operation will be rejected. format: int32
        :type  create_time: :class:`long` or ``None``
        :param create_time: Timestamp of resource creation format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  create_user: :class:`str` or ``None``
        :param create_user: ID of the user who created this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_time: :class:`long` or ``None``
        :param last_modified_time: Timestamp of last modification format: int64
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  last_modified_user: :class:`str` or ``None``
        :param last_modified_user: ID of the user who last modified this resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  protection: :class:`str` or ``None``
        :param protection: Protection status is one of the following: PROTECTED - the client
            who retrieved the entity is not allowed to modify it. NOT_PROTECTED
            - the client who retrieved the entity is allowed to modify it
            REQUIRE_OVERRIDE - the client who retrieved the entity is a super
            user and can modify it, but only when providing the request header
            X-Allow-Overwrite=true. UNKNOWN - the _protection field could not
            be determined for this entity.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  system_owned: :class:`bool` or ``None``
        :param system_owned: Indicates system owned resource
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  description: :class:`str` or ``None``
        :param description: Description of this resource
        :type  display_name: :class:`str` or ``None``
        :param display_name: Defaults to ID if not set
        :type  id: :class:`str` or ``None``
        :param id: Unique identifier of this resource
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: The type of this resource.
        :type  tags: :class:`list` of :class:`Tag` or ``None``
        :param tags: Opaque identifiers meaningful to the API user
        :type  parent_path: :class:`str` or ``None``
        :param parent_path: Path of its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  path: :class:`str` or ``None``
        :param path: Absolute path of this object
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  realization_id: :class:`str` or ``None``
        :param realization_id: This is a UUID generated by the system for realizing the entity
            object. In most cases this should be same as 'unique_id' of the
            entity. However, in some cases this can be different because of
            entities have migrated thier unique identifier to NSX Policy intent
            objects later in the timeline and did not use unique_id for
            realization. Realization id is helpful for users to debug data path
            to correlate the configuration with corresponding intent.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  relative_path: :class:`str` or ``None``
        :param relative_path: Path relative from its parent
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  unique_id: :class:`str` or ``None``
        :param unique_id: This is a UUID generated by the GM/LM to uniquely identify entites
            in a federated environment. For entities that are stretched across
            multiple sites, the same ID will be used on all the stretched
            sites.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  children: :class:`list` of :class:`vmware.vapi.struct.VapiStruct` or ``None``
        :param children: subtree for this type within policy tree containing nested
            elements.
            When clients pass a value of this class as a parameter, the
            attribute must contain all the attributes defined in
            :class:`ChildPolicyConfigResource`. When methods return a value of
            this class as a return value, the attribute will contain all the
            attributes defined in :class:`ChildPolicyConfigResource`.
        :type  marked_for_delete: :class:`bool` or ``None``
        :param marked_for_delete: Intent objects are not directly deleted from the system when a
            delete is invoked on them. They are marked for deletion and only
            when all the realized entities for that intent object gets deleted,
            the intent object is deleted. Objects that are marked for deletion
            are not returned in GET call. One can use the search API to get
            these objects.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  overridden: :class:`bool` or ``None``
        :param overridden: Global intent objects cannot be modified by the user. However,
            certain global intent objects can be overridden locally by use of
            this property. In such cases, the overridden local values take
            precedence over the globally defined values for the properties.
            This attribute may be present in responses from the server, but if
            it is present in a request to server it will be ignored.
        :type  auto_disable_old_prod_pools: :class:`bool` or ``None``
        :param auto_disable_old_prod_pools: It will automatically disable old production pools once there is a
            new production candidate. Default value when not specified in API
            or module is interpreted by ALB Controller as true.
        :type  evaluation_duration: :class:`long` or ``None``
        :param evaluation_duration: Duration of evaluation period for automatic deployment. Allowed
            values are 60-86400. Unit is SEC. Default value when not specified
            in API or module is interpreted by ALB Controller as 300. format:
            int64
        :type  markers: :class:`list` of :class:`ALBRoleFilterMatchLabel` or ``None``
        :param markers: List of labels to be used for granular RBAC. Allowed in Basic
            edition, Essentials edition, Enterprise edition.
        :type  rules: :class:`list` of :class:`ALBPGDeploymentRule` or ``None``
        :param rules: Placeholder for description of property rules of obj type
            PoolGroupDeploymentPolicy field type str type array.
        :type  scheme: :class:`str` or ``None``
        :param scheme: Possible values are: 
            
            * :attr:`ALBPoolGroupDeploymentPolicy.SCHEME_BLUE_GREEN`
            * :attr:`ALBPoolGroupDeploymentPolicy.SCHEME_CANARY`
            
            deployment scheme. Enum options - BLUE_GREEN, CANARY. Default value
            when not specified in API or module is interpreted by ALB
            Controller as BLUE_GREEN.
        :type  target_test_traffic_ratio: :class:`long` or ``None``
        :param target_test_traffic_ratio: Target traffic ratio before pool is made production. Allowed values
            are 1-100. Unit is RATIO. Default value when not specified in API
            or module is interpreted by ALB Controller as 100. format: int64
        :type  test_traffic_ratio_rampup: :class:`long` or ``None``
        :param test_traffic_ratio_rampup: Ratio of the traffic that is sent to the pool under test. test
            ratio of 100 means blue green. Allowed values are 1-100. Default
            value when not specified in API or module is interpreted by ALB
            Controller as 100. format: int64
        :type  webhook_path: :class:`str` or ``None``
        :param webhook_path: Webhook configured with URL that Avi controller will pass back
            information about pool group, old and new pool information and
            current deployment rule results. It is a reference to an object of
            type Webhook.
        """
        self.links = links
        self.schema = schema
        self.self_ = self_
        self.revision = revision
        self.create_time = create_time
        self.create_user = create_user
        self.last_modified_time = last_modified_time
        self.last_modified_user = last_modified_user
        self.protection = protection
        self.system_owned = system_owned
        self.description = description
        self.display_name = display_name
        self.id = id
        self.resource_type = resource_type
        self.tags = tags
        self.parent_path = parent_path
        self.path = path
        self.realization_id = realization_id
        self.relative_path = relative_path
        self.unique_id = unique_id
        self.children = children
        self.marked_for_delete = marked_for_delete
        self.overridden = overridden
        self.auto_disable_old_prod_pools = auto_disable_old_prod_pools
        self.evaluation_duration = evaluation_duration
        self.markers = markers
        self.rules = rules
        self.scheme = scheme
        self.target_test_traffic_ratio = target_test_traffic_ratio
        self.test_traffic_ratio_rampup = test_traffic_ratio_rampup
        self.webhook_path = webhook_path
        VapiStruct.__init__(self)


ALBPoolGroupDeploymentPolicy._set_binding_type(type.StructType(
    'com.vmware.nsx_policy.model.ALB_pool_group_deployment_policy', {
        '_links': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceLink'))),
        '_schema': type.OptionalType(type.StringType()),
        '_self': type.OptionalType(type.ReferenceType(__name__, 'SelfResourceLink')),
        '_revision': type.OptionalType(type.IntegerType()),
        '_create_time': type.OptionalType(type.IntegerType()),
        '_create_user': type.OptionalType(type.StringType()),
        '_last_modified_time': type.OptionalType(type.IntegerType()),
        '_last_modified_user': type.OptionalType(type.StringType()),
        '_protection': type.OptionalType(type.StringType()),
        '_system_owned': type.OptionalType(type.BooleanType()),
        'description': type.OptionalType(type.StringType()),
        'display_name': type.OptionalType(type.StringType()),
        'id': type.OptionalType(type.StringType()),
        'resource_type': type.OptionalType(type.StringType()),
        'tags': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'Tag'))),
        'parent_path': type.OptionalType(type.StringType()),
        'path': type.OptionalType(type.StringType()),
        'realization_id': type.OptionalType(type.StringType()),
        'relative_path': type.OptionalType(type.StringType()),
        'unique_id': type.OptionalType(type.StringType()),
        'children': type.OptionalType(type.ListType(type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType(__name__, 'ChildPolicyConfigResource')]))),
        'marked_for_delete': type.OptionalType(type.BooleanType()),
        'overridden': type.OptionalType(type.BooleanType()),
        'auto_disable_old_prod_pools': type.OptionalType(type.Bool