"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityAnalyticsPlugin = void 0;

var _createSecurityAnalyticsCluster = require("./clusters/createSecurityAnalyticsCluster");

var _routes = require("./routes");

var _RuleRoutes = require("./routes/RuleRoutes");

var _services = require("./services");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class SecurityAnalyticsPlugin {
  async setup(core) {
    // Create OpenSearch client that aware of SA API endpoints
    const osDriver = (0, _createSecurityAnalyticsCluster.createSecurityAnalyticsCluster)(core); // Initialize services

    const services = {
      detectorsService: new _services.DetectorService(osDriver),
      indexService: new _services.IndexService(osDriver),
      findingsService: new _services.FindingsService(osDriver),
      opensearchService: new _services.OpenSearchService(osDriver),
      fieldMappingService: new _services.FieldMappingService(osDriver),
      alertService: new _services.AlertService(osDriver),
      rulesService: new _services.RulesService(osDriver),
      notificationsService: new _services.NotificationsService(osDriver)
    }; // Create router

    const router = core.http.createRouter(); // setup routes

    (0, _routes.setupDetectorRoutes)(services, router);
    (0, _routes.setupIndexRoutes)(services, router);
    (0, _routes.setupFindingsRoutes)(services, router);
    (0, _routes.setupOpensearchRoutes)(services, router);
    (0, _routes.setupFieldMappingRoutes)(services, router);
    (0, _routes.setupAlertsRoutes)(services, router);
    (0, _RuleRoutes.setupRulesRoutes)(services, router);
    (0, _routes.setupNotificationsRoutes)(services, router);
    return {};
  }

  async start(_core) {
    return {};
  }

}

exports.SecurityAnalyticsPlugin = SecurityAnalyticsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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