"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomImportMapPlugin = void 0;

var _operators = require("rxjs/operators");

var _flights_saved_objects = require("./services/sample_data/flights_saved_objects");

var _clusters = require("./clusters");

var _services = require("./services");

var _routes = require("../server/routes");

var _saved_objects = require("./saved_objects");

var _capabilities_provider = require("./saved_objects/capabilities_provider");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CustomImportMapPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "globalConfig$", void 0);

    _defineProperty(this, "config$", void 0);

    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
    this.config$ = initializerContext.config.create();
  } // Adds dashboards-maps saved objects to existing sample datasets using home plugin


  addMapsSavedObjects(home, config) {
    home.sampleData.addSavedObjectsToSampleDataset('flights', (0, _flights_saved_objects.getFlightsSavedObjects)(config));
  }

  async setup(core, plugins) {
    this.logger.debug('customImportMap: Setup'); // @ts-ignore

    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise(); // @ts-ignore

    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const geospatialClient = (0, _clusters.createGeospatialCluster)(core, globalConfig); // Initialize services

    const geospatialService = new _services.GeospatialService(geospatialClient);
    const opensearchService = new _services.OpensearchService(geospatialClient);
    const router = core.http.createRouter();
    const {
      home
    } = plugins; // Register server side APIs

    (0, _routes.geospatial)(geospatialService, router);
    (0, _routes.opensearch)(opensearchService, router); // Register saved object types

    core.savedObjects.registerType(_saved_objects.mapSavedObjectsType); // Register capabilities

    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    if (home) this.addMapsSavedObjects(home, config);
    return {};
  }

  start(core) {
    this.logger.debug('customImportMap: Started');
    return {};
  }

  stop() {}

}

exports.CustomImportMapPlugin = CustomImportMapPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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