/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.handlers.form.FormData;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;

public class PartImpl
implements Part {
    private final String name;
    private final FormData.FormValue formValue;
    private final MultipartConfigElement config;
    private final ServletContextImpl servletContext;
    private final HttpServletRequestImpl servletRequest;

    public PartImpl(String name, FormData.FormValue formValue, MultipartConfigElement config, ServletContextImpl servletContext, HttpServletRequestImpl servletRequest) {
        this.name = name;
        this.formValue = formValue;
        this.config = config;
        this.servletContext = servletContext;
        this.servletRequest = servletRequest;
    }

    public InputStream getInputStream() throws IOException {
        if (this.formValue.isFileItem()) {
            return this.formValue.getFileItem().getInputStream();
        }
        String requestedCharset = this.servletRequest.getCharacterEncoding();
        String charset = requestedCharset != null ? requestedCharset : this.servletContext.getDeployment().getDefaultRequestCharset().name();
        return new ByteArrayInputStream(this.formValue.getValue().getBytes(charset));
    }

    public String getContentType() {
        return this.formValue.getHeaders().get("Content-Type");
    }

    public String getName() {
        return this.name;
    }

    public String getSubmittedFileName() {
        return this.formValue.getFileName();
    }

    public long getSize() {
        try {
            if (this.formValue.isFileItem()) {
                return this.formValue.getFileItem().getFileSize();
            }
            return this.formValue.getValue().length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(String fileName) throws IOException {
        Path target = Paths.get(fileName, new String[0]);
        if (!target.isAbsolute()) {
            target = this.config.getLocation().isEmpty() ? this.servletContext.getDeployment().getDeploymentInfo().getTempPath().resolve(fileName) : Paths.get(this.config.getLocation(), fileName);
        }
        if (this.formValue.isFileItem()) {
            this.formValue.getFileItem().write(target);
        }
    }

    public void delete() throws IOException {
        if (this.formValue.isFileItem()) {
            try {
                this.formValue.getFileItem().delete();
            }
            catch (IOException e) {
                throw UndertowServletMessages.MESSAGES.deleteFailed(this.formValue.getPath());
            }
        }
    }

    public String getHeader(String name) {
        return this.formValue.getHeaders().get(name);
    }

    public Collection<String> getHeaders(String name) {
        List values = this.formValue.getHeaders().getAll(name);
        return values == null ? Collections.emptyList() : values;
    }

    public Collection<String> getHeaderNames() {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry i : this.formValue.getHeaders()) {
            ret.add((String)i.getKey());
        }
        return ret;
    }
}

