/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devconsole;

import io.quarkus.arc.deployment.devconsole.DevBeanInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DependencyGraph {
    public final Set<DevBeanInfo> nodes;
    public final Set<Link> links;
    public final int maxLevel;

    public DependencyGraph(Set<DevBeanInfo> nodes, Set<Link> links) {
        this.nodes = nodes;
        this.links = links;
        this.maxLevel = links.stream().mapToInt(l -> l.level).max().orElse(0);
    }

    DependencyGraph forLevel(int level) {
        HashSet<Link> newLinks = new HashSet<Link>();
        HashSet<DevBeanInfo> newNodes = new HashSet<DevBeanInfo>();
        HashSet<String> usedIds = new HashSet<String>();
        for (Link link : this.links) {
            if (link.level > level) continue;
            newLinks.add(link);
            usedIds.add(link.source);
            usedIds.add(link.target);
        }
        for (DevBeanInfo node : this.nodes) {
            if (!usedIds.contains(node.getId())) continue;
            newNodes.add(node);
        }
        return new DependencyGraph(newNodes, newLinks);
    }

    public static class Link {
        public final String source;
        public final String target;
        public final String type;
        public final int level;

        static Link dependent(String source, String target, int level) {
            return new Link(source, target, level == 0 ? "directDependent" : "dependency", level);
        }

        static Link dependency(String source, String target, int level) {
            return new Link(source, target, level == 0 ? "directDependency" : "dependency", level);
        }

        static Link lookup(String source, String target, int level) {
            return new Link(source, target, "lookup", level);
        }

        static Link producer(String source, String target, int level) {
            return new Link(source, target, "producer", level);
        }

        public Link(String source, String target, String type, int level) {
            this.source = source;
            this.target = target;
            this.type = type;
            this.level = level;
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            return Objects.equals(this.source, other.source) && Objects.equals(this.target, other.target);
        }
    }
}

