/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ducttape.ratelimits;

import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.rnorth.ducttape.ratelimits.RateLimiter;

class ConstantThroughputRateLimiter
extends RateLimiter {
    private final long timeBetweenInvocations;

    ConstantThroughputRateLimiter(@NotNull Integer rate, @NotNull TimeUnit perTimeUnit) {
        this.timeBetweenInvocations = perTimeUnit.toMillis(1L) / (long)rate.intValue();
    }

    @Override
    protected long getWaitBeforeNextInvocation() {
        long timeToNextAllowed = this.lastInvocation + this.timeBetweenInvocations - System.currentTimeMillis();
        return Math.max(timeToNextAllowed, 0L);
    }
}

