/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import org.infinispan.server.core.transport.NettyTransport;

@ChannelHandler.Sharable
public class StatsChannelHandler
extends ChannelDuplexHandler {
    private final NettyTransport transport;

    public StatsChannelHandler(NettyTransport transport) {
        this.transport = transport;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.transport.updateTotalBytesRead(this.getByteSize(msg));
        super.channelRead(ctx, msg);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.transport.acceptedChannels.add((Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        int writable = this.getByteSize(msg);
        this.transport.updateTotalBytesWritten(writable);
        super.write(ctx, msg, promise);
    }

    int getByteSize(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return -1;
    }
}

