/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.AuthenticationConfiguration;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.SecurityConfiguration;
import org.infinispan.persistence.remote.configuration.SslConfiguration;

public class RemoteStoreConfigurationSerializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<RemoteStoreConfiguration> {
    public void serialize(ConfigurationWriter writer, RemoteStoreConfiguration configuration) {
        writer.writeStartElement((Enum)Element.REMOTE_STORE);
        writer.writeDefaultNamespace("urn:infinispan:config:store:remote:" + Version.getMajorMinor());
        configuration.attributes().write(writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeAsyncExecutor(writer, configuration.asyncExecutorFactory());
        this.writeConnectionPool(writer, configuration.connectionPool());
        this.writeServers(writer, configuration.servers());
        this.writeSecurity(writer, configuration.security());
        this.writeCommonStoreElements(writer, (StoreConfiguration)configuration);
        writer.writeEndElement();
    }

    private void writeAsyncExecutor(ConfigurationWriter writer, ExecutorFactoryConfiguration executorFactoryConfiguration) {
        AttributeSet attributes = executorFactoryConfiguration.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.ASYNC_TRANSPORT_EXECUTOR);
            attributes.write(writer, ExecutorFactoryConfiguration.EXECUTOR_FACTORY, (Enum)Attribute.FACTORY);
            SerializeUtils.writeTypedProperties((ConfigurationWriter)writer, (TypedProperties)executorFactoryConfiguration.properties());
            writer.writeEndElement();
        }
    }

    private void writeConnectionPool(ConfigurationWriter writer, ConnectionPoolConfiguration connectionPool) {
        writer.writeStartElement((Enum)Element.CONNECTION_POOL);
        writer.writeAttribute((Enum)Attribute.EXHAUSTED_ACTION, connectionPool.exhaustedAction().name());
        writer.writeAttribute((Enum)Attribute.MAX_ACTIVE, Integer.toString(connectionPool.maxActive()));
        writer.writeAttribute((Enum)Attribute.MAX_PENDING_REQUESTS, Integer.toString(connectionPool.maxPendingRequests()));
        writer.writeAttribute((Enum)Attribute.MAX_WAIT, Integer.toString(connectionPool.maxWait()));
        writer.writeAttribute((Enum)Attribute.MIN_IDLE, Integer.toString(connectionPool.minIdle()));
        writer.writeAttribute((Enum)Attribute.MIN_EVICTABLE_IDLE_TIME, Long.toString(connectionPool.minEvictableIdleTime()));
        writer.writeEndElement();
    }

    private void writeServers(ConfigurationWriter writer, List<RemoteServerConfiguration> servers) {
        writer.writeStartListElement((Enum)Element.REMOTE_SERVER, false);
        for (RemoteServerConfiguration server : servers) {
            writer.writeStartElement((Enum)Element.REMOTE_SERVER);
            writer.writeAttribute((Enum)Attribute.HOST, server.host());
            writer.writeAttribute((Enum)Attribute.PORT, Integer.toString(server.port()));
            writer.writeEndElement();
        }
        writer.writeEndListElement();
    }

    private void writeSecurity(ConfigurationWriter writer, SecurityConfiguration security) {
        if (security.authentication().attributes().isModified() || security.ssl().attributes().isModified()) {
            writer.writeStartElement((Enum)Element.SECURITY);
            this.writeAuthentication(writer, security.authentication());
            this.writeEncryption(writer, security.ssl());
            writer.writeEndElement();
        }
    }

    private void writeAuthentication(ConfigurationWriter writer, AuthenticationConfiguration authentication) {
        AttributeSet attributeSet = authentication.attributes();
        if (attributeSet.isModified()) {
            writer.writeStartElement((Enum)Element.AUTHENTICATION);
            attributeSet.write(writer);
            switch (authentication.saslMechanism()) {
                case "PLAIN": {
                    writer.writeStartElement((Enum)Element.AUTH_PLAIN);
                    writer.writeAttribute((Enum)Attribute.USERNAME, authentication.username());
                    writer.writeAttribute((Enum)Attribute.PASSWORD, new String(authentication.password()));
                    writer.writeEndElement();
                    break;
                }
                case "DIGEST-MD5": {
                    writer.writeStartElement((Enum)Element.AUTH_DIGEST);
                    writer.writeAttribute((Enum)Attribute.USERNAME, authentication.username());
                    writer.writeAttribute((Enum)Attribute.PASSWORD, new String(authentication.password()));
                    writer.writeAttribute((Enum)Attribute.REALM, authentication.realm());
                    writer.writeEndElement();
                    break;
                }
                case "EXTERNAL": {
                    writer.writeEmptyElement((Enum)Element.AUTH_EXTERNAL);
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeEncryption(ConfigurationWriter writer, SslConfiguration ssl) {
        AttributeSet attributes = ssl.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.ENCRYPTION);
            attributes.write(writer);
            if (ssl.keyStoreFileName() != null) {
                writer.writeStartElement((Enum)Element.KEYSTORE);
                writer.writeAttribute((Enum)Attribute.FILENAME, ssl.keyStoreFileName());
                writer.writeAttribute((Enum)Attribute.PASSWORD, new String(ssl.keyStorePassword()));
                if (ssl.keyStoreCertificatePassword() != null) {
                    writer.writeAttribute((Enum)Attribute.CERTIFICATE_PASSWORD, new String(ssl.keyStoreCertificatePassword()));
                }
                if (ssl.keyAlias() != null) {
                    writer.writeAttribute((Enum)Attribute.KEY_ALIAS, ssl.keyAlias());
                }
                writer.writeAttribute((Enum)Attribute.TYPE, ssl.keyStoreType());
                writer.writeEndElement();
            }
            if (ssl.trustStoreFileName() != null) {
                writer.writeStartElement((Enum)Element.TRUSTSTORE);
                writer.writeAttribute((Enum)Attribute.FILENAME, ssl.trustStoreFileName());
                writer.writeAttribute((Enum)Attribute.PASSWORD, new String(ssl.trustStorePassword()));
                writer.writeAttribute((Enum)Attribute.TYPE, ssl.trustStoreType());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

