/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import java.util.Objects;
import java.util.function.Function;

public class CastUtils {
    public static <T> T cast(Object value, Class<T> toClass) {
        return value == null ? null : (T)CastUtils.getCastFunc(value.getClass(), toClass).apply(value);
    }

    public static <E extends Enum<E>> Function<?, ?> getCastFunc(Class<?> fromClass, Class<?> toClass) {
        if (fromClass == toClass || toClass.isAssignableFrom(fromClass)) {
            return Function.identity();
        }
        if (toClass == String.class) {
            return Objects::toString;
        }
        if (fromClass == String.class) {
            if (toClass == Integer.class) {
                return Integer::valueOf;
            }
            if (toClass == Long.class) {
                return Long::valueOf;
            }
            if (toClass == Boolean.class) {
                return Boolean::valueOf;
            }
            if (toClass.isEnum()) {
                Class<?> enumClass = toClass;
                return value -> Enum.valueOf(enumClass, value);
            }
        }
        if (fromClass == Long.class && toClass == Integer.class) {
            return Long::intValue;
        }
        if (fromClass == Integer.class && toClass == Long.class) {
            return Integer::longValue;
        }
        throw new IllegalStateException("Unknown cast: " + fromClass + " -> " + toClass);
    }
}

