/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleAccumulation;
import java.util.List;

final class AutoValue_DoubleAccumulation
extends DoubleAccumulation {
    private final double value;
    private final List<DoubleExemplarData> exemplars;

    AutoValue_DoubleAccumulation(double value, List<DoubleExemplarData> exemplars) {
        this.value = value;
        if (exemplars == null) {
            throw new NullPointerException("Null exemplars");
        }
        this.exemplars = exemplars;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public String toString() {
        return "DoubleAccumulation{value=" + this.value + ", exemplars=" + this.exemplars + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DoubleAccumulation) {
            DoubleAccumulation that = (DoubleAccumulation)o;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.getValue()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value));
        h$ *= 1000003;
        return h$ ^= this.exemplars.hashCode();
    }
}

