/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j.example;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jitsi_modified.sctp4j.Sctp4j;
import org.jitsi_modified.sctp4j.SctpClientSocket;
import org.jitsi_modified.sctp4j.SctpSocket;

public class Client {
    public static void main(String[] args2) throws UnknownHostException, SocketException, ExecutionException, InterruptedException {
        Sctp4j.init(5000);
        InetAddress localAddr = InetAddress.getByName("127.0.0.1");
        int localPort = 48002;
        int localSctpPort = 5002;
        InetAddress remoteAddr = InetAddress.getByName("127.0.0.1");
        int remotePort = 48001;
        int remoteSctpPort = 5001;
        DatagramSocket socket = new DatagramSocket(localPort, localAddr);
        final SctpClientSocket client = Sctp4j.createClientSocket(localSctpPort);
        CompletableFuture dataReceived = new CompletableFuture();
        client.outgoingDataSender = (data2, offset, length) -> {
            DatagramPacket packet = new DatagramPacket(data2, offset, length, remoteAddr, remotePort);
            try {
                socket.send(packet);
            }
            catch (IOException e) {
                System.out.println("Error sending packet: " + e.toString());
            }
            return 0;
        };
        client.dataCallback = (data2, sid, ssn, tsn, ppid, context, flags) -> {
            String message = new String(data2);
            dataReceived.complete(message);
        };
        new Thread(() -> {
            byte[] buf = new byte[1600];
            DatagramPacket p = new DatagramPacket(buf, 1600);
            try {
                do {
                    socket.receive(p);
                    client.onConnIn(p.getData(), p.getOffset(), p.getLength());
                } while (!dataReceived.isDone());
            }
            catch (IOException e) {
                System.out.println("Error receiving from udp socket: " + e.toString());
            }
        }).start();
        client.connect(remoteSctpPort);
        client.eventHandler = new SctpSocket.SctpSocketEventHandler(){

            @Override
            public void onReady() {
                System.out.println("Client connected, sending message");
                String message = "Marco";
                client.send(ByteBuffer.wrap(message.getBytes()), true, 0, 1);
            }

            @Override
            public void onDisconnected() {
                System.out.println("Client disconnected");
            }
        };
        String serverMessage = (String)dataReceived.get();
        client.close();
        System.out.println("Client received message: '" + serverMessage + "'");
    }
}

