/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rest;

import jakarta.servlet.DispatcherType;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rest.JettyBundleActivatorConfig;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"servletContextHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "Lorg/eclipse/jetty/server/Server;", "getServletContextHandler", "(Lorg/eclipse/jetty/server/Server;)Lorg/eclipse/jetty/servlet/ServletContextHandler;", "createJettyServer", "config", "Lorg/jitsi/rest/JettyBundleActivatorConfig;", "createSecureJettyServer", "createServer", "addServlet", "", "servlet", "Lorg/eclipse/jetty/servlet/ServletHolder;", "pathSpec", "", "enableCors", "isEnabled", "", "jicoco"})
@JvmName(name="JettyHelpers")
public final class JettyHelpers {
    @NotNull
    public static final Server createJettyServer(@NotNull JettyBundleActivatorConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        Dumpable $this$createJettyServer_u24lambda_u2d1 = httpConfiguration;
        boolean bl = false;
        ((HttpConfiguration)$this$createJettyServer_u24lambda_u2d1).setSendServerVersion(config.getSendServerVersion());
        ((HttpConfiguration)$this$createJettyServer_u24lambda_u2d1).addCustomizer(JettyHelpers::createJettyServer$lambda-1$lambda-0);
        HttpConfiguration httpConfig = httpConfiguration;
        Dumpable $this$createJettyServer_u24lambda_u2d2 = $this$createJettyServer_u24lambda_u2d1 = new Server();
        boolean bl2 = false;
        ((HandlerWrapper)$this$createJettyServer_u24lambda_u2d2).setHandler(new ServletContextHandler());
        Dumpable server = $this$createJettyServer_u24lambda_u2d1;
        Object object = new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)};
        Object $this$createJettyServer_u24lambda_u2d3 = object = new ServerConnector((Server)server, (ConnectionFactory[])object);
        boolean bl3 = false;
        ((AbstractNetworkConnector)$this$createJettyServer_u24lambda_u2d3).setPort(config.getPort());
        ((AbstractNetworkConnector)$this$createJettyServer_u24lambda_u2d3).setHost(config.getHost());
        Object connector = object;
        ((Server)server).addConnector((Connector)connector);
        return server;
    }

    @NotNull
    public static final Server createSecureJettyServer(@NotNull JettyBundleActivatorConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String string = config.getKeyStorePath();
        Intrinsics.checkNotNull(string);
        File sslContextFactoryKeyStoreFile = Paths.get(string, new String[0]).toFile();
        SslContextFactory.Server server = new SslContextFactory.Server();
        Dumpable $this$createSecureJettyServer_u24lambda_u2d4 = server;
        boolean bl = false;
        Collection $this$toTypedArray$iv = config.getTlsProtocols();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray2 = stringArray;
        ((SslContextFactory)$this$createSecureJettyServer_u24lambda_u2d4).setIncludeProtocols(Arrays.copyOf(stringArray2, stringArray2.length));
        $this$toTypedArray$iv = config.getTlsCipherSuites();
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        stringArray2 = stringArray3;
        ((SslContextFactory)$this$createSecureJettyServer_u24lambda_u2d4).setIncludeCipherSuites(Arrays.copyOf(stringArray2, stringArray2.length));
        ((SslContextFactory)$this$createSecureJettyServer_u24lambda_u2d4).setRenegotiationAllowed(false);
        if (config.getKeyStorePassword() != null) {
            ((SslContextFactory)$this$createSecureJettyServer_u24lambda_u2d4).setKeyStorePassword(config.getKeyStorePassword());
        }
        ((SslContextFactory)$this$createSecureJettyServer_u24lambda_u2d4).setKeyStorePath(sslContextFactoryKeyStoreFile.getPath());
        ((SslContextFactory.Server)$this$createSecureJettyServer_u24lambda_u2d4).setNeedClientAuth(config.getNeedClientAuth());
        SslContextFactory.Server sslContextFactory = server;
        Dumpable $this$createSecureJettyServer_u24lambda_u2d5 = $this$createSecureJettyServer_u24lambda_u2d4 = new HttpConfiguration();
        boolean bl2 = false;
        ((HttpConfiguration)$this$createSecureJettyServer_u24lambda_u2d5).setSecurePort(config.getTlsPort());
        ((HttpConfiguration)$this$createSecureJettyServer_u24lambda_u2d5).setSecureScheme("https");
        ((HttpConfiguration)$this$createSecureJettyServer_u24lambda_u2d5).addCustomizer(new SecureRequestCustomizer());
        ((HttpConfiguration)$this$createSecureJettyServer_u24lambda_u2d5).setSendServerVersion(config.getSendServerVersion());
        Dumpable httpConfig = $this$createSecureJettyServer_u24lambda_u2d4;
        Dumpable $this$createSecureJettyServer_u24lambda_u2d6 = $this$createSecureJettyServer_u24lambda_u2d5 = new Server();
        boolean bl3 = false;
        ((HandlerWrapper)$this$createSecureJettyServer_u24lambda_u2d6).setHandler(new ServletContextHandler());
        Dumpable server2 = $this$createSecureJettyServer_u24lambda_u2d5;
        Object object = new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory((HttpConfiguration)httpConfig)};
        Object $this$createSecureJettyServer_u24lambda_u2d7 = object = new ServerConnector((Server)server2, (ConnectionFactory[])object);
        boolean bl4 = false;
        ((AbstractNetworkConnector)$this$createSecureJettyServer_u24lambda_u2d7).setHost(config.getHost());
        ((AbstractNetworkConnector)$this$createSecureJettyServer_u24lambda_u2d7).setPort(config.getTlsPort());
        Object connector = object;
        ((Server)server2).addConnector((Connector)connector);
        return server2;
    }

    @NotNull
    public static final Server createServer(@NotNull JettyBundleActivatorConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        return config.isTls() ? JettyHelpers.createSecureJettyServer(config) : JettyHelpers.createJettyServer(config);
    }

    public static final boolean isEnabled(@NotNull JettyBundleActivatorConfig $this$isEnabled) {
        Intrinsics.checkNotNullParameter($this$isEnabled, "<this>");
        return $this$isEnabled.getPort() != -1 || $this$isEnabled.getTlsPort() != -1;
    }

    @NotNull
    public static final ServletContextHandler getServletContextHandler(@NotNull Server $this$servletContextHandler) {
        Intrinsics.checkNotNullParameter($this$servletContextHandler, "<this>");
        Handler handler = $this$servletContextHandler.getHandler();
        if (handler == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.eclipse.jetty.servlet.ServletContextHandler");
        }
        return (ServletContextHandler)handler;
    }

    public static final void enableCors(@NotNull ServletContextHandler $this$enableCors, @NotNull String pathSpec) {
        FilterHolder filterHolder;
        Intrinsics.checkNotNullParameter($this$enableCors, "<this>");
        Intrinsics.checkNotNullParameter(pathSpec, "pathSpec");
        FilterHolder $this$enableCors_u24lambda_u2d8 = filterHolder = $this$enableCors.addFilter(CrossOriginFilter.class, pathSpec, EnumSet.of((Enum)DispatcherType.REQUEST));
        boolean bl = false;
        $this$enableCors_u24lambda_u2d8.setInitParameter("allowedOrigins", "*");
        $this$enableCors_u24lambda_u2d8.setInitParameter("Access-Control-Allow-Origin", "*");
        $this$enableCors_u24lambda_u2d8.setInitParameter("allowedMethods", "GET,POST");
        $this$enableCors_u24lambda_u2d8.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
    }

    public static /* synthetic */ void enableCors$default(ServletContextHandler servletContextHandler, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/*";
        }
        JettyHelpers.enableCors(servletContextHandler, string);
    }

    public static final void addServlet(@NotNull Server $this$addServlet, @NotNull ServletHolder servlet, @NotNull String pathSpec) {
        Intrinsics.checkNotNullParameter($this$addServlet, "<this>");
        Intrinsics.checkNotNullParameter(servlet, "servlet");
        Intrinsics.checkNotNullParameter(pathSpec, "pathSpec");
        JettyHelpers.getServletContextHandler($this$addServlet).addServlet(servlet, pathSpec);
    }

    private static final void createJettyServer$lambda-1$lambda-0(Connector connector, HttpConfiguration httpConfiguration, Request request) {
        if (StringsKt.equals(request.getMethod(), "TRACE", true)) {
            request.setHandled(true);
            request.getResponse().setStatus(405);
        }
    }
}

