/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge.colibri;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.bridge.colibri.ParticipantInfo;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.Source;
import org.jitsi.jicofo.conference.source.SsrcGroup;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.packet.IQ;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001\u001a*\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\t0\u000eH\u0000\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"SSRC_OWNER_JVB", "", "parseSources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifiedIQ;", "parseTransport", "Lorg/jitsi/xmpp/extensions/colibri2/Transport;", "endpointId", "sendIqAndHandleResponseAsync", "", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "iq", "Lorg/jivesoftware/smack/packet/IQ;", "block", "Lkotlin/Function1;", "toColibriMediaSources", "Lorg/jitsi/xmpp/extensions/colibri2/Sources;", "Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "toEndpoint", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Endpoint$Builder;", "Lorg/jitsi/jicofo/bridge/colibri/ParticipantInfo;", "create", "", "expire", "jicofo-selector"})
public final class ExtensionsKt {
    @NotNull
    public static final String SSRC_OWNER_JVB = "jvb";

    @Nullable
    public static final Transport parseTransport(@NotNull ConferenceModifiedIQ $this$parseTransport, @NotNull String endpointId) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter($this$parseTransport, "<this>");
            Intrinsics.checkNotNullParameter(endpointId, "endpointId");
            List<Colibri2Endpoint> list = $this$parseTransport.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "endpoints");
            Iterable iterable = list;
            for (Object t : iterable) {
                Colibri2Endpoint it = (Colibri2Endpoint)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), endpointId)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        Colibri2Endpoint colibri2Endpoint = v1;
        return colibri2Endpoint != null ? colibri2Endpoint.getTransport() : null;
    }

    @NotNull
    public static final ConferenceSourceMap parseSources(@NotNull ConferenceModifiedIQ $this$parseSources) {
        ConferenceSourceMap parsedSources;
        block3: {
            Intrinsics.checkNotNullParameter($this$parseSources, "<this>");
            parsedSources = new ConferenceSourceMap(null, 1, null);
            Object object = $this$parseSources.getSources();
            if (object == null || (object = ((Sources)object).getMediaSources()) == null) break block3;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaSource mediaSource = (MediaSource)element$iv;
                boolean bl = false;
                List<SourcePacketExtension> list = mediaSource.getSources();
                Intrinsics.checkNotNullExpressionValue(list, "mediaSource.sources");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SourcePacketExtension sourcePacketExtension = (SourcePacketExtension)element$iv2;
                    boolean bl2 = false;
                    String msid = "mixedmslabel mixedlabel" + mediaSource.getType() + "0";
                    long l = sourcePacketExtension.getSSRC();
                    MediaType mediaType = mediaSource.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, "mediaSource.type");
                    Source source = new Source(l, mediaType, sourcePacketExtension.getName(), msid, null, 16, null);
                    parsedSources.add(SSRC_OWNER_JVB, new EndpointSourceSet(source));
                }
                List<SourceGroupPacketExtension> list2 = mediaSource.getSsrcGroups();
                Intrinsics.checkNotNullExpressionValue(list2, "mediaSource.ssrcGroups");
                $this$forEach$iv2 = list2;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SourceGroupPacketExtension it = (SourceGroupPacketExtension)element$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    MediaType mediaType = mediaSource.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, "mediaSource.type");
                    parsedSources.add(SSRC_OWNER_JVB, new EndpointSourceSet(SsrcGroup.Companion.fromPacketExtension(it, mediaType)));
                }
            }
        }
        return parsedSources;
    }

    @NotNull
    public static final Sources toColibriMediaSources(@NotNull EndpointSourceSet $this$toColibriMediaSources, @NotNull String endpointId) {
        Intrinsics.checkNotNullParameter($this$toColibriMediaSources, "<this>");
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Map mediaSources = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$toColibriMediaSources.getSources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaSource.Builder mediaSource;
            Source source = (Source)element$iv;
            boolean bl = false;
            String string = source.getName();
            if (string == null) {
                string = Source.Companion.nameForIdAndMediaType(endpointId, source.getMediaType(), 0);
            }
            String sourceId = string;
            Intrinsics.checkNotNullExpressionValue(mediaSources.computeIfAbsent(sourceId, arg_0 -> ExtensionsKt.toColibriMediaSources$lambda-5$lambda-4(source, sourceId, arg_0)), "mediaSources.computeIfAb\u2026setId(sourceId)\n        }");
            mediaSource.addSource(Source.toPacketExtension$default(source, null, false, 1, null));
        }
        $this$forEach$iv = $this$toColibriMediaSources.getSsrcGroups();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaSource.Builder mediaSource;
            Source firstSource;
            Object v1;
            SsrcGroup ssrcGroup;
            block7: {
                ssrcGroup = (SsrcGroup)element$iv;
                boolean bl = false;
                if (ssrcGroup.getSsrcs().isEmpty()) continue;
                Iterable $this$firstOrNull$iv = $this$toColibriMediaSources.getSources();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Source it = (Source)element$iv2;
                    boolean bl2 = false;
                    if (!ssrcGroup.getSsrcs().contains(it.getSsrc())) continue;
                    v1 = element$iv2;
                    break block7;
                }
                v1 = null;
            }
            if ((Source)v1 == null) {
                throw new IllegalStateException("An SsrcGroup in an EndpointSourceSet has an SSRC without a Source");
            }
            String string = firstSource.getName();
            if (string == null) {
                string = Source.Companion.nameForIdAndMediaType(endpointId, ssrcGroup.getMediaType(), 0);
            }
            String sourceId = string;
            Intrinsics.checkNotNullExpressionValue(mediaSources.computeIfAbsent(sourceId, arg_0 -> ExtensionsKt.toColibriMediaSources$lambda-8$lambda-7(ssrcGroup, sourceId, arg_0)), "mediaSources.computeIfAb\u2026setId(sourceId)\n        }");
            mediaSource.addSsrcGroup(ssrcGroup.toPacketExtension());
        }
        Sources.Builder builder = Sources.getBuilder();
        Intrinsics.checkNotNullExpressionValue(builder, "getBuilder()");
        Sources.Builder sources = builder;
        Iterable $this$forEach$iv2 = mediaSources.values();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            MediaSource.Builder it = (MediaSource.Builder)element$iv;
            boolean bl = false;
            sources.addMediaSource(it.build());
        }
        Sources sources2 = sources.build();
        Intrinsics.checkNotNullExpressionValue(sources2, "sources.build()");
        return sources2;
    }

    @NotNull
    public static final Colibri2Endpoint.Builder toEndpoint(@NotNull ParticipantInfo $this$toEndpoint, boolean create, boolean expire2) {
        Colibri2Endpoint.Builder builder;
        Intrinsics.checkNotNullParameter($this$toEndpoint, "<this>");
        Colibri2Endpoint.Builder builder2 = Colibri2Endpoint.getBuilder();
        Intrinsics.checkNotNullExpressionValue(builder2, "getBuilder()");
        Colibri2Endpoint.Builder $this$toEndpoint_u24lambda_u2d10 = builder = builder2;
        boolean bl = false;
        $this$toEndpoint_u24lambda_u2d10.setId($this$toEndpoint.getId());
        if (create) {
            $this$toEndpoint_u24lambda_u2d10.setCreate(true);
            $this$toEndpoint_u24lambda_u2d10.setStatsId($this$toEndpoint.getStatsId());
            if ($this$toEndpoint.getSupportsSourceNames()) {
                $this$toEndpoint_u24lambda_u2d10.addCapability("source-names");
            }
            if ($this$toEndpoint.getUseSsrcRewriting()) {
                $this$toEndpoint_u24lambda_u2d10.addCapability("ssrc-rewriting");
            }
        }
        if (!expire2) {
            $this$toEndpoint_u24lambda_u2d10.setSources(ExtensionsKt.toColibriMediaSources($this$toEndpoint.getSources(), $this$toEndpoint.getId()));
        }
        if (expire2) {
            $this$toEndpoint_u24lambda_u2d10.setExpire(true);
        }
        return builder;
    }

    public static final void sendIqAndHandleResponseAsync(@NotNull AbstractXMPPConnection $this$sendIqAndHandleResponseAsync, @NotNull IQ iq, @NotNull Function1<? super IQ, Unit> block) {
        Intrinsics.checkNotNullParameter($this$sendIqAndHandleResponseAsync, "<this>");
        Intrinsics.checkNotNullParameter(iq, "iq");
        Intrinsics.checkNotNullParameter(block, "block");
        StanzaCollector stanzaCollector = $this$sendIqAndHandleResponseAsync.createStanzaCollectorAndSend(iq);
        TaskPools.Companion.getIoPool().submit(() -> ExtensionsKt.sendIqAndHandleResponseAsync$lambda-11(block, stanzaCollector));
    }

    private static final MediaSource.Builder toColibriMediaSources$lambda-5$lambda-4(Source $source, String $sourceId, String it) {
        Intrinsics.checkNotNullParameter($source, "$source");
        Intrinsics.checkNotNullParameter($sourceId, "$sourceId");
        Intrinsics.checkNotNullParameter(it, "it");
        return MediaSource.getBuilder().setType($source.getMediaType()).setId($sourceId);
    }

    private static final MediaSource.Builder toColibriMediaSources$lambda-8$lambda-7(SsrcGroup $ssrcGroup, String $sourceId, String it) {
        Intrinsics.checkNotNullParameter($ssrcGroup, "$ssrcGroup");
        Intrinsics.checkNotNullParameter($sourceId, "$sourceId");
        Intrinsics.checkNotNullParameter(it, "it");
        return MediaSource.getBuilder().setType($ssrcGroup.getMediaType()).setId($sourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendIqAndHandleResponseAsync$lambda-11(Function1 $block, StanzaCollector $stanzaCollector) {
        Intrinsics.checkNotNullParameter($block, "$block");
        try {
            $block.invoke($stanzaCollector.nextResult());
        }
        finally {
            $stanzaCollector.cancel();
        }
    }
}

