/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PolicyEditorAboutDialog
extends JFrame {
    private final String content;
    private final JScrollPane scrollPane = new JScrollPane();
    private final JTextPane textArea = new JTextPane();
    private final JPanel noWrapPanel = new JPanel();
    private final JButton closeButton = new JButton(Translator.R("ButClose"));
    private final ActionListener closeButtonAction;
    private final KeyListener closeKeyListener;

    public PolicyEditorAboutDialog(String title, String content) {
        super(title);
        this.content = content;
        this.setupLayout();
        this.closeButtonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyEditorAboutDialog.this.close();
            }
        };
        this.closeButton.addActionListener(this.closeButtonAction);
        this.closeKeyListener = new CloseKeyListener();
        this.scrollPane.addKeyListener(this.closeKeyListener);
        this.textArea.addKeyListener(this.closeKeyListener);
        this.noWrapPanel.addKeyListener(this.closeKeyListener);
        this.closeButton.addKeyListener(this.closeKeyListener);
        this.setDefaultCloseOperation(2);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        this.textArea.setEditorKit(new HTMLEditorKit());
        this.textArea.setContentType("text/html");
        this.textArea.setText(this.content);
        this.textArea.setEditable(false);
        this.textArea.addHyperlinkListener(new UrlHyperlinkListener());
        this.noWrapPanel.setLayout(new BorderLayout());
        this.noWrapPanel.add((Component)this.textArea, "Center");
        this.scrollPane.setViewportView(this.textArea);
        this.textArea.setCaretPosition(0);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 3;
        panelConstraints.weighty = 1.0;
        panelConstraints.fill = 1;
        EmptyBorder scrollPaneBorder = new EmptyBorder(5, 5, 5, 5);
        this.scrollPane.setBorder(scrollPaneBorder);
        EmptyBorder textAreaBorder = new EmptyBorder(0, 10, 10, 10);
        this.textArea.setBorder(textAreaBorder);
        this.add((Component)this.scrollPane, panelConstraints);
        GridBagConstraints closeButtonConstraints = new GridBagConstraints();
        closeButtonConstraints.weightx = 1.0;
        closeButtonConstraints.weighty = 0.0;
        closeButtonConstraints.gridx = 1;
        closeButtonConstraints.gridy = 1;
        closeButtonConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.closeButton, closeButtonConstraints);
        this.setMinimumSize(new Dimension(500, 400));
        this.setPreferredSize(this.getMinimumSize());
        this.pack();
    }

    public static void main(String[] args) {
        PolicyEditorAboutDialog dialog = new PolicyEditorAboutDialog(Translator.R("PEHelpDialogTitle"), Translator.R("PEHelpDialogContent"));
        dialog.setVisible(true);
    }

    private static class UrlHyperlinkListener
    implements HyperlinkListener {
        private UrlHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (Desktop.isDesktopSupported() && event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(event.getURL().toURI());
                }
                catch (IOException | URISyntaxException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        }
    }

    private class CloseKeyListener
    implements KeyListener {
        private CloseKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getExtendedKeyCode() == KeyStroke.getKeyStroke(Translator.R("PEAboutPolicyEditorCloseAccelerator")).getKeyCode() || e.getExtendedKeyCode() == 27) {
                PolicyEditorAboutDialog.this.close();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

