/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.Parser;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.runtime.html.AppletExtractor;
import net.sourceforge.jnlp.runtime.html.ElementValidator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AppletParser {
    private static final String[] PARAMS = new String[]{"param", "PARAM", "Param"};
    private final Element source;
    private final URL docBase;

    public AppletParser(Element applet, URL docbase) {
        this.source = applet;
        this.docBase = docbase;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("width: ").append(this.source.getAttribute("width")).append("\n");
        sb.append("height: ").append(this.source.getAttribute("height")).append("\n");
        sb.append("codebase: ").append(this.source.getAttribute("codebase")).append("\n");
        sb.append("code: ").append(this.source.getAttribute("code")).append("\n");
        sb.append("archive: ").append(this.source.getAttribute("archive")).append("\n");
        sb.append("data: ").append(this.source.getAttribute("data")).append("\n");
        List<Element> found = this.findParams();
        sb.append("params: ").append(found.size()).append("\n");
        for (Element element : found) {
            sb.append("param: ").append(element.getAttribute("name")).append("=").append(element.getAttribute("value")).append("\n");
        }
        return sb.toString();
    }

    public PluginBridge toPluginBridge() throws Exception {
        return new PluginBridge(this.createCodebase(), this.docBase, this.getArchives(), this.getMain(), new Integer(AppletParser.sanitizeSize(this.source.getAttribute("width"))), new Integer(AppletParser.sanitizeSize(this.source.getAttribute("height"))), this.createParams());
    }

    private URL createCodebase() throws ParseException, MalformedURLException {
        URL u;
        String inHtmlCodebase = this.source.getAttribute("codebase");
        if (inHtmlCodebase != null && inHtmlCodebase.trim().isEmpty()) {
            inHtmlCodebase = ".";
        }
        if (!(u = Parser.getURL(inHtmlCodebase, "In html " + this.source.getNodeName() + "'s codebase", this.docBase, false)).toExternalForm().endsWith("/")) {
            u = new URL(u.toExternalForm() + "/");
        }
        return u;
    }

    private PluginParameters createParams() {
        HashMap<String, String> data = new HashMap<String, String>();
        List<Element> found = this.findParams();
        for (Element element : found) {
            data.put(element.getAttribute("name"), element.getAttribute("value"));
        }
        if (data.get("jnlp_href") == null && data.get("code") == null && data.get("object") == null) {
            data.put("code", this.source.getAttribute("code"));
        }
        NamedNodeMap atts = this.source.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.item(i).getNodeName();
            String value = atts.item(i).getTextContent();
            if (name.trim().equalsIgnoreCase("width") || name.trim().equalsIgnoreCase("height")) {
                value = AppletParser.sanitizeSize(value);
            }
            data.put(name, value);
        }
        return new PluginParameters(data);
    }

    private List<Element> findParams() {
        return AppletExtractor.findElements(PARAMS, this.source, new ElementValidator(){

            @Override
            public boolean isElementValid(Element e) {
                return true;
            }
        });
    }

    private String getMain() {
        String s = this.source.getAttribute("code");
        if (s == null || s.trim().length() == 0) {
            List<Element> found = this.findParams();
            for (Element element : found) {
                if (!element.getAttribute("name").equalsIgnoreCase("code")) continue;
                s = element.getAttribute("value");
                break;
            }
        }
        if ((s == null || s.trim().length() == 0) && (s = this.source.getAttribute("classid")) != null && s.contains(":")) {
            s = s.split(":")[1];
        }
        return s;
    }

    private String getArchives() {
        String s = this.source.getAttribute("archive");
        if (s == null || s.trim().length() == 0) {
            List<Element> found = this.findParams();
            for (Element element : found) {
                if (!element.getAttribute("name").equalsIgnoreCase("archive")) continue;
                s = element.getAttribute("value");
                break;
            }
        }
        return s;
    }

    static String sanitizeSize(String attribute) {
        if (attribute == null) {
            return "1";
        }
        return attribute.replaceAll("[^0-9]+", "");
    }
}

