/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.common.io.sza.AnimationEvent;
import net.sf.freecol.common.io.sza.ImageAnimationEvent;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class UnitImageAnimation {
    private final SwingGUI gui;
    private final Unit unit;
    private final Tile tile;
    private final SimpleZippedAnimation animation;
    private final boolean mirror;

    public UnitImageAnimation(SwingGUI gui, Unit unit, Tile tile, SimpleZippedAnimation animation, boolean mirror) {
        this.gui = gui;
        this.unit = unit;
        this.tile = tile;
        this.animation = animation;
        this.mirror = mirror;
    }

    public void animate() {
        if (this.gui.getTilePosition(this.tile) == null) {
            return;
        }
        this.gui.paintImmediatelyCanvasInItsBounds();
        this.gui.executeWithUnitOutForAnimation(this.unit, this.tile, unitLabel -> {
            for (AnimationEvent event : this.animation) {
                long time = System.nanoTime();
                if (!(event instanceof ImageAnimationEvent)) continue;
                ImageAnimationEvent ievent = (ImageAnimationEvent)event;
                ImageIcon icon = (ImageIcon)unitLabel.getIcon();
                Image image = ievent.getImage();
                if (this.mirror) {
                    image = ImageLibrary.createMirroredImage(image);
                }
                icon.setImage(image);
                this.gui.paintImmediatelyCanvasIn(this.getDirtyAnimationArea());
                time = (long)ievent.getDurationInMs() - (System.nanoTime() - time) / 1000000L;
                if (time <= 0L) continue;
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    protected Rectangle getDirtyAnimationArea() {
        return this.gui.getTileBounds(this.tile);
    }
}

