/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class RecentMenu
extends JMenu {
    private static final Logger logger = Logger.getLogger(RecentMenu.class);
    public static final int DEFAULT_MAX_RECENT_FILES = 5;
    private final int maxRecentFiles;
    private static final String PREFS_KEY = "recentFile";
    private List<String> recentFileNames = new ArrayList<String>();
    final Preferences prefs;
    private ActionListener recentOpener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            try {
                RecentMenu.this.openFile(mi.getText());
            }
            catch (IOException e1) {
                SPSUtils.showExceptionDialogNoReport(Messages.getString("RecentMenu.couldNotOpenFile"), e1);
            }
        }
    };
    private PreferenceChangeListener recentListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            logger.debug((Object)"Called from pref change");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RecentMenu.this.loadRecentMenu();
                }
            });
        }
    };

    public RecentMenu(Class<?> mainClass, int max) {
        super(Messages.getString("RecentMenu.recentItems"));
        this.prefs = RecentMenu.getUserPrefsNode(mainClass);
        this.prefs.addPreferenceChangeListener(this.recentListener);
        this.maxRecentFiles = max;
        logger.debug((Object)"Called from Recent menu constructor");
        this.loadRecentMenu();
    }

    public static Preferences getUserPrefsNode(Class<?> mainClass) {
        return Preferences.userNodeForPackage(mainClass);
    }

    public RecentMenu(Class<?> mainClass) {
        this(mainClass, 5);
    }

    public void openFile(String fileName) throws IOException {
        this.loadFile(fileName);
        this.putRecentFileName(fileName);
    }

    public abstract void loadFile(String var1) throws IOException;

    public void putRecentFileName(String f) {
        String file;
        int i;
        this.recentFileNames.clear();
        for (i = 0; i < this.maxRecentFiles && (file = this.prefs.get(PREFS_KEY + i, null)) != null && !file.equals("Clear Recent Items"); ++i) {
            if (!new File(file).exists()) continue;
            if (this.recentFileNames.contains(file)) {
                this.recentFileNames.remove(file);
            }
            this.recentFileNames.add(file);
        }
        if (this.recentFileNames.contains(f)) {
            this.recentFileNames.remove(f);
        }
        while (this.recentFileNames.size() > this.maxRecentFiles - 1) {
            this.recentFileNames.remove(this.recentFileNames.size() - 1);
        }
        this.recentFileNames.add(0, f);
        for (i = 0; i < this.recentFileNames.size(); ++i) {
            String t = this.recentFileNames.get(i);
            logger.debug((Object)("put " + t));
            this.prefs.put(PREFS_KEY + i, t);
        }
        logger.debug((Object)"Called from putFileName");
        this.loadRecentMenu();
    }

    public void loadRecentMenu() {
        String f;
        this.recentFileNames.clear();
        this.setEnabled(false);
        this.removeAll();
        for (int i = 0; i < this.maxRecentFiles && (f = this.prefs.get(PREFS_KEY + i, null)) != null && !f.equals("Clear Recent Items"); ++i) {
            if (!new File(f).exists()) continue;
            this.setEnabled(true);
            JMenuItem mi = new JMenuItem(f);
            this.add(mi);
            mi.addActionListener(this.recentOpener);
            this.recentFileNames.add(f);
        }
        this.addSeparator();
        JMenuItem clearItem = new JMenuItem(Messages.getString("RecentMenu.clearRecentFiles"));
        clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentMenu.this.clear();
            }
        });
        this.recentFileNames.add("Clear Recent Items");
        this.add(clearItem);
    }

    public void clear() {
        for (int i = 0; i < this.maxRecentFiles; ++i) {
            this.prefs.remove(PREFS_KEY + i);
        }
        this.loadRecentMenu();
    }

    public File getMostRecentFile() {
        if (this.recentFileNames.size() > 0) {
            String mostRecentPath = this.recentFileNames.get(0);
            return new File(mostRecentPath);
        }
        return null;
    }
}

