/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.BaseDataHandler;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Position;

@Singleton
@ChannelHandler.Sharable
public class HemisphereHandler
extends BaseDataHandler {
    private int latitudeFactor;
    private int longitudeFactor;

    @Inject
    public HemisphereHandler(Config config) {
        String longitudeHemisphere;
        String latitudeHemisphere = config.getString(Keys.LOCATION_LATITUDE_HEMISPHERE);
        if (latitudeHemisphere != null) {
            if (latitudeHemisphere.equalsIgnoreCase("N")) {
                this.latitudeFactor = 1;
            } else if (latitudeHemisphere.equalsIgnoreCase("S")) {
                this.latitudeFactor = -1;
            }
        }
        if ((longitudeHemisphere = config.getString(Keys.LOCATION_LONGITUDE_HEMISPHERE)) != null) {
            if (longitudeHemisphere.equalsIgnoreCase("E")) {
                this.longitudeFactor = 1;
            } else if (longitudeHemisphere.equalsIgnoreCase("W")) {
                this.longitudeFactor = -1;
            }
        }
    }

    @Override
    protected Position handlePosition(Position position) {
        if (this.latitudeFactor != 0) {
            position.setLatitude(Math.abs(position.getLatitude()) * (double)this.latitudeFactor);
        }
        if (this.longitudeFactor != 0) {
            position.setLongitude(Math.abs(position.getLongitude()) * (double)this.longitudeFactor);
        }
        return position;
    }
}

