/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateComponent;
import com.damnhandy.uri.template.impl.Modifier;
import com.damnhandy.uri.template.impl.Operator;
import com.damnhandy.uri.template.impl.VarSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Expression
extends UriTemplateComponent {
    private static final long serialVersionUID = -5305648325957481840L;
    private String replacementPattern;
    private Operator op;
    private final int location;
    private List<VarSpec> varSpecs;
    private Pattern matchPattern;

    public static Builder simple(VarSpec ... varSpec) {
        return Builder.create(Operator.NUL, varSpec);
    }

    public static Builder reserved(VarSpec ... varSpec) {
        return Builder.create(Operator.RESERVED, varSpec);
    }

    public static Builder fragment(VarSpec ... varSpec) {
        return Builder.create(Operator.FRAGMENT, varSpec);
    }

    public static Builder label(VarSpec ... varSpec) {
        return Builder.create(Operator.NAME_LABEL, varSpec);
    }

    public static Builder path(VarSpec ... varSpec) {
        return Builder.create(Operator.PATH, varSpec);
    }

    public static Builder matrix(VarSpec ... varSpec) {
        return Builder.create(Operator.MATRIX, varSpec);
    }

    public static Builder query(VarSpec ... varSpec) {
        return Builder.create(Operator.QUERY, varSpec);
    }

    public static Builder continuation(VarSpec ... varSpec) {
        return Builder.create(Operator.CONTINUATION, varSpec);
    }

    public Expression(String rawExpression, int startPosition) throws MalformedUriTemplateException {
        super(startPosition);
        this.location = startPosition;
        this.parseRawExpression(rawExpression);
    }

    public Expression(Operator op, List<VarSpec> varSpecs) {
        super(0);
        this.op = op;
        this.varSpecs = varSpecs;
        this.replacementPattern = Pattern.quote(this.toString());
        this.location = 0;
    }

    private void parseRawExpression(String rawExpression) throws MalformedUriTemplateException {
        String expressionReplacement = Pattern.quote(rawExpression);
        String token = rawExpression.substring(1, rawExpression.length() - 1);
        Operator operator = Operator.NUL;
        String firstChar = token.substring(0, 1);
        if (UriTemplate.containsOperator(firstChar)) {
            try {
                operator = Operator.fromOpCode(firstChar);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedUriTemplateException("Invalid operator", this.location, e);
            }
            token = token.substring(1, token.length());
        }
        String[] varspecStrings = token.split(",");
        ArrayList<VarSpec> varspecs = new ArrayList<VarSpec>();
        for (String varname : varspecStrings) {
            int subStrPos = varname.indexOf(Modifier.PREFIX.getValue());
            if (subStrPos > 0) {
                String[] pair = varname.split(Modifier.PREFIX.getValue());
                try {
                    Integer pos = Integer.valueOf(varname.substring(subStrPos + 1));
                    varspecs.add(new VarSpec(pair[0], Modifier.PREFIX, pos));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new MalformedUriTemplateException("The prefix value for " + pair[0] + " was not a number", this.location, e);
                }
            }
            if (varname.lastIndexOf(Modifier.EXPLODE.getValue()) > 0) {
                varspecs.add(new VarSpec(varname, Modifier.EXPLODE));
                continue;
            }
            varspecs.add(new VarSpec(varname, Modifier.NONE));
        }
        this.replacementPattern = expressionReplacement;
        this.op = operator;
        this.varSpecs = varspecs;
    }

    private Pattern buildMatchingPattern() {
        StringBuilder b = new StringBuilder();
        for (VarSpec v : this.getVarSpecs()) {
            b.append("(?<").append(v.getVariableName()).append(">[^\\/]+)");
        }
        return Pattern.compile(b.toString());
    }

    @Override
    public Pattern getMatchPattern() {
        if (this.matchPattern == null) {
            this.matchPattern = this.buildMatchingPattern();
        }
        return this.matchPattern;
    }

    public String getReplacementPattern() {
        return this.replacementPattern;
    }

    public Operator getOperator() {
        return this.op;
    }

    public List<VarSpec> getVarSpecs() {
        return this.varSpecs;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{").append(this.getOperator().getOperator());
        for (int i = 0; i < this.varSpecs.size(); ++i) {
            VarSpec v = this.varSpecs.get(i);
            b.append(v.getValue());
            int r = v.getValue().lastIndexOf(v.getModifier().getValue());
            if (v.getModifier() != null && v.getValue().lastIndexOf(v.getModifier().getValue()) == -1) {
                b.append(v.getModifier().getValue());
            }
            if (v.getModifier() == Modifier.PREFIX) {
                b.append(v.getPosition());
            }
            if (i == this.varSpecs.size() - 1) continue;
            b.append(",");
        }
        return b.append("}").toString();
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + (this.varSpecs == null ? 0 : this.varSpecs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        if (this.op != other.op) {
            return false;
        }
        return !(this.varSpecs == null ? other.varSpecs != null : !this.varSpecs.equals(other.varSpecs));
    }

    public static class Builder {
        private Operator operator;
        private List<VarSpec> varSpecs;

        private Builder(Operator operator, VarSpec ... varSpec) {
            this.operator = operator;
            this.varSpecs = new ArrayList<VarSpec>();
            for (VarSpec v : varSpec) {
                this.varSpecs.add(v);
            }
        }

        static Builder create(Operator operator, VarSpec ... varSpec) {
            return new Builder(operator, varSpec);
        }

        public Expression build() {
            return new Expression(this.operator, this.varSpecs);
        }
    }
}

