/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EllipticCurvesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.EllipticCurvesExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EllipticCurvesExtensionPreparator
extends ExtensionPreparator<EllipticCurvesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EllipticCurvesExtensionMessage msg;

    public EllipticCurvesExtensionPreparator(Chooser chooser, EllipticCurvesExtensionMessage message, EllipticCurvesExtensionSerializer serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing EllipticCurvesExtensionMessage");
        this.prepareSupportedGroups(this.msg);
        this.prepareSupportedGroupsLength(this.msg);
    }

    private void prepareSupportedGroups(EllipticCurvesExtensionMessage msg) {
        msg.setSupportedGroups(this.createNamedGroupsArray());
        LOGGER.debug("SupportedGroups: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSupportedGroups().getValue())));
    }

    private byte[] createNamedGroupsArray() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        List<NamedGroup> namedGroups = this.chooser.getTalkingConnectionEnd() == ConnectionEndType.CLIENT ? this.chooser.getConfig().getDefaultClientNamedGroups() : this.chooser.getConfig().getDefaultServerNamedGroups();
        for (NamedGroup group : namedGroups) {
            try {
                stream.write(group.getValue());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not write NamedGroup to byte[]", ex);
            }
        }
        return stream.toByteArray();
    }

    private void prepareSupportedGroupsLength(EllipticCurvesExtensionMessage msg) {
        msg.setSupportedGroupsLength(((byte[])msg.getSupportedGroups().getValue()).length);
        LOGGER.debug("SupportedGroupsLength: " + msg.getSupportedGroupsLength().getValue());
    }
}

