/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextKnnVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.RandomAccessVectorValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;

public class SimpleTextKnnVectorsReader
extends KnnVectorsReader {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextKnnVectorsReader.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    private static final BytesRef EMPTY = new BytesRef((CharSequence)"");
    private final SegmentReadState readState;
    private final IndexInput dataIn;
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private final Map<String, FieldEntry> fieldEntries = new HashMap<String, FieldEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SimpleTextKnnVectorsReader(SegmentReadState readState) throws IOException {
        this.readState = readState;
        String metaFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"gri");
        String vectorFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"vec");
        boolean success = false;
        try {
            try (ChecksumIndexInput in = readState.directory.openChecksumInput(metaFileName, IOContext.DEFAULT);){
                int fieldNumber = this.readInt((IndexInput)in, SimpleTextKnnVectorsWriter.FIELD_NUMBER);
                while (fieldNumber != -1) {
                    String fieldName = this.readString((IndexInput)in, SimpleTextKnnVectorsWriter.FIELD_NAME);
                    long vectorDataOffset = this.readLong((IndexInput)in, SimpleTextKnnVectorsWriter.VECTOR_DATA_OFFSET);
                    long vectorDataLength = this.readLong((IndexInput)in, SimpleTextKnnVectorsWriter.VECTOR_DATA_LENGTH);
                    int dimension = this.readInt((IndexInput)in, SimpleTextKnnVectorsWriter.VECTOR_DIMENSION);
                    int size = this.readInt((IndexInput)in, SimpleTextKnnVectorsWriter.SIZE);
                    int[] docIds = new int[size];
                    for (int i = 0; i < size; ++i) {
                        docIds[i] = this.readInt((IndexInput)in, EMPTY);
                    }
                    assert (!this.fieldEntries.containsKey(fieldName));
                    this.fieldEntries.put(fieldName, new FieldEntry(dimension, vectorDataOffset, vectorDataLength, docIds));
                    fieldNumber = this.readInt((IndexInput)in, SimpleTextKnnVectorsWriter.FIELD_NUMBER);
                }
                SimpleTextUtil.checkFooter(in);
                this.dataIn = readState.directory.openInput(vectorFileName, IOContext.DEFAULT);
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
    }

    public VectorValues getVectorValues(String field) throws IOException {
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        if (info == null) {
            return null;
        }
        int dimension = info.getVectorDimension();
        if (dimension == 0) {
            return VectorValues.EMPTY;
        }
        FieldEntry fieldEntry = this.fieldEntries.get(field);
        if (fieldEntry == null) {
            return null;
        }
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + field + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        IndexInput bytesSlice = this.dataIn.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new SimpleTextVectorValues(fieldEntry, bytesSlice);
    }

    public TopDocs search(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        int doc;
        VectorValues values = this.getVectorValues(field);
        if (target.length != values.dimension()) {
            throw new IllegalArgumentException("vector dimensions differ: " + target.length + "!=" + values.dimension());
        }
        FieldInfo info = this.readState.fieldInfos.fieldInfo(field);
        VectorSimilarityFunction vectorSimilarity = info.getVectorSimilarityFunction();
        HitQueue topK = new HitQueue(k, false);
        int numVisited = 0;
        TotalHits.Relation relation = TotalHits.Relation.EQUAL_TO;
        while ((doc = values.nextDoc()) != Integer.MAX_VALUE) {
            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
            if (numVisited >= visitedLimit) {
                relation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                break;
            }
            float[] vector = values.vectorValue();
            float score = vectorSimilarity.compare(vector, target);
            topK.insertWithOverflow((Object)new ScoreDoc(doc, score));
            ++numVisited;
        }
        ScoreDoc[] topScoreDocs = new ScoreDoc[topK.size()];
        for (int i = topScoreDocs.length - 1; i >= 0; --i) {
            topScoreDocs[i] = (ScoreDoc)topK.pop();
        }
        return new TopDocs(new TotalHits((long)numVisited, relation), topScoreDocs);
    }

    public void checkIntegrity() throws IOException {
        IndexInput clone = this.dataIn.clone();
        clone.seek(0L);
        long footerStartPos = this.dataIn.length() - (long)(SimpleTextUtil.CHECKSUM.length + 21);
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(clone);
        if (footerStartPos == 0L) {
            SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
            return;
        }
        do {
            SimpleTextUtil.readLine((DataInput)input, this.scratch);
        } while (input.getFilePointer() < footerStartPos);
        if (input.getFilePointer() != footerStartPos) {
            throw new CorruptIndexException("SimpleText failure: footer does not start at expected position current=" + input.getFilePointer() + " vs expected=" + footerStartPos, (DataInput)input);
        }
        SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
    }

    public long ramBytesUsed() {
        long totalBytes = BASE_RAM_BYTES_USED;
        totalBytes += RamUsageEstimator.sizeOf((byte[])this.scratch.bytes());
        totalBytes += RamUsageEstimator.sizeOfMap(this.fieldEntries, (long)RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class));
        for (FieldEntry entry : this.fieldEntries.values()) {
            totalBytes += RamUsageEstimator.sizeOf((int[])entry.ordToDoc);
        }
        return totalBytes;
    }

    public void close() throws IOException {
        this.dataIn.close();
    }

    private int readInt(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine((DataInput)in, this.scratch);
        return this.parseInt(field);
    }

    private long readLong(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine((DataInput)in, this.scratch);
        return this.parseLong(field);
    }

    private String readString(IndexInput in, BytesRef field) throws IOException {
        SimpleTextUtil.readLine((DataInput)in, this.scratch);
        return this.stripPrefix(field);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)prefix);
    }

    private int parseInt(BytesRef prefix) {
        assert (this.startsWith(prefix));
        return Integer.parseInt(this.stripPrefix(prefix));
    }

    private long parseLong(BytesRef prefix) {
        assert (this.startsWith(prefix));
        return Long.parseLong(this.stripPrefix(prefix));
    }

    private String stripPrefix(BytesRef prefix) {
        int prefixLen = prefix.length;
        return new String(this.scratch.bytes(), prefixLen, this.scratch.length() - prefixLen, StandardCharsets.UTF_8);
    }

    private static class SimpleTextVectorValues
    extends VectorValues
    implements RandomAccessVectorValues,
    RandomAccessVectorValuesProducer {
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final FieldEntry entry;
        private final IndexInput in;
        private final BytesRef binaryValue;
        private final float[][] values;
        int curOrd;

        SimpleTextVectorValues(FieldEntry entry, IndexInput in) throws IOException {
            this.entry = entry;
            this.in = in;
            this.values = new float[entry.size()][entry.dimension];
            this.binaryValue = new BytesRef(entry.dimension * 4);
            this.binaryValue.length = this.binaryValue.bytes.length;
            this.curOrd = -1;
            this.readAllVectors();
        }

        public int dimension() {
            return this.entry.dimension;
        }

        public int size() {
            return this.entry.size();
        }

        public float[] vectorValue() {
            return this.values[this.curOrd];
        }

        public BytesRef binaryValue() {
            ByteBuffer.wrap(this.binaryValue.bytes).asFloatBuffer().get(this.values[this.curOrd]);
            return this.binaryValue;
        }

        public RandomAccessVectorValues randomAccess() {
            return this;
        }

        public int docID() {
            if (this.curOrd == -1) {
                return -1;
            }
            if (this.curOrd >= this.entry.size()) {
                return Integer.MAX_VALUE;
            }
            return this.entry.ordToDoc[this.curOrd];
        }

        public int nextDoc() throws IOException {
            if (++this.curOrd < this.entry.size()) {
                return this.docID();
            }
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public long cost() {
            return this.size();
        }

        private void readAllVectors() throws IOException {
            for (float[] value : this.values) {
                this.readVector(value);
            }
        }

        private void readVector(float[] value) throws IOException {
            SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
            String s = new BytesRef(this.scratch.bytes(), 1, this.scratch.length() - 2).utf8ToString();
            String[] floatStrings = s.split(",");
            assert (floatStrings.length == value.length) : " read " + s + " when expecting " + value.length + " floats";
            for (int i = 0; i < floatStrings.length; ++i) {
                value[i] = Float.parseFloat(floatStrings[i]);
            }
        }

        public float[] vectorValue(int targetOrd) throws IOException {
            return this.values[targetOrd];
        }

        public BytesRef binaryValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class FieldEntry {
        final int dimension;
        final long vectorDataOffset;
        final long vectorDataLength;
        final int[] ordToDoc;

        FieldEntry(int dimension, long vectorDataOffset, long vectorDataLength, int[] ordToDoc) {
            this.dimension = dimension;
            this.vectorDataOffset = vectorDataOffset;
            this.vectorDataLength = vectorDataLength;
            this.ordToDoc = ordToDoc;
        }

        int size() {
            return this.ordToDoc.length;
        }
    }
}

