/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.SolrQueryResponse;

public class RawResponseWriter
implements BinaryQueryResponseWriter {
    public static final String CONTENT = "content";
    private String _baseWriter = null;

    @Override
    public void init(NamedList<?> n) {
        Object base;
        if (n != null && (base = n.get("base")) != null) {
            this._baseWriter = base.toString();
        }
    }

    protected QueryResponseWriter getBaseWriter(SolrQueryRequest request) {
        return request.getCore().getQueryResponseWriter(this._baseWriter);
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        Object obj = response.getValues().get(CONTENT);
        if (obj != null && obj instanceof ContentStream) {
            return ((ContentStream)obj).getContentType();
        }
        return this.getBaseWriter(request).getContentType(request, response);
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        Object obj = response.getValues().get(CONTENT);
        if (obj != null && obj instanceof ContentStream) {
            ContentStream content = (ContentStream)obj;
            try (Reader reader = content.getReader();){
                reader.transferTo(writer);
            }
        } else {
            this.getBaseWriter(request).write(writer, request, response);
        }
    }

    @Override
    public void write(OutputStream out, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        Object obj = response.getValues().get(CONTENT);
        if (obj != null && obj instanceof ContentStream) {
            ContentStream content = (ContentStream)obj;
            try (InputStream in = content.getStream();){
                in.transferTo(out);
            }
        } else {
            QueryResponseWriterUtil.writeQueryResponse(out, this.getBaseWriter(request), request, response, this.getContentType(request, response));
        }
    }
}

