import { Document, DocumentEvent } from "../document";
import type { Patch } from "../document";
import { Message } from "../protocol/message";
import { ClientConnection } from "./connection";
export declare type OkMsg = Message<{}>;
export declare type ErrorMsg = Message<{
    text: string;
    traceback: string | null;
}>;
export declare type PatchMsg = Message<Patch>;
export declare class ClientSession {
    protected readonly _connection: ClientConnection;
    readonly document: Document;
    protected _document_listener: (event: DocumentEvent) => void;
    constructor(_connection: ClientConnection, document: Document);
    get id(): string;
    handle(message: Message<unknown>): void;
    close(): void;
    _connection_closed(): void;
    request_server_info(): Promise<{
        version_info: string;
    }>;
    force_roundtrip(): Promise<void>;
    protected _document_changed(event: DocumentEvent): void;
    protected _handle_patch(message: PatchMsg): void;
    protected _handle_ok(message: OkMsg): void;
    protected _handle_error(message: ErrorMsg): void;
}
//# sourceMappingURL=session.d.ts.map