/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 ^ (- abs(ivec2(38, 35)))) => ivec2(-42, -47)
 * (12 ^ (- abs(ivec2(64, -9)))) => ivec2(-52, -5)
 * (12 ^ (- abs(ivec2(64, 9)))) => ivec2(-52, -5)
 * (-6 ^ (- abs(ivec2(38, 35)))) => ivec2(32, 39)
 * (-6 ^ (- abs(ivec2(64, -9)))) => ivec2(58, 13)
 * (-6 ^ (- abs(ivec2(64, 9)))) => ivec2(58, 13)
 * (76 ^ (- abs(ivec2(38, 35)))) => ivec2(-106, -111)
 * (76 ^ (- abs(ivec2(64, -9)))) => ivec2(-116, -69)
 * (76 ^ (- abs(ivec2(64, 9)))) => ivec2(-116, -69)
 * (-32 ^ (- abs(ivec2(38, 35)))) => ivec2(58, 61)
 * (-32 ^ (- abs(ivec2(64, -9)))) => ivec2(32, 23)
 * (-32 ^ (- abs(ivec2(64, 9)))) => ivec2(32, 23)
 * (0 ^ (- abs(ivec2(38, 35)))) => ivec2(-38, -35)
 * (0 ^ (- abs(ivec2(64, -9)))) => ivec2(-64, -9)
 * (0 ^ (- abs(ivec2(64, 9)))) => ivec2(-64, -9)
 */
#version 150

void main()
{
  float[all(equal((12 ^ (- abs(ivec2(38, 35)))), ivec2(-42, -47))) ? 1 : -1] array0;
  float[all(equal((12 ^ (- abs(ivec2(64, -9)))), ivec2(-52, -5))) ? 1 : -1] array1;
  float[all(equal((12 ^ (- abs(ivec2(64, 9)))), ivec2(-52, -5))) ? 1 : -1] array2;
  float[all(equal((-6 ^ (- abs(ivec2(38, 35)))), ivec2(32, 39))) ? 1 : -1] array3;
  float[all(equal((-6 ^ (- abs(ivec2(64, -9)))), ivec2(58, 13))) ? 1 : -1] array4;
  float[all(equal((-6 ^ (- abs(ivec2(64, 9)))), ivec2(58, 13))) ? 1 : -1] array5;
  float[all(equal((76 ^ (- abs(ivec2(38, 35)))), ivec2(-106, -111))) ? 1 : -1] array6;
  float[all(equal((76 ^ (- abs(ivec2(64, -9)))), ivec2(-116, -69))) ? 1 : -1] array7;
  float[all(equal((76 ^ (- abs(ivec2(64, 9)))), ivec2(-116, -69))) ? 1 : -1] array8;
  float[all(equal((-32 ^ (- abs(ivec2(38, 35)))), ivec2(58, 61))) ? 1 : -1] array9;
  float[all(equal((-32 ^ (- abs(ivec2(64, -9)))), ivec2(32, 23))) ? 1 : -1] array10;
  float[all(equal((-32 ^ (- abs(ivec2(64, 9)))), ivec2(32, 23))) ? 1 : -1] array11;
  float[all(equal((0 ^ (- abs(ivec2(38, 35)))), ivec2(-38, -35))) ? 1 : -1] array12;
  float[all(equal((0 ^ (- abs(ivec2(64, -9)))), ivec2(-64, -9))) ? 1 : -1] array13;
  float[all(equal((0 ^ (- abs(ivec2(64, 9)))), ivec2(-64, -9))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
