/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryRequirements
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int MEMORYTYPEBITS;

    public VkMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryRequirements.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMemoryRequirements.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long alignment() {
        return VkMemoryRequirements.nalignment(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeBits() {
        return VkMemoryRequirements.nmemoryTypeBits(this.address());
    }

    public static VkMemoryRequirements malloc() {
        return (VkMemoryRequirements)VkMemoryRequirements.wrap(VkMemoryRequirements.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMemoryRequirements calloc() {
        return (VkMemoryRequirements)VkMemoryRequirements.wrap(VkMemoryRequirements.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMemoryRequirements)VkMemoryRequirements.wrap(VkMemoryRequirements.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMemoryRequirements create(long address) {
        return (VkMemoryRequirements)VkMemoryRequirements.wrap(VkMemoryRequirements.class, (long)address);
    }

    @Nullable
    public static VkMemoryRequirements createSafe(long address) {
        return address == 0L ? null : (VkMemoryRequirements)VkMemoryRequirements.wrap(VkMemoryRequirements.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMemoryRequirements.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMemoryRequirements.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMemoryRequirements.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryRequirements.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMemoryRequirements.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMemoryRequirements.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMemoryRequirements.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkMemoryRequirements mallocStack() {
        return VkMemoryRequirements.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryRequirements callocStack() {
        return VkMemoryRequirements.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryRequirements mallocStack(MemoryStack stack) {
        return (VkMemoryRequirements)VkMemoryRequirements.wrap(VkMemoryRequirements.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryRequirements callocStack(MemoryStack stack) {
        return (VkMemoryRequirements)VkMemoryRequirements.wrap(VkMemoryRequirements.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryRequirements.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryRequirements.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryRequirements.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryRequirements.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long nalignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALIGNMENT);
    }

    public static int nmemoryTypeBits(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPEBITS);
    }

    static {
        Struct.Layout layout = VkMemoryRequirements.__struct((Struct.Member[])new Struct.Member[]{VkMemoryRequirements.__member((int)8), VkMemoryRequirements.__member((int)8), VkMemoryRequirements.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        MEMORYTYPEBITS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkMemoryRequirements ELEMENT_FACTORY = VkMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMemoryRequirements.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long alignment() {
            return VkMemoryRequirements.nalignment(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeBits() {
            return VkMemoryRequirements.nmemoryTypeBits(this.address());
        }
    }
}

