/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceMemoryOpaqueCaptureAddressInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;

    public VkDeviceMemoryOpaqueCaptureAddressInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDeviceMemoryOpaqueCaptureAddressInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.npNext(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.nmemory(this.address());
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceMemoryOpaqueCaptureAddressInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceMemoryOpaqueCaptureAddressInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo memory(@NativeType(value="VkDeviceMemory") long value) {
        VkDeviceMemoryOpaqueCaptureAddressInfo.nmemory(this.address(), value);
        return this;
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo set(int sType, long pNext, long memory) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        return this;
    }

    public VkDeviceMemoryOpaqueCaptureAddressInfo set(VkDeviceMemoryOpaqueCaptureAddressInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo malloc() {
        return (VkDeviceMemoryOpaqueCaptureAddressInfo)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(VkDeviceMemoryOpaqueCaptureAddressInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo calloc() {
        return (VkDeviceMemoryOpaqueCaptureAddressInfo)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(VkDeviceMemoryOpaqueCaptureAddressInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDeviceMemoryOpaqueCaptureAddressInfo)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(VkDeviceMemoryOpaqueCaptureAddressInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo create(long address) {
        return (VkDeviceMemoryOpaqueCaptureAddressInfo)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(VkDeviceMemoryOpaqueCaptureAddressInfo.class, (long)address);
    }

    @Nullable
    public static VkDeviceMemoryOpaqueCaptureAddressInfo createSafe(long address) {
        return address == 0L ? null : (VkDeviceMemoryOpaqueCaptureAddressInfo)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(VkDeviceMemoryOpaqueCaptureAddressInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDeviceMemoryOpaqueCaptureAddressInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceMemoryOpaqueCaptureAddressInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo mallocStack() {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo callocStack() {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo mallocStack(MemoryStack stack) {
        return (VkDeviceMemoryOpaqueCaptureAddressInfo)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(VkDeviceMemoryOpaqueCaptureAddressInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceMemoryOpaqueCaptureAddressInfo callocStack(MemoryStack stack) {
        return (VkDeviceMemoryOpaqueCaptureAddressInfo)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(VkDeviceMemoryOpaqueCaptureAddressInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceMemoryOpaqueCaptureAddressInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceMemoryOpaqueCaptureAddressInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    static {
        Struct.Layout layout = VkDeviceMemoryOpaqueCaptureAddressInfo.__struct((Struct.Member[])new Struct.Member[]{VkDeviceMemoryOpaqueCaptureAddressInfo.__member((int)4), VkDeviceMemoryOpaqueCaptureAddressInfo.__member((int)POINTER_SIZE), VkDeviceMemoryOpaqueCaptureAddressInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceMemoryOpaqueCaptureAddressInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceMemoryOpaqueCaptureAddressInfo ELEMENT_FACTORY = VkDeviceMemoryOpaqueCaptureAddressInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDeviceMemoryOpaqueCaptureAddressInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceMemoryOpaqueCaptureAddressInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceMemoryOpaqueCaptureAddressInfo.npNext(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkDeviceMemoryOpaqueCaptureAddressInfo.nmemory(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceMemoryOpaqueCaptureAddressInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceMemoryOpaqueCaptureAddressInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkDeviceMemoryOpaqueCaptureAddressInfo.nmemory(this.address(), value);
            return this;
        }
    }
}

