/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkBufferDeviceAddressInfo;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceMemoryOpaqueCaptureAddressInfo;
import org.lwjgl.vulkan.VkRenderPassBeginInfo;
import org.lwjgl.vulkan.VkRenderPassCreateInfo2;
import org.lwjgl.vulkan.VkSemaphoreSignalInfo;
import org.lwjgl.vulkan.VkSemaphoreWaitInfo;
import org.lwjgl.vulkan.VkSubpassBeginInfo;
import org.lwjgl.vulkan.VkSubpassEndInfo;

public class VK12
extends VK10 {
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES = 49;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES = 50;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES = 51;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES = 52;
    public static final int VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO = 1000147000;
    public static final int VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE = 4;
    public static final int VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2 = 1000109000;
    public static final int VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2 = 1000109001;
    public static final int VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2 = 1000109002;
    public static final int VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2 = 1000109003;
    public static final int VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2 = 1000109004;
    public static final int VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO = 1000109005;
    public static final int VK_STRUCTURE_TYPE_SUBPASS_END_INFO = 1000109006;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES = 1000177000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES = 1000196000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES = 1000180000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES = 1000082000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES = 1000197000;
    public static final int VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO = 1000161000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES = 1000161001;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES = 1000161002;
    public static final int VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO = 1000161003;
    public static final int VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT = 1000161004;
    public static final int VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT = 2;
    public static final int VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT = 2;
    public static final int VK_ERROR_FRAGMENTATION = -1000161000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES = 1000199000;
    public static final int VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE = 1000199001;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES = 1000221000;
    public static final int VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO = 1000246000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES = 1000130000;
    public static final int VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO = 1000130001;
    public static final int VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT = 65536;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES = 1000211000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES = 1000108000;
    public static final int VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO = 1000108001;
    public static final int VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO = 1000108002;
    public static final int VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO = 1000108003;
    public static final int VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT = 1;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES = 1000253000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES = 1000175000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES = 1000241000;
    public static final int VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT = 1000241001;
    public static final int VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT = 1000241002;
    public static final int VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL = 1000241000;
    public static final int VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL = 1000241001;
    public static final int VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL = 1000241002;
    public static final int VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL = 1000241003;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES = 1000261000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES = 1000207000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES = 1000207001;
    public static final int VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO = 1000207002;
    public static final int VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO = 1000207003;
    public static final int VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO = 1000207004;
    public static final int VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO = 1000207005;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES = 1000257000;
    public static final int VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO = 1000244001;
    public static final int VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO = 1000257002;
    public static final int VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO = 1000257003;
    public static final int VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO = 1000257004;
    public static final int VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT = 131072;
    public static final int VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT = 16;
    public static final int VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT = 2;
    public static final int VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT = 4;
    public static final int VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS = -1000257000;
    public static final int VK_DRIVER_ID_AMD_PROPRIETARY = 1;
    public static final int VK_DRIVER_ID_AMD_OPEN_SOURCE = 2;
    public static final int VK_DRIVER_ID_MESA_RADV = 3;
    public static final int VK_DRIVER_ID_NVIDIA_PROPRIETARY = 4;
    public static final int VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS = 5;
    public static final int VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA = 6;
    public static final int VK_DRIVER_ID_IMAGINATION_PROPRIETARY = 7;
    public static final int VK_DRIVER_ID_QUALCOMM_PROPRIETARY = 8;
    public static final int VK_DRIVER_ID_ARM_PROPRIETARY = 9;
    public static final int VK_DRIVER_ID_GOOGLE_SWIFTSHADER = 10;
    public static final int VK_DRIVER_ID_GGP_PROPRIETARY = 11;
    public static final int VK_DRIVER_ID_BROADCOM_PROPRIETARY = 12;
    public static final int VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY = 0;
    public static final int VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL = 1;
    public static final int VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE = 2;
    public static final int VK_RESOLVE_MODE_NONE = 0;
    public static final int VK_RESOLVE_MODE_SAMPLE_ZERO_BIT = 1;
    public static final int VK_RESOLVE_MODE_AVERAGE_BIT = 2;
    public static final int VK_RESOLVE_MODE_MIN_BIT = 4;
    public static final int VK_RESOLVE_MODE_MAX_BIT = 8;
    public static final int VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT = 1;
    public static final int VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT = 2;
    public static final int VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT = 4;
    public static final int VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT = 8;
    public static final int VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE = 0;
    public static final int VK_SAMPLER_REDUCTION_MODE_MIN = 1;
    public static final int VK_SAMPLER_REDUCTION_MODE_MAX = 2;
    public static final int VK_SEMAPHORE_TYPE_BINARY = 0;
    public static final int VK_SEMAPHORE_TYPE_TIMELINE = 1;
    public static final int VK_SEMAPHORE_WAIT_ANY_BIT = 1;
    public static final int VK_API_VERSION_1_2 = VK10.VK_MAKE_VERSION(1, 2, 0);
    public static final int VK_MAX_DRIVER_NAME_SIZE = 256;
    public static final int VK_MAX_DRIVER_INFO_SIZE = 256;

    protected VK12() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains("Vulkan12") && VK.checkExtension("Vulkan12", VK.isSupported(provider, "vkCmdDrawIndirectCount", caps) && VK.isSupported(provider, "vkCmdDrawIndexedIndirectCount", caps) && VK.isSupported(provider, "vkCreateRenderPass2", caps) && VK.isSupported(provider, "vkCmdBeginRenderPass2", caps) && VK.isSupported(provider, "vkCmdNextSubpass2", caps) && VK.isSupported(provider, "vkCmdEndRenderPass2", caps) && VK.isSupported(provider, "vkResetQueryPool", caps) && VK.isSupported(provider, "vkGetSemaphoreCounterValue", caps) && VK.isSupported(provider, "vkWaitSemaphores", caps) && VK.isSupported(provider, "vkSignalSemaphore", caps) && VK.isSupported(provider, "vkGetBufferDeviceAddress", caps) && VK.isSupported(provider, "vkGetBufferOpaqueCaptureAddress", caps) && VK.isSupported(provider, "vkGetDeviceMemoryOpaqueCaptureAddress", caps));
    }

    public static void vkCmdDrawIndirectCount(VkCommandBuffer commandBuffer, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkBuffer") long countBuffer, @NativeType(value="VkDeviceSize") long countBufferOffset, @NativeType(value="uint32_t") int maxDrawCount, @NativeType(value="uint32_t") int stride) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDrawIndirectCount;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJJJJV((long)commandBuffer.address(), (long)buffer, (long)offset, (long)countBuffer, (long)countBufferOffset, (int)maxDrawCount, (int)stride, (long)__functionAddress);
    }

    public static void vkCmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkBuffer") long countBuffer, @NativeType(value="VkDeviceSize") long countBufferOffset, @NativeType(value="uint32_t") int maxDrawCount, @NativeType(value="uint32_t") int stride) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDrawIndexedIndirectCount;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJJJJV((long)commandBuffer.address(), (long)buffer, (long)offset, (long)countBuffer, (long)countBufferOffset, (int)maxDrawCount, (int)stride, (long)__functionAddress);
    }

    public static int nvkCreateRenderPass2(VkDevice device, long pCreateInfo, long pAllocator, long pRenderPass) {
        long __functionAddress = device.getCapabilities().vkCreateRenderPass2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkRenderPassCreateInfo2.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo, (long)pAllocator, (long)pRenderPass, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateRenderPass2(VkDevice device, @NativeType(value="VkRenderPassCreateInfo2 const *") VkRenderPassCreateInfo2 pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkRenderPass *") LongBuffer pRenderPass) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pRenderPass, (int)1);
        }
        return VK12.nvkCreateRenderPass2(device, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pRenderPass));
    }

    public static void nvkCmdBeginRenderPass2(VkCommandBuffer commandBuffer, long pRenderPassBegin, long pSubpassBeginInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBeginRenderPass2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkRenderPassBeginInfo.validate(pRenderPassBegin);
        }
        JNI.callPPPV((long)commandBuffer.address(), (long)pRenderPassBegin, (long)pSubpassBeginInfo, (long)__functionAddress);
    }

    public static void vkCmdBeginRenderPass2(VkCommandBuffer commandBuffer, @NativeType(value="VkRenderPassBeginInfo const *") VkRenderPassBeginInfo pRenderPassBegin, @NativeType(value="VkSubpassBeginInfo const *") VkSubpassBeginInfo pSubpassBeginInfo) {
        VK12.nvkCmdBeginRenderPass2(commandBuffer, pRenderPassBegin.address(), pSubpassBeginInfo.address());
    }

    public static void nvkCmdNextSubpass2(VkCommandBuffer commandBuffer, long pSubpassBeginInfo, long pSubpassEndInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdNextSubpass2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)commandBuffer.address(), (long)pSubpassBeginInfo, (long)pSubpassEndInfo, (long)__functionAddress);
    }

    public static void vkCmdNextSubpass2(VkCommandBuffer commandBuffer, @NativeType(value="VkSubpassBeginInfo const *") VkSubpassBeginInfo pSubpassBeginInfo, @NativeType(value="VkSubpassEndInfo const *") VkSubpassEndInfo pSubpassEndInfo) {
        VK12.nvkCmdNextSubpass2(commandBuffer, pSubpassBeginInfo.address(), pSubpassEndInfo.address());
    }

    public static void nvkCmdEndRenderPass2(VkCommandBuffer commandBuffer, long pSubpassEndInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdEndRenderPass2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)commandBuffer.address(), (long)pSubpassEndInfo, (long)__functionAddress);
    }

    public static void vkCmdEndRenderPass2(VkCommandBuffer commandBuffer, @NativeType(value="VkSubpassEndInfo const *") VkSubpassEndInfo pSubpassEndInfo) {
        VK12.nvkCmdEndRenderPass2(commandBuffer, pSubpassEndInfo.address());
    }

    public static void vkResetQueryPool(VkDevice device, @NativeType(value="VkQueryPool") long queryPool, @NativeType(value="uint32_t") int firstQuery, @NativeType(value="uint32_t") int queryCount) {
        long __functionAddress = device.getCapabilities().vkResetQueryPool;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJV((long)device.address(), (long)queryPool, (int)firstQuery, (int)queryCount, (long)__functionAddress);
    }

    public static int nvkGetSemaphoreCounterValue(VkDevice device, long semaphore, long pValue) {
        long __functionAddress = device.getCapabilities().vkGetSemaphoreCounterValue;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)semaphore, (long)pValue, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetSemaphoreCounterValue(VkDevice device, @NativeType(value="VkSemaphore") long semaphore, @NativeType(value="uint64_t *") LongBuffer pValue) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pValue, (int)1);
        }
        return VK12.nvkGetSemaphoreCounterValue(device, semaphore, MemoryUtil.memAddress((LongBuffer)pValue));
    }

    public static int nvkWaitSemaphores(VkDevice device, long pWaitInfo, long timeout) {
        long __functionAddress = device.getCapabilities().vkWaitSemaphores;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkSemaphoreWaitInfo.validate(pWaitInfo);
        }
        return JNI.callPPJI((long)device.address(), (long)pWaitInfo, (long)timeout, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkWaitSemaphores(VkDevice device, @NativeType(value="VkSemaphoreWaitInfo const *") VkSemaphoreWaitInfo pWaitInfo, @NativeType(value="uint64_t") long timeout) {
        return VK12.nvkWaitSemaphores(device, pWaitInfo.address(), timeout);
    }

    public static int nvkSignalSemaphore(VkDevice device, long pSignalInfo) {
        long __functionAddress = device.getCapabilities().vkSignalSemaphore;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (long)pSignalInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkSignalSemaphore(VkDevice device, @NativeType(value="VkSemaphoreSignalInfo const *") VkSemaphoreSignalInfo pSignalInfo) {
        return VK12.nvkSignalSemaphore(device, pSignalInfo.address());
    }

    public static long nvkGetBufferDeviceAddress(VkDevice device, long pInfo) {
        long __functionAddress = device.getCapabilities().vkGetBufferDeviceAddress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPJ((long)device.address(), (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="VkDeviceAddress")
    public static long vkGetBufferDeviceAddress(VkDevice device, @NativeType(value="VkBufferDeviceAddressInfo const *") VkBufferDeviceAddressInfo pInfo) {
        return VK12.nvkGetBufferDeviceAddress(device, pInfo.address());
    }

    public static long nvkGetBufferOpaqueCaptureAddress(VkDevice device, long pInfo) {
        long __functionAddress = device.getCapabilities().vkGetBufferOpaqueCaptureAddress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPJ((long)device.address(), (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long vkGetBufferOpaqueCaptureAddress(VkDevice device, @NativeType(value="VkBufferDeviceAddressInfo const *") VkBufferDeviceAddressInfo pInfo) {
        return VK12.nvkGetBufferOpaqueCaptureAddress(device, pInfo.address());
    }

    public static long nvkGetDeviceMemoryOpaqueCaptureAddress(VkDevice device, long pInfo) {
        long __functionAddress = device.getCapabilities().vkGetDeviceMemoryOpaqueCaptureAddress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPJ((long)device.address(), (long)pInfo, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long vkGetDeviceMemoryOpaqueCaptureAddress(VkDevice device, @NativeType(value="VkDeviceMemoryOpaqueCaptureAddressInfo const *") VkDeviceMemoryOpaqueCaptureAddressInfo pInfo) {
        return VK12.nvkGetDeviceMemoryOpaqueCaptureAddress(device, pInfo.address());
    }

    @NativeType(value="VkResult")
    public static int vkCreateRenderPass2(VkDevice device, @NativeType(value="VkRenderPassCreateInfo2 const *") VkRenderPassCreateInfo2 pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkRenderPass *") long[] pRenderPass) {
        long __functionAddress = device.getCapabilities().vkCreateRenderPass2;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pRenderPass, (int)1);
            VkRenderPassCreateInfo2.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI((long)device.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pRenderPass, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetSemaphoreCounterValue(VkDevice device, @NativeType(value="VkSemaphore") long semaphore, @NativeType(value="uint64_t *") long[] pValue) {
        long __functionAddress = device.getCapabilities().vkGetSemaphoreCounterValue;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pValue, (int)1);
        }
        return JNI.callPJPI((long)device.address(), (long)semaphore, (long[])pValue, (long)__functionAddress);
    }
}

