/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCompletionResult
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CURSORKIND;
    public static final int COMPLETIONSTRING;

    public CXCompletionResult(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXCompletionResult.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXCursorKind")
    public int CursorKind() {
        return CXCompletionResult.nCursorKind(this.address());
    }

    @NativeType(value="CXCompletionString")
    public long CompletionString() {
        return CXCompletionResult.nCompletionString(this.address());
    }

    public static CXCompletionResult malloc() {
        return (CXCompletionResult)CXCompletionResult.wrap(CXCompletionResult.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXCompletionResult calloc() {
        return (CXCompletionResult)CXCompletionResult.wrap(CXCompletionResult.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXCompletionResult create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXCompletionResult)CXCompletionResult.wrap(CXCompletionResult.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXCompletionResult create(long address) {
        return (CXCompletionResult)CXCompletionResult.wrap(CXCompletionResult.class, (long)address);
    }

    @Nullable
    public static CXCompletionResult createSafe(long address) {
        return address == 0L ? null : (CXCompletionResult)CXCompletionResult.wrap(CXCompletionResult.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXCompletionResult.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXCompletionResult.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXCompletionResult.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCompletionResult.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXCompletionResult.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXCompletionResult.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXCompletionResult.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXCompletionResult mallocStack() {
        return CXCompletionResult.mallocStack(MemoryStack.stackGet());
    }

    public static CXCompletionResult callocStack() {
        return CXCompletionResult.callocStack(MemoryStack.stackGet());
    }

    public static CXCompletionResult mallocStack(MemoryStack stack) {
        return (CXCompletionResult)CXCompletionResult.wrap(CXCompletionResult.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXCompletionResult callocStack(MemoryStack stack) {
        return (CXCompletionResult)CXCompletionResult.wrap(CXCompletionResult.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXCompletionResult.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXCompletionResult.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXCompletionResult.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXCompletionResult.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nCursorKind(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSORKIND);
    }

    public static long nCompletionString(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COMPLETIONSTRING));
    }

    static {
        Struct.Layout layout = CXCompletionResult.__struct((Struct.Member[])new Struct.Member[]{CXCompletionResult.__member((int)4), CXCompletionResult.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CURSORKIND = layout.offsetof(0);
        COMPLETIONSTRING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXCompletionResult, Buffer>
    implements NativeResource {
        private static final CXCompletionResult ELEMENT_FACTORY = CXCompletionResult.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXCompletionResult getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXCursorKind")
        public int CursorKind() {
            return CXCompletionResult.nCursorKind(this.address());
        }

        @NativeType(value="CXCompletionString")
        public long CompletionString() {
            return CXCompletionResult.nCompletionString(this.address());
        }
    }
}

