/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_platform_data_t")
public class BGFXPlatformData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NDT;
    public static final int NWH;
    public static final int CONTEXT;
    public static final int BACKBUFFER;
    public static final int BACKBUFFERDS;

    public BGFXPlatformData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXPlatformData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long ndt() {
        return BGFXPlatformData.nndt(this.address());
    }

    @NativeType(value="void *")
    public long nwh() {
        return BGFXPlatformData.nnwh(this.address());
    }

    @NativeType(value="void *")
    public long context() {
        return BGFXPlatformData.ncontext(this.address());
    }

    @NativeType(value="void *")
    public long backBuffer() {
        return BGFXPlatformData.nbackBuffer(this.address());
    }

    @NativeType(value="void *")
    public long backBufferDS() {
        return BGFXPlatformData.nbackBufferDS(this.address());
    }

    public BGFXPlatformData ndt(@NativeType(value="void *") long value) {
        BGFXPlatformData.nndt(this.address(), value);
        return this;
    }

    public BGFXPlatformData nwh(@NativeType(value="void *") long value) {
        BGFXPlatformData.nnwh(this.address(), value);
        return this;
    }

    public BGFXPlatformData context(@NativeType(value="void *") long value) {
        BGFXPlatformData.ncontext(this.address(), value);
        return this;
    }

    public BGFXPlatformData backBuffer(@NativeType(value="void *") long value) {
        BGFXPlatformData.nbackBuffer(this.address(), value);
        return this;
    }

    public BGFXPlatformData backBufferDS(@NativeType(value="void *") long value) {
        BGFXPlatformData.nbackBufferDS(this.address(), value);
        return this;
    }

    public BGFXPlatformData set(long ndt, long nwh, long context, long backBuffer, long backBufferDS) {
        this.ndt(ndt);
        this.nwh(nwh);
        this.context(context);
        this.backBuffer(backBuffer);
        this.backBufferDS(backBufferDS);
        return this;
    }

    public BGFXPlatformData set(BGFXPlatformData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXPlatformData malloc() {
        return (BGFXPlatformData)BGFXPlatformData.wrap(BGFXPlatformData.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static BGFXPlatformData calloc() {
        return (BGFXPlatformData)BGFXPlatformData.wrap(BGFXPlatformData.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static BGFXPlatformData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (BGFXPlatformData)BGFXPlatformData.wrap(BGFXPlatformData.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static BGFXPlatformData create(long address) {
        return (BGFXPlatformData)BGFXPlatformData.wrap(BGFXPlatformData.class, (long)address);
    }

    @Nullable
    public static BGFXPlatformData createSafe(long address) {
        return address == 0L ? null : (BGFXPlatformData)BGFXPlatformData.wrap(BGFXPlatformData.class, (long)address);
    }

    public static BGFXPlatformData mallocStack() {
        return BGFXPlatformData.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXPlatformData callocStack() {
        return BGFXPlatformData.callocStack(MemoryStack.stackGet());
    }

    public static BGFXPlatformData mallocStack(MemoryStack stack) {
        return (BGFXPlatformData)BGFXPlatformData.wrap(BGFXPlatformData.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXPlatformData callocStack(MemoryStack stack) {
        return (BGFXPlatformData)BGFXPlatformData.wrap(BGFXPlatformData.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static long nndt(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NDT));
    }

    public static long nnwh(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NWH));
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT));
    }

    public static long nbackBuffer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BACKBUFFER));
    }

    public static long nbackBufferDS(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BACKBUFFERDS));
    }

    public static void nndt(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NDT), (long)value);
    }

    public static void nnwh(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NWH), (long)value);
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTEXT), (long)value);
    }

    public static void nbackBuffer(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BACKBUFFER), (long)value);
    }

    public static void nbackBufferDS(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BACKBUFFERDS), (long)value);
    }

    static {
        Struct.Layout layout = BGFXPlatformData.__struct((Struct.Member[])new Struct.Member[]{BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)POINTER_SIZE), BGFXPlatformData.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NDT = layout.offsetof(0);
        NWH = layout.offsetof(1);
        CONTEXT = layout.offsetof(2);
        BACKBUFFER = layout.offsetof(3);
        BACKBUFFERDS = layout.offsetof(4);
    }
}

