/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU55;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CU60
extends CU55 {
    public static final int CU_MEM_ATTACH_GLOBAL = 1;
    public static final int CU_MEM_ATTACH_HOST = 2;
    public static final int CU_MEM_ATTACH_SINGLE = 4;

    protected CU60() {
        throw new UnsupportedOperationException();
    }

    public static int ncuMemAllocManaged(long dptr, long bytesize, int flags) {
        long __functionAddress = Functions.MemAllocManaged;
        return JNI.callPPI((long)dptr, (long)bytesize, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMemAllocManaged(@NativeType(value="CUdeviceptr *") PointerBuffer dptr, @NativeType(value="size_t") long bytesize, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)dptr, (int)1);
        }
        return CU60.ncuMemAllocManaged(MemoryUtil.memAddress((CustomBuffer)dptr), bytesize, flags);
    }

    public static int ncuPointerSetAttribute(long value, int attribute, long ptr) {
        long __functionAddress = Functions.PointerSetAttribute;
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        return JNI.callPPI((long)value, (int)attribute, (long)ptr, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuPointerSetAttribute(@NativeType(value="void const *") ByteBuffer value, @NativeType(value="CUpointer_attribute") int attribute, @NativeType(value="CUdeviceptr") long ptr) {
        return CU60.ncuPointerSetAttribute(MemoryUtil.memAddress((ByteBuffer)value), attribute, ptr);
    }

    @NativeType(value="CUresult")
    public static int cuStreamAttachMemAsync(@NativeType(value="CUstream") long hStream, @NativeType(value="CUdeviceptr") long dptr, @NativeType(value="size_t") long length, @NativeType(value="unsigned int") int flags) {
        long __functionAddress = Functions.StreamAttachMemAsync;
        if (Checks.CHECKS) {
            Checks.check((long)dptr);
        }
        return JNI.callPPPI((long)hStream, (long)dptr, (long)length, (int)flags, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long MemAllocManaged = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuMemAllocManaged");
        public static final long PointerSetAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuPointerSetAttribute");
        public static final long StreamAttachMemAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamAttachMemAsync"));

        private Functions() {
        }
    }
}

