/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4HC;
import org.lwjgl.util.lz4.LZ4HCCCtxInternal;

@NativeType(value="union LZ4_streamHC_t")
public class LZ4StreamHC
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TABLE;
    public static final int INTERNAL_DONOTUSE;

    public LZ4StreamHC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4StreamHC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t[LZ4_STREAMHCSIZE_SIZET]")
    public PointerBuffer table() {
        return LZ4StreamHC.ntable(this.address());
    }

    @NativeType(value="size_t")
    public long table(int index) {
        return LZ4StreamHC.ntable(this.address(), index);
    }

    @NativeType(value="struct LZ4HC_CCtx_internal")
    public LZ4HCCCtxInternal internal_donotuse() {
        return LZ4StreamHC.ninternal_donotuse(this.address());
    }

    public static LZ4StreamHC create(long address) {
        return (LZ4StreamHC)LZ4StreamHC.wrap(LZ4StreamHC.class, (long)address);
    }

    @Nullable
    public static LZ4StreamHC createSafe(long address) {
        return address == 0L ? null : (LZ4StreamHC)LZ4StreamHC.wrap(LZ4StreamHC.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LZ4StreamHC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LZ4StreamHC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static PointerBuffer ntable(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)TABLE), (int)LZ4HC.LZ4_STREAMHCSIZE_SIZET);
    }

    public static long ntable(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TABLE + Checks.check((int)index, (int)LZ4HC.LZ4_STREAMHCSIZE_SIZET) * (long)POINTER_SIZE));
    }

    public static LZ4HCCCtxInternal ninternal_donotuse(long struct) {
        return LZ4HCCCtxInternal.create(struct + (long)INTERNAL_DONOTUSE);
    }

    static {
        Struct.Layout layout = LZ4StreamHC.__union((Struct.Member[])new Struct.Member[]{LZ4StreamHC.__array((int)POINTER_SIZE, (int)LZ4HC.LZ4_STREAMHCSIZE_SIZET), LZ4StreamHC.__member((int)LZ4HCCCtxInternal.SIZEOF, (int)LZ4HCCCtxInternal.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TABLE = layout.offsetof(0);
        INTERNAL_DONOTUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4StreamHC, Buffer> {
        private static final LZ4StreamHC ELEMENT_FACTORY = LZ4StreamHC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LZ4StreamHC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t[LZ4_STREAMHCSIZE_SIZET]")
        public PointerBuffer table() {
            return LZ4StreamHC.ntable(this.address());
        }

        @NativeType(value="size_t")
        public long table(int index) {
            return LZ4StreamHC.ntable(this.address(), index);
        }

        @NativeType(value="struct LZ4HC_CCtx_internal")
        public LZ4HCCCtxInternal internal_donotuse() {
            return LZ4StreamHC.ninternal_donotuse(this.address());
        }
    }
}

