/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filewatch;

import java.io.FileDescriptor;
import java.nio.channels.Channel;
import jnr.posix.HANDLE;
import jnr.posix.JavaLibCHelper;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyIO;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"WinIO"})
public class RubyWinIO
extends RubyIO {
    private boolean valid;
    private boolean direct;
    private long address;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyWinIO(Ruby runtime, Channel channel) {
        super(runtime, channel);
        OpenFile fptr = this.getOpenFileChecked();
        boolean locked = fptr.lock();
        try {
            fptr.checkClosed();
            HANDLE handle = JavaLibCHelper.gethandle((FileDescriptor)JavaLibCHelper.getDescriptorFromChannel((Channel)fptr.fd().chFile));
            if (handle.isValid()) {
                this.direct = handle.toPointer().isDirect();
                this.address = handle.toPointer().address();
                this.valid = true;
            } else {
                this.direct = false;
                this.address = 0L;
                this.valid = false;
            }
        }
        finally {
            if (locked) {
                fptr.unlock();
            }
        }
    }

    @JRubyMethod(name={"valid?"})
    public RubyBoolean valid_p(ThreadContext context) {
        return context.runtime.newBoolean(this.valid);
    }

    @JRubyMethod
    public IRubyObject close() {
        this.direct = false;
        this.address = 0L;
        return super.close();
    }

    public final boolean isDirect() {
        return this.direct;
    }

    public final long getAddress() {
        return this.address;
    }
}

