/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.snmp4j.TransportStateReference;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;

public class TLSTMUtil {
    private static final LogAdapter logger = LogFactory.getLogger(TLSTMUtil.class);
    private static final int MD_SHA_PREFIX_LENGTH = "SHA".length();

    public static OctetString getFingerprint(X509Certificate cert) {
        OctetString certFingerprint = null;
        try {
            String algo = cert.getSigAlgName();
            if (algo.contains("with")) {
                algo = algo.substring(0, algo.indexOf("with"));
            }
            if (algo.length() > MD_SHA_PREFIX_LENGTH) {
                char c = algo.charAt(MD_SHA_PREFIX_LENGTH);
                switch (c) {
                    case '1': 
                    case '2': {
                        String algoPrefix = algo.substring(0, MD_SHA_PREFIX_LENGTH);
                        String algoSuffix = algo.substring(MD_SHA_PREFIX_LENGTH);
                        algo = algoPrefix + "-" + algoSuffix;
                    }
                }
            }
            MessageDigest md = MessageDigest.getInstance(algo);
            md.update(cert.getEncoded());
            certFingerprint = new OctetString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("No such digest algorithm exception while getting fingerprint from " + cert + ": " + e.getMessage(), e);
        }
        catch (CertificateEncodingException e) {
            logger.error("Certificate encoding exception while getting fingerprint from " + cert + ": " + e.getMessage(), e);
        }
        return certFingerprint;
    }

    public static boolean isMatchingFingerprint(X509Certificate[] x509Certificates, OctetString fingerprint, boolean useClientMode, CounterSupport tlstmCounters, LogAdapter logger, Object eventSource) throws CertificateException {
        X509Certificate cert = x509Certificates[0];
        if (fingerprint != null && fingerprint.length() > 0) {
            OctetString certFingerprint = null;
            certFingerprint = TLSTMUtil.getFingerprint(cert);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Comparing certificate fingerprint " + certFingerprint + " with " + fingerprint)));
            }
            if (certFingerprint == null) {
                logger.error((Serializable)((Object)("Failed to determine fingerprint for certificate " + cert + " and algorithm " + cert.getSigAlgName())));
            } else if (certFingerprint.equals(fingerprint)) {
                if (logger.isInfoEnabled()) {
                    logger.info("Peer is trusted by fingerprint '" + fingerprint + "' of certificate: '" + cert + "'");
                }
                return true;
            }
            tlstmCounters.fireIncrementCounter(new CounterEvent(eventSource, useClientMode ? SnmpConstants.snmpTlstmSessionInvalidServerCertificates : SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
            throw new CertificateException("No fingerprint of provided certificates " + Arrays.asList(x509Certificates) + " matched " + fingerprint.toHexString());
        }
        return false;
    }

    public static Object getSubjAltName(Collection<List<?>> subjAltNames, int type) {
        if (subjAltNames != null) {
            for (List<?> entry : subjAltNames) {
                int t = (Integer)entry.get(0);
                if (t != type) continue;
                return entry.get(1);
            }
        }
        return null;
    }

    public static OctetString getIpAddressFromSubjAltName(Collection<List<?>> altNames) {
        Object entry = TLSTMUtil.getSubjAltName(altNames, 7);
        if (entry != null) {
            String ipAddress = ((String)entry).toLowerCase();
            if (ipAddress.indexOf(58) >= 0) {
                String[] bytes;
                StringBuilder buf = new StringBuilder(16);
                for (String b : bytes = ipAddress.split(":")) {
                    for (int diff = 2 - b.length(); diff > 0; --diff) {
                        buf.append('0');
                    }
                    buf.append(b);
                }
                return new OctetString(buf.toString());
            }
            return new OctetString(ipAddress);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static SSLContext createSSLContext(String protocol, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword, TransportStateReference transportStateReference, TLSTM.TLSTMTrustManagerFactory trustManagerFactory, boolean useClientMode, TlsTmSecurityCallback<X509Certificate> securityCallback, String localCertificateAlias) throws GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void filterCertificates(KeyStore ks, TransportStateReference transportStateReference, TlsTmSecurityCallback<X509Certificate> securityCallback, String localCertificateAlias) {
        String localCertAlias = localCertificateAlias;
        if (securityCallback != null && transportStateReference != null && (localCertAlias = securityCallback.getLocalCertificateAlias(transportStateReference.getAddress())) == null) {
            localCertAlias = localCertificateAlias;
        }
        if (localCertAlias != null) {
            try {
                Certificate[] chain = ks.getCertificateChain(localCertAlias);
                if (chain == null) {
                    logger.warn((Serializable)((Object)("Local certificate with alias '" + localCertAlias + "' not found. Known aliases are: " + Collections.list(ks.aliases()))));
                } else {
                    ArrayList<String> chainAliases = new ArrayList<String>(chain.length);
                    for (Certificate certificate : chain) {
                        String alias = ks.getCertificateAlias(certificate);
                        if (alias == null) continue;
                        chainAliases.add(alias);
                    }
                    for (String alias : Collections.list(ks.aliases())) {
                        if (chainAliases.contains(alias)) continue;
                        ks.deleteEntry(alias);
                    }
                }
            }
            catch (KeyStoreException e) {
                logger.error("Failed to get certificate chain for alias " + localCertAlias + ": " + e.getMessage(), e);
            }
        }
    }
}

