/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;

public abstract class TcpTransportMapping
extends AbstractTransportMapping<TcpAddress>
implements ConnectionOrientedTransportMapping<TcpAddress> {
    private static final LogAdapter logger = LogFactory.getLogger(TcpTransportMapping.class);
    protected TcpAddress tcpAddress;
    private transient Vector<TransportStateListener> transportStateListeners;

    public TcpTransportMapping(TcpAddress tcpAddress) {
        this.tcpAddress = tcpAddress;
    }

    @Override
    public Class<? extends Address> getSupportedAddressClass() {
        return TcpAddress.class;
    }

    public TcpAddress getAddress() {
        return this.tcpAddress;
    }

    @Override
    public TcpAddress getListenAddress() {
        return this.tcpAddress;
    }

    @Override
    public abstract void sendMessage(TcpAddress var1, byte[] var2, TransportStateReference var3) throws IOException;

    @Override
    public abstract void listen() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract MessageLengthDecoder getMessageLengthDecoder();

    @Override
    public abstract void setMessageLengthDecoder(MessageLengthDecoder var1);

    @Override
    public abstract void setConnectionTimeout(long var1);

    @Override
    public synchronized void addTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners == null) {
            this.transportStateListeners = new Vector(2);
        }
        this.transportStateListeners.add(l);
    }

    @Override
    public synchronized void removeTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners != null) {
            this.transportStateListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionStateChanged(TransportStateEvent change) {
        block8: {
            Vector<TransportStateListener> listenersFinalRef;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Firing transport state event: " + change)));
            }
            if ((listenersFinalRef = this.transportStateListeners) != null) {
                try {
                    ArrayList<TransportStateListener> listeners;
                    Vector<TransportStateListener> vector = listenersFinalRef;
                    synchronized (vector) {
                        listeners = new ArrayList<TransportStateListener>(listenersFinalRef);
                    }
                    for (TransportStateListener listener : listeners) {
                        listener.connectionStateChanged(change);
                    }
                }
                catch (RuntimeException ex) {
                    logger.error("Exception in fireConnectionStateChanged: " + ex.getMessage(), ex);
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) break block8;
                    throw ex;
                }
            }
        }
    }
}

