/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.FlowCapture;
import org.logstash.instrument.metrics.FlowMetric;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.MetricType;
import org.logstash.util.SetOnceReference;

abstract class BaseFlowMetric
extends AbstractMetric<Map<String, Double>>
implements FlowMetric {
    static final Logger LOGGER = LogManager.getLogger(BaseFlowMetric.class);
    private final Metric<? extends Number> numeratorMetric;
    private final Metric<? extends Number> denominatorMetric;
    protected final SetOnceReference<FlowCapture> lifetimeBaseline = SetOnceReference.unset();
    static final String LIFETIME_KEY = "lifetime";
    final LongSupplier nanoTimeSupplier;
    static final MathContext LIMITED_PRECISION = new MathContext(4, RoundingMode.HALF_UP);

    BaseFlowMetric(LongSupplier nanoTimeSupplier, String name, Metric<? extends Number> numeratorMetric, Metric<? extends Number> denominatorMetric) {
        super(name);
        this.nanoTimeSupplier = nanoTimeSupplier;
        this.numeratorMetric = numeratorMetric;
        this.denominatorMetric = denominatorMetric;
        if (this.doCapture().isEmpty()) {
            LOGGER.trace("FlowMetric({}) -> DEFERRED", (Object)name);
        }
    }

    @Override
    public MetricType getType() {
        return MetricType.FLOW_RATE;
    }

    protected Optional<FlowCapture> doCapture() {
        Number numeratorValue = this.numeratorMetric.getValue();
        if (Objects.isNull(numeratorValue)) {
            LOGGER.trace("FlowMetric({}) numerator metric {} returned null value", (Object)this.name, (Object)this.numeratorMetric.getName());
            return Optional.empty();
        }
        Number denominatorValue = this.denominatorMetric.getValue();
        if (Objects.isNull(denominatorValue)) {
            LOGGER.trace("FlowMetric({}) numerator metric {} returned null value", (Object)this.name, (Object)this.denominatorMetric.getName());
            return Optional.empty();
        }
        FlowCapture currentCapture = new FlowCapture(this.nanoTimeSupplier.getAsLong(), numeratorValue, denominatorValue);
        if (this.lifetimeBaseline.offer(currentCapture)) {
            LOGGER.trace("FlowMetric({}) baseline -> {}", (Object)this.name, (Object)currentCapture);
        }
        return Optional.of(currentCapture);
    }

    protected void injectLifetime(FlowCapture currentCapture, Map<String, Double> rates) {
        BaseFlowMetric.calculateRate(currentCapture, this.lifetimeBaseline::get).ifPresent(rate -> rates.put(LIFETIME_KEY, rate));
    }

    protected static OptionalDouble calculateRate(FlowCapture current, FlowCapture baseline) {
        Objects.requireNonNull(current, "current must not be null");
        Objects.requireNonNull(baseline, "baseline must not be null");
        if (baseline.equals(current)) {
            return OptionalDouble.empty();
        }
        BigDecimal deltaNumerator = current.numerator().subtract(baseline.numerator());
        BigDecimal deltaDenominator = current.denominator().subtract(baseline.denominator());
        if (deltaDenominator.signum() == 0) {
            return OptionalDouble.empty();
        }
        BigDecimal rate = deltaNumerator.divide(deltaDenominator, LIMITED_PRECISION);
        return OptionalDouble.of(rate.doubleValue());
    }

    protected static OptionalDouble calculateRate(FlowCapture current, Supplier<FlowCapture> possibleBaseline) {
        return Optional.ofNullable(possibleBaseline.get()).map(baseline -> BaseFlowMetric.calculateRate(current, baseline)).orElseGet(OptionalDouble::empty);
    }
}

