%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/home/gub/NewGub/gub/target/linux-x86/src/lilypond-git.sv.gnu.org--lilypond.git-stable-2.22/input/regression/footnote-auto-numbering.ly"
\sourcefileline 0
\version "2.19.21"
\header {
  texidoc = "This is an example of automatic footnote numbering
where the number is not reset on each page.  It uses the default
numbering function, which assigns numbers starting at 1 to successive
footnotes.
"
}

#(define (make-footnote-numbering-assertion-function n)
  (lambda (x)
    (if (not (= n x))
      (ly:error (_ "Expecting number ~a, got ~a") n x))))

#(define (simultaneous-footnote-numbering-assertion-function x y)
  (lambda (grob)
    (let ((n (if (grob::has-interface (ly:grob-parent grob Y)
                                      'beam-interface)
                 x
                 y)))
      (lambda (x)
        (if (not (= n x))
          (ly:error (_ "Expecting number ~a, got ~a") n x))))))

\paper {
  reset-footnotes-on-new-page = ##f
}

#(set-default-paper-size "a6")
\book {

\markup {
  a \auto-footnote b c
  \auto-footnote d e
  \auto-footnote f g
}

\markup { h i }

\relative c' {
  \once \override Score.FootnoteItem.numbering-assertion-function =
    #(lambda (grob) (make-footnote-numbering-assertion-function 3))
  \footnote #'(1 . -1) \markup { j } NoteHead
  a b c d
}

\pageBreak

\markup { k \auto-footnote l m }

\relative { a1 }

\relative {
  d'4 e
  \once \override Score.FootnoteItem.numbering-assertion-function =
    #(lambda (grob) (make-footnote-numbering-assertion-function 5))
  < f \footnote #'(1 . -1) \markup { n } a c >
  \once \override Score.FootnoteSpanner.numbering-assertion-function =
    #(simultaneous-footnote-numbering-assertion-function 6 7)
  a8-\footnote #'(1 . 1) \markup { p } \<
  -\footnote #'(1 . 1) \markup { o } [ b c d ] a4 b c |
  d a b c |
  d a b c |
  d a b c\f |
}}



% ****************************************************************
% end ly snippet
% ****************************************************************
